// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hp/presenter/dashboard/DashboardResourcePresenter',
    'hp/core/LinkTargetBuilder',
    'jquery',
    'hp/lib/jquery.hpTimestamp',
    'hp/lib/jquery.hpPlot'],
function(DashboardResourcePresenter, linkTargetBuilder) { "use strict";

    var DashboardResourceView = (function() {
      
        var STATUSES = ['error', 'warning', 'ok'];
      
        /**
         * Constructor
         */
        function DashboardResourceView() {
          
            var presenter;
            var container;
          
            function onSummaryChange(summary) {
                var link = linkTargetBuilder.makeLink(summary.name, summary.uri);
                // TODO: use MainMenu to get label
                $('header .hp-name', container).text(summary.name);
                $('header a', container).attr('href', $(link).attr('href'));
                $('header .hp-count', container).hide();
                $.each(STATUSES, function(index, status) {
                    var anchor =
                        $('.hp-summary-status a.hp-summary-' + status, container);
                    var icon = $('> .hp-status', anchor);
                    
                    $('.hp-count', anchor).text(summary[status]);
                    anchor.attr('href', $(link).attr('href'));
                    if (! summary[status]) {
                        icon.addClass('hp-unset');
                        anchor.addClass('hp-inactive');
                    } else {
                        icon.removeClass('hp-unset');
                        anchor.removeClass('hp-inactive');
                    }
                });
            }
          
            /**
             * @public
             */
            this.pause = function () {
                presenter.pause();
                presenter.off('summaryChange', onSummaryChange);
            };
            
            this.resume = function () {
                presenter.on('summaryChange', onSummaryChange);
                presenter.resume();
            };
            
            this.init = function (configurationArg, containerArg) {
                container = containerArg;
                presenter = new DashboardResourcePresenter();
                presenter.init(configurationArg);
                
                if (configurationArg.utilization) {
                    // TODO
                } else {
                    $('.hp-utilization-summary', container).hide();
                }
            };
        }

        return DashboardResourceView;
    }());
    
    return DashboardResourceView;
});
