// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['hp/presenter/settings/DevelopmentPresenter',
        'hp/core/Localizer', 'hp/model/Session'],
function(presenter, Localizer, session) {"use strict";

    var DevelopmentShowView = ( function() {

        var REFRESH_INTERVAL = '#hp-settings-refresh-interval',
            MAX_INDEX_ITEMS = '#hp-settings-max-index-items',
            EXPERIMENTAL_FEATURES = '#hp-settings-experimental-features',
            ROUTING_LOG_LEVEL = '#hp-settings-routing-log-level',
            AUDIO = '#hp-settings-audio',
            DISABLE_IPV6 = '#hp-settings-ipv6-disable', 
            DISABLE_FACTORY_RESET = '#hp-settings-factory-reset-disable',             
            HIGH_CONTRAST = '#hp-settings-high-contrast',
            TRACK_TIMING = '#hp-settings-track-timing',
            EDIT_LINK='#hp-settings-development-edit',
            msLabel;

        /**
         * @class View script for the Development Settings panel on the
         *     Overview pane of the Settings page.
         * @type {DevelopmentShowView}
         */
        function DevelopmentShowView() {

            function updateContent() {
                if (session.canPerformAction("appliance", "Update")) {
                    $(EDIT_LINK).show();
                }else{
                    $(EDIT_LINK).hide();
                }
                var yes = Localizer.getString('core.common.yes'),
                    no = Localizer.getString('core.common.no');
                
                $(REFRESH_INTERVAL).text(presenter.getRefreshInterval() + " " + msLabel);
                $(MAX_INDEX_ITEMS).text(presenter.getMaxIndexItems());
                $(EXPERIMENTAL_FEATURES).text(presenter.isExperimentalFeatures() ? yes : no);
                $(ROUTING_LOG_LEVEL).text(presenter.getRoutingLogLevel());
                $(AUDIO).text(presenter.getDisableAudio() ? no : yes);
                $(DISABLE_IPV6).text(presenter.getDisableIPv6() ? yes : no);
                $(DISABLE_FACTORY_RESET).text(presenter.getDisableFactoryReset() ? yes : no);
                $(HIGH_CONTRAST).text(presenter.getHighContrast() ? yes : no);
                $(TRACK_TIMING).text(presenter.getTrackTiming() ? yes : no);
            }

            this.init = function() {
                msLabel = Localizer.getString('core.settings.development.ms');
                this.resume();
                presenter.on('change', updateContent);
            };

            this.resume = function() {
                updateContent();
            };

        }

        return new DevelopmentShowView();

    }());

    return DevelopmentShowView;
});
