// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {GraphicsRoutes}
 */
define(['hp/core/Router'],
function (router) { "use strict";

    var GraphicsRoutes = ( function() {

        var CONTAINER = '#tour-graphics-page .hp-details-pane';

        function GraphicsRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.watch('graphics master', '/graphics/.*', {
                    change: function (location) {
                        require(['hpsum/view/graphics/GraphicsView'],
                        function (view) {
                            view.changeLocation(location);
                        });
                    }
                });

                router.map('graphics paths', '/graphics/paths', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/paths.html',
                            'hpsum/view/graphics/GraphicsPathsView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('graphics physical appliance', '/graphics/appliance', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/virtual_appliance.html',
                            'hpsum/view/graphics/GraphicsVirtualApplianceView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('graphics virtual appliance', '/graphics/virtual_appliance', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/virtual_appliance.html',
                            'hpsum/view/graphics/GraphicsApplianceView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('graphics enclosure', '/graphics/enclosure', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/enclosure.html',
                            'hpsum/view/graphics/GraphicsEnclosureView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('graphics switch', '/graphics/switch', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/switch.html',
                            'hpsum/view/graphics/GraphicsSwitchView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('graphics server', '/graphics/server', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/server.html',
                            'hpsum/view/graphics/GraphicsServerView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('graphics rack', '/graphics/rack', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/rack.html',
                            'hpsum/view/graphics/GraphicsRackView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('graphics map', '/graphics/map', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/map.html',
                            'hpsum/view/graphics/GraphicsMapView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('graphics logical switch', '/graphics/logical_switch', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/graphics/logical_switch.html',
                            'hpsum/view/graphics/GraphicsLogicalSwitchView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.filter('graphics default redirector', '/graphics$|/graphics/$', {
                    check: function (location, result) {
                        result.redirectTo('/graphics/paths');
                    }
                });

                router.map('graphics no route', '/graphics/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new GraphicsRoutes();
    }());

    return GraphicsRoutes;
});
