// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {GroupShowRoutes}
 * This is used to provide route map for each GroupShow action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 */

define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

	var GroupShowRoutes = ( function() {

			//Consts can go here
			var CONTAINER = '#hpsum-groups-page .hp-details-show-view',
			    CHANGE_CONTAINER = '#hp-change-page-container';

			/**
			 * @constructor
			 */
			function GroupShowRoutes() {

				var registered = false;
				
				this.register = function() {
					if (registered)
						return;
					registered = true;

					router.map('group show overview', '/group/show/overview' + urlFragment.viewSinglePatternTerminal, {
						container : CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/overview.html',
							'hpsum/view/group/GroupShowOverviewView'],
							function(page, view) {
								result.load(page, view);
							});
						}
					});

					router.filter('group show default redirector', '/group/show' + urlFragment.viewPatternTerminal, {
						check : function(location, result) {
							result.replaceWith(urlFragment.replaceView(location, 'show/overview'));
						}
					});

					router.map('group show no route', '/group/show/.+', {
						container : CONTAINER,
						enter : function(location, result) {
							require(['text!hpPages/core/no_details.html'], function(page) {
								result.load(page);
							});
						}
					});
				}
			}

			return new GroupShowRoutes();

		}());

	return GroupShowRoutes;

});
