// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['hp/services/Log', 'jquery'], function(log) {"use strict";
    var SessionService = ( function() {

        /**
         * @type {SessionService}
         * @constructor
         */
        function SessionService() {
          
          	/**
             * Create the session for the log in credentials entered by user.
             */
            this.createSession = function(username, password, data, handlers) {
              
                $.ajax({
                    url : "/session/create",
                    type : 'POST',
                    contentType : "application/json",
                    data: JSON.stringify(data),
                    dataType : "json",
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : '',
                        "Session-KeepAlive": true
                    }
                });
            };
            
            /**
             * Accesses the session of the current logged in user.
             */
            this.accessSession = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/" + token + "/getdata",
                    type : 'GET',
                    contentType : "application/json",
                    dataType : "json",
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : lang,
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
            
            /**
             * Closes the session of the current logged in user.
             */
            this.closeSession = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/" + token + "/close",
                    type : 'GET',
                    contentType : "application/json",
                    dataType : "json",
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : lang,
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
            
             /**
             * Shuts down the HPSUM service.
             */
            this.shutDown = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/shutdown",
                    type : 'POST',
                    contentType : "application/json",
                    dataType : "json",     
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
        }

        return new SessionService();
    }());
    return SessionService;
});
