// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (BaselineShowView)
 * This is a view class for Baseline.
 * Provides functions to show details pane for a baseline item
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
    'hp/view/DetailsShowView',
    'hp/view/NotificationsView',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/core/Localizer',
    'hp/view/DialogView',
    'jquery',
    //These two modules required to show table for contents section in details pane
    'lib/jquery.dataTables',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.dataTables.rowReordering',
    //
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpSelect',
    'hp/lib/jquery.hpStackedPanels'],
function(presenter, DetailsShowView, NotificationsView, router, urlFragment, notifications, localizer, DialogView) { "use strict";

    var BaselineShowView = (function() {
      
        var VIEW = '#hpsum-baselines-show',
            HEADER = '#hpsum-baselines-show .hp-details-header',
            TITLE = '#hpsum-baselines-details-title',
            RELEASE_DATE = '#hpsum-baseline-release-date',
            LANGUAGES = '#hpsum-baseline-languages',
            ENHANCEMENTS = '#hpsum-baseline-enhancements',
            PANEL_SELECTOR = '#hpsum-baselines-show-panel-selector',
            PANELS = '#hpsum-baselines-show-panels',
            DELETE_ACTION = '#hpsum-baselines-delete-action',
            DELETE_DIALOG = '#hpsum-baselines-delete-confirm',
            DELETE_NAME = '#hpsum-baselines-delete-name',
            DELETE_TITLE = '#hpsum-baseline-delete-title',
            COMPONENT_DIALOG = '#hpsum-component-dialog',
	    COMPONENT_CONFIG_DIALOG = '#hpsum-component-config-dialog',
	    ACTIONS = '.hp-details-actions',
            COMPONENT_TABLE = '#baselines-contents-table',
            ROUTE_PREFIX = '/baseline/show',
            NOTIFY_STATUSES = {error:'error', warning:'warning', ok:'ok'};
      		var SCHEDULE_DIALOG = '#hpsum-baseline-schedule-information';
      		var scheduleDialogContents;
			var SCHEDULE_DATE_AND_TIME = "#hpsum-baseline-schedule-date-time",
				SCHEDULE_TYPE = "#hpsum-baseline-schedule-type",
				SCHEDULE_RECURS = "#hpsum-baseline-schedule-recurring";
		var CANCEL = '#hpsum-component-config-cancel';
        /**
         * Constructor
         */
        function BaselineShowView() {
          
            var detailsShowView = new DetailsShowView(),
                notificationsView = new NotificationsView(),
                deleteInProgress = false,
                okMessage = null,
                warningMessage = null,
                errorMessage = null,
                componentDialogContents,
                componentConfigDialogContents,
                timer = null,
                baselineItem = null,
                deleteDialogContents;
                
            function onItemChange(item) {
			if(timer) {
		            clearInterval(timer);
		            timer = null;
		    }
			notificationsView.clear();
			$(COMPONENT_TABLE).dataTable().fnClearTable();

                if (item && item.hasOwnProperty("hapi")) {
                    var hapi = item.hapi;
                    baselineItem = hapi;
                    $(TITLE).html(item.hapi.baseline_name);
                    $(DELETE_NAME).html(item.hapi.baseline_name);
                    $(RELEASE_DATE).html(item.hapi.baseline_release_date);
                    $(LANGUAGES).html(item.hapi.baseline_languages);
                    var i,html;
                    html="";
 
					//populate os details
					$('#os ol').html(localizer.getString('core.loading'));
					presenter.getOsInfo(hapi.baseline_uri, {
							success : function(data) {
								if (data.hapi.hasOwnProperty("baseline_os")) {
									for ( i = 0; i < data.hapi.baseline_os.os.length; i++) {
										html = html + '<li>' + data.hapi.baseline_os.os[i] + '</li>'
									}

									$('#os ol').html(html);
								}
							},
							error : function(data) {
							}
					}); 

					//populate enhacements
					$('#hpsum-baseline-enhancements ol').html(localizer.getString('core.loading'));
					presenter.getEnhancements(hapi.baseline_uri, {
							success : function(data) {
								if (data.hapi.hasOwnProperty("baseline_enhancements")) {
									html = '';
									for ( i = 0; i < data.hapi.baseline_enhancements.length; i++) {
										var baselineEnhancement = data.hapi.baseline_enhancements[i];

										if (baselineEnhancement.hasOwnProperty('revision_enhancement')) {
											var revEnhancement = baselineEnhancement.revision_enhancement[0];

											if (revEnhancement && revEnhancement.hasOwnProperty('language_enhancement')) {
												html = html + '<li>' + revEnhancement.language_enhancement + '</li>';
											}
										}
									}

									$('#hpsum-baseline-enhancements ol').html(html);
								}
							},
							error : function(data) {
							}
						}); 
  
	                
	                //populate components table
	                //populateComponentTable(item);
	                presenter.getComponents(hapi.baseline_uri, {
	                	success : function (data) {
						var dataItem = {hapi:{location_id:item.hapi.location_id,baseline_id:item.hapi.baseline_id, components:data.hapi.components}};
	                		populateComponentTable(dataItem);
	                	},
	                	error : function (data) {
	                	}
	                });
	                
	          
					if (hapi.baseline_state === "inventory_needed") {
							if (hapi.location_type.match(/local|Unc/i)) {
								presenter.startInventory({uri: hapi.baseline_uri + '/getBaselineData'}, {
								success : function (data) {
	                			 
								 
								  var currComps = hapi.baseline_state_detail.current_progress,
	                		totalComps = hapi.baseline_state_detail.total_no_component;
	                		currprogress = 0.1;
	                		
	                		if (0 != totalComps) {
	                			currprogress = (currComps/totalComps) * 100;
	                		} 
	                		
							//show notification details
							notificationsView.add({
									status : 'running',
									summary : localizer.getString(bState),
									timestamp : (new Date().toISOString()),
									changing : true,
									progress : currprogress,
									step : hapi.baseline_state_detail.detail,
									
							});  
					   
	                			},
	                			error : function (data) {
	                			}});
							}
						}

	                //if(hapi.baseline_state === "inventory_in_progress") {
	                if(hapi.baseline_state === "inventory_in_progress" || 
	                   hapi.baseline_state === "comp_download_in_progress" ||
			   hapi.baseline_state === "reading_web_catalog" ||
			   hapi.baseline_state === "reading_manifest_xml" ||
			   hapi.baseline_state === "manifest_component_processing") {
	                	
	                	var bState = "hpsum.baseline.show.inventoryInProgress";
	                	if (hapi.baseline_state === "comp_download_in_progress")
	                		bState = "hpsum.baseline.compDownloadInProgress";
	                		
	                		 var currComps = hapi.baseline_state_detail.current_progress,
	                		totalComps = hapi.baseline_state_detail.total_no_component,
	                		currprogress = 0.1;
	                		
	                		if (0 != totalComps) {
	                			currprogress = (currComps/totalComps) * 100;
	                		} 
	                		
							//show notification details
							notificationsView.add({
									status : 'running',
									summary : localizer.getString(bState),
									timestamp : (new Date().toISOString()),
									changing : true,
									progress : currprogress,
									step : hapi.baseline_state_detail.detail,
									
							});
							
	                	var uri = 	{
	                					location_id: item.hapi.location_id,
					        			baseline_id: item.hapi.baseline_id
					        		};
					    
	                	showInventoryProgress(uri);
	                }
	               	else if(hapi.baseline_state === "inventory_completed") {
	               		
	               		if(timer)
	               			clearInterval(timer);
	               		
	               		var details='';
	                	var compAdded;
	                	if(hapi.hasOwnProperty("components")) {
	                		compAdded = hapi.components.component.length;
	                		details = localizer.getString("hpsum.baseline.show.totalComponents") + " " + compAdded;
	                	}
	                	
	                	//show notification details
		                notificationsView.add({
	                            status: 'info',
	                            summary: localizer.getString("hpsum.baseline.show.inventoryCompleted"),
	                            sourceName: item.hapi.baseline_name,
	                            sourceUri: item.hapi.baseline_url,
	                            details: hapi.baseline_state_detail.detail
	                   	});
	               	}
	               	else if (hapi.baseline_state === "inventory_needed") {
	               		//show notification details
	               		// In case of PFW we need to show the Start Inventory Link
	               		if (hapi.location_type == "FTP") {
	               			//var detailed = '<a id="hpsum-schedule-pfw-inventory" href="javascript:void(0);">' + localizer.getString("hpsum.baseline.schedule_download") + '</a>';
	               			var detailsfornow = '<a id="hpsum-schedule-pfw-inventory-now" href="javascript:void(0);">' + localizer.getString("hpsum.baseline.download_now") + '</a>';
		            		notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.show.downloadNeeded"),
	                        sourceName: item.hapi.baseline_name,
	                        sourceUri: item.hapi.baseline_url,
	                        //details:  detailed + " or " + detailsfornow
	                        details:  detailsfornow
	                   	});
	                   	$('#hpsum-schedule-pfw-inventory').click(function (e) {	                   		
	                   		showScheduleDialog(item);	                   		
	                   	});
	                   	$('#hpsum-schedule-pfw-inventory-now').click(function (e) {	  
	                   		presenter.startPFWInventory({
                    		scheduled: "Off",
                    		scheduleDate: "",
                    		scheduleTime: "",
                    		scheduleType: "",
                    		scheduleRecurs: "",
                    		uri: item.hapi.baseline_uri
                    	});
                    	notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.starting_download")	                        
	                   	});	                   		
	                   	});
	                  }
	              }
                } else {
                    $(TITLE).html('');
                }
            }
            
            function showScheduleDialog(item){
		 var timer_uri = 	{
	                		location_id: item.hapi.location_id,
					baseline_id: item.hapi.baseline_id
				};

				$(SCHEDULE_TYPE, scheduleDialogContents).hpSelect().on('change',function(){
					if ($(SCHEDULE_TYPE).val() == 'daily')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Day(s)');
					else if ($(SCHEDULE_TYPE).val() == 'weekly')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Week(s)');
					else if ($(SCHEDULE_TYPE).val() == 'monthly')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Month(s)');
					else if ($(SCHEDULE_TYPE).val() == 'onetime')
						$('#rec-every-for-schedule',scheduleDialogContents).text('Once');
					else
						$('#rec-every-for-schedule',scheduleDialogContents).text('');
				});

            	new DialogView({contents: scheduleDialogContents,	
                	position : "center",
                    ok: function (elem) {
                    	var schedule_date = $(SCHEDULE_DATE_AND_TIME).datetimepicker("getDate");
                    	presenter.startPFWInventory({
                    		scheduled: "On",
                    		scheduleDate: $.format.date(schedule_date, "yyyy-MM-dd"),
                    		scheduleTime: $.format.date(schedule_date, "hh:mm:ss"),
                    		scheduleType: $(SCHEDULE_TYPE).val(),
                    		scheduleRecurs: $(SCHEDULE_RECURS).val(),
                    		uri: item.hapi.baseline_uri
                    	});
                    	notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.starting_download")	                        
	                   	});

            		showInventoryProgress(timer_uri);
                    },
                    cancel: function () {   
                    	$(SCHEDULE_RECURS).val('1');
                    	$(SCHEDULE_DATE_AND_TIME).val('');
                    }
                });
            }
            
            //Populate component/fixes table
            function populateComponentTable(item){
	                var oTable = $(COMPONENT_TABLE).dataTable();
	                oTable.fnClearTable();
	                if(item.hapi.hasOwnProperty("components")) {
	                   oTable.fnAddData(item.hapi.components.component);
	                   //select first record
	                   $(COMPONENT_TABLE + ' tbody tr').first().addClass('hp-selected');
	                   //to enable click event for a row
	                   $(COMPONENT_TABLE + " tbody tr").click( function( e ) {
							var data = oTable.fnGetData( this );
					        if ( $(this).hasClass('hp-selected') ) {
					            $(this).removeClass('hp-selected');
					        }
					        else {
					        	$(COMPONENT_TABLE + ' tr.hp-selected').removeClass('hp-selected');
					            $(this).addClass('hp-selected');
					        }
					        //call REST API to get component data and show it to user in a dialog
					        var uri = {location_id: item.hapi.location_id,
					        			baseline_id: item.hapi.baseline_id,
					        			component_id: data.component_id
					        			};
							
							var srcElem, browserType = 0;
                            var bPopulateConfigUI=false;
							//Check if firefox or (chrome and IE)
							if(e.srcElement)
							{
								srcElem = e.srcElement;//Chrome and IE
                                if((!srcElem.cellIndex) && srcElem.parentElement.cellIndex !=0)
                                    bPopulateConfigUI=true;
							}
							else
							{
								srcElem = e.target;//Firefox
								browserType = 1;
								if((!srcElem.cellIndex) && srcElem.parentElement.cellIndex !=0)
                                    bPopulateConfigUI=true;
							}
                            
							 if(bPopulateConfigUI === true)
							 {
					        	presenter.getCompConfDetail(uri, 
								{
									success : function(compdata) {
									onComponentConfigDataSuccess(uri, compdata, browserType);
									},
									error : function(errorInfo) {
									onComponentDataError(errorInfo);
									}
								});
							 }
							 else
							 {
								presenter.getComponentData(uri, {
									success : function(compdata) {
										onComponentDataSuccess(compdata);
									},
									error : function(errorInfo) {
										onComponentDataError(errorInfo);
									}
								});
							}
					    });
	                
                }
            }
            
            //get baseline inventory progress/status every 3 seconds and update UI 
            function showInventoryProgress(uri){
            	if(timer)
		        {
		            clearInterval(timer);
		            timer = null;
		        }
            	
            	timer = setInterval(function () {
            		var bStopTimer = false;
            		presenter.getBaselineStatus(uri, {
            					item: uri,
                				success : function(data) {
                    				onBaselineStatusSuccess(data, this.item);
                    				if(data.hapi.baseline_state === "inventory_completed") {
                    					bStopTimer = true;
                    				}
                    		 	},
                    			error : function(errorInfo) {
                        			onBaselineStatusError(errorInfo);
                    			}
                			});
                	
                	if(bStopTimer){
	                	if(timer)
		                {
		                	clearInterval(timer);
		                	timer = null;
		                }
		          	}
                			
                }, 3000);
            }
            
            function onBaselineStatusSuccess(data, item) {
            	//show inventory progress
            	//if(data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing") {
            	if(data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing" ||
            	   data.hapi.baseline_state === "comp_download_in_progress" || data.hapi.baseline_state === "reading_manifest_xml" ||
		   data.hapi.baseline_state === "reading_web_catalog" ||  data.hapi.baseline_state === "inventory_web_catalog_downloading") {	
            		//currently finding the progress by extracting the total components and current components processed data
            		//baseline_state_detail need to be changed to object format, so that we can handle this in proper manner.
            		var totalComps, currComps;
            		currComps = data.hapi.baseline_state_detail.current_progress;
            		totalComps = data.hapi.baseline_state_detail.total_no_component;
            		var currprogress = 0.1;
            		if (0 != totalComps) {
            			currprogress = (currComps/totalComps) * 100;
            		}
            		var bState = "hpsum.baseline.show.inventoryInProgress";
            		if (data.hapi.baseline_state === "comp_download_in_progress")
            			bState = "hpsum.baseline.compDownloadInProgress";
            			
            		var bStep = data.hapi.baseline_state_detail.detail;
            		
	                //show notification details
	                notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString(bState),
	                        //summary: localizer.getString("hpsum.baseline.show.inventoryInProgress"),
	                        timestamp: (new Date().toISOString()),
	                        changing: 1,
	                        progress: currprogress,
	                        step: bStep,
	                        details: '' 
	               });
	           	}
	           	else if(data.hapi.baseline_state === "inventory_completed") {
	                //show notification details
	                notificationsView.add({
	                        status: 'info',
	                        summary: localizer.getString("hpsum.baseline.show.inventoryCompleted"),
	                        timestamp: (new Date().toISOString()),
	                        step: data.hapi.baseline_state_detail.detail,
	                        details: '' 
	               });
	               
	               //populate fixes/components table
	               //presenter.getBundleIndexData(item, {
	               	presenter.getComponents(baselineItem.baseline_uri, {
        					success : function(data) {
                				populateComponentTable(data);
                		 	},
                			error : function(errorInfo) {
                    			
                			}
                	});
                	
                	if(timer)
	                {
	                	clearInterval(timer);
	                	timer = null;
	                }
                }
            }
            
            function onBaselineStatusError(errorInfo) {
            }
            
            function onComponentDataSuccess(data) {
            	//show component dialog
            	var dialog = new DialogView({contents: componentDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                dialog.setMessage({summary: data.hapi.component_data.compTexts[0].description,
                    status: "ok",
                    details: data.hapi.component_data.compTexts[0].enhancements,
                    actions: ""/*[linkTargetBuilder.makeLink('Edit device',
                      '/device/item1', 'edit', 'device')]*/
                }, true);
                
                $('#component_title').html(data.hapi.component_data.package_name);
                $('#hpsum-component-id').html(data.hapi.component_data.component_id);
                $('#hpsum-component-version').html(data.hapi.component_data.component_version);
                $('#hpsum-component-installation-notes').html(data.hapi.component_data.compTexts[0].installation_notes);

                $('div').remove('.hp-controls');
                //setTimeout(dialog.clearMessage, 3000);
            }
			
			function onComponentConfigDataSuccess(item, compdata, browserType) {
				if(compdata && compdata.hapi && compdata.hapi.component_config_data && compdata.hapi.component_config_data.config_file_data)
				{
					var data = compdata.hapi.component_config_data.config_file_data;
					
					data = data.replace(/&quot;/g,'"'); //Replace all &quot; with '"'.
					data = data.replace(/[\r\n]+(?=[^\r\n])/g,''); //Replace all new line and carriage returns
					data = data.replace(/\s{2,}/g, '');//Remove all Tabs
					
					data = JSON.parse(data);
					
					//show component config dialog
					var dialog = new DialogView({contents: componentConfigDialogContents,
						ok: function (elem) {
						//build the saveconfig hapi request
						var outData,k=0,strJSON, saveRequired = true;
						outData = data;
						if(!data.parameter.length)
						{
							if(elem.form[0].type == "radio")
							{								
								if(elem.form[0].checked == true)
								{									
									strJSON = "{\"param\":{\"value__attr\":\"" + elem.form[0].value + "\", \"name__attr\":\"" + data.parameter.name__attr +"\"}}";
									outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strJSON }};
								}
							}
							else if(elem.form[0].value != data.parameter.output.value__attr)
							{
								strJSON = "{\"param\":{\"value__attr\":\"" + elem.form[0].value + "\", \"name__attr\":\"" + data.parameter.name__attr +"\"}}";
								outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strJSON }};
							}
							else{
							saveRequired = false;
							}
						}
						else
						{
							var keys = new Array();
							var values = new Array();
							var savedParamValues = {};
							var formInputCount = 0;
							while(k<data.parameter.length)
							{
								
								if(data.parameter[k].requirements.input_requirements.user_visible.value__attr == "no")
								{
									k++;
									continue;
								}
								else 
								{								
									if(!(elem.form[formInputCount].type == "radio"))
									{
										if((outData.parameter[k].requirements.required_for_installation.value__attr.toLowerCase() == "yes" || outData.parameter[k].requirements.required_for_installation.value__attr.toLowerCase() == "y") && (!elem.form[formInputCount].value || elem.form[formInputCount].value == ""))
										{
											$('<p style="color: red">'+localizer.getString('fs.users.validations.fieldRequired')+'</p>').appendTo($('#'+outData.parameter[k].name__attr));
											return false;
										}
										values[k]=elem.form[formInputCount].value;
										keys[k]=outData.parameter[k].name__attr;
										savedParamValues[outData.parameter[k].name__attr]=outData.parameter[k].output.value__attr;
										formInputCount++;
										k++;
									}
									else
									{
										while(elem.form[formInputCount].type == "radio")
										{
											if(elem.form[formInputCount].checked == true)
											{
												values[k]=elem.form[formInputCount].value;
												keys[k]=outData.parameter[k].name__attr;
												savedParamValues[outData.parameter[k].name__attr]=outData.parameter[k].output.value__attr;
												k++;
											}
											formInputCount++;
										}
									}
								}
							}
							var strObj = "{\"param\":[";
							saveRequired = false;
							for(var i=0; i<keys.length; i++){
							if(savedParamValues[keys[i]].toLowerCase()!=values[i].toLowerCase()){						
								strObj = strObj + "{\"value__attr\":\""+values[i]+"\", \"name__attr\":\""+keys[i]+"\"},";
								saveRequired = true;
								}
							}
							if(saveRequired)
							{
								strObj = strObj.substr(0,strObj.length - 1);
								strObj = strObj + "]}";
								outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strObj}};
							}
							else//Send atleast one key value pair so that engine marks the component as configured
							{
								strObj = strObj + "{\"value__attr\":\""+values[0]+"\", \"name__attr\":\""+keys[0]+"\"}]}"
								outData = {hapi:{component_id:compdata.hapi.component_id,config_file_data:strObj}};
							}
						}
						presenter.saveComponentConfig(item, outData, {
										success : function(compdatareturn) {
										if(compdatareturn.hapi.hcode==0)
										{
 										var compId=item.component_id;
 										compId = compId.replace(/(:|\.)/g,'');
 										$('#hpsum-NC-'+compId).hide();
 										$('#hpsum-C-'+compId).show();
 										$(CANCEL).trigger('click');
											return true;											
										}
										else{
											$('#hpsum-component-config-error').show();
											return false;
										}
										},
										error : function(errorInfo) {
											onComponentDataError(errorInfo);
										}}
										);
								return false;
						},
						cancel: function () {
						}
					});                
					var valueField,i,defaultValue;
					//Clear all the entries and add the header
					$('#hpsum-component-config-param tr').html('<thead><tr><td>' + localizer.getString('hpsum.baseline.show.parDesc') + '</td><td>' + localizer.getString('hpsum.baseline.show.value') + '</td><td>' + localizer.getString('hpsum.baseline.show.parName') + '</td></tr></thead>');
					var title = localizer.getString('hpsum.baseline.show.componentConfigFor') + item.component_id;
					$('#component_config_title').html(title);
					var radioValue;
					$('#hpsum-component-config-error').hide();
					if(!data.parameter.length)
					{
						var values = data.parameter["default"].value__attr;
						var valuesArray;
						if(values != "")
						{
							valuesArray = values.split(";");
						}
						var maxLen = data.parameter.requirements.input_requirements.maximum_length;
						var minLen = data.parameter.requirements.input_requirements.minimum_length;
						
						if(data.parameter.requirements.input_requirements.user_visible.value__attr == "no")
						{
							//Invisible
							//So ignore
						}
						else if(values == "" && (($.trim(data.parameter.requirements.input_requirements.required_format)).toLowerCase() == "y" || ($.trim(data.parameter.requirements.input_requirements.required_format)).toLowerCase() == "n"))
						{
							//Radio button
							radioValue = $.trim(data.parameter.output.value__attr).toLowerCase();
							if(radioValue == "yes")
							{
								valueField = "<table border=0><tr><td><label>" + localizer.getString('hpsum.common.yes') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"Yes\" checked></td></tr><tr><td><label>" + localizer.getString('hpsum.common.no') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"No\"></td></tr></table>";
							}
							else if(radioValue == "no" || radioValue == "")
							{
								valueField = "<table><tr><td><label>" + localizer.getString('hpsum.common.yes') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"Yes\" ></td></tr><tr><td><label>" + localizer.getString('hpsum.common.no') + "</label></td><td><input type=\"radio\" name=\"group\" value=\"No\" checked></td></tr></table>";
							}
						}
						else if(values == "" && maxLen < 26)
						{
							//input type text
							//check for password field
							if(data.parameter.requirements.input_requirements.password_field.value__attr == "yes")
							{
								valueField = "<input type=\"password\" value=\"" + data.parameter.output.value__attr + "\">";							
								//password field
							}
							else
							{
								valueField = "<input type=\"text\" value=\"" + data.parameter.output.value__attr + "\">";
							}						
						}
						else if(values == "" && maxLen > 24)
						{
							//text area
							valueField = "<textarea rows=\"4\" cols=\"50\">" + data.parameter.output.value__attr + "<\/textarea>";								
						}
						else if(valuesArray.length > 1)
						{
							//Combo box
							var j, comboField = "<select value=\"" + data.parameter.output.value__attr + "\">" ;
							for(j=0;j<valuesArray.length;j++)
							{
								if(valuesArray[j]==data.parameter.output.value__attr)
								{
									comboField = comboField + "<option selected>" + valuesArray[j] + "</option>";
								}
								else
								{
									comboField = comboField + "<option>" + valuesArray[j] + "</option>";
								}
							}
							valueField = comboField + "</select>";
						}
						
						$('#hpsum-component-config-param tr:last').after('<tr><td>' + data.parameter.user_prompt + '</td><td>'+valueField+'</td><td>' + data.parameter.name__attr + '</td></tr>');
					}
					else
					{
						var tdid,rYesId,rNoId;
						//Determine the value of valufield for each parameter
						for(i=0;i<data.parameter.length;i++)
						{
							var values = data.parameter[i]["default"].value__attr;
							var valuesArray, isMultiValueField = false;
							tdid = data.parameter[i].name__attr;
							
							if (values)
							{
								if(values.indexOf(";") >= 0)
								{
									valuesArray = values.split(";");
									isMultiValueField = true;
								}
								else if(values.indexOf(":") >= 0)
								{
									valuesArray = values.split(":");
									isMultiValueField = true;
								}
							}
							var maxLen = data.parameter[i].requirements.input_requirements.maximum_length;
							var minLen = data.parameter[i].requirements.input_requirements.minimum_length;
							
							if(data.parameter[i].requirements.input_requirements.user_visible.value__attr == "no")
							{
								//Invisible
								//So ignore
								continue;
							}
							else if(!isMultiValueField && (($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "y" || ($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "n"))
							{
								//Radio button
								rYesId = tdid + 'y';
								rNoId = tdid + "n";
								radioValue = $.trim(data.parameter[i].output.value__attr).toLowerCase();
								if(radioValue == "yes")
								{
									valueField = "<label>" + localizer.getString('hpsum.common.yes') + "</label><input id = \""+rYesId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+"\" value=\"Yes\" checked>&nbsp;&nbsp;&nbsp;&nbsp;<label>" + localizer.getString('hpsum.common.no') + "</label><input id = \""+rNoId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+"\" value=\"No\">";
								}
								else if (radioValue == "no" || radioValue == "")
								{
									valueField = "<label>" + localizer.getString('hpsum.common.yes') + "</label><input id = \""+rYesId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+ "\" value=\"Yes\">&nbsp;&nbsp;&nbsp;&nbsp;<label>" + localizer.getString('hpsum.common.no') + "</label><input id = \""+rNoId+"\" type=\"radio\" name=\""+data.parameter[i].name__attr+"\" value=\"No\" checked>";
								}
							}
							else if(!isMultiValueField && maxLen < 26)
							{
								//input type text
								//check for password field
								if(data.parameter[i].requirements.input_requirements.password_field.value__attr == "yes")
								{
									valueField = "<input type=\"password\" value=\"" + data.parameter[i].output.value__attr + "\">";							
									//password field
								}
								else
								{
									valueField = "<input type=\"text\" value=\"" + data.parameter[i].output.value__attr + "\">";
								}						
							}
							else if(!isMultiValueField && maxLen > 24)
							{
								//text area
								//check for password field
								if(data.parameter[i].requirements.input_requirements.password_field.value__attr == "yes")
								{
									valueField = "<input type=\"password\" value=\" size=\"" +maxLen+ "\"" + data.parameter[i].output.value__attr + "\">";
									//password field
								}
								else
								{
									valueField = "<textarea rows=\"4\" cols=\"50\">" + data.parameter[i].output.value__attr + "<\/textarea>";
								}
							}
							else if(isMultiValueField)
							{
								if(valuesArray.length > 1)
								{
									//Combo box
									var j, comboField = "<select value=\"" + data.parameter[i].output.value__attr + "\">" ;
									for(j=0;j<valuesArray.length;j++)
									{
										if(valuesArray[j]==data.parameter[i].output.value__attr)
										{
											comboField = comboField + "<option selected>" + valuesArray[j] + "</option>";
										}
										else
										{
											comboField = comboField + "<option>" + valuesArray[j] + "</option>";
										}
									}
									valueField = comboField + "</select>";
								}
							}
							//Add the row to config table
							$('#hpsum-component-config-param tr:last').after('<tr><td>' + data.parameter[i].user_prompt + '</td><td id="'+tdid+'">'+valueField+'</td><td>' + data.parameter[i].name__attr + '</td></tr>');
						}
					
						//Handle dependencies
						var tdid, temp = {};
						for(i=0;i<data.parameter.length;i++)
						{
							if(data.parameter[i].depends)
							{
								if($.trim(data.parameter[i].depends.dependent.name__attr) != "")
								{
									// disable the td of dependent param
									$('#' + $.trim(data.parameter[i].name__attr)).find(':input').prop("disabled", true);
									
									// add onclick event param to enable/disable the dependent param
									var values = data.parameter[i]["default"].value__attr;
									var inputType, srcElem;
									
									//If the field on which other field depends is a radio button
									if(!(values.indexOf(';')>0)&& (($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "y" || ($.trim(data.parameter[i].requirements.input_requirements.required_format)).toLowerCase() == "n"))
									{
										tdid = $.trim(data.parameter[i].depends.dependent.name__attr) + data.parameter[i].depends.dependent.value__attr.toLowerCase();
										inputType="radio";
									}
									else if(!(values.indexOf(';')>0))
									{
										tdid = $.trim(data.parameter[i].depends.dependent.name__attr);
										inputType="text";
									}
									else
									{
										tdid = $.trim(data.parameter[i].depends.dependent.name__attr);
										inputType="combo";
									}
									
									//Maintaining dictionary of params and dependent params
									temp[tdid] = $.trim(data.parameter[i].name__attr);
									
									if(inputType == "radio")
									{
										$("#"+ tdid).live('change',function(e){
										srcElem = getSrcElem(browserType, e);
										$('#' + temp[srcElem.id]).find(':input').prop("disabled", false);
										});
										
										//This logic holds good when dependent params are radio buttons (Most likely in configurable component)
										if(data.parameter[i].depends.dependent.value__attr.toLowerCase() == "y")
										{
											tdid = $.trim(data.parameter[i].depends.dependent.name__attr) + "n";
											if(!temp[tdid])
											{
												temp[tdid] = $.trim(data.parameter[i].name__attr);
											}
											$("#"+ tdid).live('change',function(e){
											srcElem = getSrcElem(browserType, e);
											$('#' + temp[srcElem.id]).find(':input').prop("disabled", true);
											});
										}
										else if(data.parameter[i].depends.dependent.value__attr.toLowerCase() == "n")
										{
											tdid = $.trim(data.parameter[i].depends.dependent.name__attr) + "y";
											if(!temp[tdid])
											{
												temp[tdid] = $.trim(data.parameter[i].name__attr);
											}
											$("#"+ tdid).live('change',function(e){
											srcElem = getSrcElem(browserType, e);
											$('#' + temp[srcElem.id]).find(':input').prop("disabled", false);
											});
										}
									}
									else if(inputType=="combo")
									{
										var depValue = data.parameter[i].depends.dependent.value__attr.toLowerCase();
										var defaultVal = data.parameter[i].output.value__attr;
										$("#"+ tdid).live('change',function(e){
										srcElem = getSrcElem(browserType, e);
										if(srcElem.value.toLowerCase() == depValue)
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", false);
										}
										else
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", true);
										}
										});
									}
									else
									{
										$("#"+ tdid).live('change',function(e){
										srcElem = getSrcElem(browserType, e);
										if(srcElem.value.toLowerCase() != "")
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", false);
										}
										else
										{
											$('#' + temp[e.currentTarget.id]).find(':input').prop("disabled", true);
										}
										});
									}
								}
							}
						}
					}
				}
				else
				{
					var errorInfo = "Configure Information Unavailable";
					onComponentDataError(errorInfo);
				}
            }
			function getSrcElem(browserType, e){
				var srcElem;
				if(browserType==1){
				srcElem = e.target;//Firefox
				}
				else{
				srcElem = e.srcElement;//Chrome and IE
				}
				return srcElem;
			}
            function onComponentDataError(errorInfo) {
            }

            function onItemError(errorMessage) {
            }
            
            function onSelectionChange(selection) {
                //urlFragment.replaceHrefUris(HEADER + ', ' + PANEL_SELECTOR, selection.uris);
				urlFragment.replaceHrefUris(HEADER,
                    selection.uris, selection.multiSelectId);
                if ($(HEADER).hasClass('hp-show-init')) {
                    $(HEADER).removeClass('hp-show-init');
                } else {
                    $(HEADER).addClass('hp-show-changing');
                    //$(ACTIONS).addClass('hp-disabled');
                }
            }
            
            function onChange() {            	
            	var selection = $(SCHEDULE_TYPE).hpSelect('get');
            	$('#rec-every-for-schedule').text = selection;            	
            }
            
            function onItemDeleteSuccess(item_name) {
                //notifications.show("Deleted " + item_name);
                deleteInProgress = false;
                
                $(DELETE_DIALOG).dialog('close');
                deleteInProgress = false;
            }

            /**
             * @private
             */
            function onItemDeleteError(errorMessage) {
                notifications.show(errorMessage);
                // real product code should also ensure hp-details-notify
                // is populated via item state
                deleteInProgress = false;
            }

            /**
             * @private
             */
            function onDeleteItem(ev) {
                
                if (! deleteInProgress) {
                    deleteInProgress = true;
                    $('#hpsum-baseline-delete-contents',deleteDialogContents).html("Continue with Delete?");
					var bName = presenter.selectionLabel();
					if(bName == '')
						return;
                    localizer.localizeDom(deleteDialogContents);
                    $(DELETE_TITLE, deleteDialogContents).text(
                        localizer.getString('core.deleteConfirm.title',
                            [bName]));
                    
                    new DialogView({contents: deleteDialogContents,
                        ok: function () {
                                presenter.removeBaseline(baselineItem, {
                        		success : onItemDeleteSuccess,
                       			 error : onItemDeleteError
                    			});
                        },
                        cancel: function () {
                            deleteInProgress = false;
                        }
                    });


                }
                
                ev.preventDefault();
            }
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
            /**
             * @public
             */
             
            this.pause = function () {
            	$(COMPONENT_TABLE).dataTable().fnClearTable();
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                if(timer)
                	clearInterval(timer);
            };
            
            this.resume = function () {
            	$(COMPONENT_TABLE).dataTable().fnClearTable();
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                if(timer)
                {
                	clearInterval(timer);
                	timer = null;
                }
            };
            
            this.init = function() {
            	$(SCHEDULE_DATE_AND_TIME).datetimepicker({ dateFormat: "yy-mm-dd"});
            	scheduleDialogContents = $(SCHEDULE_DIALOG).detach().show();
            	deleteDialogContents = $(DELETE_DIALOG).detach().show();
                var deleteConfirmButtons = {};

                detailsShowView.init();
                $('.hp-details-actions').hpDropMenu();
                notificationsView.init($(VIEW), '#/baseline/show/alerts');
                
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                $(DELETE_ACTION).bind('click', onDeleteItem);
                
                $(COMPONENT_TABLE + ' tbody td').click( function () {
				    // Get the position of the current data from the node
				    var aPos = $(COMPONENT_TABLE).dataTable().fnGetPosition( this );
				     
				    // Get the data array for this row
				    var aData = $(COMPONENT_TABLE).dataTable().fnGetData( aPos[0] );
				     
				    
				});
                
                //Sample data added here to show contents section in the Details pane
                /*
                var data = [{component_file_name: "1", package_name: "HP System Management Home page for Windows", component_version: "6.10.002"},
				    {component_file_name: "2", package_name: "Headless Server Registry update for Windows", component_version: "4.2.021"}];
				*/
				var compId;    
				var oTab = $(COMPONENT_TABLE).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.baseline.show.noComponentsFound")
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [				        
                        {mDataProp: 'component_file_name',
                fnRender: function (oObj) {
                    return '<a href="javascript:void(0);">'+ oObj.aData.component_file_name + '</a>';
                }},

				        {mDataProp: 'package_name'},
				        {mDataProp: 'product_typeInString'},
				        {mDataProp: 'criticality'},
				        {mDataProp: 'component_version'},
						{mDataProp: 'config_required', sDefaultContent: "",
                        fnRender: function (oObj) {
						if(oObj.aData.config_required == true) {
						compId = oObj.aData.component_id;
						compId = compId.replace(/(:|\.)/g,'');
							if(oObj.aData.is_configured == false)
							{
								return '<a id="hpsum-NC-'+compId+'" href="javascript:void(0);">' + localizer.getString('hpsum.baseline.show.needConfig') + '</a><a id="hpsum-C-'+compId+'" href="javascript:void(0);" style="display: none">Configured</a>';
							}
							else
							{
								return '<a id="hpsum-C-'+compId+'" href="javascript:void(0);">' + localizer.getString('hpsum.baseline.addBaseline.configured') +'</a>';
							}
						}
							return '<div align="center" class=""></div>'; },
                        sWidth: 15}],
				    	aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        return nRow;
				    }
				    });
				 
				$(COMPONENT_TABLE + ' tbody tr').first().addClass('hp-selected');
				
				componentDialogContents = $(COMPONENT_DIALOG).detach().show();
				componentConfigDialogContents = $(COMPONENT_CONFIG_DIALOG).detach().show();
			   
			    router.watch('baseline show section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
				this.resume();
            };
            
        }

        return new BaselineShowView();
    }());
    
    return BaselineShowView;
});
