// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeAddView)
 * This is a view class for Node Add menu option.
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Validator',
    'hp/view/FormStateView',
	'hp/view/DialogView',
    'hp/core/HelpMenu',
	'hp/services/REST',
    'hp/core/Localizer',
	'hp/model/Session',
    'text!hpPages/core/header_help.html',
    'jquery',
	'hpsum/view/node/jquery.hpsumInstallables',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpToggle'],
function(presenter, router,urlFragment,validator, FormStateView, DialogView, helpMenu,rest, localizer,session, headerHelpHtml) { "use strict";
    	
    	var AddView = (function() {
    		var ADD = '#hpsum-node-add',
            	CANCEL = '#hpsum-node-add-close',
				CLOSE = '#hpsum-ipdialog-close',
             	RESET = '#hpsum-node-reset',
				PANEL_SELECTOR = '#hpsum-node-add-panel-selector',
            	FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            	PANELS = '#hpsum-node-add-panels',	
           		NAME = '#hpsum-node-name',
           		NAMEERR= '#hpsum-node-name-error',
           		DESC = '#hpsum-node-description',
           		TYPE ='#hpsum-node-type',
           		TYPEERR='#hpsum-node-type-error',
           		ENTER_CRED = '#hpsum-node-cred-details',
				ENTER_LINUX_CRED = '#hpsum-linux-node-cred-details',
           		USERNAME = '#hpsum-node-credential-username',
           		USERNAME_ERR ='#hpsum-node-username-err',
           		PASSWORD = '#hpsum-node-credential-password',
           		PASSWORD_ERR ='#hpsum-node-password-err',
				LINUX_CRED_PANEL = '#hpsum-linux-node-add-credentials',
				LINUXUSERNAME = '#hpsum-linux-node-credential-username',
				LINUXUSERNAME_ERR = '#hpsum-linux-node-username-err',
           		LINUXPASSWORD_ERR = '#hpsum-linux-node-password-err',
				LINUXPASSWORD = '#hpsum-linux-node-credential-password',
           		FORM = '#hpsum-node-add-form',
            	SEARCHER = '#hpsum-node-searcher',
            	BASELINES = '#hpsum-node-add-baselines-search',
            	HOTFIX = '#hpsum-node-add-hotfix-search',
            	COLLAPSE = '#hpsum-node-add-bandwidth',
            	PARTNER_TYPE ='#hpsum-node-add-partner',
            	PARTNER_CRED_PANEL ='#hpsum-node-add-partner-credentials',
            	PARTNER_IP_LABEL = '#hpsum-node-partner-ip',
            	PARTNER_IP_VALUE ='#hpsum-node-partner-ip-value',
            	PARTNER_ENTER_CRED = '#hpsum-node-partner-cred-details',
            	PARTNER_USERNAME = '#hpsum-node-partner-credential-username',
           		PARTNER_PASSWORD = '#hpsum-node-partner-credential-password',
            	ROUTE_PREFIX = '/node/add',
				FIND_NODES_BUTTON = '#hpsum-ip-dialog',
				SEARCH_BUTTON = '#hpsum-node-search',
				IP_DIALOG = '#hpsum-node-ip-dialog',
				IP_FORM_CONTENT = '#hpsum-all-form-content',
				IP_DIALOG_HEADER = '#hp-ip-header',
				IP_DIALOG_FOOTER = '#hp-ip-footer',
				IP_START = '#hpsum-ip-start',
				IP_END = '#hpsum-ip-end',
				NODE_COMP = '#hpsum-node-components',
				SEARCH_NODE = '#hpsum-search-node',
				SEARCH_DIALOG = '#hpsum-search-dialog',
				SEARCH_SPINNER = '#hpsum-search-spinner',
				APPLY_SETTINGS_BUTTON = '#hpsum-apply-settings',
				NODESETTINGS_DIALOG = '#hpsum-node-settings-dialog',
				NODESETTINGS_CRED = '#hpsum-node-settings-cred-details',
           		NODESETTINGS_USERNAME = '#hpsum-node-settings-credential-username',
           		NODESETTINGS_USERNAME_ERR ='#hpsum-node-settings-username-err',
           		NODESETTINGS_PASSWORD = '#hpsum-node-settings-credential-password',
           		NODESETTINGS_PASSWORD_ERR ='#hpsum-node-settings-password-err',
				NODESETTINGS_BASELINE = '#hpsum-node-settings-add-baselines-search',
				NODESETTINGS_HOTFIX = '#hpsum-node-settings-add-hotfix-search',
				NODESETTINGS_ADD = '#hpsum-node-settings-add',
				NODESETTINGS_RESET = '#hpsum-node-settings-reset',
                NODE_SELECTED = '#hpsum-node-comp-selected',
				NODESETTINGS_CANCEL = '#hpsum-node-settings-close',
				IP_ERR = '#hpsum-node-settings-err',
				ADD_ASSOC_NODES = '#hpsum-node-addassocnodes';
           		
    		function AddView(){
    			
    			var formStateView = new FormStateView(),
					useCurrentCredentials = false,
    				useSudoCredentials = false,
					rootUsername='',
					rootPassword='',
    				partnerUsername='',
    				partnerPassword='',
    				baselines='',
    				hotfixes='',
    				addInProgress = false,
					checkedVal = '',
					nodeSettingsDialog= null,
					node_table,
                    node_data = [],
					nodeIpDialog= null;
					var IpdialogContents;
					var nodeSettingsDialogContents;
    			    var node_details = [];
					var selected_nodes = [];
					var added_nodes = [];
			    	var complex_id;
					var searchInProgress = false;
					var progressTimer;
    			
    			
    		function changeLocation(location) {
                	
              if (location.length > ROUTE_PREFIX.length) {
                   $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
               	} else {
                   $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            	
           function onItemAddSuccess(data) {
			  addInProgress = false;
			  if(data.hapi.hcode > 0)
			  {
				onItemAddError(localizer.getString('hpsum.node.duplicateNode'));
			  }
			  else
              $(CANCEL).trigger('click');
           }
		   
		   function onItemsAddSuccess(data) {
			  addInProgress = false;
			  nodeSettingsDialog.cancel();
			  addselected();
			}
           
		   function addselected()
           {
             var node_selected_id = '#hpsum-node-selected-table';
			 var node_tableid = '#hpsum-node-table';

             var node_selected_table =  $(node_selected_id).dataTable();
			 var node_table = $(node_tableid).dataTable();
			 
			 for( var j=0;j<selected_nodes.length;j++)
			 {
				added_nodes.push(selected_nodes[j]);
				node_details.pop(selected_nodes[j]);				
			 }
			 if(node_selected_table.length != 0)
				node_selected_table.fnClearTable();
             node_selected_table.fnAddData(added_nodes); 
			 				
			 selected_nodes = [];
			 
			 var nNodes = node_table.fnGetNodes( );
			 var aRow = new Array();
			 for( var i=0;i<nNodes.length;i++)
			 {
				if ( $(nNodes[i]).hasClass('hp-selected') ) 
				{					
					aRow.push($(nNodes[i]).closest('tr')[0]);
				}
			 }
			 
			 for( var j=0;j<aRow.length;j++)
			 {
				node_table.fnDeleteRow(aRow[j]);
			 }
			 nNodes = node_table.fnGetNodes( );
			 
			 $(APPLY_SETTINGS_BUTTON).attr("disabled","disabled");
            }
		   
            function NodeSelectedTable(tableid) {
              
			  var oTab = $(tableid).dataTable({
			  oLanguage: {
					sEmptyTable: localizer.getString('hpsum.node.noAddedNodes')
						},
				bPaginate : false,
				bProcessing : true,
				bFilter : false,
				bSort : true,
				bAutoWidth : false,
				bInfo : false,
				bRetrieve : true,
				bDestroy : true,
				//aaData: data,
				aoColumns : [
				{mDataProp: 'node_ip'},
				{mDataProp: 'node_name'}
				],
				aaSorting: [[ 0, "asc" ]],
				fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
					//$(nRow).attr('id', aData.component_file_name);
					return nRow;
            }
          
      });
      }
		   
		   function onItemsAddError(data) {			                
              reset();			  
			  addInProgress = false;			  
           }
           
           function onTypeEdit(){
           		$(TYPEERR).hide();
            	$(TYPE).removeClass("hp-error");
            	$(TYPE).unbind('mousedown', onTypeEdit);
           }
           function showPartnerOptions() {
            	//$(TYPE).unbind('mousedown', onTypeEdit);
            	if($(TYPE).val().toLowerCase().match(/Windows/i) ||
            			$(TYPE).val().toLowerCase().match(/Linux/i) ||
            			$(TYPE).val().toLowerCase().match(/HP-UX/i))
            				$('#hpsum-node-add-alreadyExist').show();
            		else	
            				$('#hpsum-node-add-alreadyExist').hide();
							
				if($(TYPE).val().toLowerCase().match(/Linux/i)){
					$(LINUX_CRED_PANEL).css({"display":""});
					$(LINUXUSERNAME).removeClass("hp-error");
					$(LINUXPASSWORD).removeClass("hp-error");
					$(LINUXUSERNAME_ERR).hide();
					$(LINUXPASSWORD_ERR).hide();
					$(ENTER_LINUX_CRED).hide();
					
					var value = $("input[name='hpsum-node-credential']:checked").val();
					
					if(value == 'one'){
						$('input[name="hpsum-linux-node-credential"]').attr("disabled",true);
						$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentialsApplicable'));
					}
					else {
						$('input[name="hpsum-linux-node-credential"]').attr("disabled",false);
						$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentials'));
					}
					
					//$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
            		 //linuxCredentialOptions('two');
				}
				else
					$(LINUX_CRED_PANEL).css({"display":"none"});
            		
            	if($(TYPE).val().toLowerCase().match(/sas_switch/i) || 
            		$(TYPE).val().toLowerCase().match(/vc/i) ||
            		$(TYPE).val().toLowerCase().match(/pdu/i)) {
            			if($(TYPE).val().toLowerCase().match(/pdu/i)){
            				$(PARTNER_TYPE).html("Partner iPDU Credentials");
            				$(PARTNER_IP_LABEL).html("Partner iPDU IP/DNS")
            			}
            			else{
            				$(PARTNER_TYPE).html("Associated Onboard Administrator Credentials");
            				$(PARTNER_IP_LABEL).html("Associated Onboard Administrator IP/DNS")
            			}
            				
            			$(PARTNER_CRED_PANEL).css({"display":""});;
            			$('input[name="hpsum-node-partner-credential"]').click(partnerCredentialsOptions);
            			partnerCredentialsOptions("two");
            		
            		}
            	else
            		$(PARTNER_CRED_PANEL).css({"display":"none"});
				
				if($(TYPE).val().toLowerCase().match(/vc/i) ||
            			$(TYPE).val().toLowerCase().match(/sas_switch/i) ||
            			$(TYPE).val().toLowerCase().match(/enclosure/i) ||
						$(TYPE).val().toLowerCase().match(/switch/i) ||
						$(TYPE).val().toLowerCase().match(/ilo/i)) {
            				$(ADD_ASSOC_NODES).show();
							$('#hpsum-node-addassoc-description').show();
				}
            	else {	
            			$(ADD_ASSOC_NODES).hide();
						$('#hpsum-node-addassoc-description').hide();
				}
            
           }
           
		   function linuxCredentialOptions(value){
          		if(value.target)
            		value = value.target.value;
				if(checkedVal === value)
				{
					checkedVal = '';
					useSudoCredentials =false;
					if(value ==="one")
						$('#hpsum-linux-node-sudo').attr('checked',false);
					if(value == "two"){
						$(ENTER_LINUX_CRED).hide();
						$('#hpsum-linux-node-root').attr('checked',false);
					}
				}
				else{
					checkedVal = $('input[name="hpsum-linux-node-credential"]:checked').val();
					if(value == "one"){
						$(ENTER_LINUX_CRED).hide();
						useSudoCredentials =true;
					}
					if(value == "two"){
						$(ENTER_LINUX_CRED).show();
						rootUsername = $(LINUXUSERNAME).val();
						rootPassword = $(LINUXPASSWORD).val();
						useSudoCredentials= false;
					}
				}
            }
			
           function partnerCredentialsOptions(value)
           {
           	    if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(PARTNER_ENTER_CRED).hide();
            		partnerUsername= $(USERNAME).val();
            		partnerPassword= $(PASSWORD).val();
            		//useCurrentCredentials =true;
            	}
            	if(value == "two"){
            		$(PARTNER_ENTER_CRED).show();
            	}
           	
           }
           
           function onNameEdit(){
           		$(NAMEERR).hide();
            	$(NAME).removeClass("hp-error");
            	$(NAME).unbind('keyup',onNameEdit);
           }
           
          function onItemAddError(msg) {	
              addInProgress = false;
              $(NAMEERR).text(msg);
              $(NAME).addClass("hp-error");
              $(NAMEERR).show();
              $(NAME).keyup(onNameEdit);
           }
           
          function reset() {
				formStateView.reset();
                addInProgress = false;
				searchInProgress = false;
                $(NAMEERR).hide();
                $(PARTNER_CRED_PANEL).css({"display":"none"});;
				$(LINUX_CRED_PANEL).css({"display":"none"});
            	$(NAME).removeClass("hp-error");
				$(NODESETTINGS_USERNAME).removeClass("hp-error");
            	$(NODESETTINGS_PASSWORD).removeClass("hp-error");
            	$(NODESETTINGS_USERNAME_ERR).hide();
            	$(NODESETTINGS_PASSWORD_ERR).hide();
            }
            
            function validate()
            {
            	var returnValue
            	
            	if($(TYPE).val().match(/Linux/i))
					returnValue = validateName($(NAME).val())  &&
            			validateType() && validateCredentials() && validateSudoCredentials();
				else
					returnValue = validateName($(NAME).val())  &&
            			validateType() && validateCredentials();
						
            	return returnValue;
            		
            }
			function initIpdialog()
			{	
				
				nodeIpDialog = new DialogView({contents: IpdialogContents,
                	position : "center",  	
					cancel : function() {
						searchInProgress = false;
						clearInterval(progressTimer);
						$(SEARCH_BUTTON).off('click',btnSearchClicked);
						router.go('/node/show/');
					}
                 });

				//lets set the ip table form contents max-height
				$(IP_DIALOG).css('max-height',$(window).height() - 40 );
				var maxheight = ($(window).height() - 40) - ($(IP_DIALOG_HEADER).height() + $(IP_DIALOG_FOOTER).height());

				$(IP_FORM_CONTENT).css('max-height',maxheight);

				$(IP_ERR).hide();
				$(IP_START).val('');
				$(IP_END).val('');				
				$(IP_START).removeClass("hp-error");
				$(IP_END).removeClass("hp-error");
		        $(SEARCH_BUTTON).attr("disabled",true);
				$(IP_START).change(function(){
					if(($(IP_START).val() != '') && ($(IP_END).val() != '')){
						$(IP_ERR).hide();
						$(IP_START).removeClass("hp-error");
						$(SEARCH_BUTTON).removeAttr('disabled');
					}
					else
						$(SEARCH_BUTTON).attr("disabled",true);
            		});
				$(IP_END).change(function(){
					if(($(IP_START).val() != '') && ($(IP_END).val() != '')){
						$(IP_ERR).hide();
						$(IP_END).removeClass("hp-error");
						$(SEARCH_BUTTON).removeAttr('disabled');
					}
					else
						$(SEARCH_BUTTON).attr("disabled",true);
            		});
					
				var node_tableid = '#hpsum-node-table';
				initNodeTable(node_tableid);
				var node_table = $(node_tableid, IpdialogContents).dataTable();
				var node_selected_id = '#hpsum-node-selected-table';
				NodeSelectedTable(node_selected_id);
				var node_selected_table =  $(node_selected_id, IpdialogContents).dataTable();
				
				if(node_table.length != 0)
					node_table.fnClearTable();
				if(node_selected_table.length != 0)
					node_selected_table.fnClearTable();
				
				$(APPLY_SETTINGS_BUTTON, IpdialogContents).attr("disabled","true");
				
				$(CLOSE, IpdialogContents).on('click', function () {
					nodeIpDialog.cancel();
				});
				
				$(SEARCH_BUTTON, IpdialogContents).on('click', btnSearchClicked);
			}
			
			function validatefindnodesip(ip){
            	//ipv4 match
            	if(ip == '0.0.0.0' | ip == '255.255.255.255'){
					return "invalid";
            	}
            	var patt = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/
            	if(ip.match(patt))
            		return "ip";
            	else{
            		patt = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?$/
            		if(ip.match(patt))
            			return "ipv6";
					else{
            			return "invalid";
            		}
            	}
            		
           }
			function btnSearchClicked()
			{
				selected_nodes = [];
				added_nodes = [];
				
				var ipstarttype = validatefindnodesip($(IP_START).val());
				var ipendtype = validatefindnodesip($(IP_END).val());
				if((ipstarttype === ipendtype) && (!ipstarttype.match(/invalid/i)) && (!ipendtype.match(/invalid/i)))
				{
					if(!searchInProgress)
					{
						searchInProgress = true;
						showSearchSplash();
						var ip_start = $(IP_START).val();
						var ip_end = $(IP_END).val();
						var max_returns = 50;
						var type = ipstarttype;
						presenter.FindNodes(ip_start,ip_end,max_returns,type, {
								 
							success : function(data) {
							onFindNodesSuccess(data); 
							},
							error : function(errorInfo) {
									onFindNodesError(errorInfo);
								}
						});
					}
				}
				else
				{	
					$(IP_ERR).show();
					if(ipstarttype.match(/invalid/i))
						$(IP_START).addClass("hp-error");
					if(ipendtype.match(/invalid/i))
						$(IP_END).addClass("hp-error");
					$(SEARCH_BUTTON).attr("disabled",true);
				}
			}
				
			function onFindNodesSuccess(data)
			{
				var complex_id = data.hapi.complex_id;
				var node_uri = "/Session/" + session.getToken() + "/complex/" + complex_id ;
				
				var node_tableid = '#hpsum-node-table';
			    var node_table = $(node_tableid).dataTable();
				if(node_table.length != 0)
					node_table.fnClearTable();
			
				progressTimer = setInterval(function () {
				
				rest.getURI(node_uri + "/getstatus", {
				            success : function(data) {
							if(data.hapi.command_status === 1)
							{
							
							}
							else if(data.hapi.command_status === 0)
							{
								node_details = [];
                                clearInterval(progressTimer);
                                closeSearchSplash();		
								searchInProgress = false;

								for(var j=0; j<data.hapi.nodes.node.length; j++)
								{                
									var node_data = [{
									'node_name':data.hapi.nodes.node[j].node_name,
									'node_ip':data.hapi.nodes.node[j].node_address,
									}];
									node_table.fnAddData(node_data); 									
								}
								
								$(node_tableid + " tbody tr").click(function(e) 
								{
									node_details = node_table.fnGetData();
									var srcElem;
									//Check if firefox or (chrome and IE)
									if (e.srcElement) 
									{
										//Chrome and IE
										srcElem = e.srcElement;                                    
									} 
									else 
									{
										//Firefox
										srcElem = e.target;                          
									}
									var clickedCellIndex = srcElem.cellIndex
									if (clickedCellIndex === undefined) 
                                        $(APPLY_SETTINGS).attr("disabled",true);
									var bselected = false;									
									
									var nodedetails = node_table.fnGetData( this );
									if ( $(this).hasClass('hp-selected') ) {										
										bselected = false;
									}
									else {
										bselected = true;
									}
									$(this).toggleClass('hp-selected');
									if(bselected)
									{										
										selected_nodes.push(nodedetails);
									}
									else
									{										
										selected_nodes.pop(nodedetails);
									}
									if(selected_nodes.length === 0)
										$(APPLY_SETTINGS_BUTTON).attr("disabled",true);
									else
										$(APPLY_SETTINGS_BUTTON).removeAttr("disabled");
								});
							}							
							},
							error : function(errorInfo) {							
							}
						});
		          }, 3000);
			}
			
			function initNodeTable(tableid) 
			{            	
  				var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString('hpsum.node.noFoundNodes')
							},
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    //aaData: data,
				    aoColumns : [
						{mDataProp: 'node_ip'},
						{mDataProp: 'node_name'}
					  ],
					aaSorting: [[ 0, "asc" ]],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
					}
					
			});
			}
			
			function showSearchSplash(){
				
				 $(SEARCH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
			        dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
			    
			    $(SEARCH_SPINNER).show();	
			}
			
			function closeSearchSplash()
			{
			$(SEARCH_SPINNER).hide();
			$(SEARCH_DIALOG).dialog('destroy');
			}
			
			function onFindNodesError(errorInfo)
			{
				$(SEARCH_SPINNER).hide();
				$(SEARCH_DIALOG).dialog('destroy');
			}
			
			function initnodeSettingsDialog(selected_nodes)
			{
				$(NODESETTINGS_RESET).click();
				//reset.call();
				var useCurrentCredentials = false;
				nodeSettingsDialog =  new DialogView({contents: nodeSettingsDialogContents,
                	position : "center", 
					cancel: function () { }
                    });
					
				presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                                  
				$(NODESETTINGS_ADD, nodeSettingsDialogContents).live('click', function(ev) {
						var node_tableid = '#hpsum-node-table';
						var node_table = $(node_tableid).dataTable();
						var nNodes = node_table.fnGetNodes( );
						var aRow = [];
						for( var i=0;i<nNodes.length;i++)
						{
							if ( $(nNodes[i]).hasClass('hp-selected') ) 
							{
								var nodedetails = node_table.fnGetData( nNodes[i] );
								aRow.push(nodedetails);
							}
						}
                   		onNodeSettingsAddItem.call(this,aRow);
                    	ev.preventDefault();
				});
				
				$(NODESETTINGS_CANCEL,nodeSettingsDialogContents).on('click', function () {
                    nodeSettingsDialog.cancel();
                });
				$(NODESETTINGS_BASELINE).hpSearchCombo({getResults:getBaseline});
				$(NODESETTINGS_HOTFIX).hpSearchCombo({getResults: getHotfixes});
				$(NODESETTINGS_RESET, nodeSettingsDialogContents).live('click', function() {
					reset.call();
				});
				$('input[name="hpsum-node-settings-credential"]').click(nodesettingscredentialsOptions);
            	$('#hpsum-node-add-alreadyExist').hide();
				$('#hpsum-node-settings-credential-key').attr('checked',true);
            	nodesettingscredentialsOptions('two');
				$(NODESETTINGS_USERNAME).val('');
            	$(NODESETTINGS_PASSWORD).val('');
            	$(NODESETTINGS_USERNAME).removeClass("hp-error");
            	$(NODESETTINGS_PASSWORD).removeClass("hp-error");
            	$(NODESETTINGS_USERNAME_ERR).hide();
            	$(NODESETTINGS_PASSWORD_ERR).hide();
				$('#hpsum-node-settings-close', nodeSettingsDialogContents).click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
				 
			}
            
            function validateType(){
            	if($(TYPE).val().match(/Select Type/i)){
            		$(TYPEERR).text(" \t !Please select a type");
            		$(TYPE).bind('mousedown', onTypeEdit);
            		$(TYPEERR).show();
            		return false;
            	}
            	return true;	
            }
            
            function validateCredentials(){
            	if($('input[name="hpsum-node-credential"]:checked').val() == "one")
            		return true;
            	var success = true;
            	if($(USERNAME).val() == ''){
            		$(USERNAME).addClass("hp-error");
            		$(USERNAME_ERR).show();
            		$(USERNAME).bind('keyup', function(){
            			$(USERNAME_ERR).hide();
            			$(USERNAME).removeClass('hp-error');
            		});
            		success= false;
            	}
            	if($(PASSWORD).val() == ''){
            		$(PASSWORD).addClass("hp-error");
            		$(PASSWORD_ERR).show();
            		$(PASSWORD).bind('keyup', function(){
            			$(PASSWORD_ERR).hide();
            			$(PASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
            }
            
			function validateSudoCredentials(){
				var value = $('input[name="hpsum-linux-node-credential"]:checked').val();
				if((value == "one") || (value == "none") || (value == undefined))
            		return true;
            	var success = true;
            	if($(LINUXUSERNAME).val() == ''){
            		$(LINUXUSERNAME).addClass("hp-error");
            		$(LINUXUSERNAME_ERR).show();
            		$(LINUXUSERNAME).bind('keyup', function(){
            			$(LINUXUSERNAME_ERR).hide();
            			$(LINUXUSERNAME).removeClass('hp-error');
            		});
            		success = false;
            	}
            	if($(LINUXPASSWORD).val() == ''){
            		$(LINUXPASSWORD).addClass("hp-error");
            		$(LINUXPASSWORD_ERR).show();
            		$(LINUXPASSWORD).bind('keyup', function(){
            			$(LINUXPASSWORD_ERR).hide();
            			$(LINUXPASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
			}
	    
	    	function validateNodeSettingsCredentials(){
            	if($('input[name="hpsum-node-settings-credential"]:checked').val() == "one")
            		return true;
            	var success = true;
            	if($(NODESETTINGS_USERNAME).val() == ''){
            		$(NODESETTINGS_USERNAME).addClass("hp-error");
            		$(NODESETTINGS_USERNAME_ERR).show();
            		$(NODESETTINGS_USERNAME).bind('keyup', function(){
            			$(NODESETTINGS_USERNAME_ERR).hide();
            			$(NODESETTINGS_USERNAME).removeClass('hp-error');
            		});
            		success= false;
            	}
            	if($(NODESETTINGS_PASSWORD).val() == ''){
            		$(NODESETTINGS_PASSWORD).addClass("hp-error");
            		$(NODESETTINGS_PASSWORD_ERR).show();
            		$(NODESETTINGS_PASSWORD).bind('keyup', function(){
            			$(NODESETTINGS_PASSWORD_ERR).hide();
            			$(NODESETTINGS_PASSWORD).removeClass('hp-error');
            		}); 
            		success= false;
            	}
            	return success;
            }
            
            function validateName(ip){
            	if(ip.toLowerCase() == 'localhost')
            		return true;
            		//ipv4 match
            	if(ip == '0.0.0.0' | ip == '255.255.255.255'){
            		onItemAddError(localizer.getString('hpsum.node.ipCannotBe') + ' ' + ip);
            		return false;
            	}
            	var patt = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/
            	if(ip.match(patt))
            		return true;
            	else{
            		patt = /^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))?$/
            		if(ip.match(patt))
            			return true;
                    patt = /^[a-zA-Z0-9-_]+(\.[a-zA-Z0-9-_]+)*\.([a-zA-Z]{2,4})$/
                    //FQDN match
                    if(ip.match(patt))
                        return true;                           
            		else{
            			//check for unqualified domain name or netbios hostname
            			var hostnamepatt = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])$";
            			if(ip.match(hostnamepatt))
                        	return true;
                        	
            			onItemAddError(localizer.getString('hpsum.node.notValidIpOrDns'));
            			return false;
            		}
            	}
            		
           }
            	
		function onAddItem() {
        	if(validate()){
            	var nodeType, assocnodeType='';
            	switch ($(TYPE).val().toLowerCase()){
            		case "vmware":
            				nodeType = 'vmware';
            				break;
            		case "enclosure":
            				nodeType = 'oa';
            				break;
					case "sd2":
            				nodeType = 'sd2';
            				break;
            		case "sas_switch":
            				nodeType = 'sas_switch';
            				assocnodeType = 'oa';
            				break;
            		case "switch":
            				nodeType = 'fc_switch';
            				break;
            		case "pdu":
            				nodeType = 'ipdu';
            				assocnodeType = 'ipdu';
            				break;
            		case "vc":
            				nodeType = 'virtual_connect';
            				assocnodeType  = 'oa';
            				break;
            		default:
            			nodeType = $(TYPE).val().toLowerCase();
            			break; 
            	}
            	var baselineJson = [];
            	if(($(BASELINES).val() != '' ) && ($(HOTFIX).val() != '')){
					baselineJson.push($(BASELINES).val());
            		baselineJson.push($(HOTFIX).val());
            	}else if($(BASELINES).val() == ''){
            		baselineJson.push($(HOTFIX).val());
            	}else {
            		baselineJson.push($(BASELINES).val());
            	}
            	
            	var assocTargetDetails = null;
            	var pUsername, pPassword;
				if(nodeType.match(/virtual_connect|sas_switch|ipdu/))
            	{
            		var value = $("input[name='hpsum-node-partner-credential']:checked").val(); 
            			if(value == "one"){
            				pUsername = $(USERNAME).val();
            				pPassword = $(PASSWORD).val();
            			}else {
            				pUsername = $(PARTNER_USERNAME).val();
            				pPassword = $(PARTNER_PASSWORD).val();
            			}
            			
            		assocTargetDetails = {
            				ip: $(PARTNER_IP_VALUE).val(),
            				type :assocnodeType,
            				username : pUsername,
            				password : pPassword
            		};
            	}
				
				var susername,spassword;
				if(nodeType.match(/Linux/i)){
					if(useSudoCredentials){
						susername = "";
						spassword = "";
					}
					else{
						susername = $(LINUXUSERNAME).val();
						spassword = $(LINUXPASSWORD).val()
					}
				}
				//var auto_add_associated_nodes = $("input[name='hpsum-node-autoadd']:checked").val();
				var auto_add_assoc_nodes;
				if(nodeType.match(/virtual_connect|sas_switch|oa|fc_switch|ilo/i)){
					if($(ADD_ASSOC_NODES).is(':checked'))
						auto_add_assoc_nodes = true;
					else
						auto_add_assoc_nodes = false;
				}
            	
            	var node_skip = $("input[name='hpsum-node-active']:checked").val();
            	if(node_skip == "one")
            		node_skip = true;
            	else 
            		node_skip = false;
        		
              if(! addInProgress) {
              		addInProgress = true;
                    presenter.addItem({
                    	category: nodeType,
                    	name: $(NAME).val().toLowerCase(),
						description: $(DESC).val(),
                        status: 'Init',
                        username: $(USERNAME).val(),
                        password: $(PASSWORD).val(),
						su_username: susername,
						su_password: spassword,
						use_sudo: useSudoCredentials,
                        baseline: baselineJson,
                        associated_node:assocTargetDetails,
                        stateDetails: null,
                        node_skip: node_skip,
						auto_add_assoc_nodes: auto_add_assoc_nodes,
                        uri:null,
                        phase: null,
                        index:null,
                        }, true,{
                        	success : onItemAddSuccess,
                        	error : onItemAddError
                    });
                        
                    }
    			}

    		}	
    		
			function onNodeSettingsAddItem(selected_nodes) {
        	if(validateNodeSettingsCredentials()){
				var node_object = {
						hapi:{
							nodes:{
								node:[]
							}
						}
					};
            	var baselineJson = [];
            	if(($(NODESETTINGS_BASELINE).val() != '' ) && ($(NODESETTINGS_HOTFIX).val() != '')){
					baselineJson.push($(NODESETTINGS_BASELINE).val());
            		baselineJson.push($(NODESETTINGS_HOTFIX).val());
            	}else if($(NODESETTINGS_BASELINE).val() == ''){
            		baselineJson.push($(NODESETTINGS_HOTFIX).val());
            	}else {
            		baselineJson.push($(BASELINES).val());
            	}

				var baselineinfo = {
						baseline:[]
						};
				for (var tmp = 0; tmp < baselineJson.length; tmp++) {
					if(baselineJson[tmp]){
						var baselinedetails = presenter.getBaselineDetailsforId(baselineJson[tmp]);
						var baselinedata = {
								uri:baselinedetails.location,
								bundle_name:baselinedetails.bundleid
							};
						baselineinfo.baseline.push(baselinedata);
					}
				}
            
				for (var i = 0; i < selected_nodes.length; i++) {
					var node = {
						ip : selected_nodes[i].node_ip,
						selected :true,
						baselines : baselineinfo,
						authentication :{
							username : $(NODESETTINGS_USERNAME).val(),
							password : $(NODESETTINGS_PASSWORD).val(),
							use_current_credentials : useCurrentCredentials,
							auto_add_assoc_nodes : false
						}
					};  
					node_object.hapi.nodes.node.push(node);

				}

				if(! addInProgress) {
              		addInProgress = true;
                    presenter.addItems(node_object, {
                        	success : onItemsAddSuccess,
                        	error : onItemsAddError
                    });
                        
                    }
				}

    		}

    		function baselinesAvailable(data){
    			//data = {count: data.count, members: data};
            //	$(BASELINES).hpSearchCombo({getResults: presenter.getResults});
            }
            
            function getBaseline(string, handlers){
            	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(baselines, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string, 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results});
        	}
          
          	function getHotfixes(string, handlers){
          		  	var results=[];
            		if (string && string.length > 0) {
              			 results =
                		    $.grep(hotfixes, function(option, index) {
                    		    return (option.name.match(
                  	         			 new RegExp(string, 'i')));
                  		  });	
           			 }
            		handlers.success({count: results.length, members: results});
          	}
            
            function getBaselinesSuccess(searchResults)
            {
            		baselines = $.grep(searchResults, function (option, index ) {
        				return !(option.name.match(new RegExp('^Additional', 'i')));
        			});
        			hotfixes = $.grep(searchResults, function (option, index) {
        				return (option.name.match(new RegExp('^Additional', 'i')));
           			});
            }
            
            function getBaselinesError(msg)
            {
            	
            }
            
            function credentialsOptions(value){
          		if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(ENTER_CRED).hide();
            		useCurrentCredentials =true;
            		if($(TYPE).val().toLowerCase().match(/Linux/i))
            		{
            			$('input[name="hpsum-linux-node-credential"]').attr("disabled",true);
            			$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentialsApplicable'));
            		}
            	}
            	if(value == "two"){
            		$(ENTER_CRED).show();
            		$(USERNAME).removeClass("hp-error");
            		$(PASSWORD).removeClass("hp-error");
            		useCurrentCredentials= false;
            		if($(TYPE).val().toLowerCase().match(/Linux/i))
            		{
            			$('input[name="hpsum-linux-node-credential"]').attr("disabled",false);
            			$('#hpsum-linux-access-level-label').html(localizer.getString('hpsum.common.linuxcredentials'));
            		}
            	}
            		
            }
            
			function nodesettingscredentialsOptions(value){
          		if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(NODESETTINGS_CRED).hide();
            		useCurrentCredentials =true;
            	}
            	if(value == "two"){
            		$(NODESETTINGS_CRED).show();
            		$(NODESETTINGS_USERNAME).removeClass("hp-error");
            		$(NODESETTINGS_PASSWORD).removeClass("hp-error");
            		useCurrentCredentials= false;
            	}
            		
            }
            
     
            
    			this.init = function() {
    				var resource = router.location().split('/');
                	resource = resource[1];
                	if(resource === 'node')
                		$(TYPE).val("Unknown");
                	else
                		$(TYPE).val(resource);
    				
    				 $('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
					IpdialogContents = $(IP_DIALOG).detach().show();
					nodeSettingsDialogContents = $(NODESETTINGS_DIALOG).detach().show();
					
					$(APPLY_SETTINGS_BUTTON, IpdialogContents).on('click', function () 
					{
						initnodeSettingsDialog(selected_nodes);
					});
					
					$(FIND_NODES_BUTTON).live('click', function(ev) {
                        initIpdialog.call(this);
                        ev.preventDefault();
                    });
					
					$("input").bind("keydown", function(event) {
                    var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
                    if (keycode == 13) { // keycode for enter key
                        $(ADD).trigger('click');
                        event.preventDefault();
                      }
                    });

                	$(PANELS).hpStackedPanels({
                    	panelSelector : PANEL_SELECTOR
                	});
                	$('input[name="hpsum-node-credential"]').click(credentialsOptions);
             		$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
               		$('#hpsum-node-add-close').click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                	ROUTE_PREFIX = '/'+ resource +'/add';
                	formStateView.init({form: FORM,
                    	routePattern: ROUTE_PREFIX + '.*',
                    	autoTrack: false});


		// put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }

           			presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                                  
                	$(ADD).live('click', function(ev) {
                   		onAddItem.call(this);
                    	ev.preventDefault();
                	});
                	$(BASELINES).hpSearchCombo({getResults:getBaseline});
                	$(HOTFIX).hpSearchCombo({getResults: getHotfixes});
                	$(RESET).live('click', function() {
                    	reset.call();
                	});
                

                
                this.resume();
            };
            
            this.resume = function () {
				reset();
            	var resource = router.location().split('/');
                	resource = resource[1];
                	if(resource)
					{
                		 $('select option').filter(function() {
			             if(new RegExp(this.value, 'ig').test(resource))
		    		     $(this).attr('selected', true);
					            });
                    }	
					else
					{
					$(TITLE).text('');
                    }
            		$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/add';
  				router.watch('node add section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
            	 $(RESET).trigger('click');
            	 $(NAMEERR).hide();
            	 $('input[name="hpsum-node-credential"]').click(credentialsOptions);
            	 $('#hpsum-node-add-alreadyExist').hide();
            	 credentialsOptions('two');
            	 $(NAME).removeClass("hp-error");
            	 $(USERNAME).removeClass("hp-error");
            	 $(PASSWORD).removeClass("hp-error");
            	 $(TYPEERR).hide();
            	 $(USERNAME_ERR).hide();
            	 $(PASSWORD_ERR).hide();
				 $(ADD_ASSOC_NODES).hide();
				 $('#hpsum-node-addassoc-description').hide();
				 $(LINUX_CRED_PANEL).css({"display":"none"});
            	 $(PARTNER_CRED_PANEL).css({"display":"none"});
            	 $(TYPE).bind('change', showPartnerOptions);
            	 $(TYPE).removeClass("hp-error");
            	  	presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
            };
            
      
            this.pause = function () {
             //   formStateView.reset();
            };
    		
    	}	
    	return AddView;
    }());
    	
    return new AddView();	
    		
    });

