// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeShowReports)
 * This is a view class for Node Reports menu option.
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
	'hp/core/Localizer',
	'hp/core/Notifications',
	'hp/view/DialogView',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox'],
function(presenter, router,urlFragment, FormStateView, helpMenu, localizer, notifications, DialogView) {"use strict";

	var ReportsShowView = ( function() {
			var FORM = '#hpsum-nodes-reports-form',
			    RESET = '#hpsum-nodes-reset',
			    CANCEL = '#hpsum-nodes-reports-close',
			    GENERATE = '#hpsum-nodes-reports-generate',
			    PANEL_SELECTOR = '#hpsum-node-reports-panel-selector',
			    PANELS = '#hpsum-node-reports-panels',
			    TYPE = '#hpsum-node-reports-type',
			    ROUTE_PREFIX = '/node/reports',
			    FIRMWARECHECKBOX = '#hpsum-node-reports-firmware',
			    INSTALLABLECHECKBOX = '#hpsum-node-reports-installable',
			    FAILEDDEPCHECKBOX = '#hpsum-node-reports-faileddep',
			    INSTALLEDCHECKBOX = '#hpsum-node-reports-installed',
			    REPORTFORMATHTML = '#hpsum-node-reports-html',
			    REPORTFORMATXML = '#hpsum-node-reports-xml',
			    REPORTFORMATCSV = '#hpsum-node-reports-csv',
			    RUNBACKCHECKBOX = '#chkbox-runbackReport',
			    TITLE = '#hpsum-node-reports-title',
			    SPLASH_DIALOG = '#hpsum-report-wait-dialog',
			    SPLASH_SPINNER = '#hpsum-report-spinner',
			    REPORTS_TABLE = '#hpsum-reports-table';

			function ReportsShowView() {
				var nodeItem = null,
				    timer = null,
				    inProgressTimer = null,
				    inProgressReportId = null,
				    reportWaitDialog,
				    allReportsDialog,
				    deleteInfoDialog,
				    deleteReportId,
				    generateInProgress = false;
				    
				function reset() {
				}

				function onItemChange(item) {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					
					nodeItem = item.hapi;
					if (nodeItem && nodeItem.hasOwnProperty("node_id")) {
						$(TITLE).text(nodeItem.name);
						
						if(nodeItem.node_state != "INSTALLDONE" && !router.location().match(/one-touch-update/i)){
						    //Disable installed reports
						    $(INSTALLEDCHECKBOX).attr('checked', false).attr('disabled','disabled');;
						} else {
						    $(INSTALLEDCHECKBOX).removeAttr('disabled').attr('checked', true);
						}
					} else {
						$(CANCEL).trigger('click');
					}
				}

				function showReportGenerationWait() {

					var reportButtons = {};

					reportButtons[localizer.getString('hpsum.node.runbackReport')] = function() {
						notifications.show(localizer.getString("hpsum.node.runningReportInBack") + nodeItem.name + 
										   '. ' + localizer.getString("hpsum.node.referForReportStatus"), 'ok');
						//clearInterval(timer);
						closesReportGenerationWait();
						//populateReportsTable(false);
						//$(GENERATE).attr("disabled", false);
					};

					if (!reportWaitDialog) {
						reportWaitDialog = $(SPLASH_DIALOG);
						reportWaitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : reportButtons,
							width : 260,
							height : 180
						});
					}
					$(SPLASH_SPINNER).show();
					reportWaitDialog.dialog('open');
				}

				function closesReportGenerationWait() {
					$(SPLASH_SPINNER).hide();
					if (reportWaitDialog) {
					   reportWaitDialog.dialog('close');
					}
				}

				function populateReportsTable(isItemOnChange) {	
					var reports = [],
					    firmware_report,
					    update_applied_report,
					    installed_report,
					    dependency_report,
					    nodes = [];

					presenter.getAllReports({
						success : function(data) {
							reports = data.hapi.reports.report;
							var tableReports = [],
							    reportTypes = [],
							    reportStatus,
							    inProgress = false;
							    							    
							for (var idx = 0; idx < reports.length; ++idx) {
								    reportStatus = reports[idx].report_state;
								    
								if (reportStatus == "report_generation_completed") {
									reportStatus = localizer.getString("hpsum.node.completed");
								} else if (reportStatus == "in_progress" || reportStatus == "not_started" || reportStatus == "partially_generated") {
									reportStatus = localizer.getString("hpsum.node.inProgress");
									inProgress = true;
									if (isItemOnChange) {
										inProgressReportId = reports[idx].report_id;

										$(GENERATE).attr("disabled", true);
										inProgressTimer = setInterval(function() {
											presenter.getReportStatus(inProgressReportId, {
												success : function(data) {
													if (data.hapi.report_state.match(/in_progress|not_started|partially_generated/i)) {
													} else if (data.hapi.report_state.match(/report_generation_completed/i)) {

														clearInterval(inProgressTimer);

														$(GENERATE).attr("disabled", false);
														populateReportsTable(false);
														generateInProgress = false;

													} else {

														clearInterval(inProgressTimer);

													}
												},
												error : function(errorInfo) {

													clearInterval(inProgressTimer);
												}
											});

										}, 3000);
									}
								} else {
									reportStatus = localizer.getString("hpsum.node.failed");
								}

								    
								    reportTypes = reports[idx].report_type;
								    firmware_report = update_applied_report = 	installed_report = dependency_report = "";					    
								    for (var i=0; i < reportTypes.length; i++) {
								    	
								    	if (reportTypes[i] == "firmware_report") {
								    		reportTypes[i] = "Firmware";
								    		if (inProgress) {
												firmware_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 	
								    		    firmware_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' + 
								    		                   '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                   localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "update_applied_report") {
								    		reportTypes[i] = "update_applied";
								    		if (inProgress) {
												update_applied_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 
								    		    update_applied_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                      '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                      localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "installed_report") {
								    		reportTypes[i] = "Installed";
								    		if (inProgress) {
												installed_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 
								    		    installed_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                    '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                     localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    	else if (reportTypes[i] == "dependency_report") {
								    		reportTypes[i] = "FailedDependency";
								    		if (inProgress) {
												dependency_report = '<img src="/img/hp-sum/jstree/throbber.gif">';
											} else { 
								    		    dependency_report =  '<a href="' + reports[idx].report_id + '/' + reportTypes[i] + '.rpt"' + 'target ="_blank">' +
								    		                     '<img src="/img/hp-piano/status-ok.png" ></br>' +
								    		                   localizer.getString("hpsum.node.viewDetails") + '</a>';
								    		}
								    	}
								    }
								    
								    inProgress = false;
								
								var deleteReport = '<a id="hpsum-delete-report" data-custom-value="' + reports[idx].report_id + '">' +
								'<img src="/img/hp-piano/close.png" >' + '</a>';
								
								tableReports.push({
									time_stamp : reports[idx].date_and_time,
									report_format : reports[idx].report_format,
									firmware_type : firmware_report,
									update_applied_type : update_applied_report,
									installed_type : installed_report,
									dependency_type : dependency_report,
									report_status : reportStatus,
									node_name : reports[idx].node_id,
									delete_report : deleteReport
								});
							}
	
							presenter.getAllNodes({
								success : function(data) {
									nodes = data.hapi.output_data.nodes.node;

									for (var jdx = 0; jdx < tableReports.length; ++jdx) {
										for (var idx = 0; idx < nodes.length; ++idx) {
											if (nodes[idx].node_id == tableReports[jdx].node_name) {
												tableReports[jdx].node_name = nodes[idx].node_name;
												break;
											}
										}
									}

									$(REPORTS_TABLE).dataTable().fnClearTable();
									$(REPORTS_TABLE).dataTable().fnAddData(tableReports);

								},
								error : function() {
								}
							}); 

									    
							$(REPORTS_TABLE).dataTable().fnClearTable();
							$(REPORTS_TABLE).dataTable().fnAddData(tableReports);
						},
						error : function(data) {
							notifications.show(localizer.getString("hpsum.node.failedReport") + nodeItem.name, 'error');
							$(CANCEL).trigger('click');
						}
					});
				};

					
				function onGenerate() {
					
					generateInProgress = true;
					
					$(GENERATE).attr("disabled", true);
					
					if (!$(RUNBACKCHECKBOX).is(':checked')) {
						showReportGenerationWait();
					}

					var request,
					    firmwaretype = "false",
					    update_appliedtype = "false",
					    faileddeptype = "false",
					    installedtype = "false",
					    reportformat = "false";

					if ($(REPORTFORMATHTML).is(':checked')) {
						reportformat = $(REPORTFORMATHTML).val();
					} else if ($(REPORTFORMATXML).is(':checked')) {
						reportformat = $(REPORTFORMATXML).val();
					} else if ($(REPORTFORMATCSV).is(':checked')) {
						reportformat = $(REPORTFORMATCSV).val();
					}

					if ($(FIRMWARECHECKBOX).is(':checked')) {
						firmwaretype = "true";
					}
					if ($(INSTALLABLECHECKBOX).is(':checked')) {
						update_appliedtype = "true";
					}
					if ($(FAILEDDEPCHECKBOX).is(':checked')) {
						faileddeptype = "true";
					}
					if ($(INSTALLEDCHECKBOX).is(':checked')) {
						installedtype = "true";
					}
					
					var nodeId,
						currentLocation = router.location();
						
					if (currentLocation.match(/one-touch-update/i)) {
						nodeId = "N1localhost";
						nodeItem = {name: "localhost"};
					}
					else {
						if (nodeItem && nodeItem.hasOwnProperty("node_id")) {
						nodeId = nodeItem.node_id;
						}
						else {
							nodeItem = {name: "localhost"};
							nodeId = "N1localhost";	
						}
					}
						
					var request = {
						hapi : {
							report_format : reportformat,
							nodes : {
								node : {
									node_id : nodeId,	
									firmware_report : firmwaretype,
									update_applied_report : update_appliedtype,
									dependency_report : faileddeptype,
									installed_report : installedtype
								}
							}
						}
					};

					presenter.createReport(request, {
						success : function(data) {
							onSuccessReportCreation(data.hapi.report_id);
						},
						error : function(errorInfo) {
							notifications.show(errorInfo, 'error');
							closesReportGenerationWait();
							$(CANCEL).trigger('click');
						}
					});

				}

				function getReportStatus(reportId) {
					
					if (timer) {
						clearInterval(timer);
						timer = null;
					}

					//var status = "";
					timer = setInterval(function() {
						presenter.getReportStatus(reportId, {
							success : function(data) {
						//	if (status != data.hapi.status) {
							//	status = data.hapi.status;
								if (data.hapi.report_state.match(/in_progress|not_started/i)) {
								} else if (data.hapi.report_state.match(/report_generation_completed/i)) {
									notifications.show(localizer.getString("hpsum.node.doneReport") + nodeItem.name, 'ok');
									closesReportGenerationWait();
									//clearInterval(timer);
								
									if (timer) {
										clearInterval(timer);
										timer = null;
									}

									$(GENERATE).attr("disabled", false);
									populateReportsTable(false);
									generateInProgress = false;
									//status = "";
									//changeLocation('/node/reports/allAvailableReports');
								} else if (data.hapi.report_state.match(/partially_generated/i)) {
									//notifications.show(localizer.getString("hpsum.node.partialReport") + nodeItem.name, 'warning');
									//closesReportGenerationWait();
									//clearInterval(timer);
									//$(GENERATE).attr("disabled", false);
									//populateReportsTable();
									//status = "";
									//changeLocation('/node/reports/allAvailableReports');
									
								} else {
									notifications.show(localizer.getString("hpsum.node.failedReport") + nodeItem.name, 'error');
									closesReportGenerationWait();
									
									if (timer) {
										clearInterval(timer);
										timer = null;
									}

									$(CANCEL).trigger('click');
								}
							 //}
							},
							error : function(errorInfo) {
								notifications.show(errorInfo, 'error');
								closesReportGenerationWait();
								
								if (timer) {
									clearInterval(timer);
									timer = null;
								}

								$(CANCEL).trigger('click');
							}
						});

					}, 3000);
				}

				function onSuccessReportCreation(reportId) {
					//$(GENERATE).attr("disabled", false);
					populateReportsTable(false);
					presenter.generateReport(reportId, {
						success : function(data) {
							if (!$(RUNBACKCHECKBOX).is(':checked')) {
								populateReportsTable(false);
								getReportStatus(reportId);
							} else {
								notifications.show(localizer.getString("hpsum.node.runningReportInBack") + nodeItem.name +
												   '. ' + localizer.getString("hpsum.node.referForReportStatus"), 'ok');
							    populateReportsTable(false);
								//$(GENERATE).attr("disabled", false);
								getReportStatus(reportId);
							}
						},
						error : function(errorInfo) {
							notifications.show(errorInfo, 'error');
							closesReportGenerationWait();
							$(CANCEL).trigger('click');
						}
					});
				}

				function onDeleteReport() {
					var deleteConfirmButtons = {};

					deleteConfirmButtons[localizer.getString('core.delete.delete_button')] = function() {
						presenter.deleteReport({report_id : deleteReportId},
							{
							success : function(data) {
								notifications.show(data.hapi.hmessage, 'ok');
								populateReportsTable(false);
							},
							error : function(message) {
								notifications.show(message, 'error');
							}
						});
						deleteInfoDialog.dialog('close');
					};

					deleteConfirmButtons[localizer.getString('core.delete.cancel_button')] = function() {
						deleteInfoDialog.dialog('close');
					};
					
					if (!deleteInfoDialog) {
						deleteInfoDialog = $('#hpsum-delete-report-dialog');
						deleteInfoDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							buttons : deleteConfirmButtons
						});
					}
					
					deleteInfoDialog.dialog('open');	
				}
				
				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}


				this.init = function() {
					var resource = router.location().split('/');
                	resource = resource[1];
              	$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/reports';

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(RESET).live('click', function() {
						reset.call();
					});

					$(GENERATE).live('click', function(ev) {
						if (!generateInProgress) {
						 onGenerate.call();
						}
						ev.preventDefault();
					});
					
					$('#hpsum-delete-report').live('click', function(ev) {
						deleteReportId = $(this).data("custom-value");
						onDeleteReport.call();
						ev.preventDefault();
					});
					
					$(CANCEL).click(function () {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					if (inProgressTimer) {
						clearInterval(inProgressTimer);
						inProgressTimer = null;
					}
					
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
					router.watch('node report section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});
					
					this.resume();
				};

				this.resume = function() {
					
					var dummyReportsData = [];
					$(REPORTS_TABLE).dataTable({
						oLanguage : {
							sEmptyTable : localizer.getString("hpsum.node.noReports")
						},
						bPaginate : false,
						bFilter : false,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyReportsData,
						aoColumns : [{
							mDataProp : 'time_stamp'
						},{
							sWidth: 75, mDataProp : 'firmware_type'
						},{
							sWidth: 75, mDataProp : 'update_applied_type'
						},{
							sWidth: 75, mDataProp : 'installed_type'
						},{
							sWidth: 75, mDataProp : 'dependency_type'
						},{
							mDataProp : 'report_format'
						},{
							mDataProp : 'node_name'
						},{
							mDataProp : 'report_status'
						},{
							mDataProp : 'delete_report'
						}],
						aaSorting: [[ 0, "desc" ]]
					});
					
					generateInProgress = false;
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					if (inProgressTimer) {
						clearInterval(inProgressTimer);
						inProgressTimer = null;
					}
					presenter.on("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('resume');
					$(RESET).trigger('click');
					$(GENERATE).attr("disabled", false);
					populateReportsTable(true);
					
					
				};

				this.pause = function() {
					
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
					presenter.off("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};

			}

			return ReportsShowView;
		}());

	return new ReportsShowView();

});



