// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
	'hp/model/Session',
    'text!hpsumpages/graphics/switch.html',
	'hp/core/Localizer',
    'text!hpPages/core/no_details.html',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'lib/jquery.dateFormat',
    'hp/lib/date'],
function(presenter, urlFragment, router, session, switchGraphic, localizer, noneHtml) { "use strict";

    var SwitchOverviewView = (function() {
      
        var VIEW = '.hp-details-show-section',
        	MODEL ='#hpsum-switch-model',
        	DESCRIPTION ='#hpsum-switch-description',
        	WWN = '#hpsum-switch-wwn',
        	FWVERSION = '#hpsum-switch-fw',
        	BASELINE='#hpsum-switch-bundle',
        	NOASSOC ='#hpsum-switch-noassocdevices',
        	ASSOC ='#hpsum-switch-assocdevices',
        	PARTNER ='#hpsum-switch-partner',
        	PARTNERWFW ='#hpsum-switch-partner-writtenfw',
        	PARTNERAFW ='#hpsum-switch-partner-activefw',
        	OA ='#hpsum-switch-oa',
        	SPINNER = '#hpsum-node-add-spinner';
        var GRAPHIC_CONTAINER = '.hp-overview-graphic';
        var INSTALL_LOGS = '#hpsum-switch-install-log';
        /**
         * Constructor
         */
        function SwitchOverviewView() {
            var noItem,
            	thisNode = null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode = item;
                noItem.remove();
        		item.type = item.type.toLowerCase();
        		if(!router.location().match(item.type))
        			router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));

                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();

        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        			 presenter.startNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			$(NOASSOC).hide();
        			$(ASSOC).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			
        			$(DESCRIPTION).text(item.description);
        			if(item.hasOwnProperty('model_name'))
        				$(MODEL).text(item.model_name);
        			else 
        				$(MODEL).text('');
        			if(item.hasOwnProperty('active_version'))
        				$(FWVERSION).text(item.active_version);
        			else
        				$(FWVERSION).text('');
        			if(item.hasOwnProperty('device_wwn'))
						$(WWN).text(item.device_wwn);
					else
						$(WWN).text('');
					showAssociatedDevices(item);
        			var fwBaseline =presenter.getFWBaseline(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
            }
            
            function showAssociatedDevices(item){
            	if(item.hasOwnProperty('oa_ip_address')){
					var assoc_node_url = '#/node/show/r/session/' + session.getToken() + '/node/' + item.assoc_node_id + '/getData';
            		$(NOASSOC).hide();
            		$(ASSOC).show();
					if(item.assoc_node_id)
					{
						var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/' + item.assoc_node_id + '/getdata';
						$(OA).html ('<a href="' + assoc_node_url + '">' + item.oa_ip_address+ '</a>');
					}
					else
						$(OA).text(item.oa_ip_address);
            	}
            	if(item.hasOwnProperty('partner_ip_address')){
            		$(NOASSOC).hide();
            		$(ASSOC).show();
					if(item.partner_node_id)
					{
						var partner_url = '#/node/show/r/session/' + session.getToken() +'/node/' + item.partener_node_id + '/getdata';
						$(PARTNER).html ('<a href="' + partner_url + '">' + item.partner_ip_address+ '</a>');					
					}
					else 
						$(PARTNER).text(item.partner_ip_address);
            		$(PARTNERWFW).text(item.partner_written_version);
            		$(PARTNERAFW).text(item.partner_active_version);
            	}
            }
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }

            function onItemError(errorMessage) {
            }
            
            function onResize() {
                var connectivity = $('#tour-switch-connectivity');
                if (connectivity.width() < 700 || connectivity.height() < 300) {
                    $('.hp-overview-graphic .hp-form-section > .hp-switch').show();
                    $('.hp-overview-graphic .hp-form-section > .hp-switch-context').hide();
                } else {
                    $('.hp-overview-graphic .hp-form-section > .hp-switch').hide();
                    $('.hp-overview-graphic .hp-form-section > .hp-switch-context').show();
                }
            }
          
            /**
             * @public
             */
            this.pause = function () {
                //$(window).off('resize', onResize);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
            };
            
            this.resume = function () {
                $('.hp-grid-panels').hpGridPanels('reset');
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                //$(window).on('resize', onResize);
                //onResize();
            };
            
            this.init = function() {
            	if(!presenter.initDone)
            		presenter.init();
                noItem = $(noneHtml);
                $('.hp-grid-panels').hpGridPanels();
                
                this.resume();
            };
            
        }

        return new SwitchOverviewView();
    }());
    
    return SwitchOverviewView;
});
