/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __QFLE3I_GLOBAL_H__
#define __QFLE3I_GLOBAL_H__

#include <vmkapi.h>

#define NIPQUAD(addr) \
	((unsigned char *)&addr)[0], \
	((unsigned char *)&addr)[1], \
	((unsigned char *)&addr)[2], \
	((unsigned char *)&addr)[3]

#define NIPQUAD_FMT "%u.%u.%u.%u"


#define SCSI_SENSE_BUFFERSIZE   96

typedef int pci_power_t;

#define PCI_D0          ((pci_power_t ) 0)
#define PCI_D1          ((pci_power_t ) 1)
#define PCI_D2          ((pci_power_t ) 2)
#define PCI_D3hot       ((pci_power_t ) 3)
#define PCI_D3cold      ((pci_power_t ) 4)
#define PCI_UNKNOWN     ((pci_power_t ) 5)
#define PCI_POWER_ERROR ((pci_power_t ) -1)

#define container_of(ptr, type, member) ({                      \
	const typeof( ((type *)0)->member ) *__mptr = (ptr);    \
	(type *)( (char *)__mptr - vmk_offsetof(type,member) );})

#ifndef min
#define min(x, y) (((x) < (y)) ? (x) : (y))
#endif

#define min_t(type, x, y) ({			\
	type __min1 = (x);			\
	type __min2 = (y);			\
	__min1 < __min2 ? __min1: __min2; })

#define max_t(type, x, y) ({			\
	type __max1 = (x);			\
	type __max2 = (y);			\
	__max1 > __max2 ? __max1: __max2; })

#ifndef DIV_ROUND_UP
#define DIV_ROUND_UP(n,d) (((n) + (d) - 1) / (d))
#endif
#define ADDR (*(volatile long *) addr)

#define __constant_htonl(x) vmk_CPUToBE32(x)
#define htonl(x)    vmk_CPUToBE32(x)
#define htons(x)    vmk_CPUToBE16(x)
#define ntohl(x)    vmk_BE32ToCPU(x)
#define ntohs(x)    vmk_BE16ToCPU(x)

static inline void int_to_scsilun(unsigned int lun, vmk_uint8	*scsilun)
{
	int i;

	vmk_Memset(scsilun, 0, 8);

	for (i = 0; i < sizeof(lun); i += 2) {
		scsilun[i] = (lun >> 8) & 0xFF;
		scsilun[i+1] = lun & 0xFF;
		lun = lun >> 16;
	}
}

//#if (VMWARE_ESX_DDK_VERSION >= 60000)
static inline void qfle3i_int_to_scsilun_with_sec_lun_id(vmk_uint16 lun,
							vmk_uint8 *scsi_lun,
							vmk_uint64 sllid)
{
	if (sllid != VMK_SCSI_INVALID_SECONDLEVEL_ID) {
		vmk_Memset(scsi_lun, 0, 8);
		scsi_lun[0] = (lun >> 8) & 0xFF;
		scsi_lun[1] = lun & 0xFF;
		scsi_lun[2] = (vmk_uint8)((sllid >> 56) & 0xFF); /* sllid msb */
		scsi_lun[3] = (vmk_uint8)((sllid >> 48) & 0xFF);
		scsi_lun[4] = (vmk_uint8)((sllid >> 40) & 0xFF);
		scsi_lun[5] = (vmk_uint8)((sllid >> 32) & 0xFF);
		scsi_lun[6] = (vmk_uint8)((sllid >> 24) & 0xFF);
		scsi_lun[7] = (vmk_uint8)((sllid >> 16) & 0xFF); /* sllid lsb */
	} else {
		int_to_scsilun(lun, scsi_lun);
	}
}
//#endif /* (VMWARE_ESX_DDK_VERSION >= 60000) */



#endif
