#include <stdio.h>
#include <unistd.h>

extern long ce_exec_config[];

int main(int argc, char *argv[])
{
	int i, cnt, pos, len;
	unsigned int cksum, val;
	unsigned char *lp;
	unsigned char buf[8192];
	if (argc != 2)
	{
		fprintf(stderr, "usage: %s name <in-file >out-file\n",
			argv[0]);
		exit(1);
	}
	fprintf(stdout, "/*\n");
	fprintf(stdout, "* Miscellaneous data structures:\n");
	fprintf(stdout, "* WARNING - this file is automatically generated!\n");
	fprintf(stdout, "*/\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "unsigned long orion_%s_start[] = {\n", argv[1]);
	pos = 0;
	cksum = 0;
	while ((len = read(0, buf, sizeof(buf))) > 0)
	{
		cnt = 0;
		lp = (unsigned char *)buf;
		len = (len + 3) & ~3;  /* Round up to longwords */
		for (i = 0;  i < len;  i += 4)
		{
			if (cnt == 0)
			{
				fprintf(stdout, "\t");
			}
			fprintf(stdout, "0x%02X%02X%02X%02X", lp[0], lp[1], lp[2], lp[3]);
			val = *(unsigned long *)lp;
			cksum ^= val;
			lp += 4;
			if (++cnt == 4)
			{
				cnt = 0;
				fprintf(stdout, ", /* %x */\n", pos+i-12);
				fflush(stdout);
			} else
			{
				fprintf(stdout, ",");
			}
		}
		pos += len;
	}
	fprintf(stdout, "0 };\n");
	fprintf(stdout, "unsigned long orion_%s_size = 0x%x;\n", argv[1], pos);
	fflush(stdout);
	fclose(stdout);
	fprintf(stderr, "cksum = %x\n", cksum);
	exit(0);
}
