// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::FwIsoCtx;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    /// An object to receive isochronous packet for several channels.
    ///
    /// A [`FwIsoIrMultiple`][crate::FwIsoIrMultiple] receives isochronous packets for several channels by IR context for
    /// buffer-fill mode in 1394 OHCI.
    ///
    /// # Implements
    ///
    /// [`FwIsoIrMultipleExt`][trait@crate::prelude::FwIsoIrMultipleExt], [`FwIsoCtxExt`][trait@crate::prelude::FwIsoCtxExt], [`FwIsoIrMultipleExtManual`][trait@crate::prelude::FwIsoIrMultipleExtManual], [`FwIsoCtxExtManual`][trait@crate::prelude::FwIsoCtxExtManual]
    #[doc(alias = "HinokoFwIsoIrMultiple")]
    pub struct FwIsoIrMultiple(Object<ffi::HinokoFwIsoIrMultiple, ffi::HinokoFwIsoIrMultipleClass>) @implements FwIsoCtx;

    match fn {
        type_ => || ffi::hinoko_fw_iso_ir_multiple_get_type(),
    }
}

impl FwIsoIrMultiple {
    pub const NONE: Option<&'static FwIsoIrMultiple> = None;

    /// Instantiate [`FwIsoIrMultiple`][crate::FwIsoIrMultiple] object and return the instance.
    ///
    /// # Returns
    ///
    /// an instance of [`FwIsoIrMultiple`][crate::FwIsoIrMultiple].
    #[doc(alias = "hinoko_fw_iso_ir_multiple_new")]
    pub fn new() -> FwIsoIrMultiple {
        unsafe { from_glib_full(ffi::hinoko_fw_iso_ir_multiple_new()) }
    }
}

impl Default for FwIsoIrMultiple {
    fn default() -> Self {
        Self::new()
    }
}

/// Trait containing the part of [`struct@FwIsoIrMultiple`] methods.
///
/// # Implementors
///
/// [`FwIsoIrMultiple`][struct@crate::FwIsoIrMultiple]
pub trait FwIsoIrMultipleExt: 'static {
    /// Allocate an IR context to 1394 OHCI controller for buffer-fill mode. A local node of the node
    /// corresponding to the given path is used as the controller, thus any path is accepted as long as
    /// process has enough permission for the path.
    /// ## `path`
    /// A path to any Linux FireWire character device.
    /// ## `channels`
    /// an array for channels to listen
    ///       to. The value of each element should be up to 63.
    #[doc(alias = "hinoko_fw_iso_ir_multiple_allocate")]
    fn allocate(&self, path: &str, channels: &[u8]) -> Result<(), glib::Error>;

    /// Map an intermediate buffer to share payload of IR context with 1394 OHCI
    /// controller.
    /// ## `bytes_per_chunk`
    /// The maximum number of bytes for payload of isochronous packet (not payload for
    ///          isochronous context).
    /// ## `chunks_per_buffer`
    /// The number of chunks in buffer.
    #[doc(alias = "hinoko_fw_iso_ir_multiple_map_buffer")]
    fn map_buffer(&self, bytes_per_chunk: u32, chunks_per_buffer: u32) -> Result<(), glib::Error>;

    /// Emitted when Linux FireWire subsystem generates interrupt event. There are two cases
    /// for Linux FireWire subsystem to generate the event:
    ///
    /// - When OHCI 1394 controller generates hardware interrupt as a result to process the
    ///   isochronous packet for the buffer chunk marked to generate hardware interrupt.
    /// - When application calls [`FwIsoCtxExt::flush_completions()`][crate::prelude::FwIsoCtxExt::flush_completions()] explicitly.
    ///
    /// The handler of signal can retrieve the content of packet by call of
    /// [`FwIsoIrMultipleExtManual::payload()`][crate::prelude::FwIsoIrMultipleExtManual::payload()].
    /// ## `count`
    /// The number of packets available in this interrupt.
    #[doc(alias = "interrupted")]
    fn connect_interrupted<F: Fn(&Self, u32) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<FwIsoIrMultiple>> FwIsoIrMultipleExt for O {
    fn allocate(&self, path: &str, channels: &[u8]) -> Result<(), glib::Error> {
        let channels_length = channels.len() as u32;
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_ir_multiple_allocate(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
                channels.to_glib_none().0,
                channels_length,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn map_buffer(&self, bytes_per_chunk: u32, chunks_per_buffer: u32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_ir_multiple_map_buffer(
                self.as_ref().to_glib_none().0,
                bytes_per_chunk,
                chunks_per_buffer,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn connect_interrupted<F: Fn(&Self, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn interrupted_trampoline<
            P: IsA<FwIsoIrMultiple>,
            F: Fn(&P, u32) + 'static,
        >(
            this: *mut ffi::HinokoFwIsoIrMultiple,
            count: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                FwIsoIrMultiple::from_glib_borrow(this).unsafe_cast_ref(),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"interrupted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    interrupted_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for FwIsoIrMultiple {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("FwIsoIrMultiple")
    }
}
