/*
 * scancodes.h  Version 0.1
 *
 * Copyright (C) 1999 Vojtech Pavlik
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * Should you need to contact me, the author, you can do so either by
 * e-mail - mail your message to <vojtech@ucw.cz>, or by paper mail:
 * Vojtech Pavlik, Ucitelska 1576, Prague 8, 182 00 Czech Republic
 */


struct scancode_list {
	unsigned char xt;
	unsigned char at2;
	unsigned char at3;
	unsigned char sun;
	unsigned char usb;
	unsigned char adb;
	unsigned char code;
};

/*
 * The base set common to all keyboards - the XT keyboard.
 */

static struct scancode_list scancodes[] = {

	{0x01, 0x76, 0x08, 0x1d, 0x29, 0x35,   1},	/* Esc */
	{0x02, 0x16, 0x16, 0x1e, 0x1e, 0x12,   2},	/* 1 ! */
	{0x03, 0x1e, 0x1e, 0x1f, 0x1f, 0x13,   3},	/* 2 @ */
	{0x04, 0x26, 0x26, 0x20, 0x20, 0x14,   4},	/* 3 # */
	{0x05, 0x25, 0x25, 0x21, 0x21, 0x15,   5},	/* 4 $ */
	{0x06, 0x2e, 0x2e, 0x22, 0x22, 0x17,   6},	/* 5 % */
	{0x07, 0x36, 0x36, 0x23, 0x23, 0x16,   7},	/* 6 ^ */
	{0x08, 0x3d, 0x3d, 0x24, 0x24, 0x1a,   8},	/* 7 & */
	{0x09, 0x3e, 0x3e, 0x25, 0x25, 0x1c,   9},	/* 8 * */
	{0x0a, 0x46, 0x46, 0x26, 0x26, 0x19,  10},	/* 9 ( */
	{0x0b, 0x45, 0x45, 0x27, 0x27, 0x1d,  11},	/* 0 ) */
	{0x0c, 0x4e, 0x4e, 0x28, 0x2d, 0x1b,  12},	/* - _ */
	{0x0d, 0x55, 0x55, 0x29, 0x2e, 0x18,  13},	/* = + */
	{0x0e, 0x66, 0x66, 0x2b, 0x2a, 0x33,  14},	/* Backspace */
	{0x0f, 0x0d, 0x0d, 0x35, 0x2b, 0x30,  15},	/* Tab */
	{0x10, 0x15, 0x15, 0x36, 0x14, 0x0c,  16},	/* Q */
	{0x11, 0x1d, 0x1d, 0x37, 0x1a, 0x0d,  17},	/* W */
	{0x12, 0x24, 0x24, 0x38, 0x08, 0x0e,  18},	/* E */
	{0x13, 0x2d, 0x2d, 0x39, 0x15, 0x0f,  19},	/* R */
	{0x14, 0x2c, 0x2c, 0x3a, 0x17, 0x11,  20},	/* T */
	{0x15, 0x35, 0x35, 0x3b, 0x1c, 0x10,  21},	/* Y */
	{0x16, 0x3c, 0x3c, 0x3c, 0x18, 0x20,  22},	/* U */
	{0x17, 0x43, 0x43, 0x3d, 0x0c, 0x22,  23},	/* I */
	{0x18, 0x44, 0x44, 0x3e, 0x12, 0x1f,  24},	/* O */
	{0x19, 0x4d, 0x4d, 0x3f, 0x13, 0x23,  25},	/* P */
	{0x1a, 0x54, 0x54, 0x40, 0x2f, 0x21,  26},	/* [ { */
	{0x1b, 0x5b, 0x5b, 0x41, 0x30, 0x1e,  27},	/* ] } */
	{0x1c, 0x5a, 0x5a, 0x59, 0x28, 0x24,  28},	/* Enter */
	{0x1d, 0x14, 0x11, 0x4c, 0xe0, 0x36,  29},	/* Left Control */
	{0x1e, 0x1c, 0x1c, 0x4d, 0x04, 0x00,  30},	/* A */
	{0x1f, 0x1b, 0x1b, 0x4e, 0x16, 0x01,  31},	/* S */
	{0x20, 0x23, 0x23, 0x4f, 0x07, 0x02,  32},	/* D */
	{0x21, 0x2b, 0x2b, 0x50, 0x09, 0x03,  33},	/* F */
	{0x22, 0x34, 0x34, 0x51, 0x0a, 0x05,  34},	/* G */
	{0x23, 0x33, 0x33, 0x52, 0x0b, 0x04,  35},	/* H */
	{0x24, 0x3b, 0x3b, 0x53, 0x0d, 0x26,  36},	/* J */
	{0x25, 0x42, 0x42, 0x54, 0x0e, 0x28,  37},	/* K */
	{0x26, 0x4b, 0x4b, 0x55, 0x0f, 0x25,  38},	/* L */
	{0x27, 0x4c, 0x4c, 0x56, 0x33, 0x29,  39},	/* ; : */
	{0x28, 0x52, 0x52, 0x57, 0x34, 0x27,  40},	/* ' " */
	{0x29, 0x0e, 0x0e, 0x2a, 0x35, 0x32,  41},	/* ` ~ */
	{0x2a, 0x12, 0x12, 0x63, 0xe1, 0x38,  42},	/* Left Shift */
	{0x2b, 0x5d, 0x5c, 0x58, 0x31, 0x2a,  43},	/* \ | */
	{   0,    0, 0x53,    0,    0,    0,  43},	/* \ | */
	{   0,    0, 0x5d,    0,    0,    0,  43},	/* \ | */
	{0x2c, 0x1a, 0x1a, 0x64, 0x1d, 0x06,  44},	/* Z */
	{0x2d, 0x22, 0x22, 0x65, 0x1b, 0x07,  45},	/* X */
	{0x2e, 0x21, 0x21, 0x66, 0x06, 0x08,  46},	/* C */
	{0x2f, 0x2a, 0x2a, 0x67, 0x19, 0x09,  47},	/* V */
	{0x30, 0x32, 0x32, 0x68, 0x05, 0x0b,  48},	/* B */
	{0x31, 0x31, 0x31, 0x69, 0x11, 0x2d,  49},	/* N */
	{0x32, 0x3a, 0x3a, 0x6a, 0x10, 0x2e,  50},	/* M */
	{0x33, 0x41, 0x41, 0x6b, 0x36, 0x2b,  51},	/* , < */
	{0x34, 0x49, 0x49, 0x6c, 0x37, 0x2f,  52},	/* . > */
	{0x35, 0x4a, 0x4a, 0x6d, 0x38, 0x2c,  53},	/* / ? */
	{0x36, 0x59, 0x59, 0x6e, 0xe5, 0x7b,  54},	/* Right Shift */
	{0x37, 0x7c, 0x7e, 0x2f, 0x55, 0x43,  55},	/* KP * */
	{0x38, 0x11, 0x19, 0x13, 0xe2, 0x37,  56},	/* Left Alt */
	{0x39, 0x29, 0x29, 0x79, 0x2c, 0x31,  57},	/* Space */
	{0x3a, 0x58, 0x14, 0x77, 0x39, 0x39,  58},	/* Caps Lock */
	{0x3b, 0x05, 0x07, 0x05, 0x3a, 0x7a,  59},	/* F1 */
	{0x3c, 0x06, 0x0f, 0x06, 0x3b, 0x78,  60},	/* F2 */
	{0x3d, 0x04, 0x17, 0x08, 0x3c, 0x63,  61},	/* F3 */
	{0x3e, 0x0c, 0x1f, 0x0a, 0x3d, 0x76,  62},	/* F4 */
	{0x3f, 0x03, 0x27, 0x0c, 0x3e, 0x60,  63},	/* F5 */
	{0x40, 0x0b, 0x2f, 0x0e, 0x3f, 0x61,  64},	/* F6 */
	{0x41, 0x02, 0x37, 0x10, 0x40, 0x62,  65},	/* F7 */
	{0x42, 0x0a, 0x3f, 0x11, 0x41, 0x64,  66},	/* F8 */
	{0x43, 0x01, 0x47, 0x12, 0x42, 0x65,  67},	/* F9 */
	{0x44, 0x09, 0x4f, 0x07, 0x43, 0x6d,  68},	/* F10 */
	{0x45, 0x77, 0x76, 0x62, 0x53, 0x47,  69},	/* Num Lock */
	{0x46, 0x7e, 0x5f, 0x17, 0x47, 0x6b,  70},	/* Scroll Lock Break */
	{0x47, 0x6c, 0x6c, 0x44, 0x5f, 0x59,  71},	/* KP Home 7 */
	{0x48, 0x75, 0x75, 0x45, 0x60, 0x5b,  72},	/* KP Up 8 */
	{0x49, 0x7d, 0x7d, 0x46, 0x61, 0x5c,  73},	/* KP PgUp 9 */
	{0x4a, 0x7b, 0x84, 0x47, 0x56, 0x4e,  74},	/* KP - */
	{0x4b, 0x6b, 0x6b, 0x5b, 0x5c, 0x56,  75},	/* KP Left 4 */
	{0x4c, 0x73, 0x73, 0x5c, 0x5d, 0x57,  76},	/* KP 5 */
	{0x4d, 0x74, 0x74, 0x5d, 0x5e, 0x58,  77},	/* KP Right 6 */
	{0x4e, 0x79, 0x7c, 0x7d, 0x57, 0x45,  78},	/* KP + */
	{0x4f, 0x69, 0x69, 0x70, 0x59, 0x53,  79},	/* KP End 1 */
	{0x50, 0x72, 0x72, 0x71, 0x5a, 0x54,  80},	/* KP Down 2 */
	{0x51, 0x7a, 0x7a, 0x72, 0x5b, 0x55,  81},	/* KP PgDn 3 */
	{0x52, 0x70, 0x70, 0x5e, 0x62, 0x52,  82},	/* KP Ins 0 */
	{0x53, 0x71, 0x71, 0x32, 0x63, 0x41,  83},	/* KP Del . */

/*
 * The most common extensions to the base.
 */

	{   0, 0x78, 0x56, 0x09, 0x44, 0x67,  87},	/* F11 */
	{   0, 0x07, 0x5e, 0x0b, 0x45, 0x6f,  88},	/* F12 */
	{   0, 0xda, 0x79, 0x5a, 0x58, 0x4c,  96},	/* KP Enter */
	{   0, 0xca, 0x77, 0x2e, 0x54, 0x4b,  98},	/* KP / */
	{   0, 0x91, 0x39, 0x0d, 0xe6, 0x7c, 100},	/* Right Alt (Graph) */
	{   0,    0, 0x58,    0,    0,    0, 100},	/* Alt Graph - Sun PS/2 Type 5 */
	{   0, 0xf1, 0x64, 0x42, 0x4c, 0x75, 111},	/* Delete */
	{   0, 0xfe, 0x62, 0x15, 0x48, 0x71, 119},	/* Pause Break */
	{   0, 0xf7,    0,    0,    0,    0, 119},	/* Alternate Pause Break */

/*
 * The separate navigation keys
 */

	{   0, 0xec, 0x6e, 0x34, 0x4a, 0x73, 102},	/* Home */
	{   0, 0xf5, 0x63, 0x14, 0x52, 0x3e, 103},	/* Up */
	{   0, 0xfd, 0x6f, 0x60, 0x4b, 0x74, 104},	/* Page Up */
	{   0, 0xeb, 0x61, 0x18, 0x50, 0x3b, 105},	/* Left */
	{   0, 0xf4, 0x6a, 0x1c, 0x4f, 0x3c, 106},	/* Right */
	{   0, 0xe9, 0x65, 0x4a, 0x4d, 0x77, 107},	/* End */
	{   0, 0xf2, 0x60, 0x1b, 0x51, 0x3d, 108},	/* Down */
	{   0, 0xfa, 0x6d, 0x7b, 0x4e, 0x79, 109},	/* Page Down */
	{   0, 0xf0, 0x67, 0x2c, 0x49, 0x72, 110},	/* Insert */

/*
 * The OS keys
 */

	{   0, 0x9f, 0x8b, 0x78, 0xe3,    0, 125},	/* Left Meta (Win, Apple, Amiga) */
	{   0, 0xa7, 0x8c, 0x7a, 0xe7,    0, 126},	/* Right Meta (Win, Apple, Amiga) */
	{   0, 0xaf, 0x8d, 0x43, 0x65,    0, 127},	/* Compose (Application) */

/*
 * OS keys on a NCD PS/2 Sun keyboard
 */

	{   0,    0, 0x40,    0,    0,    0, 125},	/* Left Meta (Win, Apple, Amiga) */ 
	{   0,    0, 0x48,    0,    0,    0, 126},	/* Right Meta (Win, Apple, Amiga) */
	{   0,    0, 0x39,    0,    0,    0, 127},	/* Compose (Application) */         

/*
 * PrintScreen
 */

	{   0, 0xfc, 0x57, 0x16, 0x46,    0,  99},	/* PrintScreen SysRq */

/*
 * Right Ctrl
 */

	{   0, 0x94, 0x58,    0, 0xe4, 0x7d,  97},	/* Right Ctrl */

/*
 * The European 102nd key
 */

	{   0, 0x61, 0x13,    0, 0x64,    0,  86},	/* the 102nd key */

/*
 * Sun function keys
 */

	{   0,    0, 0x0a, 0x01, 0x78,    0, 128},	/* Stop */
	{   0,    0, 0x0b, 0x03, 0x79,    0, 129},	/* Again */
	{   0,    0, 0x0c, 0x19,    0,    0, 130},	/* Props */
	{   0,    0, 0x10, 0x1a, 0x7a,    0, 131},	/* Undo */
	{   0,    0, 0x13, 0x31,    0,    0, 132},	/* Front */
	{   0,    0, 0x18, 0x33, 0x7c,    0, 133},	/* Copy */
	{   0,    0, 0x20, 0x48,    0,    0, 134},	/* Open */
	{   0,    0, 0x28, 0x49, 0x7d,    0, 135},	/* Paste */
	{   0,    0, 0x30, 0x5f, 0x7e,    0, 136},	/* Find */
	{   0,    0, 0x38, 0x61, 0x7b,    0, 137},	/* Cut */
	{   0,    0, 0x09, 0x76, 0x75,    0, 138},	/* Help */


/*
 * Line Feed found on Sun Type 4 keyboard
 */

	{   0,    0,    0, 0x6f,    0,    0, 101},	/* Line Feed */

/*
 * AT Enhanced keyboard in XT mode
 */

	{0x57,    0,    0,    0,    0,    0,  87},	/* F11 */
	{0x58,    0,    0,    0,    0,    0,  88},	/* F12 */

/*
 * PP-06 keyboard extension keys
 */

	{0x65,    0,    0,    0,    0,    0,  87},	/* F11 */
	{0x66,    0,    0,    0,    0,    0,  88},	/* F12 */
	{0x6b,    0,    0,    0,    0,    0, 110},	/* Insert */
	{0x6c,    0,    0,    0,    0,    0, 111},	/* Delete */
	{0x6d,    0,    0,    0,    0,    0, 103},	/* Up */
	{0x6e,    0,    0,    0,    0,    0, 108},	/* Down */
	{0x6f,    0,    0,    0,    0,    0, 105},	/* Left */
	{0x70,    0,    0,    0,    0,    0, 106},	/* Right */

/*
 * F13-F24, for USB and Focus 9000
 */

	{   0, 0x60,    0,    0, 0x68,    0,  85},	/* F13 (PF1)  */
	{   0, 0x51,    0,    0, 0x69,    0,  89},	/* F14 (PF2)  */
	{   0, 0x62,    0,    0, 0x6a,    0,  90},	/* F15 (PF3)  */
	{   0, 0x63,    0,    0, 0x6b,    0,  91},	/* F16 (PF4)  */
	{   0, 0x64,    0,    0, 0x6c,    0,  92},	/* F17 (PF5)  */
	{   0, 0x65,    0,    0, 0x6d,    0,  93},	/* F18 (PF6)  */
	{   0, 0x67,    0,    0, 0x6e,    0,  94},	/* F19 (PF7)  */
	{   0, 0x68,    0,    0, 0x6f,    0,  95},	/* F20 (PF8)  */
	{   0, 0x53,    0,    0, 0x70,    0, 120},	/* F21 (PF9)  */
	{   0, 0x6d,    0,    0, 0x71,    0, 121},	/* F22 (PF10) */
	{   0, 0x50,    0,    0, 0x72,    0, 122},	/* F23 (PF11) */
	{   0, 0x6f,    0,    0, 0x73,    0, 123},	/* F24 (PF12) */

/*
 * F13-F17 for DEC LK450
 */

	{   0, 0x84,    0,    0,    0,    0,  85},	/* F13 */
	{   0, 0x8c,    0,    0,    0,    0,  89},	/* F14 */
	{   0, 0x83,    0,    0,    0,    0,  90},	/* F15 */
	{   0, 0x8b,    0,    0,    0,    0,  91},	/* F16 */
	{   0, 0x82,    0,    0,    0,    0,  92},	/* F17 */

/*
 * A1-A4 for RC930
 */

	{   0, 0x0f,    0,    0,    0,    0,  85},	/* A1 */
	{   0, 0x17,    0,    0,    0,    0,  89},	/* A2 */
	{   0, 0x1f,    0,    0,    0,    0,  90},	/* A3 */
	{   0, 0x27,    0,    0,    0,    0,  91},	/* A4 */

/*
 * Unlabeled keys on the NCD Sun PS/2 keyboard
 */

	{   0,    0, 0x7f,    0,    0,    0,  85},	/* U1 */
	{   0,    0, 0x80,    0,    0,    0,  89},	/* U2 */
	{   0,    0, 0x81,    0,    0,    0,  90},	/* U3 */
	{   0,    0, 0x82,    0,    0,    0,  91},	/* U4 */
	{   0,    0, 0x83,    0,    0,    0,  92},	/* U5 */

/*
 * Macro key on BTC and other keyboards
 */

	{   0, 0xef,    0,    0,    0,    0, 112},	/* BTC Macro key */

/*
 * Logitech key on Logitech NewTouch
 */

	{   0, 0xa8, 0x8e,    0,    0,    0, 112},	/* Logitech key */

/*
 * Omni key on NorthGate and Lueck keyboards
 */

	{   0, 0xf3,    0,    0,    0,    0, 112},	/* NorthGate / Lueck Omni */

/*
 * Sound (NCD Sun PS/2 + Sun Type 5 keyboard)
 */

	{   0,    0, 0x50, 0x2d, 0x7f,    0, 113},	/* Mute */
	{   0,    0, 0x51, 0x02, 0x81,    0, 114},	/* Volume Down */
	{   0,    0, 0x53, 0x04, 0x80,    0, 115},	/* Volume Up */

/*
 * Sound (BTC Ez multimedia keyboard)
 */

	{   0, 0xcb, 0x9c,    0,    0,    0, 113},	/* Mute */
	{   0, 0xc2, 0x9d,    0,    0,    0, 114},	/* Volume Down */
	{   0, 0x9c, 0x95,    0,    0,    0, 115},	/* Volume Up */

/*
 * BTC Ez Function keys
 */

	{   0, 0xbb, 0x94,    0,    0,    0, 165},	/* Previous song */
	{   0, 0xab, 0x99,    0,    0,    0, 164},	/* Play/Pause */
	{   0, 0xc3, 0x98,    0,    0,    0, 166},	/* Stop */
	{   0, 0xb4, 0x93,    0,    0,    0, 163},	/* Next song */
	{   0, 0xba, 0x97,    0,    0,    0, 161},	/* Eject */
	{   0, 0xb3, 0x9a,    0,    0,    0, 160},	/* Close */
	{   0, 0xb1, 0x9e,    0,    0,    0, 167},	/* Record */
	{   0, 0xc4, 0x9f,    0,    0,    0, 168},	/* Rewind */
	{   0, 0xb2, 0x91,    0,    0,    0, 139},	/* Menu */
	{   0, 0x9b, 0xa3,    0,    0,    0, 140},	/* Calc */
	{   0, 0xad, 0xa2,    0,    0,    0, 147},	/* X-fer */
	{   0, 0xa1, 0x92,    0,    0,    0, 150},	/* WWW */
	{   0, 0xa3, 0x9b,    0,    0,    0, 154},	/* Cycle Windows */
	{   0, 0xa4, 0x96,    0,    0,    0, 152},	/* Coffee */
	{   0, 0xcd, 0xa0,    0,    0,    0, 148},	/* Prog 1 */
	{   0, 0x95, 0xa1,    0,    0,    0, 149},	/* Prog 2 */

/*
 * NCD Sun PS/2 Setup key
 */

	{   0,    0, 0x5d,    0,    0,    0, 141},	/* Setup */

/*
 * The power key (AP PFT keyboard)
 */

	{   0, 0xb7,    0, 0x30, 0x66, 0x7f, 116},	/* Power */

/*
 * The power management keys (AP PFT keyboard)
 */

	{   0, 0xbf,    0,    0,    0,    0, 142},	/* Sleep */
	{   0, 0xde,    0,    0,    0,    0, 143},	/* WakeUp */

/*
 * Turbo-Xwing function keys.
 */

	{   0, 0xe2,    0,    0,    0,    0, 116},	/* WWW / Power */
	{   0, 0xb3,    0,    0,    0,    0, 176},	/* Sleep */
	{   0, 0xe4,    0,    0,    0,    0, 143},	/* Joystick / Wake */
	{   0, 0xd7,    0,    0,    0,    0, 140},	/* Calc */
	{   0, 0x8c,    0,    0,    0,    0, 101},	/* Line Feed */
	{   0, 0x86,    0,    0,    0,    0, 137},	/* Cut */
	{   0, 0xe7,    0,    0,    0,    0, 133},	/* Copy */
	{   0, 0xb4,    0,    0,    0,    0, 135},	/* Paste */
	{   0, 0xcf,    0,    0,    0,    0, 138},	/* Help */
	{   0, 0x8d,    0,    0,    0,    0, 144},	/* File */
	{   0, 0xab,    0,    0,    0,    0, 145},	/* Send File */
	{   0, 0xc0,    0,    0,    0,    0, 146},	/* Delete File */
	{   0, 0xa6,    0,    0,    0,    0, 151},	/* MS DOS */
	{   0, 0xd6,    0,    0,    0,    0, 153},	/* Direction */
	{   0, 0xa9,    0,    0,    0,    0, 166},	/* Stop */
	{   0, 0x95,    0,    0,    0,    0, 165},	/* Prev Song */
	{   0, 0xbb,    0,    0,    0,    0, 113},	/* Mute */
	{   0, 0xa5,    0,    0,    0,    0, 163},	/* Next Song */
	{   0, 0x96,    0,    0,    0,    0, 164},	/* Play / Pause */
	{   0, 0x82,    0,    0,    0,    0, 162},	/* Eject / Close */
	{   0, 0x84,    0,    0,    0,    0, 115},	/* Volume Up */
	{   0, 0x83,    0,    0,    0,    0, 114},	/* Volume Down */

/*
 * KeyPad equal, found on Sun Type 4 and Mac keyboards
 */

	{   0,    0,    0, 0x2d, 0x67, 0x51, 117},	/* KP = */

/*
 * KeyPad plusminus, found on DEC LK450
 */

	{   0, 0xf9,    0,    0,    0,    0, 118},	/* DEC LK450 KP +- */

/*
 * Japan alphabet switch key
 */

	{   0, 0x68,    0,    0, 0x87,    0, 124},	/* The Jpn key - clashes with Focus PF8 */
	{   0,    0,    0,    0,    0,    0,   0}};

