/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class AbbreviationMap {
    private String key;
    private Object value;
    private final Map children = new TreeMap();
    private int keysBeyond;

    AbbreviationMap() {
    }

    boolean contains(String aKey) {
        return this.get(aKey) != null;
    }

    Object get(String aKey) {
        char[] chars = AbbreviationMap.charsOf(aKey);
        AbbreviationMap child = this;
        for (int i = 0; i < chars.length; ++i) {
            child = (AbbreviationMap)child.children.get(new Character(chars[i]));
            if (child != null) continue;
            return null;
        }
        return child.value;
    }

    void put(String aKey, Object newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        if (aKey.length() == 0) {
            throw new IllegalArgumentException();
        }
        char[] chars = AbbreviationMap.charsOf(aKey);
        this.add(chars, newValue, 0, chars.length);
    }

    void putAll(List keys, Object newValue) {
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            this.put((String)iter.next(), newValue);
        }
    }

    private boolean add(char[] chars, Object newValue, int offset, int length) {
        boolean newKeyAdded;
        if (offset == length) {
            this.value = newValue;
            boolean wasAlreadyAKey = this.key != null;
            this.key = new String(chars);
            return !wasAlreadyAKey;
        }
        Character nextChar = new Character(chars[offset]);
        AbbreviationMap child = (AbbreviationMap)this.children.get(nextChar);
        if (child == null) {
            child = new AbbreviationMap();
            this.children.put(nextChar, child);
        }
        if (newKeyAdded = child.add(chars, newValue, offset + 1, length)) {
            ++this.keysBeyond;
        }
        if (this.key == null) {
            this.value = this.keysBeyond > 1 ? null : newValue;
        }
        return newKeyAdded;
    }

    void remove(String aKey) {
        if (aKey.length() == 0) {
            throw new IllegalArgumentException();
        }
        char[] keyChars = AbbreviationMap.charsOf(aKey);
        this.remove(keyChars, 0, keyChars.length);
    }

    private boolean remove(char[] aKey, int offset, int length) {
        if (offset == length) {
            return this.removeAtEndOfKey();
        }
        Character nextChar = new Character(aKey[offset]);
        AbbreviationMap child = (AbbreviationMap)this.children.get(nextChar);
        if (child == null || !child.remove(aKey, offset + 1, length)) {
            return false;
        }
        --this.keysBeyond;
        if (child.keysBeyond == 0) {
            this.children.remove(nextChar);
        }
        if (this.keysBeyond == 1 && this.key == null) {
            this.setValueToThatOfOnlyChild();
        }
        return true;
    }

    private void setValueToThatOfOnlyChild() {
        Map.Entry entry = this.children.entrySet().iterator().next();
        AbbreviationMap onlyChild = (AbbreviationMap)entry.getValue();
        this.value = onlyChild.value;
    }

    private boolean removeAtEndOfKey() {
        if (this.key == null) {
            return false;
        }
        this.key = null;
        if (this.keysBeyond == 1) {
            this.setValueToThatOfOnlyChild();
        } else {
            this.value = null;
        }
        return true;
    }

    Map toJavaUtilMap() {
        TreeMap mappings = new TreeMap();
        this.addToMappings(mappings);
        return mappings;
    }

    private void addToMappings(Map mappings) {
        if (this.key != null) {
            mappings.put(this.key, this.value);
        }
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            ((AbbreviationMap)iter.next()).addToMappings(mappings);
        }
    }

    private static char[] charsOf(String aKey) {
        char[] chars = new char[aKey.length()];
        aKey.getChars(0, aKey.length(), chars, 0);
        return chars;
    }
}

