let _ = Mltop.add_known_module "coq-plugin-tutorial.tuto0"

# 3 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
 

open Pp
open Ltac_plugin

let cat = CWarnings.create_category ~name:"plugin-tuto-cat" ()

let tuto_warn = CWarnings.create ~name:"name" ~category:cat
                            (fun _ -> strbrk Tuto0_main.message)



let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-plugin-tutorial.tuto0") ~command:"HelloWorld" ~classifier:(fun _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("HelloWorld", 
                                     Vernacextend.TyNil), (let coqpp_body () = 
                                                          Vernacextend.vtdefault (fun () -> 
                                                          
# 22 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
                        Feedback.msg_notice (strbrk Tuto0_main.message) 
                                                          ) in fun ?loc ~atts ()
                                                          -> coqpp_body (Attributes.unsupported_attributes atts)), None))]

let () = Tacentries.tactic_extend "coq-plugin-tutorial.tuto0" "hello_world_tactic" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("hello_world", Tacentries.TyNil), 
           (fun ist -> 
# 30 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
    let _ = Feedback.msg_notice (str Tuto0_main.message) in
    Tacticals.tclIDTAC 
           )))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-plugin-tutorial.tuto0") ~command:"HelloWarning" ~classifier:(fun _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("HelloWarning", 
                                     Vernacextend.TyNil), (let coqpp_body () = 
                                                          Vernacextend.vtdefault (fun () -> 
                                                          
# 43 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
    
     tuto_warn ()
   
                                                          ) in fun ?loc ~atts ()
                                                          -> coqpp_body (Attributes.unsupported_attributes atts)), None))]

let () = Tacentries.tactic_extend "coq-plugin-tutorial.tuto0" "hello_warning_tactic" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("hello_warning", Tacentries.TyNil), 
           (fun ist -> 
# 53 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
    
     let _ = tuto_warn () in
     Tacticals.tclIDTAC
   
           )))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-plugin-tutorial.tuto0") ~command:"HelloError" ~classifier:(fun _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("HelloError", 
                                     Vernacextend.TyNil), (let coqpp_body () = 
                                                          Vernacextend.vtdefault (fun () -> 
                                                          
# 66 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
                        CErrors.user_err (str Tuto0_main.message) 
                                                          ) in fun ?loc ~atts ()
                                                          -> coqpp_body (Attributes.unsupported_attributes atts)), None))]

let () = Tacentries.tactic_extend "coq-plugin-tutorial.tuto0" "hello_error_tactic" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("hello_error", Tacentries.TyNil), 
           (fun ist -> 
# 74 "doc/plugin_tutorial/tuto0/src/g_tuto0.mlg"
    let _ = CErrors.user_err (str Tuto0_main.message) in
    Tacticals.tclIDTAC 
           )))]

