/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Stack;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ContainerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class Annotation
extends Expression {
    Annotation persistibleAnnotation = this;
    static final MemberValuePair[] NoValuePairs = new MemberValuePair[0];
    static final int[] TYPE_PATH_ELEMENT_ARRAY = new int[]{0, 0};
    static final int[] TYPE_PATH_INNER_TYPE = new int[]{1, 0};
    static final int[] TYPE_PATH_ANNOTATION_ON_WILDCARD_BOUND = new int[]{2, 0};
    public int declarationSourceEnd;
    public Binding recipient;
    public TypeReference type;
    protected AnnotationBinding compilerAnnotation = null;

    public static int[] getLocations(Expression expression, Annotation annotation) {
        if (expression == null) {
            return null;
        }
        class LocationCollector
        extends ASTVisitor {
            Stack typePathEntries = new Stack();
            Annotation searchedAnnotation;
            boolean continueSearch = true;

            public LocationCollector(Annotation annotation) {
                this.searchedAnnotation = annotation;
            }

            private int[] computeNestingDepth(TypeReference typeReference) {
                TypeBinding typeBinding = typeReference.resolvedType == null ? null : typeReference.resolvedType.leafComponentType();
                int[] nArray = new int[typeReference.getAnnotatableLevels()];
                if (typeBinding != null && typeBinding.isNestedType()) {
                    int n = 0;
                    for (TypeBinding typeBinding2 = typeBinding; typeBinding2 != null; typeBinding2 = typeBinding2.enclosingType()) {
                        n += typeBinding2.isStatic() ? 0 : 1;
                    }
                    int n2 = nArray.length - 1;
                    while (typeBinding != null && n2 >= 0) {
                        nArray[n2--] = n;
                        n -= typeBinding.isStatic() ? 0 : 1;
                        typeBinding = typeBinding.enclosingType();
                    }
                }
                return nArray;
            }

            private void inspectAnnotations(Annotation[] annotationArray) {
                int n;
                int n2 = n = annotationArray == null ? 0 : annotationArray.length;
                for (int i = 0; this.continueSearch && i < n; ++i) {
                    if (annotationArray[i] != this.searchedAnnotation) continue;
                    this.continueSearch = false;
                    break;
                }
            }

            private void inspectArrayDimensions(Annotation[][] annotationArray, int n) {
                for (int i = 0; this.continueSearch && i < n; ++i) {
                    Annotation[] annotationArray2 = annotationArray == null ? null : annotationArray[i];
                    this.inspectAnnotations(annotationArray2);
                    if (!this.continueSearch) {
                        return;
                    }
                    this.typePathEntries.push(TYPE_PATH_ELEMENT_ARRAY);
                }
            }

            private void inspectTypeArguments(TypeReference[] typeReferenceArray) {
                int n;
                int n2 = n = typeReferenceArray == null ? 0 : typeReferenceArray.length;
                for (int i = 0; this.continueSearch && i < n; ++i) {
                    int n3 = this.typePathEntries.size();
                    this.typePathEntries.add(new int[]{3, i});
                    typeReferenceArray[i].traverse((ASTVisitor)this, (BlockScope)null);
                    if (!this.continueSearch) {
                        return;
                    }
                    this.typePathEntries.setSize(n3);
                }
            }

            public boolean visit(TypeReference typeReference, BlockScope blockScope) {
                if (this.continueSearch) {
                    this.inspectArrayDimensions(typeReference.getAnnotationsOnDimensions(), typeReference.dimensions());
                    if (this.continueSearch) {
                        int[] nArray = this.computeNestingDepth(typeReference);
                        Annotation[][] annotationArray = typeReference.annotations;
                        TypeReference[][] typeReferenceArray = typeReference.getTypeArguments();
                        int n = typeReference.getAnnotatableLevels();
                        int n2 = this.typePathEntries.size();
                        for (int i = n - 1; this.continueSearch && i >= 0; --i) {
                            this.typePathEntries.setSize(n2);
                            int n3 = nArray[i];
                            for (int j = 0; j < n3; ++j) {
                                this.typePathEntries.add(TYPE_PATH_INNER_TYPE);
                            }
                            if (annotationArray != null) {
                                this.inspectAnnotations(annotationArray[i]);
                            }
                            if (!this.continueSearch || typeReferenceArray == null) continue;
                            this.inspectTypeArguments(typeReferenceArray[i]);
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean visit(SingleTypeReference singleTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)singleTypeReference, blockScope);
            }

            @Override
            public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)arrayTypeReference, blockScope);
            }

            @Override
            public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)parameterizedSingleTypeReference, blockScope);
            }

            @Override
            public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)qualifiedTypeReference, blockScope);
            }

            @Override
            public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)arrayQualifiedTypeReference, blockScope);
            }

            @Override
            public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)parameterizedQualifiedTypeReference, blockScope);
            }

            @Override
            public boolean visit(Wildcard wildcard, BlockScope blockScope) {
                TypeReference typeReference;
                this.visit((TypeReference)wildcard, blockScope);
                if (this.continueSearch && (typeReference = wildcard.bound) != null) {
                    int n = this.typePathEntries.size();
                    this.typePathEntries.push(TYPE_PATH_ANNOTATION_ON_WILDCARD_BOUND);
                    typeReference.traverse((ASTVisitor)this, blockScope);
                    if (this.continueSearch) {
                        this.typePathEntries.setSize(n);
                    }
                }
                return false;
            }

            @Override
            public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope blockScope) {
                if (this.continueSearch) {
                    this.inspectArrayDimensions(arrayAllocationExpression.getAnnotationsOnDimensions(), arrayAllocationExpression.dimensions.length);
                    if (this.continueSearch) {
                        arrayAllocationExpression.type.traverse((ASTVisitor)this, blockScope);
                    }
                    if (this.continueSearch) {
                        throw new IllegalStateException();
                    }
                }
                return false;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("search location for ").append(this.searchedAnnotation).append("\ncurrent type_path entries : ");
                int n = this.typePathEntries.size();
                for (int i = 0; i < n; ++i) {
                    int[] nArray = (int[])this.typePathEntries.get(i);
                    stringBuffer.append('(').append(nArray[0]).append(',').append(nArray[1]).append(')');
                }
                return String.valueOf(stringBuffer);
            }
        }
        LocationCollector locationCollector = new LocationCollector(annotation);
        expression.traverse((ASTVisitor)locationCollector, (BlockScope)null);
        if (locationCollector.typePathEntries.isEmpty()) {
            return null;
        }
        int n = locationCollector.typePathEntries.size();
        int[] nArray = new int[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = (int[])locationCollector.typePathEntries.get(i);
            nArray[n2++] = nArray2[0];
            nArray[n2++] = nArray2[1];
        }
        return nArray;
    }

    public static long getRetentionPolicy(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CLASS)) break;
                return 0x200000000000L;
            }
            case 'S': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_SOURCE)) break;
                return 0x100000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_RUNTIME)) break;
                return 0x300000000000L;
            }
        }
        return 0L;
    }

    public static long getTargetElementType(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'A': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_ANNOTATION_TYPE)) break;
                return 0x40000000000L;
            }
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CONSTRUCTOR)) break;
                return 0x10000000000L;
            }
            case 'F': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_FIELD)) break;
                return 0x2000000000L;
            }
            case 'L': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_LOCAL_VARIABLE)) break;
                return 0x20000000000L;
            }
            case 'M': {
                if (CharOperation.equals(cArray, TypeConstants.UPPER_METHOD)) {
                    return 0x4000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_MODULE)) break;
                return 0x2000000000000000L;
            }
            case 'P': {
                if (CharOperation.equals(cArray, TypeConstants.UPPER_PARAMETER)) {
                    return 0x8000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_PACKAGE)) break;
                return 0x80000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_RECORD_COMPONENT)) break;
                return 0x40000000L;
            }
            case 'T': {
                if (CharOperation.equals(cArray, TypeConstants.TYPE)) {
                    return 0x1000000000L;
                }
                if (CharOperation.equals(cArray, TypeConstants.TYPE_USE_TARGET)) {
                    return 0x20000000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.TYPE_PARAMETER_TARGET)) break;
                return 0x40000000000000L;
            }
        }
        return 0L;
    }

    public ElementValuePair[] computeElementValuePairs() {
        return Binding.NO_ELEMENT_VALUE_PAIRS;
    }

    private long detectStandardAnnotation(Scope scope, ReferenceBinding referenceBinding, MemberValuePair memberValuePair) {
        long l = 0L;
        block0 : switch (referenceBinding.id) {
            case 48: {
                FieldBinding fieldBinding;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if ((expression.bits & 3) != 1 || !(expression instanceof Reference) || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 51) break;
                l |= Annotation.getRetentionPolicy(fieldBinding.name);
                break;
            }
            case 50: {
                FieldBinding fieldBinding;
                l |= 0x800000000L;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    for (Expression expression2 : expressionArray) {
                        FieldBinding fieldBinding2;
                        if ((expression2.bits & 3) != 1 || (fieldBinding2 = ((Reference)expression2).fieldBinding()) == null || fieldBinding2.declaringClass.id != 52) continue;
                        long l2 = Annotation.getTargetElementType(fieldBinding2.name);
                        if ((l & l2) != 0L) {
                            scope.problemReporter().duplicateTargetInTargetAnnotation(referenceBinding, (NameReference)expression2);
                            continue;
                        }
                        l |= l2;
                    }
                    break;
                }
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 52) break;
                l |= Annotation.getTargetElementType(fieldBinding.name);
                break;
            }
            case 94: {
                l |= 0x180000000L;
                for (MemberValuePair memberValuePair2 : this.memberValuePairs()) {
                    if (!CharOperation.equals(memberValuePair2.name, TypeConstants.ESSENTIAL_API) || !(memberValuePair2.value instanceof TrueLiteral)) continue;
                    l |= 0x400L;
                }
                break;
            }
            case 44: {
                l |= 0x400000000000L;
                if (scope.compilerOptions().complianceLevel < 0x350000L) break;
                for (MemberValuePair memberValuePair3 : this.memberValuePairs()) {
                    if (!CharOperation.equals(memberValuePair3.name, TypeConstants.FOR_REMOVAL)) continue;
                    if (!(memberValuePair3.value instanceof TrueLiteral)) break block0;
                    l |= 0x4000000000000000L;
                    break block0;
                }
                break;
            }
            case 45: {
                l |= 0x800000000000L;
                break;
            }
            case 46: {
                l |= 0x1000000000000L;
                break;
            }
            case 47: {
                l |= 0x2000000000000L;
                break;
            }
            case 77: {
                l |= 0x800000000000000L;
                break;
            }
            case 90: {
                l |= 0x1000000000000000L;
                break;
            }
            case 49: {
                l |= 0x4000000000000L;
                break;
            }
            case 60: {
                l |= 0x8000000000000L;
                break;
            }
            case 61: {
                l |= 0x10000000000000L;
            }
        }
        if (referenceBinding.hasNullBit(64)) {
            l |= 0x80000000000000L;
        } else if (referenceBinding.hasNullBit(32)) {
            l |= 0x100000000000000L;
        } else if (referenceBinding.hasNullBit(128)) {
            l |= this.determineNonNullByDefaultTagBits(referenceBinding, memberValuePair);
        }
        return l;
    }

    private long determineNonNullByDefaultTagBits(ReferenceBinding referenceBinding, MemberValuePair memberValuePair) {
        long l = 0L;
        Object object = null;
        if (memberValuePair != null) {
            if (memberValuePair.compilerElementPair != null) {
                object = memberValuePair.compilerElementPair.value;
            }
        } else {
            MethodBinding[] methodBindingArray = referenceBinding.methods();
            if (methodBindingArray != null && methodBindingArray.length == 1) {
                object = methodBindingArray[0].getDefaultValue();
            } else {
                l |= 0x38L;
            }
        }
        if (object instanceof BooleanConstant) {
            l |= ((BooleanConstant)object).booleanValue() ? 56L : 2L;
        } else if (object != null) {
            l |= (long)Annotation.nullLocationBitsFromAnnotationValue(object);
        } else {
            int n = BinaryTypeBinding.evaluateTypeQualifierDefault(referenceBinding);
            if (n != 0) {
                return n;
            }
        }
        return l;
    }

    public static int nullLocationBitsFromAnnotationValue(Object object) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                return 2;
            }
            int n = 0;
            for (Object object2 : (Object[])object) {
                n |= Annotation.evaluateDefaultNullnessLocation(object2);
            }
            return n;
        }
        return Annotation.evaluateDefaultNullnessLocation(object);
    }

    private static int evaluateDefaultNullnessLocation(Object object) {
        char[] cArray = null;
        if (object instanceof FieldBinding) {
            cArray = ((FieldBinding)object).name;
        } else if (object instanceof EnumConstantSignature) {
            cArray = ((EnumConstantSignature)object).getEnumConstantName();
        } else if (object instanceof ElementValuePair.UnresolvedEnumConstant) {
            cArray = ((ElementValuePair.UnresolvedEnumConstant)object).getEnumConstantName();
        } else if (object instanceof BooleanConstant) {
            return ((BooleanConstant)object).booleanValue() ? 56 : 2;
        }
        if (cArray != null) {
            switch (cArray.length) {
                case 5: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__FIELD)) break;
                    return 32;
                }
                case 9: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__PARAMETER)) break;
                    return 8;
                }
                case 10: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__TYPE_BOUND)) break;
                    return 256;
                }
                case 11: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__RETURN_TYPE)) break;
                    return 16;
                }
                case 13: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__TYPE_ARGUMENT)) break;
                    return 64;
                }
                case 14: {
                    if (CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__TYPE_PARAMETER)) {
                        return 128;
                    }
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__ARRAY_CONTENTS)) break;
                    return 512;
                }
            }
        }
        return 0;
    }

    public static int nullLocationBitsFromElementTypeAnnotationValue(Object object) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                return 2;
            }
            int n = 0;
            for (Object object2 : (Object[])object) {
                n |= Annotation.evaluateElementTypeNullnessLocation(object2);
            }
            return n;
        }
        return Annotation.evaluateElementTypeNullnessLocation(object);
    }

    private static int evaluateElementTypeNullnessLocation(Object object) {
        char[] cArray = null;
        if (object instanceof FieldBinding) {
            cArray = ((FieldBinding)object).name;
        } else if (object instanceof EnumConstantSignature) {
            cArray = ((EnumConstantSignature)object).getEnumConstantName();
        } else if (object instanceof ElementValuePair.UnresolvedEnumConstant) {
            cArray = ((ElementValuePair.UnresolvedEnumConstant)object).getEnumConstantName();
        }
        if (cArray != null) {
            switch (cArray.length) {
                case 5: {
                    if (!CharOperation.equals(cArray, TypeConstants.UPPER_FIELD)) break;
                    return 32;
                }
                case 6: {
                    if (!CharOperation.equals(cArray, TypeConstants.UPPER_METHOD)) break;
                    return 16;
                }
                case 9: {
                    if (!CharOperation.equals(cArray, TypeConstants.UPPER_PARAMETER)) break;
                    return 8;
                }
            }
        }
        return 0;
    }

    static String getRetentionName(long l) {
        if ((l & 0x300000000000L) == 0x300000000000L) {
            return new String(UPPER_RUNTIME);
        }
        if ((l & 0x100000000000L) != 0L) {
            return new String(UPPER_SOURCE);
        }
        return new String(TypeConstants.UPPER_CLASS);
    }

    private static long getAnnotationRetention(ReferenceBinding referenceBinding) {
        long l = referenceBinding.getAnnotationTagBits() & 0x300000000000L;
        return l != 0L ? l : 0x200000000000L;
    }

    public void checkRepeatableMetaAnnotation(BlockScope blockScope) {
        ReferenceBinding referenceBinding = (ReferenceBinding)this.recipient;
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        if (memberValuePairArray == null || memberValuePairArray.length != 1) {
            return;
        }
        Object object = memberValuePairArray[0].compilerElementPair.value;
        if (!(object instanceof ReferenceBinding)) {
            return;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)object;
        if (!referenceBinding2.isAnnotationType()) {
            return;
        }
        referenceBinding.setContainerAnnotationType(referenceBinding2);
        Annotation.checkContainerAnnotationType(memberValuePairArray[0], blockScope, referenceBinding2, referenceBinding, false);
    }

    public static void checkContainerAnnotationType(ASTNode aSTNode, BlockScope blockScope, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, boolean bl) {
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        boolean bl2 = false;
        for (MethodBinding methodBinding : methodBindingArray) {
            if (CharOperation.equals(methodBinding.selector, TypeConstants.VALUE)) {
                ArrayBinding arrayBinding;
                bl2 = true;
                if (methodBinding.returnType.isArrayType() && methodBinding.returnType.dimensions() == 1 && TypeBinding.equalsEquals((arrayBinding = (ArrayBinding)methodBinding.returnType).elementsType(), referenceBinding2)) continue;
                referenceBinding2.tagAsHavingDefectiveContainerType();
                blockScope.problemReporter().containerAnnotationTypeHasWrongValueType(aSTNode, referenceBinding, referenceBinding2, methodBinding.returnType);
                continue;
            }
            if ((methodBinding.modifiers & 0x20000) != 0) continue;
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().containerAnnotationTypeHasNonDefaultMembers(aSTNode, referenceBinding, methodBinding.selector);
        }
        if (!bl2) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().containerAnnotationTypeMustHaveValue(aSTNode, referenceBinding);
        }
        if (bl) {
            Annotation.checkContainingAnnotationTargetAtUse((Annotation)aSTNode, blockScope, referenceBinding, referenceBinding2);
        } else {
            Annotation.checkContainerAnnotationTypeTarget(aSTNode, blockScope, referenceBinding, referenceBinding2);
        }
        long l = Annotation.getAnnotationRetention(referenceBinding2);
        long l2 = Annotation.getAnnotationRetention(referenceBinding);
        if (l2 < l) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().containerAnnotationTypeHasShorterRetention(aSTNode, referenceBinding2, Annotation.getRetentionName(l), referenceBinding, Annotation.getRetentionName(l2));
        }
        if ((referenceBinding2.getAnnotationTagBits() & 0x800000000000L) != 0L && (referenceBinding.getAnnotationTagBits() & 0x800000000000L) == 0L) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().repeatableAnnotationTypeIsDocumented(aSTNode, referenceBinding2, referenceBinding);
        }
        if ((referenceBinding2.getAnnotationTagBits() & 0x1000000000000L) != 0L && (referenceBinding.getAnnotationTagBits() & 0x1000000000000L) == 0L) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().repeatableAnnotationTypeIsInherited(aSTNode, referenceBinding2, referenceBinding);
        }
    }

    private static void checkContainerAnnotationTypeTarget(ASTNode aSTNode, Scope scope, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        long l;
        long l2;
        long l3;
        long l4 = referenceBinding2.getAnnotationTagBits();
        if ((l4 & 0x20600FF840000000L) == 0L) {
            l4 = 0xFF000000000L;
        }
        if (((l3 = referenceBinding.getAnnotationTagBits()) & 0x20600FF840000000L) == 0L) {
            l3 = 0xFF000000000L;
        }
        if (((l2 = l3 & 0x20600FF840000000L) & ((l = l4 & 0x20600FF840000000L) ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            class MissingTargetBuilder {
                StringBuffer targetBuffer = new StringBuffer();

                MissingTargetBuilder() {
                }

                void check(long l3, char[] cArray) {
                    if ((l2 & l3 & (l ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                        if (l3 == 0x1000000000L && (l & 0x20000000000000L) != 0L) {
                            return;
                        }
                        this.add(cArray);
                    }
                }

                void checkAnnotationType(char[] cArray) {
                    if ((l2 & 0x40000000000L) != 0L && (l & 0x41000000000L) == 0L) {
                        this.add(cArray);
                    }
                }

                private void add(char[] cArray) {
                    if (this.targetBuffer.length() != 0) {
                        this.targetBuffer.append(", ");
                    }
                    this.targetBuffer.append(cArray);
                }

                public String toString() {
                    return this.targetBuffer.toString();
                }

                public boolean hasError() {
                    return this.targetBuffer.length() != 0;
                }
            }
            MissingTargetBuilder missingTargetBuilder = new MissingTargetBuilder();
            missingTargetBuilder.check(0x1000000000L, TypeConstants.TYPE);
            missingTargetBuilder.check(0x2000000000L, TypeConstants.UPPER_FIELD);
            missingTargetBuilder.check(0x4000000000L, TypeConstants.UPPER_METHOD);
            missingTargetBuilder.check(0x8000000000L, TypeConstants.UPPER_PARAMETER);
            missingTargetBuilder.check(0x10000000000L, TypeConstants.UPPER_CONSTRUCTOR);
            missingTargetBuilder.check(0x20000000000L, TypeConstants.UPPER_LOCAL_VARIABLE);
            missingTargetBuilder.checkAnnotationType(TypeConstants.UPPER_ANNOTATION_TYPE);
            missingTargetBuilder.check(0x80000000000L, TypeConstants.UPPER_PACKAGE);
            missingTargetBuilder.check(0x40000000000000L, TypeConstants.TYPE_PARAMETER_TARGET);
            missingTargetBuilder.check(0x20000000000000L, TypeConstants.TYPE_USE_TARGET);
            missingTargetBuilder.check(0x2000000000000000L, TypeConstants.UPPER_MODULE);
            missingTargetBuilder.check(0x40000000L, TypeConstants.UPPER_RECORD_COMPONENT);
            if (missingTargetBuilder.hasError()) {
                referenceBinding2.tagAsHavingDefectiveContainerType();
                scope.problemReporter().repeatableAnnotationTypeTargetMismatch(aSTNode, referenceBinding2, referenceBinding, missingTargetBuilder.toString());
            }
        }
    }

    public static void checkContainingAnnotationTargetAtUse(Annotation annotation, BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (!typeBinding2.isValidBinding()) {
            return;
        }
        if (Annotation.isAnnotationTargetAllowed(annotation, blockScope, typeBinding, annotation.recipient.kind()) != AnnotationTargetAllowed.YES) {
            blockScope.problemReporter().disallowedTargetForContainerAnnotation(annotation, typeBinding);
        }
    }

    public AnnotationBinding getCompilerAnnotation() {
        return this.compilerAnnotation;
    }

    public boolean isRuntimeInvisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x60000000000000L) != 0L && (l & 0xFF000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return true;
        }
        return (l & 0x300000000000L) == 0x200000000000L;
    }

    public boolean isRuntimeTypeInvisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x20600FF840000000L) != 0L && (l & 0x60000000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return true;
        }
        return (l & 0x300000000000L) == 0x200000000000L;
    }

    public boolean isRuntimeTypeVisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x20600FF840000000L) != 0L && (l & 0x60000000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return false;
        }
        return (l & 0x300000000000L) == 0x300000000000L;
    }

    public boolean isRuntimeVisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x60000000000000L) != 0L && (l & 0xFF000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return false;
        }
        return (l & 0x300000000000L) == 0x300000000000L;
    }

    public abstract MemberValuePair[] memberValuePairs();

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('@');
        this.type.printExpression(0, stringBuffer);
        return stringBuffer;
    }

    public void recordSuppressWarnings(Scope scope, int n, int n2, boolean bl) {
        IrritantSet irritantSet = null;
        for (MemberValuePair memberValuePair : this.memberValuePairs()) {
            if (!CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) continue;
            Expression expression = memberValuePair.value;
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                Expression[] expressionArray = arrayInitializer.expressions;
                if (expressionArray == null) break;
                int n3 = expressionArray.length;
                for (int i = 0; i < n3; ++i) {
                    Constant constant = expressionArray[i].constant;
                    if (constant == Constant.NotAConstant || constant.typeID() != 11) continue;
                    IrritantSet irritantSet2 = CompilerOptions.warningTokenToIrritants(constant.stringValue());
                    if (irritantSet2 != null) {
                        if (irritantSet == null) {
                            irritantSet = new IrritantSet(irritantSet2);
                            continue;
                        }
                        if (irritantSet.set(irritantSet2) != null) continue;
                        scope.problemReporter().unusedWarningToken(expressionArray[i]);
                        continue;
                    }
                    scope.problemReporter().unhandledWarningToken(expressionArray[i]);
                }
                break;
            }
            Constant constant = expression.constant;
            if (constant == Constant.NotAConstant || constant.typeID() != 11) break;
            IrritantSet irritantSet3 = CompilerOptions.warningTokenToIrritants(constant.stringValue());
            if (irritantSet3 != null) {
                irritantSet = new IrritantSet(irritantSet3);
                break;
            }
            scope.problemReporter().unhandledWarningToken(expression);
            break;
        }
        if (bl && irritantSet != null) {
            scope.referenceCompilationUnit().recordSuppressWarnings(irritantSet, this, n, n2, scope.referenceContext());
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        Object object;
        int n;
        Object object2;
        Object object3;
        int n2;
        Object object4;
        int n3;
        MemberValuePair[] memberValuePairArray;
        TypeBinding typeBinding;
        if (this.compilerAnnotation != null) {
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        if (this.resolvedType == null) {
            typeBinding = this.type.resolveType(blockScope);
            if (typeBinding == null) {
                this.resolvedType = new ProblemReferenceBinding(this.type.getTypeName(), null, 1);
                return null;
            }
            this.resolvedType = typeBinding;
        } else {
            typeBinding = this.resolvedType;
        }
        if (!typeBinding.isAnnotationType() && typeBinding.isValidBinding()) {
            blockScope.problemReporter().notAnnotationType(typeBinding, this.type);
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair[] memberValuePairArray2 = this.memberValuePairs();
        MemberValuePair memberValuePair = null;
        int n4 = memberValuePairArray2.length;
        if (n4 > 0) {
            memberValuePairArray = new MemberValuePair[n4];
            System.arraycopy(memberValuePairArray2, 0, memberValuePairArray, 0, n4);
        } else {
            memberValuePairArray = memberValuePairArray2;
        }
        int n5 = methodBindingArray.length;
        block9: for (n3 = 0; n3 < n5; ++n3) {
            MethodBinding methodBinding = methodBindingArray[n3];
            object4 = methodBinding.selector;
            n2 = 0;
            for (int i = 0; i < n4; ++i) {
                object3 = memberValuePairArray[i];
                if (object3 == null || !CharOperation.equals((char[])(object2 = ((MemberValuePair)object3).name), object4)) continue;
                if (memberValuePair == null && CharOperation.equals((char[])object2, TypeConstants.VALUE)) {
                    memberValuePair = object3;
                }
                ((MemberValuePair)object3).binding = methodBinding;
                ((MemberValuePair)object3).resolveTypeExpecting(blockScope, methodBinding.returnType);
                memberValuePairArray[i] = null;
                n2 = 1;
                n = 0;
                for (int j = i + 1; j < n4; ++j) {
                    object = memberValuePairArray[j];
                    if (object == null || !CharOperation.equals(((MemberValuePair)object).name, object4)) continue;
                    n = 1;
                    blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, (MemberValuePair)object);
                    ((MemberValuePair)object).binding = methodBinding;
                    ((MemberValuePair)object).resolveTypeExpecting(blockScope, methodBinding.returnType);
                    memberValuePairArray[j] = null;
                }
                if (n == 0) continue;
                blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, (MemberValuePair)object3);
                continue block9;
            }
            if (n2 != 0 || (methodBinding.modifiers & 0x20000) != 0 || (this.bits & 0x20) != 0 || !referenceBinding.isValidBinding()) continue;
            blockScope.problemReporter().missingValueForAnnotationMember(this, (char[])object4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (memberValuePairArray[n3] == null) continue;
            if (referenceBinding.isValidBinding()) {
                blockScope.problemReporter().undefinedAnnotationValue(referenceBinding, memberValuePairArray[n3]);
            }
            memberValuePairArray[n3].resolveTypeExpecting(blockScope, null);
        }
        this.compilerAnnotation = blockScope.environment().createAnnotation((ReferenceBinding)this.resolvedType, this.computeElementValuePairs());
        long l = this.detectStandardAnnotation(blockScope, referenceBinding, memberValuePair);
        int n6 = (int)(l & 0x3FAL);
        object4 = blockScope.compilerOptions();
        if (((l &= 0xFFFFFFFFFFFFFC05L) & 0x400000000000L) != 0L && object4.complianceLevel >= 0x350000L && !object4.storeAnnotations) {
            this.recipient.setAnnotations(new AnnotationBinding[]{this.compilerAnnotation}, true);
        }
        blockScope.referenceCompilationUnit().recordSuppressWarnings(IrritantSet.NLS, null, this.sourceStart, this.declarationSourceEnd, blockScope.referenceContext());
        if (this.recipient != null) {
            n2 = this.recipient.kind();
            if (l != 0L || n6 != 0) {
                switch (n2) {
                    case 64: {
                        SourceModuleBinding sourceModuleBinding = (SourceModuleBinding)this.recipient;
                        sourceModuleBinding.tagBits |= l;
                        if ((l & 0x4000000000000L) != 0L) {
                            object3 = sourceModuleBinding.scope.referenceContext.moduleDeclaration;
                            this.recordSuppressWarnings(blockScope, 0, ((ModuleDeclaration)object3).declarationSourceEnd, object4.suppressWarnings);
                        }
                        sourceModuleBinding.defaultNullness |= n6;
                        break;
                    }
                    case 16: {
                        ((PackageBinding)this.recipient).tagBits |= l;
                        break;
                    }
                    case 4: 
                    case 2052: {
                        object3 = (SourceTypeBinding)this.recipient;
                        if ((l & 0x1000000000000000L) == 0L || ((ReferenceBinding)object3).isAnnotationType()) {
                            ((SourceTypeBinding)object3).tagBits |= l;
                        }
                        if ((l & 0x4000000000000L) != 0L) {
                            object2 = ((SourceTypeBinding)object3).scope.referenceContext;
                            n = blockScope.referenceCompilationUnit().types[0] == object2 ? 0 : ((TypeDeclaration)object2).declarationSourceStart;
                            this.recordSuppressWarnings(blockScope, n, ((TypeDeclaration)object2).declarationSourceEnd, object4.suppressWarnings);
                        }
                        ((SourceTypeBinding)object3).defaultNullness |= n6;
                        break;
                    }
                    case 8: {
                        long l2;
                        object2 = (MethodBinding)this.recipient;
                        ((MethodBinding)object2).tagBits |= l;
                        if ((l & 0x4000000000000L) != 0L) {
                            object3 = (SourceTypeBinding)((MethodBinding)object2).declaringClass;
                            AbstractMethodDeclaration abstractMethodDeclaration = ((SourceTypeBinding)object3).scope.referenceContext.declarationOf((MethodBinding)object2);
                            this.recordSuppressWarnings(blockScope, abstractMethodDeclaration.declarationSourceStart, abstractMethodDeclaration.declarationSourceEnd, object4.suppressWarnings);
                        }
                        if ((l2 = ((MethodBinding)object2).tagBits & 0x180000000000000L) == 0x180000000000000L) {
                            blockScope.problemReporter().contradictoryNullAnnotations(this);
                            ((MethodBinding)object2).tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        }
                        if (l2 != 0L && ((MethodBinding)object2).isConstructor()) {
                            if (object4.sourceLevel >= 0x340000L) {
                                blockScope.problemReporter().nullAnnotationUnsupportedLocation(this);
                            }
                            ((MethodBinding)object2).tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        }
                        ((MethodBinding)object2).defaultNullness |= n6;
                        break;
                    }
                    case 131072: {
                        object = (RecordComponentBinding)this.recipient;
                        ((RecordComponentBinding)object).tagBits |= l;
                        if ((l & 0x4000000000000L) == 0L) break;
                        RecordComponent recordComponent = ((RecordComponentBinding)object).sourceRecordComponent();
                        this.recordSuppressWarnings(blockScope, recordComponent.declarationSourceStart, recordComponent.declarationSourceEnd, object4.suppressWarnings);
                        break;
                    }
                    case 1: {
                        FieldDeclaration fieldDeclaration;
                        FieldBinding fieldBinding = (FieldBinding)this.recipient;
                        fieldBinding.tagBits |= l;
                        if ((l & 0x4000000000000L) != 0L) {
                            object3 = (SourceTypeBinding)fieldBinding.declaringClass;
                            fieldDeclaration = ((SourceTypeBinding)object3).scope.referenceContext.declarationOf(fieldBinding);
                            this.recordSuppressWarnings(blockScope, fieldDeclaration.declarationSourceStart, fieldDeclaration.declarationSourceEnd, object4.suppressWarnings);
                        }
                        if (n6 != 0) {
                            object3 = (SourceTypeBinding)fieldBinding.declaringClass;
                            fieldDeclaration = ((SourceTypeBinding)object3).scope.referenceContext.declarationOf(fieldBinding);
                            Binding binding = blockScope.parent.checkRedundantDefaultNullness(n6 | blockScope.localNonNullByDefaultValue(fieldDeclaration.sourceStart), fieldDeclaration.sourceStart);
                            blockScope.recordNonNullByDefault(fieldDeclaration.binding, n6, this, fieldDeclaration.declarationSourceStart, fieldDeclaration.declarationSourceEnd);
                            if (binding != null) {
                                blockScope.problemReporter().nullDefaultAnnotationIsRedundant(fieldDeclaration, new Annotation[]{this}, binding);
                            }
                        }
                        if ((fieldBinding.tagBits & 0x180000000000000L) != 0x180000000000000L) break;
                        blockScope.problemReporter().contradictoryNullAnnotations(this);
                        fieldBinding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        break;
                    }
                    case 2: {
                        LocalVariableBinding localVariableBinding = (LocalVariableBinding)this.recipient;
                        localVariableBinding.tagBits |= l;
                        if ((localVariableBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                            blockScope.problemReporter().contradictoryNullAnnotations(this);
                            localVariableBinding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        }
                        if ((l & 0x4000000000000L) == 0L) break;
                        LocalDeclaration localDeclaration = localVariableBinding.declaration;
                        this.recordSuppressWarnings(blockScope, localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd, object4.suppressWarnings);
                    }
                }
            }
            if (n2 == 4) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.recipient;
                if (CharOperation.equals(sourceTypeBinding.sourceName, TypeConstants.PACKAGE_INFO_NAME)) {
                    n2 = 16;
                }
            }
            Annotation.checkAnnotationTarget(this, blockScope, referenceBinding, n2, this.recipient, l & 0x180000000000000L);
        }
        return this.resolvedType;
    }

    public long handleNonNullByDefault(BlockScope blockScope) {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            typeBinding = this.type.resolveType(blockScope);
            if (typeBinding == null) {
                return 0L;
            }
            this.resolvedType = typeBinding;
        }
        if (!typeBinding.isAnnotationType()) {
            return 0L;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (!referenceBinding.hasNullBit(128)) {
            return 0L;
        }
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        MemberValuePair memberValuePair = null;
        int n = memberValuePairArray.length;
        for (MethodBinding methodBinding : methodBindingArray) {
            char[] cArray = methodBinding.selector;
            for (int i = 0; i < n; ++i) {
                char[] cArray2;
                MemberValuePair memberValuePair2 = memberValuePairArray[i];
                if (memberValuePair2 == null || !CharOperation.equals(cArray2 = memberValuePair2.name, cArray) || memberValuePair != null || !CharOperation.equals(cArray2, TypeConstants.VALUE)) continue;
                memberValuePair = memberValuePair2;
                memberValuePair2.binding = methodBinding;
                memberValuePair2.resolveTypeExpecting(blockScope, methodBinding.returnType);
            }
        }
        long l = this.determineNonNullByDefaultTagBits(referenceBinding, memberValuePair);
        return (int)(l & 0x3FAL);
    }

    private static AnnotationTargetAllowed isAnnotationTargetAllowed(Binding binding, BlockScope blockScope, TypeBinding typeBinding, int n, long l) {
        switch (n) {
            case 16: {
                if ((l & 0x80000000000L) != 0L) {
                    return AnnotationTargetAllowed.YES;
                }
                if (blockScope.compilerOptions().sourceLevel > 0x320000L) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
                if (!CharOperation.equals(sourceTypeBinding.sourceName, TypeConstants.PACKAGE_INFO_NAME)) break;
                return AnnotationTargetAllowed.YES;
            }
            case 16388: {
                if ((l & 0x20000000000000L) != 0L) {
                    return AnnotationTargetAllowed.YES;
                }
                if (blockScope.compilerOptions().sourceLevel >= 0x340000L) break;
                return AnnotationTargetAllowed.YES;
            }
            case 4: 
            case 2052: {
                if (((ReferenceBinding)binding).isAnnotationType()) {
                    if ((l & 0x20041000000000L) == 0L) break;
                    return AnnotationTargetAllowed.YES;
                }
                if ((l & 0x20001000000000L) != 0L) {
                    return AnnotationTargetAllowed.YES;
                }
                if ((l & 0x80000000000L) == 0L || !CharOperation.equals(((ReferenceBinding)binding).sourceName, TypeConstants.PACKAGE_INFO_NAME)) break;
                return AnnotationTargetAllowed.YES;
            }
            case 8: {
                MethodBinding methodBinding = (MethodBinding)binding;
                if (methodBinding.isConstructor()) {
                    if ((l & 0x20010000000000L) == 0L) break;
                    return AnnotationTargetAllowed.YES;
                }
                if ((l & 0x4000000000L) != 0L) {
                    return AnnotationTargetAllowed.YES;
                }
                if ((l & 0x20000000000000L) == 0L) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)methodBinding.declaringClass;
                MethodDeclaration methodDeclaration = (MethodDeclaration)sourceTypeBinding.scope.referenceContext.declarationOf(methodBinding);
                if (Annotation.isTypeUseCompatible(methodDeclaration.returnType, blockScope)) {
                    return AnnotationTargetAllowed.YES;
                }
                return AnnotationTargetAllowed.TYPE_ANNOTATION_ON_QUALIFIED_NAME;
            }
            case 1: {
                if ((l & 0x2000000000L) != 0L) {
                    return AnnotationTargetAllowed.YES;
                }
                if (((FieldBinding)binding).isRecordComponent()) {
                    long l2 = 9008024962203648L;
                    return (l & l2) != 0L ? AnnotationTargetAllowed.YES : AnnotationTargetAllowed.NO;
                }
                if ((l & 0x20000000000000L) == 0L) break;
                FieldBinding fieldBinding = (FieldBinding)binding;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                FieldDeclaration fieldDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(fieldBinding);
                if (Annotation.isTypeUseCompatible(fieldDeclaration.type, blockScope)) {
                    return AnnotationTargetAllowed.YES;
                }
                return AnnotationTargetAllowed.TYPE_ANNOTATION_ON_QUALIFIED_NAME;
            }
            case 131072: {
                long l3 = 9008162401157120L;
                return (l & l3) != 0L ? AnnotationTargetAllowed.YES : AnnotationTargetAllowed.NO;
            }
            case 2: {
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)binding;
                if ((localVariableBinding.tagBits & 0x400L) != 0L) {
                    if ((l & 0x8000000000L) != 0L) {
                        return AnnotationTargetAllowed.YES;
                    }
                    if ((l & 0x20000000000000L) == 0L) break;
                    if (Annotation.isTypeUseCompatible(localVariableBinding.declaration.type, blockScope)) {
                        return AnnotationTargetAllowed.YES;
                    }
                    return AnnotationTargetAllowed.TYPE_ANNOTATION_ON_QUALIFIED_NAME;
                }
                if ((typeBinding.tagBits & 0x20000000000L) != 0L) {
                    return AnnotationTargetAllowed.YES;
                }
                if ((l & 0x20000000000000L) == 0L) break;
                if (localVariableBinding.declaration.isTypeNameVar(blockScope)) {
                    return AnnotationTargetAllowed.NO;
                }
                if (Annotation.isTypeUseCompatible(localVariableBinding.declaration.type, blockScope)) {
                    return AnnotationTargetAllowed.YES;
                }
                return AnnotationTargetAllowed.TYPE_ANNOTATION_ON_QUALIFIED_NAME;
            }
            case 4100: {
                if ((l & 0x60000000000000L) == 0L) break;
                return AnnotationTargetAllowed.YES;
            }
            case 64: {
                if ((l & 0x2000000000000000L) == 0L) break;
                return AnnotationTargetAllowed.YES;
            }
        }
        return AnnotationTargetAllowed.NO;
    }

    public static boolean isAnnotationTargetAllowed(BlockScope blockScope, TypeBinding typeBinding, Binding binding) {
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x20600FF840000000L) == 0L) {
            return true;
        }
        return Annotation.isAnnotationTargetAllowed(binding, blockScope, typeBinding, binding.kind(), l) == AnnotationTargetAllowed.YES;
    }

    static AnnotationTargetAllowed isAnnotationTargetAllowed(Annotation annotation, BlockScope blockScope, TypeBinding typeBinding, int n) {
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x20600FF840000000L) == 0L) {
            return AnnotationTargetAllowed.YES;
        }
        if ((l & 0xFF000000000L) == 0L && (l & 0x60000000000000L) != 0L && blockScope.compilerOptions().sourceLevel < 0x340000L) {
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 2052: 
                case 131072: {
                    blockScope.problemReporter().invalidUsageOfTypeAnnotations(annotation);
                }
            }
        }
        return Annotation.isAnnotationTargetAllowed(annotation.recipient, blockScope, typeBinding, n, l);
    }

    static void checkAnnotationTarget(Annotation annotation, BlockScope blockScope, ReferenceBinding referenceBinding, int n, Binding binding, long l) {
        if (!referenceBinding.isValidBinding()) {
            return;
        }
        AnnotationTargetAllowed annotationTargetAllowed = Annotation.isAnnotationTargetAllowed(annotation, blockScope, referenceBinding, n);
        if (annotationTargetAllowed != AnnotationTargetAllowed.YES) {
            if (annotationTargetAllowed == AnnotationTargetAllowed.TYPE_ANNOTATION_ON_QUALIFIED_NAME) {
                blockScope.problemReporter().typeAnnotationAtQualifiedName(annotation);
            } else {
                blockScope.problemReporter().disallowedTargetForAnnotation(annotation);
            }
            if (binding instanceof TypeBinding) {
                ((TypeBinding)binding).tagBits &= l ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }

    public static void checkForInstancesOfRepeatableWithRepeatingContainerAnnotation(BlockScope blockScope, ReferenceBinding referenceBinding, Annotation[] annotationArray) {
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(TypeConstants.VALUE);
        if (methodBindingArray.length != 1) {
            return;
        }
        TypeBinding typeBinding = methodBindingArray[0].returnType;
        if (!typeBinding.isArrayType() || typeBinding.dimensions() != 1) {
            return;
        }
        ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
        TypeBinding typeBinding2 = arrayBinding.elementsType();
        if (!typeBinding2.isRepeatableAnnotationType()) {
            return;
        }
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation = annotationArray[i];
            if (!TypeBinding.equalsEquals(typeBinding2, annotation.resolvedType)) continue;
            blockScope.problemReporter().repeatableAnnotationWithRepeatingContainer(annotation, referenceBinding);
            return;
        }
    }

    public static boolean isTypeUseCompatible(TypeReference typeReference, Scope scope) {
        Binding binding;
        return typeReference == null || typeReference instanceof SingleTypeReference || !((binding = scope.getPackage(typeReference.getTypeName())) instanceof PackageBinding);
    }

    public static void isTypeUseCompatible(TypeReference typeReference, Scope scope, Annotation[] annotationArray) {
        TypeBinding typeBinding;
        if (annotationArray == null || typeReference == null || typeReference.getAnnotatableLevels() == 1) {
            return;
        }
        if (scope.environment().globalOptions.sourceLevel < 0x340000L) {
            return;
        }
        TypeBinding typeBinding2 = typeBinding = typeReference.resolvedType == null ? null : typeReference.resolvedType.leafComponentType();
        if (typeBinding == null || !typeBinding.isNestedType()) {
            return;
        }
        block0: for (Annotation annotation : annotationArray) {
            long l = annotation.resolvedType.getAnnotationTagBits();
            if ((l & 0x20000000000000L) == 0L || (l & 0xFF000000000L) != 0L) continue;
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
            while (referenceBinding.isNestedType()) {
                if (referenceBinding.isStatic()) {
                    QualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, referenceBinding, new Annotation[]{annotation});
                    continue block0;
                }
                if (annotation.hasNullBit(96)) {
                    scope.problemReporter().nullAnnotationAtQualifyingType(annotation);
                    continue block0;
                }
                referenceBinding = referenceBinding.enclosingType();
            }
        }
    }

    public boolean hasNullBit(int n) {
        return this.resolvedType instanceof ReferenceBinding && ((ReferenceBinding)this.resolvedType).hasNullBit(n);
    }

    @Override
    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    @Override
    public abstract void traverse(ASTVisitor var1, ClassScope var2);

    public Annotation getPersistibleAnnotation() {
        return this.persistibleAnnotation;
    }

    public void setPersistibleAnnotation(ContainerAnnotation containerAnnotation) {
        this.persistibleAnnotation = containerAnnotation;
    }

    public static enum AnnotationTargetAllowed {
        YES,
        TYPE_ANNOTATION_ON_QUALIFIED_NAME,
        NO;

    }
}

