/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchExpression
extends SwitchStatement
implements IPolyExpression {
    TypeBinding expectedType;
    private ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private boolean isPolyExpression = false;
    private TypeBinding[] originalValueResultExpressionTypes;
    private TypeBinding[] finalValueResultExpressionTypes;
    Map<Expression, TypeBinding> originalTypeMap;
    private int nullStatus = 1;
    public List<Expression> resultExpressions;
    public boolean resolveAll;
    List<Integer> resultExpressionNullStatus;
    LocalVariableBinding hiddenYield;
    int hiddenYieldResolvedPosition = -1;
    public boolean containsTry = false;
    private static Map<TypeBinding, TypeBinding[]> type_map;
    static final char[] SECRET_YIELD_VALUE_NAME;
    int yieldResolvedPosition = -1;
    List<LocalVariableBinding> typesOnStack;

    @Override
    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    protected boolean ignoreMissingDefaultCase(CompilerOptions compilerOptions, boolean bl) {
        return bl;
    }

    @Override
    protected void reportMissingEnumConstantCase(BlockScope blockScope, FieldBinding fieldBinding) {
        blockScope.problemReporter().missingEnumConstantCase(this, fieldBinding);
    }

    @Override
    protected int getFallThroughState(Statement statement, BlockScope blockScope) {
        Block block;
        if (statement instanceof Expression && ((Expression)statement).isTrulyExpression() || statement instanceof ThrowStatement) {
            return 3;
        }
        if ((this.switchBits & 1) != 0 && statement instanceof Block && !(block = (Block)statement).canCompleteNormally()) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, int n) {
        if ((this.nullStatus & 2) != 0) {
            blockScope.problemReporter().expressionNullReference(this);
        } else if ((this.nullStatus & 0x10) != 0) {
            blockScope.problemReporter().expressionPotentialNullReference(this);
        }
        return true;
    }

    private void computeNullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        int n;
        boolean bl;
        boolean bl2 = bl = this.resultExpressionNullStatus.size() > 0;
        if (!bl) {
            this.resultExpressionNullStatus.add(this.resultExpressions.get(0).nullStatus(flowInfo, flowContext));
        }
        int n2 = n = this.resultExpressions.get(0).nullStatus(flowInfo, flowContext);
        boolean bl3 = true;
        int n3 = this.resultExpressions.size();
        for (int i = 1; i < n3; ++i) {
            int n4;
            if (!bl) {
                this.resultExpressionNullStatus.add(this.resultExpressions.get(i).nullStatus(flowInfo, flowContext));
            }
            bl3 &= n == (n4 = this.resultExpressions.get(i).nullStatus(flowInfo, flowContext));
            n2 |= n4;
        }
        if (bl3) {
            this.nullStatus = n;
            return;
        }
        n = Expression.computeNullStatus(0, n2);
        if (n > 0) {
            this.nullStatus = n;
        }
    }

    @Override
    protected void completeNormallyCheck(BlockScope blockScope) {
        int n;
        int n2 = n = this.statements != null ? this.statements.length : 0;
        if (n == 0) {
            return;
        }
        if ((this.switchBits & 1) != 0) {
            for (Statement statement : this.statements) {
                if (!(statement instanceof Block) || !statement.canCompleteNormally()) continue;
                blockScope.problemReporter().switchExpressionLastStatementCompletesNormally(statement);
            }
            return;
        }
        Statement statement = null;
        Statement statement2 = null;
        for (int i = n - 1; i >= 0; --i) {
            Statement statement3 = this.statements[n - 1];
            if (!(statement3 instanceof CaseStatement)) {
                statement = statement3;
                break;
            }
            statement2 = statement3;
        }
        if (statement != null) {
            if (statement.canCompleteNormally()) {
                blockScope.problemReporter().switchExpressionLastStatementCompletesNormally(statement);
            } else if (statement instanceof ContinueStatement || statement instanceof ReturnStatement) {
                blockScope.problemReporter().switchExpressionIllegalLastStatement(statement);
            }
        }
        if (statement2 != null) {
            blockScope.problemReporter().switchExpressionTrailingSwitchLabels(statement2);
        }
    }

    @Override
    protected boolean needToCheckFlowInAbsenceOfDefaultBranch() {
        return (this.switchBits & 1) == 0;
    }

    @Override
    public Expression[] getPolyExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (Expression expression : this.resultExpressions) {
            Expression[] expressionArray = expression.getPolyExpressions();
            if (expressionArray == null || expressionArray.length == 0) continue;
            arrayList.addAll(Arrays.asList(expressionArray));
        }
        return arrayList.toArray(new Expression[0]);
    }

    @Override
    public boolean isPertinentToApplicability(TypeBinding typeBinding, MethodBinding methodBinding) {
        for (Expression expression : this.resultExpressions) {
            if (expression.isPertinentToApplicability(typeBinding, methodBinding)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPotentiallyCompatibleWith(TypeBinding typeBinding, Scope scope) {
        for (Expression expression : this.resultExpressions) {
            if (expression.isPotentiallyCompatibleWith(typeBinding, scope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFunctionalType() {
        for (Expression expression : this.resultExpressions) {
            if (!expression.isFunctionalType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if ((this.implicitConversion & 0x200) != 0) {
            return 4;
        }
        return this.nullStatus;
    }

    @Override
    protected void statementGenerateCode(BlockScope blockScope, CodeStream codeStream, Statement statement) {
        if (!(statement instanceof Expression) || !((Expression)statement).isTrulyExpression() || statement instanceof Assignment || statement instanceof MessageSend || statement instanceof SwitchStatement && !(statement instanceof SwitchExpression)) {
            super.statementGenerateCode(blockScope, codeStream, statement);
            return;
        }
        Expression expression = (Expression)statement;
        expression.generateCode(blockScope, codeStream, true);
    }

    private TypeBinding createType(int n) {
        TypeBinding typeBinding = TypeBinding.wellKnownType(this.scope, n);
        return typeBinding != null ? typeBinding : this.scope.getJavaLangObject();
    }

    private LocalVariableBinding addTypeStackVariable(CodeStream codeStream, TypeBinding typeBinding, int n, int n2, int n3) {
        char[] cArray = CharOperation.concat(SECRET_YIELD_VALUE_NAME, String.valueOf(n2).toCharArray());
        typeBinding = typeBinding != null ? typeBinding : this.createType(n);
        LocalVariableBinding localVariableBinding = new LocalVariableBinding(cArray, typeBinding, 0, false);
        localVariableBinding.setConstant(Constant.NotAConstant);
        localVariableBinding.useFlag = 1;
        localVariableBinding.resolvedPosition = n3;
        this.scope.addLocalVariable(localVariableBinding);
        localVariableBinding.declaration = new LocalDeclaration(cArray, 0, 0);
        return localVariableBinding;
    }

    private int getNextOffset(LocalVariableBinding localVariableBinding) {
        int n = TypeBinding.equalsEquals(localVariableBinding.type, TypeBinding.LONG) || TypeBinding.equalsEquals(localVariableBinding.type, TypeBinding.DOUBLE) ? 2 : 1;
        return localVariableBinding.resolvedPosition + n;
    }

    private void processTypesBindingsOnStack(CodeStream codeStream) {
        int n;
        int n2 = 0;
        int n3 = this.scope.offset;
        if (!codeStream.switchSaveTypeBindings.empty()) {
            this.typesOnStack = new ArrayList<LocalVariableBinding>();
            n = 0;
            Stack<TypeBinding> stack = new Stack<TypeBinding>();
            int n4 = codeStream.switchSaveTypeBindings.size();
            for (int i = codeStream.lastSwitchCumulativeSyntheticVars; i < n4; ++i) {
                stack.add((TypeBinding)codeStream.switchSaveTypeBindings.get(i));
            }
            while (!stack.empty()) {
                TypeBinding typeBinding = (TypeBinding)stack.pop();
                LocalVariableBinding localVariableBinding = this.addTypeStackVariable(codeStream, typeBinding, 0, n++, n3);
                n3 = this.getNextOffset(localVariableBinding);
                this.typesOnStack.add(localVariableBinding);
                codeStream.store(localVariableBinding, false);
                codeStream.addVariable(localVariableBinding);
                ++n2;
            }
        }
        this.yieldResolvedPosition = n3;
        int n5 = TypeBinding.equalsEquals(this.resolvedType, TypeBinding.LONG) || TypeBinding.equalsEquals(this.resolvedType, TypeBinding.DOUBLE) ? 2 : 1;
        codeStream.lastSwitchCumulativeSyntheticVars += n2 + 1;
        n = (n3 += n5) - this.scope.offset;
        this.scope.adjustLocalVariablePositions(n, false);
    }

    public void loadStoredTypesAndKeep(CodeStream codeStream) {
        List<LocalVariableBinding> list = this.typesOnStack;
        int n = list != null ? list.size() : 0;
        codeStream.clearTypeBindingStack();
        int n2 = n - 1;
        while (n2 >= 0) {
            LocalVariableBinding localVariableBinding = list.get(n2--);
            codeStream.load(localVariableBinding);
        }
    }

    private void removeStoredTypes(CodeStream codeStream) {
        List<LocalVariableBinding> list = this.typesOnStack;
        int n = list != null ? list.size() : 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            LocalVariableBinding localVariableBinding = list.get(n2--);
            codeStream.removeVariable(localVariableBinding);
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = 0;
        if (this.containsTry) {
            n = codeStream.lastSwitchCumulativeSyntheticVars;
            this.processTypesBindingsOnStack(codeStream);
        }
        super.generateCode(blockScope, codeStream);
        if (this.containsTry) {
            this.removeStoredTypes(codeStream);
            codeStream.lastSwitchCumulativeSyntheticVars = n;
        }
        if (!bl) {
            switch (this.postConversionType((Scope)blockScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                    break;
                }
            }
        } else if (!this.isPolyExpression()) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
    }

    protected boolean computeConversions(BlockScope blockScope, TypeBinding typeBinding) {
        boolean bl = true;
        int n = this.resultExpressions.size();
        for (int i = 0; i < n; ++i) {
            bl &= this.computeConversionsResultExpressions(blockScope, typeBinding, this.originalValueResultExpressionTypes[i], this.resultExpressions.get(i));
        }
        return bl;
    }

    private boolean computeConversionsResultExpressions(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression) {
        if (typeBinding2 != null && typeBinding2.isValidBinding()) {
            if (expression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding)) {
                expression.computeConversion(blockScope, typeBinding, typeBinding2);
                if (typeBinding2.needsUncheckedConversion(typeBinding)) {
                    blockScope.problemReporter().unsafeTypeConversion(expression, typeBinding2, typeBinding);
                }
                if (expression instanceof CastExpression && (expression.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)expression);
                }
            } else if (this.isBoxingCompatible(typeBinding2, typeBinding, expression, blockScope)) {
                expression.computeConversion(blockScope, typeBinding, typeBinding2);
                if (expression instanceof CastExpression && (expression.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)expression);
                }
            } else {
                blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, expression, null);
                return false;
            }
        }
        return true;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveTypeInternal(blockScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public TypeBinding resolveTypeInternal(BlockScope blockScope) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.constant != Constant.NotAConstant) {
                Iterator<Expression> iterator;
                this.constant = Constant.NotAConstant;
                if (this.expressionContext == ExpressionContext.ASSIGNMENT_CONTEXT || this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) {
                    for (Expression object32 : this.resultExpressions) {
                        object32.setExpressionContext(this.expressionContext);
                        object32.setExpectedType(this.expectedType);
                    }
                }
                if (this.originalTypeMap == null) {
                    this.originalTypeMap = new HashMap<Expression, TypeBinding>();
                }
                this.resolve(blockScope);
                if (this.statements == null || this.statements.length == 0) {
                    blockScope.problemReporter().switchExpressionEmptySwitchBlock(this);
                    iterator = null;
                    return iterator;
                }
                int n5 = n4 = this.resultExpressions != null ? this.resultExpressions.size() : 0;
                if (n4 == 0) {
                    blockScope.problemReporter().switchExpressionNoResultExpressions(this);
                    iterator = null;
                    return iterator;
                }
                this.traverse((ASTVisitor)new OOBLFlagger(this), blockScope);
                if (this.originalValueResultExpressionTypes == null) {
                    this.originalValueResultExpressionTypes = new TypeBinding[n4];
                    this.finalValueResultExpressionTypes = new TypeBinding[n4];
                    for (int i = 0; i < n4; ++i) {
                        this.finalValueResultExpressionTypes[i] = this.originalValueResultExpressionTypes[i] = this.resultExpressions.get((int)i).resolvedType;
                    }
                }
                if (this.isPolyExpression()) {
                    if (this.expectedType == null || !this.expectedType.isProperType(true)) {
                        PolyTypeBinding polyTypeBinding = new PolyTypeBinding(this);
                        return polyTypeBinding;
                    }
                    this.resolvedType = this.computeConversions(this.scope, this.expectedType) ? this.expectedType : null;
                    TypeBinding typeBinding = this.resolvedType;
                    return typeBinding;
                }
            } else {
                int n6 = n4 = this.resultExpressions != null ? this.resultExpressions.size() : 0;
                if (n4 == 0) {
                    this.resolvedType = null;
                    TypeBinding typeBinding = null;
                    return typeBinding;
                }
                for (int i = 0; i < n4; ++i) {
                    Expression expression = this.resultExpressions.get(i);
                    TypeBinding typeBinding = this.originalTypeMap.get(expression);
                    if (typeBinding == null || typeBinding.kind() == 65540) {
                        this.finalValueResultExpressionTypes[i] = this.originalValueResultExpressionTypes[i] = expression.resolveTypeExpecting(blockScope, this.expectedType);
                    }
                    if (this.resolveAll || expression.resolvedType != null && expression.resolvedType.isValidBinding()) continue;
                    this.resolvedType = null;
                    TypeBinding typeBinding2 = null;
                    return typeBinding2;
                }
                TypeBinding typeBinding = this.resolvedType = this.computeConversions(this.scope, this.expectedType) ? this.expectedType : null;
            }
            if (n4 == 1) {
                TypeBinding typeBinding = this.resolvedType = this.originalValueResultExpressionTypes[0];
                return typeBinding;
            }
            boolean bl = true;
            TypeBinding typeBinding = this.originalValueResultExpressionTypes[0];
            int n7 = this.originalValueResultExpressionTypes.length;
            for (n3 = 1; n3 < n7; ++n3) {
                TypeBinding typeBinding3 = this.originalValueResultExpressionTypes[n3];
                if (typeBinding3 == null || !TypeBinding.notEquals(typeBinding, typeBinding3)) continue;
                bl = false;
                break;
            }
            if (bl) {
                void var4_15;
                TypeBinding typeBinding4 = this.originalValueResultExpressionTypes[0];
                for (n3 = 1; n3 < n4; ++n3) {
                    if (this.originalValueResultExpressionTypes[n3] == null) continue;
                    TypeBinding typeBinding5 = NullAnnotationMatching.moreDangerousType((TypeBinding)var4_15, this.originalValueResultExpressionTypes[n3]);
                }
                this.resolvedType = var4_15;
                void var5_22 = this.resolvedType;
                return var5_22;
            }
            n3 = 1;
            for (TypeBinding typeBinding6 : this.originalValueResultExpressionTypes) {
                if (typeBinding6 == null) continue;
                n3 &= typeBinding6.id == 5 || typeBinding6.id == 33 ? 1 : 0;
            }
            LookupEnvironment lookupEnvironment = this.scope.environment();
            if (n3 != 0) {
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.originalValueResultExpressionTypes[n2] == null || this.originalValueResultExpressionTypes[n2].id == 5) continue;
                    this.finalValueResultExpressionTypes[n2] = lookupEnvironment.computeBoxingType(this.originalValueResultExpressionTypes[n2]);
                    this.resultExpressions.get(n2).computeConversion(this.scope, this.finalValueResultExpressionTypes[n2], this.originalValueResultExpressionTypes[n2]);
                }
                this.resolvedType = TypeBinding.BOOLEAN;
                BaseTypeBinding baseTypeBinding = this.resolvedType;
                return baseTypeBinding;
            }
            n2 = 1;
            TypeBinding typeBinding7 = null;
            HashSet<TypeBinding> hashSet = new HashSet<TypeBinding>();
            for (n = 0; n < n4; ++n) {
                TypeBinding typeBinding8;
                TypeBinding typeBinding9 = this.originalValueResultExpressionTypes[n];
                if (typeBinding9 == null) continue;
                TypeBinding typeBinding10 = typeBinding8 = typeBinding9.isNumericType() ? typeBinding9 : lookupEnvironment.computeBoxingType(typeBinding9);
                if (!typeBinding8.isNumericType()) {
                    n2 = 0;
                    break;
                }
                hashSet.add(TypeBinding.wellKnownType(this.scope, typeBinding8.id));
            }
            if (n2 != 0) {
                void var11_40;
                TypeBinding[] typeBindingArray;
                for (TypeBinding typeBinding11 : typeBindingArray = new TypeBinding[]{TypeBinding.DOUBLE, TypeBinding.FLOAT, TypeBinding.LONG}) {
                    if (!hashSet.contains(typeBinding11)) continue;
                    typeBinding7 = typeBinding11;
                    break;
                }
                typeBinding7 = typeBinding7 != null ? typeBinding7 : this.check_nonconstant_int();
                typeBinding7 = typeBinding7 != null ? typeBinding7 : this.getResultNumeric(hashSet);
                Object var9_33 = null;
                boolean bl2 = false;
                while (var11_40 < n4) {
                    this.resultExpressions.get((int)var11_40).computeConversion(this.scope, typeBinding7, this.originalValueResultExpressionTypes[var11_40]);
                    this.finalValueResultExpressionTypes[var11_40] = typeBinding7;
                    ++var11_40;
                }
                TypeBinding typeBinding12 = this.resolvedType = typeBinding7;
                return typeBinding12;
            }
            for (n = 0; n < n4; ++n) {
                TypeBinding typeBinding13 = this.finalValueResultExpressionTypes[n];
                if (typeBinding13 == null || !typeBinding13.isBaseType()) continue;
                this.finalValueResultExpressionTypes[n] = lookupEnvironment.computeBoxingType(typeBinding13);
            }
            TypeBinding typeBinding14 = this.scope.lowerUpperBound(this.finalValueResultExpressionTypes);
            if (typeBinding14 != null) {
                void var11_45;
                boolean bl3 = false;
                int n8 = this.resultExpressions.size();
                while (var11_45 < n8) {
                    if (this.originalValueResultExpressionTypes[var11_45] != null) {
                        this.resultExpressions.get((int)var11_45).computeConversion(this.scope, typeBinding14, this.originalValueResultExpressionTypes[var11_45]);
                        this.finalValueResultExpressionTypes[var11_45] = typeBinding14;
                    }
                    ++var11_45;
                }
                TypeBinding typeBinding15 = this.resolvedType = typeBinding14.capture(this.scope, this.sourceStart, this.sourceEnd);
                return typeBinding15;
            }
            this.scope.problemReporter().switchExpressionIncompatibleResultExpressions(this);
            TypeBinding typeBinding16 = null;
            return typeBinding16;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private TypeBinding check_nonconstant_int() {
        int n = this.resultExpressions.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.resultExpressions.get(i);
            TypeBinding typeBinding = this.originalValueResultExpressionTypes[i];
            if (typeBinding == null || typeBinding.id != 10 || expression.constant != Constant.NotAConstant) continue;
            return TypeBinding.INT;
        }
        return null;
    }

    private boolean areAllIntegerResultExpressionsConvertibleToTargetType(TypeBinding typeBinding) {
        int n = this.resultExpressions.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.resultExpressions.get(i);
            TypeBinding typeBinding2 = this.originalValueResultExpressionTypes[i];
            if (!TypeBinding.equalsEquals(typeBinding2, TypeBinding.INT) || expression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = super.analyseCode(blockScope, flowContext, flowInfo);
        this.resultExpressionNullStatus = new ArrayList<Integer>(0);
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.enableSyntacticNullAnalysisForFields) {
            for (Expression expression : this.resultExpressions) {
                this.resultExpressionNullStatus.add(expression.nullStatus(flowInfo, flowContext));
                flowContext.expireNullCheckedFieldInfo();
            }
        }
        this.computeNullStatus(flowInfo, flowContext);
        return flowInfo;
    }

    @Override
    protected void addSecretTryResultVariable() {
        if (this.containsTry) {
            this.hiddenYield = new LocalVariableBinding(SECRET_YIELD_VALUE_NAME, null, 0, false);
            this.hiddenYield.setConstant(Constant.NotAConstant);
            this.hiddenYield.useFlag = 1;
            this.scope.addLocalVariable(this.hiddenYield);
            this.hiddenYield.declaration = new LocalDeclaration(SECRET_YIELD_VALUE_NAME, 0, 0);
        }
    }

    private TypeBinding check_csb(Set<TypeBinding> set, TypeBinding typeBinding) {
        if (!set.contains(typeBinding)) {
            return null;
        }
        TypeBinding[] typeBindingArray = type_map.get(typeBinding);
        Set set2 = Arrays.stream(typeBindingArray).collect(Collectors.toSet());
        if (!set2.containsAll(set)) {
            return null;
        }
        return this.areAllIntegerResultExpressionsConvertibleToTargetType(typeBinding) ? typeBinding : null;
    }

    private TypeBinding getResultNumeric(Set<TypeBinding> set) {
        TypeBinding[] typeBindingArray;
        for (TypeBinding typeBinding : typeBindingArray = new TypeBinding[]{TypeBinding.SHORT, TypeBinding.BYTE, TypeBinding.CHAR}) {
            TypeBinding typeBinding2 = this.check_csb(set, typeBinding);
            if (typeBinding2 == null) continue;
            return typeBinding2;
        }
        return TypeBinding.INT;
    }

    @Override
    public boolean isPolyExpression() {
        if (this.isPolyExpression) {
            return true;
        }
        this.isPolyExpression = this.expressionContext == ExpressionContext.ASSIGNMENT_CONTEXT || this.expressionContext == ExpressionContext.INVOCATION_CONTEXT;
        return this.isPolyExpression;
    }

    @Override
    public boolean isTrulyExpression() {
        return true;
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!this.isPolyExpression()) {
            return super.isCompatibleWith(typeBinding, scope);
        }
        for (Expression expression : this.resultExpressions) {
            if (expression.isCompatibleWith(typeBinding, scope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!this.isPolyExpression()) {
            return super.isBoxingCompatibleWith(typeBinding, scope);
        }
        for (Expression expression : this.resultExpressions) {
            if (expression.isCompatibleWith(typeBinding, scope) || expression.isBoxingCompatibleWith(typeBinding, scope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        if (!this.isPolyExpression()) {
            return false;
        }
        for (Expression expression : this.resultExpressions) {
            if (expression.sIsMoreSpecific(typeBinding, typeBinding2, scope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeBinding expectedType() {
        return this.expectedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
            if (this.statements != null) {
                int n = this.statements.length;
                for (int i = 0; i < n; ++i) {
                    this.statements[i].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    static {
        SECRET_YIELD_VALUE_NAME = " yieldValue".toCharArray();
        type_map = new HashMap<TypeBinding, TypeBinding[]>();
        type_map.put(TypeBinding.CHAR, new TypeBinding[]{TypeBinding.CHAR, TypeBinding.INT});
        type_map.put(TypeBinding.SHORT, new TypeBinding[]{TypeBinding.SHORT, TypeBinding.BYTE, TypeBinding.INT});
        type_map.put(TypeBinding.BYTE, new TypeBinding[]{TypeBinding.BYTE, TypeBinding.INT});
    }

    static class OOBLFlagger
    extends ASTVisitor {
        Set<String> labelDecls = new HashSet<String>();
        Set<BreakStatement> referencedBreakLabels = new HashSet<BreakStatement>();
        Set<ContinueStatement> referencedContinueLabels = new HashSet<ContinueStatement>();

        public OOBLFlagger(SwitchExpression switchExpression) {
        }

        @Override
        public boolean visit(SwitchExpression switchExpression, BlockScope blockScope) {
            return true;
        }

        private void checkForOutofBoundLabels(BlockScope blockScope) {
            try {
                for (BreakStatement branchStatement : this.referencedBreakLabels) {
                    if (branchStatement.label == null || branchStatement.label.length == 0 || this.labelDecls.contains(new String(branchStatement.label))) continue;
                    blockScope.problemReporter().switchExpressionsBreakOutOfSwitchExpression(branchStatement);
                }
                for (ContinueStatement continueStatement : this.referencedContinueLabels) {
                    if (continueStatement.label == null || continueStatement.label.length == 0 || this.labelDecls.contains(new String(continueStatement.label))) continue;
                    blockScope.problemReporter().switchExpressionsContinueOutOfSwitchExpression(continueStatement);
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }

        @Override
        public void endVisit(SwitchExpression switchExpression, BlockScope blockScope) {
            this.checkForOutofBoundLabels(blockScope);
        }

        @Override
        public boolean visit(BreakStatement breakStatement, BlockScope blockScope) {
            if (breakStatement.label != null && breakStatement.label.length != 0) {
                this.referencedBreakLabels.add(breakStatement);
            }
            return true;
        }

        @Override
        public boolean visit(ContinueStatement continueStatement, BlockScope blockScope) {
            if (continueStatement.label != null && continueStatement.label.length != 0) {
                this.referencedContinueLabels.add(continueStatement);
            }
            return true;
        }

        @Override
        public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
            return false;
        }

        @Override
        public boolean visit(LabeledStatement labeledStatement, BlockScope blockScope) {
            if (labeledStatement.label != null && labeledStatement.label.length != 0) {
                this.labelDecls.add(new String(labeledStatement.label));
            }
            return true;
        }

        @Override
        public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
            blockScope.problemReporter().switchExpressionsReturnWithinSwitchExpression(returnStatement);
            return false;
        }

        @Override
        public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
            return false;
        }
    }
}

