/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.label.AbstractGoodsLabel;
import net.sf.freecol.client.gui.label.FreeColLabel;
import net.sf.freecol.client.gui.label.GoodsTypeLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.OSUtils;

public final class DragListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(DragListener.class.getName());
    private static final int maxWindowHeight = 768;
    private static final int windowHeight = (int)Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
    private static final boolean small = windowHeight < 768;
    private final boolean windows = OSUtils.onWindows();
    private final FreeColClient freeColClient;
    private final FreeColPanel parentPanel;

    public DragListener(FreeColClient freeColClient, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.parentPanel = parentPanel;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        FreeColLabel label;
        JComponent comp = (JComponent)e.getSource();
        if (e.getButton() == 3 || e.isPopupTrigger()) {
            int lastIdx;
            if (!this.parentPanel.isEditable()) {
                return;
            }
            QuickActionMenu menu = new QuickActionMenu(this.freeColClient, this.parentPanel).addMenuItems(comp);
            while ((lastIdx = menu.getComponentCount() - 1) >= 0 && menu.getComponent(lastIdx) instanceof JPopupMenu.Separator) {
                menu.remove(lastIdx);
            }
            if (menu.getComponentCount() <= 0) {
                return;
            }
            GUI gui = this.freeColClient.getGUI();
            if (gui.isWindowed() && this.windows || small && !gui.isWindowed()) {
                gui.showPopupMenu(menu, menu.getLocation().x, 0);
            } else {
                menu.show(comp, e.getX(), e.getY());
            }
            return;
        }
        if (comp instanceof AbstractGoodsLabel) {
            label = (AbstractGoodsLabel)comp;
            if (e.isShiftDown() && e.isAltDown()) {
                Component[] cArr = comp.getParent().getComponents();
                int sum = 0;
                for (int i = 0; i < cArr.length; ++i) {
                    AbstractGoodsLabel abGoods;
                    if (!(cArr[i] instanceof AbstractGoodsLabel) || !(abGoods = (AbstractGoodsLabel)cArr[i]).getAbstractGoods().getType().equals(((AbstractGoodsLabel)label).getAbstractGoods().getType())) continue;
                    sum += abGoods.getAmount();
                }
                ((AbstractGoodsLabel)label).setSuperFullChosen(true);
                ((AbstractGoodsLabel)label).setAmount(sum);
            } else if (e.isShiftDown()) {
                ((AbstractGoodsLabel)label).setSuperFullChosen(false);
                ((AbstractGoodsLabel)label).setPartialChosen(true);
            } else if (e.isControlDown()) {
                ((AbstractGoodsLabel)label).setSuperFullChosen(false);
                ((AbstractGoodsLabel)label).setFullChosen(true);
            } else {
                ((AbstractGoodsLabel)label).setSuperFullChosen(false);
                ((AbstractGoodsLabel)label).setPartialChosen(false);
                ((AbstractGoodsLabel)label).setDefaultAmount();
            }
        } else if (comp instanceof UnitLabel) {
            label = (UnitLabel)comp;
            Unit u = ((UnitLabel)label).getUnit();
            if (u.isCarrier() && !u.isAtSea() && this.parentPanel instanceof PortPanel) {
                ((PortPanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)label);
            }
        } else if (!(comp instanceof GoodsTypeLabel)) {
            System.err.println("DragListener did not recognize:" + comp);
        }
        TransferHandler handler = comp.getTransferHandler();
        if (handler != null) {
            handler.exportAsDrag(comp, e, 1);
        }
    }
}

