/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ListModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class IconRegistry
implements IExtension {
    private final SortedComboBoxModel mapIcons = new SortedComboBoxModel();

    public IconRegistry(MapController mapController, MapModel map) {
        NodeModel rootNode = map.getRootNode();
        if (rootNode != null) {
            this.registryNodeIcons(mapController, rootNode);
        }
    }

    public void addIcon(NamedIcon icon) {
        if (icon != null) {
            this.mapIcons.add(icon);
        }
    }

    public ListModel getIconsAsListModel() {
        return this.mapIcons;
    }

    private void registryNodeIcons(MapController mapController, NodeModel node) {
        for (NamedIcon icon : node.getIcons()) {
            this.addIcon(icon);
        }
        for (NodeModel child : node.getChildren()) {
            this.registryNodeIcons(mapController, child);
        }
    }

    public void addIcons(MapModel map) {
        IconRegistry newRegistry = map.getIconRegistry();
        SortedComboBoxModel newMapIcons = newRegistry.mapIcons;
        for (Object uiIcon : newMapIcons) {
            this.mapIcons.add(uiIcon);
        }
    }
}

