/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class MapNavigationUtils {
    public static NodeModel findNext(MapController.Direction direction, NodeModel current, NodeModel end) {
        NodeModel parentNode;
        if (MapNavigationUtils.hasChildren(current, direction)) {
            NodeModel next = current.getChildAt(0);
            if (MapNavigationUtils.atEnd(next, end)) {
                return null;
            }
            return next;
        }
        do {
            if ((parentNode = current.getParentNode()) == null) {
                return current;
            }
            int index = parentNode.getIndex(current) + 1;
            int childCount = parentNode.getChildCount();
            if (direction == MapController.Direction.FORWARD_N_FOLD) {
                Controller.getCurrentModeController().getMapController().fold(current);
            }
            if (index >= childCount) continue;
            NodeModel next = parentNode.getChildAt(index);
            if (MapNavigationUtils.atEnd(next, end)) {
                return null;
            }
            return next;
        } while (!MapNavigationUtils.atEnd(current = parentNode, end));
        return null;
    }

    private static boolean atEnd(NodeModel current, NodeModel end) {
        return end != null && current.equals(end);
    }

    public static NodeModel findPrevious(MapController.Direction direction, NodeModel current, NodeModel end) {
        NodeModel parentNode;
        if (current != end && (parentNode = current.getParentNode()) != null) {
            int index;
            if (direction == MapController.Direction.BACK_N_FOLD) {
                Controller.getCurrentModeController().getMapController().fold(current);
            }
            if ((index = parentNode.getIndex(current) - 1) < 0) {
                if (direction == MapController.Direction.BACK_N_FOLD) {
                    Controller.getCurrentModeController().getMapController().fold(parentNode);
                }
                if (MapNavigationUtils.atEnd(parentNode, end)) {
                    return null;
                }
                return parentNode;
            }
            current = parentNode.getChildAt(index);
            if (MapNavigationUtils.atEnd(current, end)) {
                return null;
            }
        }
        while (true) {
            if (!MapNavigationUtils.hasChildren(current, direction)) {
                if (MapNavigationUtils.atEnd(current, end)) {
                    return null;
                }
                return current;
            }
            current = current.getChildAt(current.getChildCount() - 1);
        }
    }

    private static boolean hasChildren(NodeModel node, MapController.Direction direction) {
        if (node.getChildCount() == 0) {
            return false;
        }
        if (direction.canUnfold()) {
            return true;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return !node.isFolded();
        }
        return !selection.isFolded(node);
    }
}

