#############################################################################
##
##  PackageInfo.g for the package `FR'                    Laurent Bartholdi
##
SetPackageInfo( rec(
PackageName := "FR",
Subtitle := "Computations with functionally recursive groups",
Version := "2.4.12",
Date := "03/12/2022", # dd/mm/yyyy format
License := "GPL-2.0-or-later",

Persons := [
  rec(
    LastName      := "Bartholdi",
    FirstNames    := "Laurent",
    IsAuthor      := true,
    IsMaintainer  := true,
    Email         := "laurent.bartholdi@gmail.com",
    WWWHome       := "https://www.math.uni-sb.de/ag/bartholdi/",
    PostalAddress := Concatenation( [
                       "FR Mathematik+Informatik\n",
                       "D-66123 Saarbrücken\n",
                       "Germany" ] ),
    Place         := "Saarbrücken",
    Institution   := "Saarland University"
  )
],

Status := "deposited",
CommunicatedBy := "Götz Pfeiffer (NUI Galway)",
#AcceptDate := "",

SourceRepository := rec(
    Type := "git",
    URL := Concatenation( "https://github.com/gap-packages/", LowercaseString(~.PackageName) ),
),
IssueTrackerURL := Concatenation( ~.SourceRepository.URL, "/issues" ),
PackageWWWHome  := Concatenation( "https://gap-packages.github.io/", LowercaseString(~.PackageName) ),
README_URL      := Concatenation( ~.PackageWWWHome, "/README.md" ),
PackageInfoURL  := Concatenation( ~.PackageWWWHome, "/PackageInfo.g" ),
ArchiveURL      := Concatenation( ~.SourceRepository.URL,
                                 "/releases/download/v", ~.Version,
                                 "/", LowercaseString(~.PackageName), "-", ~.Version ),
ArchiveFormats := ".tar.gz",

AbstractHTML := "The <span class=\"pkgname\">fr</span> package allows \
   GAP to manipulate groups generated by automata, and more generally \
   functionally recursive groups",

PackageDoc := rec(
  BookName  := "fr",
  HTMLStart := "doc/chap0_mj.html",
  PDFFile   := "doc/manual.pdf",
  SixFile   := "doc/manual.six",
  LongTitle := "Functionally recursive and automata groups",
  ArchiveURLSubset := ["doc"],
),

Dependencies := rec(
  GAP := ">=4.8",
  NeededOtherPackages := [["FGA",">=1.1"],
                      ["IO",">=4.0"],
                      ["Polycyclic",">=2.2"],
                      ["GAPDoc",">=1.0"]],
  SuggestedOtherPackages := [["GBNP",">=0.9"],
                      ["NQ",">=2.4"],
                      ["LPRES",">=0.1"]],
  # additional desired packages: graphviz, display
  ExternalConditions := []
),

AvailabilityTest := ReturnTrue,
                    
BannerString := Concatenation("Loading ", ~.PackageName, " ", String( ~.Version ), " ...\n"),

TestFile := "tst/testall.g",
Keywords := ["functionally recursive group", "mealy machine", "automata group"],

AutoDoc := rec(
    entities := rec(
        Version := ~.Version,
        Date := ~.Date,
    ),
    MainPage := false,
    TitlePage := false,
),

));
