/* gegl-0.4.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gegl", gir_namespace = "Gegl", gir_version = "0.4", lower_case_cprefix = "gegl_")]
namespace Gegl {
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_audio_fragment_get_type ()")]
	public class AudioFragment : GLib.Object {
		[CCode (array_length = false)]
		public weak float data[8];
		[CCode (has_construct_function = false)]
		public AudioFragment (int sample_rate, int channels, int channel_layout, int max_samples);
		public int get_channel_layout ();
		public int get_channels ();
		public int get_max_samples ();
		public int get_pos ();
		public int get_sample_count ();
		public int get_sample_rate ();
		public void set_channel_layout (int channel_layout);
		public void set_channels (int channels);
		public void set_max_samples (int max_samples);
		public void set_pos (int pos);
		public void set_sample_count (int sample_count);
		public void set_sample_rate (int sample_rate);
		[NoAccessorMethod]
		public global::string string { owned get; set; }
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_buffer_get_type ()")]
	public class Buffer : Gegl.TileHandler {
		[CCode (has_construct_function = false)]
		protected Buffer ();
		public void add_handler (void* handler);
		public void clear (Gegl.Rectangle roi);
		public void copy (Gegl.Rectangle src_rect, Gegl.AbyssPolicy repeat_mode, Gegl.Buffer dst, Gegl.Rectangle dst_rect);
		public Gegl.Buffer create_sub_buffer (Gegl.Rectangle extent);
		public Gegl.Buffer dup ();
		public void flush ();
		public void flush_ext (Gegl.Rectangle rect);
		[CCode (has_construct_function = false)]
		public Buffer.for_backend (Gegl.Rectangle extent, Gegl.TileBackend backend);
		public void freeze_changed ();
		public unowned Gegl.Rectangle get_abyss ();
		public unowned Gegl.Rectangle get_extent ();
		[CCode (array_length_pos = 4.1, array_length_type = "guint")]
		public uint8[] introspectable_get (Gegl.Rectangle rect, double scale, string? format_name, Gegl.AbyssPolicy repeat_mode);
		[CCode (cname = "gegl_buffer_introspectable_new", has_construct_function = false)]
		public Buffer.introspectable_new (string format_name, int x, int y, int width, int height);
		public void introspectable_set (Gegl.Rectangle rect, string format_name, [CCode (array_length_cname = "src_length", array_length_pos = 3.1)] uint8[] src);
		public void linear_close (void* linear);
		public static Gegl.Buffer load (string path);
		public static Gegl.Buffer open (string path);
		public void remove_handler (void* handler);
		[Version (deprecated = true, deprecated_since = "0.4.2")]
		public void sample_cleanup ();
		public void save (string path, Gegl.Rectangle roi);
		public bool set_abyss (Gegl.Rectangle abyss);
		public void set_color (Gegl.Rectangle rect, Gegl.Color color);
		public void set_color_from_pixel (Gegl.Rectangle rect, void* pixel, Babl.Object pixel_format);
		public bool set_extent (Gegl.Rectangle extent);
		public void set_pattern (Gegl.Rectangle rect, Gegl.Buffer pattern, int x_offset, int y_offset);
		public bool share_storage (Gegl.Buffer buffer2);
		public long signal_connect (string detailed_signal, [CCode (scope = "async")] GLib.Callback c_handler);
		public static string? swap_create_file (string? suffix);
		public static bool swap_has_file (string path);
		public static void swap_remove_file (string path);
		public void thaw_changed ();
		[NoAccessorMethod]
		public int abyss_height { get; construct; }
		[NoAccessorMethod]
		public int abyss_width { get; construct; }
		[NoAccessorMethod]
		public int abyss_x { get; construct; }
		[NoAccessorMethod]
		public int abyss_y { get; construct; }
		[NoAccessorMethod]
		public Gegl.TileBackend backend { owned get; construct; }
		[NoAccessorMethod]
		public void* format { get; set construct; }
		[NoAccessorMethod]
		public int height { get; set construct; }
		[NoAccessorMethod]
		public bool initialized { get; construct; }
		[NoAccessorMethod]
		public string path { owned get; construct; }
		[NoAccessorMethod]
		public int pixels { get; }
		[NoAccessorMethod]
		public int px_size { get; }
		[NoAccessorMethod]
		public int shift_x { get; construct; }
		[NoAccessorMethod]
		public int shift_y { get; construct; }
		[NoAccessorMethod]
		public int tile_height { get; construct; }
		[NoAccessorMethod]
		public int tile_width { get; construct; }
		[NoAccessorMethod]
		public int width { get; set construct; }
		[NoAccessorMethod]
		public int x { get; set construct; }
		[NoAccessorMethod]
		public int y { get; set construct; }
		public signal void changed (Gegl.Rectangle object);
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	[Compact]
	public class BufferIteratorPriv {
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_color_get_type ()")]
	public class Color : GLib.Object {
		[CCode (has_construct_function = false)]
		public Color (global::string string);
		public Gegl.Color duplicate ();
		public GLib.Bytes get_bytes (Babl.Object format);
		public void get_cmyk (out double cyan, out double magenta, out double yellow, out double key, out double alpha, Babl.Object? space);
		[CCode (array_length_pos = 1.1)]
		public double[] get_components (GLib.Value format);
		public unowned Babl.Object? get_format ();
		public void get_rgba (out double red, out double green, out double blue, out double alpha);
		public void get_rgba_with_space (out double red, out double green, out double blue, out double alpha, Babl.Object space);
		public void set_bytes (Babl.Object format, GLib.Bytes bytes);
		public void set_cmyk (double cyan, double magenta, double yellow, double key, double alpha, Babl.Object? space);
		public void set_components (GLib.Value format, [CCode (array_length_cname = "components_length", array_length_pos = 2.1)] double[] components);
		public void set_rgba (double red, double green, double blue, double alpha);
		public void set_rgba_with_space (double red, double green, double blue, double alpha, Babl.Object space);
		[NoAccessorMethod]
		public global::string string { owned get; set; }
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_config_get_type ()")]
	public class Config : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Config ();
		[NoAccessorMethod]
		public string application_license { owned get; set construct; }
		[NoAccessorMethod]
		public int chunk_size { get; set construct; }
		[NoAccessorMethod]
		public bool mipmap_rendering { get; set construct; }
		[NoAccessorMethod]
		public double quality { get; set construct; }
		[NoAccessorMethod]
		public int queue_size { get; set; }
		[NoAccessorMethod]
		public string swap { owned get; set; }
		[NoAccessorMethod]
		public string swap_compression { owned get; set; }
		[NoAccessorMethod]
		public int threads { get; set construct; }
		[NoAccessorMethod]
		public uint64 tile_cache_size { get; set; }
		[NoAccessorMethod]
		public int tile_height { get; set; }
		[NoAccessorMethod]
		public int tile_width { get; set; }
		[NoAccessorMethod]
		public bool use_opencl { get; set construct; }
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_curve_get_type ()")]
	public class Curve : GLib.Object {
		[CCode (has_construct_function = false)]
		public Curve (double y_min, double y_max);
		public uint add_point (double x, double y);
		public double calc_value (double x);
		[CCode (has_construct_function = false)]
		public Curve.@default ();
		public Gegl.Curve duplicate ();
		public void get_point (uint index, out double x, out double y);
		public void get_y_bounds (out double min_y, out double max_y);
		public uint num_points ();
		public void set_point (uint index, double x, double y);
	}
	[CCode (cheader_filename = "gegl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gegl_matrix3_get_type ()")]
	[Compact]
	public class Matrix3 {
		[CCode (array_length = false)]
		public weak double coeff[9];
		[CCode (has_construct_function = false)]
		public Matrix3 ();
		public Gegl.Matrix3 copy ();
		public void copy_into (Gegl.Matrix3 src);
		public double determinant ();
		public bool equal (Gegl.Matrix3 matrix2);
		public void identity ();
		public void invert ();
		public bool is_affine ();
		public bool is_identity ();
		public bool is_scale ();
		public bool is_translate ();
		public void multiply (Gegl.Matrix3 right, Gegl.Matrix3 product);
		public void originate (double x, double y);
		public void parse_string (string string);
		public void round_error ();
		public string to_string ();
		public void transform_point (double x, double y);
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_metadata_hash_get_type ()")]
	public class MetadataHash : Gegl.MetadataStore, Gegl.Metadata {
		[CCode (has_construct_function = false, type = "GeglMetadataStore*")]
		public MetadataHash ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_metadata_store_get_type ()")]
	public abstract class MetadataStore : GLib.Object, Gegl.Metadata {
		[CCode (has_construct_function = false)]
		protected MetadataStore ();
		[NoWrapper]
		public virtual void _declare (GLib.ParamSpec pspec, bool shadow);
		[NoWrapper]
		public virtual unowned GLib.Value? _get_value (string name);
		public void declare (GLib.ParamSpec pspec);
		public unowned string get_artist ();
		public unowned string get_comment ();
		public unowned string get_copyright ();
		public unowned string get_description ();
		public unowned string get_disclaimer ();
		public unowned string get_file_module_name ();
		public Gegl.ResolutionUnit get_resolution_unit ();
		public double get_resolution_x ();
		public double get_resolution_y ();
		public unowned string get_software ();
		public unowned string get_source ();
		public unowned string get_string (string name);
		public GLib.DateTime get_timestamp ();
		public unowned string get_title ();
		public void get_value (string name, ref GLib.Value value);
		public unowned string get_warning ();
		public virtual bool has_value (string name);
		public void notify (GLib.ParamSpec pspec, bool shadow);
		public void register (string local_name, string name, [CCode (scope = "async")] GLib.ValueTransform transform);
		[NoWrapper]
		public virtual void register_hook (string file_module_name, uint flags);
		public void set_artist (string artist);
		public void set_comment (string comment);
		public void set_copyright (string copyright);
		public void set_description (string description);
		public void set_disclaimer (string disclaimer);
		public void set_resolution_unit (Gegl.ResolutionUnit unit);
		public void set_resolution_x (double resolution_x);
		public void set_resolution_y (double resolution_y);
		public void set_software (string software);
		public void set_source (string source);
		public void set_string (string name, string string);
		public void set_timestamp (GLib.DateTime timestamp);
		public void set_title (string title);
		public virtual void set_value (string name, GLib.Value value);
		public void set_warning (string warning);
		public GLib.Type typeof_value (string name);
		public string artist { get; set; }
		public string comment { get; set; }
		public string copyright { get; set; }
		public string description { get; set; }
		public string disclaimer { get; set; }
		public string file_module_name { get; }
		public Gegl.ResolutionUnit resolution_unit { get; set; }
		public double resolution_x { get; set; }
		public double resolution_y { get; set; }
		public string software { get; set; }
		public string source { get; set; }
		public GLib.DateTime timestamp { owned get; set; }
		public string title { get; set; }
		public string warning { get; set; }
		public signal void changed (GLib.ParamSpec pspec);
		public signal bool generate_value (GLib.ParamSpec pspec, ref GLib.Value value);
		public signal void mapped (string file_module, bool exclude_unmapped);
		public signal bool parse_value (GLib.ParamSpec pspec, ref GLib.Value value);
		public signal void unmapped (string file_module, string local_name);
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_node_get_type ()")]
	public class Node : GLib.Object {
		[CCode (has_construct_function = false)]
		public Node ();
		public unowned Gegl.Node add_child (Gegl.Node child);
		public void blit_buffer (Gegl.Buffer? buffer, Gegl.Rectangle? roi, int level, Gegl.AbyssPolicy abyss_policy);
		public bool connect (string a_pad_name, Gegl.Node b, string b_pad_name);
		public bool connect_from (string input_pad_name, Gegl.Node source, string output_pad_name);
		public bool connect_to (string output_pad_name, Gegl.Node sink, string input_pad_name);
		public unowned Gegl.Node create_child (string operation);
		public unowned Gegl.Node detect (int x, int y);
		public bool disconnect (string input_pad);
		public unowned GLib.ParamSpec find_property (string property_name);
		[CCode (has_construct_function = false)]
		public Node.from_file (string path);
		[CCode (has_construct_function = false)]
		public Node.from_serialized (string chaindata, string path_root);
		[CCode (has_construct_function = false)]
		public Node.from_xml (string xmldata, string path_root);
		public GLib.SList<weak Gegl.Node> get_children ();
		public int get_consumers (string output_pad, [CCode (array_length = false, array_null_terminated = true)] out Gegl.Node[] nodes, [CCode (array_length = false, array_null_terminated = true)] out string[] pads);
		public unowned Gegl.Operation? get_gegl_operation ();
		public unowned Gegl.Node get_input_proxy (string pad_name);
		public unowned string get_operation ();
		public unowned Gegl.Node get_output_proxy (string pad_name);
		public unowned Gegl.Node get_parent ();
		public bool get_passthrough ();
		public unowned Gegl.Node get_producer (string input_pad_name, string? output_pad_name);
		public bool has_pad (string pad_name);
		public Gegl.Rectangle introspectable_get_bounding_box ();
		public GLib.Value? introspectable_get_property (string property_name);
		public bool is_graph ();
		public void link (Gegl.Node sink);
		public void link_many (...);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] list_input_pads ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] list_output_pads ();
		public unowned Gegl.Node new_child (...);
		public Gegl.Processor new_processor (Gegl.Rectangle rectangle);
		public void process ();
		public unowned Gegl.Node remove_child (Gegl.Node child);
		public void set_enum_as_string (string key, string value);
		public void set_passthrough (bool passthrough);
		public void set_property (string property_name, GLib.Value value);
		public void set_time (double time);
		public string to_xml (string path_root);
		public string to_xml_full (Gegl.Node? tail, string path_root);
		[NoAccessorMethod]
		public Gegl.CachePolicy cache_policy { get; set construct; }
		[NoAccessorMethod]
		public bool dont_cache { get; set construct; }
		[NoAccessorMethod]
		public Gegl.Operation gegl_operation { owned get; set construct; }
		[NoAccessorMethod]
		public string name { owned get; set construct; }
		[NoAccessorMethod]
		public string operation { owned get; set construct; }
		public bool passthrough { get; set construct; }
		[NoAccessorMethod]
		public bool use_opencl { get; set construct; }
		public signal void computed (Gegl.Rectangle object);
		public signal void invalidated (Gegl.Rectangle object);
		[HasEmitter]
		public signal void progress (double progress);
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_operation_get_type ()")]
	public class Operation : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Operation ();
		public static unowned GLib.ParamSpec find_property (string operation_type, string property_name);
		public static unowned string get_key (string operation_type, string key_name);
		public static unowned string get_op_version (string op_name);
		public static unowned string get_property_key (string operation_type, string property_name, string property_key_name);
		[CCode (array_length_pos = 1.1, array_length_type = "guint")]
		public static (unowned string)[] list_keys (string operation_type);
		[CCode (array_length_pos = 1.1, array_length_type = "guint")]
		public static (unowned GLib.ParamSpec)[] list_properties (string operation_type);
		[CCode (array_length_pos = 2.1, array_length_type = "guint")]
		public static (unowned string)[] list_property_keys (string operation_type, string property_name);
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	[Compact]
	public class OperationContext {
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_audio_fragment_get_type ()")]
	public class ParamAudioFragment : GLib.ParamSpec {
		[CCode (has_construct_function = false)]
		protected ParamAudioFragment ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_color_get_type ()")]
	public class ParamColor : GLib.ParamSpec {
		[CCode (has_construct_function = false)]
		protected ParamColor ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_curve_get_type ()")]
	public class ParamCurve : GLib.ParamSpec {
		[CCode (has_construct_function = false)]
		protected ParamCurve ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_double_get_type ()")]
	public class ParamDouble : GLib.ParamSpecDouble {
		[CCode (has_construct_function = false)]
		protected ParamDouble ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_enum_get_type ()")]
	public class ParamEnum : GLib.ParamSpecEnum {
		[CCode (has_construct_function = false)]
		protected ParamEnum ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_file_path_get_type ()")]
	public class ParamFilePath : GLib.ParamSpecString {
		[CCode (has_construct_function = false)]
		protected ParamFilePath ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_int_get_type ()")]
	public class ParamInt : GLib.ParamSpecInt {
		[CCode (has_construct_function = false)]
		protected ParamInt ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_path_get_type ()")]
	public class ParamPath : GLib.ParamSpec {
		[CCode (has_construct_function = false)]
		protected ParamPath ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_seed_get_type ()")]
	public class ParamSeed : GLib.ParamSpecUInt {
		[CCode (has_construct_function = false)]
		protected ParamSeed ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_string_get_type ()")]
	public class ParamString : GLib.ParamSpecString {
		[CCode (has_construct_function = false)]
		protected ParamString ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_param_uri_get_type ()")]
	public class ParamUri : GLib.ParamSpecString {
		[CCode (has_construct_function = false)]
		protected ParamUri ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_path_get_type ()")]
	public class Path : GLib.Object {
		[CCode (has_construct_function = false)]
		public Path ();
		public static void add_type (char type, int items, string description);
		public bool calc (double pos, out double x, out double y);
		public int calc_y_for_x (double x, out double y);
		public void clear ();
		public double closest_point (double x, double y, out double on_path_x, out double on_path_y, out int node_pos_before);
		public void dirty ();
		public void @foreach (Gegl.NodeFunction each_item);
		public void foreach_flat (Gegl.NodeFunction each_item);
		public void freeze ();
		[CCode (has_construct_function = false)]
		public Path.from_string (string instructions);
		public void get_bounds (out double min_x, out double max_x, out double min_y, out double max_y);
		public double get_length ();
		public void get_matrix (out unowned Gegl.Matrix3 matrix);
		public int get_n_nodes ();
		public bool get_node (int index, out Gegl.PathItem node);
		public void insert_node (int pos, Gegl.PathItem node);
		public bool is_empty ();
		public void parse_string (string instructions);
		public void remove_node (int pos);
		public void replace_node (int pos, Gegl.PathItem node);
		public void set_matrix (Gegl.Matrix3 matrix);
		public void thaw ();
		public string to_string ();
		public signal void changed (void* object);
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_processor_get_type ()")]
	public class Processor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Processor ();
		public Gegl.Buffer get_buffer ();
		public void set_level (int level);
		public void set_rectangle (Gegl.Rectangle rectangle);
		public void set_scale (double scale);
		public bool work (out double progress);
		[NoAccessorMethod]
		public int chunksize { get; construct; }
		[NoAccessorMethod]
		public Gegl.Node node { set construct; }
		[NoAccessorMethod]
		public double progress { get; set; }
		[NoAccessorMethod]
		public void* rectangle { get; set; }
	}
	[CCode (cheader_filename = "gegl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gegl_random_get_type ()")]
	[Compact]
	public class Random {
		[CCode (has_construct_function = false)]
		public Random ();
		public Gegl.Random duplicate ();
		public global::float float (global::int x, global::int y, global::int z, global::int n);
		public global::float float_range (global::int x, global::int y, global::int z, global::int n, global::float min, global::float max);
		public void free ();
		public uint32 int (global::int x, global::int y, global::int z, global::int n);
		public int32 int_range (global::int x, global::int y, global::int z, global::int n, global::int min, global::int max);
		public void set_seed (uint32 seed);
		[CCode (has_construct_function = false)]
		public Random.with_seed (uint32 seed);
	}
	[CCode (cheader_filename = "gegl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gegl_rectangle_get_type ()")]
	[Compact]
	public class Rectangle {
		public int height;
		public int width;
		public int x;
		public int y;
		[CCode (has_construct_function = false)]
		public Rectangle (int x, int y, uint width, uint height);
		public bool align (Gegl.Rectangle rectangle, Gegl.Rectangle tile, Gegl.RectangleAlignment alignment);
		public bool align_to_buffer (Gegl.Rectangle rectangle, Gegl.Buffer buffer, Gegl.RectangleAlignment alignment);
		public void bounding_box (Gegl.Rectangle source1, Gegl.Rectangle source2);
		public bool contains (Gegl.Rectangle child);
		public void copy (Gegl.Rectangle source);
		public void dump ();
		public Gegl.Rectangle dup ();
		public bool equal (Gegl.Rectangle rectangle2);
		public bool equal_coords (int x, int y, int width, int height);
		public static Gegl.Rectangle infinite_plane ();
		public bool intersect (Gegl.Rectangle src1, Gegl.Rectangle src2);
		public bool is_empty ();
		public bool is_infinite_plane ();
		public void @set (int x, int y, uint width, uint height);
		public int subtract (Gegl.Rectangle minuend, Gegl.Rectangle subtrahend);
		public bool subtract_bounding_box (Gegl.Rectangle minuend, Gegl.Rectangle subtrahend);
		public int xor (Gegl.Rectangle source1, Gegl.Rectangle source2);
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	[Compact]
	public class Sampler {
		public void @get (double x, double y, Gegl.BufferMatrix2 scale, void* output, Gegl.AbyssPolicy repeat_mode);
		public unowned Gegl.Rectangle get_context_rect ();
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_stats_get_type ()")]
	public class Stats : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Stats ();
		[NoAccessorMethod]
		public int active_threads { get; }
		[NoAccessorMethod]
		public int assigned_threads { get; }
		[NoAccessorMethod]
		public uint64 scratch_total { get; }
		[NoAccessorMethod]
		public bool swap_busy { get; }
		[NoAccessorMethod]
		public uint64 swap_file_size { get; }
		[NoAccessorMethod]
		public bool swap_queue_full { get; }
		[NoAccessorMethod]
		public int swap_queue_stalls { get; }
		[NoAccessorMethod]
		public uint64 swap_queued_total { get; }
		[NoAccessorMethod]
		public uint64 swap_read_total { get; }
		[NoAccessorMethod]
		public bool swap_reading { get; }
		[NoAccessorMethod]
		public uint64 swap_total { get; }
		[NoAccessorMethod]
		public uint64 swap_total_uncompressed { get; }
		[NoAccessorMethod]
		public uint64 swap_write_total { get; }
		[NoAccessorMethod]
		public bool swap_writing { get; }
		[NoAccessorMethod]
		public uint64 tile_alloc_total { get; }
		[NoAccessorMethod]
		public int tile_cache_hits { get; }
		[NoAccessorMethod]
		public int tile_cache_misses { get; }
		[NoAccessorMethod]
		public uint64 tile_cache_total { get; }
		[NoAccessorMethod]
		public uint64 tile_cache_total_max { get; }
		[NoAccessorMethod]
		public uint64 tile_cache_total_uncompressed { get; }
		[NoAccessorMethod]
		public uint64 zoom_total { get; }
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	[Compact]
	public class Tile {
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_tile_backend_get_type ()")]
	public class TileBackend : Gegl.TileSource {
		[CCode (has_construct_function = false)]
		protected TileBackend ();
		public void* command (Gegl.TileCommand command, int x, int y, int z, void* data);
		public bool get_flush_on_destroy ();
		public int get_tile_height ();
		public int get_tile_size ();
		public int get_tile_width ();
		public unowned Gegl.TileSource peek_storage ();
		public void set_extent (Gegl.Rectangle rectangle);
		public void set_flush_on_destroy (bool flush_on_destroy);
		[Version (deprecated = true, deprecated_since = "0.4.14")]
		public static void unlink_swap (string path);
		public bool flush_on_destroy { get; set; }
		[NoAccessorMethod]
		public void* format { get; construct; }
		[NoAccessorMethod]
		public int px_size { get; }
		public int tile_height { get; construct; }
		public int tile_size { get; }
		public int tile_width { get; construct; }
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_tile_handler_get_type ()")]
	public class TileHandler : Gegl.TileSource {
		[CCode (has_construct_function = false)]
		protected TileHandler ();
		public void damage_rect (Gegl.Rectangle rect);
		public void damage_tile (int x, int y, int z, uint64 damage);
		public void @lock ();
		public void set_source (Gegl.TileSource source);
		public void @unlock ();
		[NoAccessorMethod]
		public GLib.Object source { owned get; set construct; }
	}
	[CCode (cheader_filename = "gegl.h", type_id = "gegl_tile_source_get_type ()")]
	public class TileSource : GLib.Object {
		public weak Gegl.TileSourceCommand command;
		[CCode (array_length = false)]
		public weak void* padding[4];
		[CCode (has_construct_function = false)]
		protected TileSource ();
	}
	[CCode (cheader_filename = "gegl.h", type_cname = "GeglMetadataInterface", type_id = "gegl_metadata_get_type ()")]
	public interface Metadata : GLib.Object {
		public abstract bool get_resolution (Gegl.ResolutionUnit unit, float x, float y);
		public abstract bool iter_get_value (Gegl.MetadataIter iter, GLib.Value value);
		public abstract void iter_init (Gegl.MetadataIter iter);
		public abstract bool iter_lookup (Gegl.MetadataIter iter, string key);
		public abstract unowned string iter_next (Gegl.MetadataIter iter);
		public abstract bool iter_set_value (Gegl.MetadataIter iter, GLib.Value value);
		public abstract void register_map (string file_module, uint flags, [CCode (array_length_cname = "n_map", array_length_pos = 3.1, array_length_type = "gsize")] Gegl.MetadataMap[] map);
		public abstract bool set_resolution (Gegl.ResolutionUnit unit, float x, float y);
		public void unregister_map ();
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct BufferIterator {
		public int length;
		[CCode (array_length = false)]
		public weak Gegl.BufferIteratorItem[] items;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct BufferIteratorItem {
		public void* data;
		public weak Gegl.Rectangle roi;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct BufferMatrix2 {
		[CCode (array_length = false)]
		public weak double coeff[4];
		public double determinant ();
		public bool is_identity ();
		public bool is_scale ();
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct Lookup {
		public weak Gegl.LookupFunction function;
		public void* data;
		public int shift;
		public uint32 positive_min;
		public uint32 positive_max;
		public uint32 negative_min;
		public uint32 negative_max;
		[CCode (array_length = false)]
		public weak uint32 bitmask[25600];
		[CCode (array_length = false)]
		public weak float[] table;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct MetadataIter {
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct MetadataMap {
		public weak string local_name;
		public weak string name;
		public weak GLib.ValueTransform transform;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecDouble {
		public weak GLib.ParamSpecDouble parent_instance;
		public double ui_minimum;
		public double ui_maximum;
		public double ui_gamma;
		public double ui_step_small;
		public double ui_step_big;
		public int ui_digits;
		public void set_digits (int digits);
		public void set_steps (double small_step, double big_step);
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecEnum {
		public weak GLib.ParamSpecEnum parent_instance;
		public weak GLib.SList<void*> excluded_values;
		public void exclude_value (int value);
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecFilePath {
		public weak GLib.ParamSpecString parent_instance;
		public uint no_validate;
		public uint null_ok;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecInt {
		public weak GLib.ParamSpecInt parent_instance;
		public int ui_minimum;
		public int ui_maximum;
		public double ui_gamma;
		public int ui_step_small;
		public int ui_step_big;
		public void set_steps (int small_step, int big_step);
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecSeed {
		public weak GLib.ParamSpecUInt parent_instance;
		public uint ui_minimum;
		public uint ui_maximum;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecString {
		public weak GLib.ParamSpecString parent_instance;
		public uint no_validate;
		public uint null_ok;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct ParamSpecUri {
		public weak GLib.ParamSpecString parent_instance;
		public uint no_validate;
		public uint null_ok;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct PathItem {
		public char type;
		[CCode (array_length = false)]
		public weak Gegl.PathPoint point[4];
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct PathList {
		public void* next;
		public Gegl.PathItem d;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct PathPoint {
		public float x;
		public float y;
	}
	[CCode (cheader_filename = "gegl.h", has_type_id = false)]
	public struct TileCopyParams {
		public weak Gegl.Buffer dst_buffer;
		public int dst_x;
		public int dst_y;
		public int dst_z;
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "", type_id = "gegl_abyss_policy_get_type ()")]
	public enum AbyssPolicy {
		[CCode (cname = "None")]
		NONE,
		[CCode (cname = "Clamp")]
		CLAMP,
		[CCode (cname = "Loop")]
		LOOP,
		[CCode (cname = "Black")]
		BLACK,
		[CCode (cname = "White")]
		WHITE
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_ACCESS_", type_id = "gegl_access_mode_get_type ()")]
	[Flags]
	public enum AccessMode {
		READ,
		WRITE,
		READWRITE
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "", type_id = "gegl_babl_variant_get_type ()")]
	public enum BablVariant {
		[CCode (cname = "Float")]
		FLOAT,
		[CCode (cname = "Linear")]
		LINEAR,
		[CCode (cname = "Non-linear")]
		NON_LINEAR,
		[CCode (cname = "Perceptual")]
		PERCEPTUAL,
		[CCode (cname = "Linear-premultiplied")]
		LINEAR_PREMULTIPLIED,
		[CCode (cname = "Perceptual-premultiplied")]
		PERCEPTUAL_PREMULTIPLIED,
		[CCode (cname = "Linear-premultiplied-if-alpha")]
		LINEAR_PREMULTIPLIED_IF_ALPHA,
		[CCode (cname = "Perceptual-premultiplied-if-alpha")]
		PERCEPTUAL_PREMULTIPLIED_IF_ALPHA,
		[CCode (cname = "add-alpha")]
		ADD_ALPHA
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_BLIT_", has_type_id = false)]
	[Flags]
	public enum BlitFlags {
		DEFAULT,
		CACHE,
		DIRTY
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_CACHE_POLICY_", type_id = "gegl_cache_policy_get_type ()")]
	public enum CachePolicy {
		AUTO,
		NEVER,
		ALWAYS
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_DISTANCE_METRIC_", type_id = "gegl_distance_metric_get_type ()")]
	public enum DistanceMetric {
		EUCLIDEAN,
		MANHATTAN,
		CHEBYSHEV
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "", type_id = "gegl_dither_method_get_type ()")]
	public enum DitherMethod {
		[CCode (cname = "GEGL_DITHER_NONE")]
		NONE,
		[CCode (cname = "GEGL_DITHER_FLOYD_STEINBERG")]
		FLOYD_STEINBERG,
		[CCode (cname = "GEGL_DITHER_BAYER")]
		BAYER,
		[CCode (cname = "GEGL_DITHER_RANDOM")]
		RANDOM,
		[CCode (cname = "GEGL_DITHER_RANDOM_COVARIANT")]
		RANDOM_COVARIANT,
		[CCode (cname = "Arithmetic add")]
		ADD,
		[CCode (cname = "Arithmetic add covariant")]
		ADD_COVARIANT,
		[CCode (cname = "Arithmetic xor")]
		XOR,
		[CCode (cname = "Arithmetic xor covariant")]
		XOR_COVARIANT,
		[CCode (cname = "GEGL_DITHER_BLUE_NOISE")]
		BLUE_NOISE,
		[CCode (cname = "GEGL_DITHER_BLUE_NOISE_COVARIANT")]
		BLUE_NOISE_COVARIANT
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_MAP_EXCLUDE_", has_type_id = false)]
	public enum MapFlags {
		[CCode (cname = "GEGL_MAP_EXCLUDE_UNMAPPED")]
		MAP_EXCLUDE_UNMAPPED
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_ORIENTATION_", type_id = "gegl_orientation_get_type ()")]
	public enum Orientation {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_PARAM_PAD_", has_type_id = false)]
	[Flags]
	public enum PadType {
		OUTPUT,
		INPUT
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_RECTANGLE_ALIGNMENT_", type_id = "gegl_rectangle_alignment_get_type ()")]
	public enum RectangleAlignment {
		SUBSET,
		SUPERSET,
		NEAREST
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_RESOLUTION_UNIT_", type_id = "gegl_resolution_unit_get_type ()")]
	public enum ResolutionUnit {
		NONE,
		DPI,
		DPM
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_SAMPLER_", type_id = "gegl_sampler_type_get_type ()")]
	public enum SamplerType {
		NEAREST,
		LINEAR,
		CUBIC,
		NOHALO,
		LOHALO
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_SERIALIZE_", has_type_id = false)]
	[Flags]
	public enum SerializeFlag {
		TRIM_DEFAULTS,
		VERSION,
		INDENT,
		BAKE_ANIM
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "GEGL_SPLIT_STRATEGY_", has_type_id = false)]
	public enum SplitStrategy {
		AUTO,
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "gegl.h", cprefix = "", has_type_id = false)]
	public enum TileCommand {
		[CCode (cname = "GEGL_TILE_IDLE")]
		EGL_TILE_IDLE,
		[CCode (cname = "GEGL_TILE_SET")]
		EGL_TILE_SET,
		[CCode (cname = "GEGL_TILE_GET")]
		EGL_TILE_GET,
		[CCode (cname = "GEGL_TILE_IS_CACHED")]
		EGL_TILE_IS_CACHED,
		[CCode (cname = "GEGL_TILE_EXIST")]
		EGL_TILE_EXIST,
		[CCode (cname = "GEGL_TILE_VOID")]
		EGL_TILE_VOID,
		[CCode (cname = "GEGL_TILE_FLUSH")]
		EGL_TILE_FLUSH,
		[CCode (cname = "GEGL_TILE_REFETCH")]
		EGL_TILE_REFETCH,
		[CCode (cname = "GEGL_TILE_REINIT")]
		EGL_TILE_REINIT,
		[CCode (cname = "_GEGL_TILE_LAST_0_4_8_COMMAND")]
		GEGL_TILE_LAST_0_4_8_COMMAND,
		[CCode (cname = "GEGL_TILE_COPY")]
		EGL_TILE_COPY,
		[CCode (cname = "GEGL_TILE_LAST_COMMAND")]
		EGL_TILE_LAST_COMMAND
	}
	[CCode (cheader_filename = "gegl.h", has_target = false)]
	public delegate float LookupFunction (float value, void* data);
	[CCode (cheader_filename = "gegl.h", instance_pos = 1.9)]
	public delegate void NodeFunction (Gegl.PathItem node);
	[CCode (cheader_filename = "gegl.h", instance_pos = 1.9)]
	public delegate void ParallelDistributeAreaFunc (Gegl.Rectangle area);
	[CCode (cheader_filename = "gegl.h", instance_pos = 2.9)]
	public delegate void ParallelDistributeFunc (int i, int n);
	[CCode (cheader_filename = "gegl.h", instance_pos = 2.9)]
	public delegate void ParallelDistributeRangeFunc (size_t offset, size_t size);
	[CCode (cheader_filename = "gegl.h", has_target = false)]
	public delegate void SamplerGetFun (Gegl.Sampler self, double x, double y, Gegl.BufferMatrix2 scale, void* output, Gegl.AbyssPolicy repeat_mode);
	[CCode (cheader_filename = "gegl.h", instance_pos = 1.9)]
	public delegate void TileCallback (Gegl.Tile tile);
	[CCode (cheader_filename = "gegl.h", has_target = false)]
	public delegate void* TileSourceCommand (Gegl.TileSource gegl_tile_source, Gegl.TileCommand command, int x, int y, int z, void* data);
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_AUTO_ROWSTRIDE")]
	public const int AUTO_ROWSTRIDE;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_BACK_CENTER")]
	public const int CH_BACK_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_BACK_LEFT")]
	public const int CH_BACK_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_BACK_RIGHT")]
	public const int CH_BACK_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_FRONT_CENTER")]
	public const int CH_FRONT_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_FRONT_LEFT")]
	public const int CH_FRONT_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_FRONT_LEFT_OF_CENTER")]
	public const int CH_FRONT_LEFT_OF_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_FRONT_RIGHT")]
	public const int CH_FRONT_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_FRONT_RIGHT_OF_CENTER")]
	public const int CH_FRONT_RIGHT_OF_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_2POINT1")]
	public const int CH_LAYOUT_2POINT1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_2_1")]
	public const int CH_LAYOUT_2_1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_2_2")]
	public const int CH_LAYOUT_2_2;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_3POINT1")]
	public const int CH_LAYOUT_3POINT1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_4POINT0")]
	public const int CH_LAYOUT_4POINT0;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_4POINT1")]
	public const int CH_LAYOUT_4POINT1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_5POINT0")]
	public const int CH_LAYOUT_5POINT0;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_5POINT0_BACK")]
	public const int CH_LAYOUT_5POINT0_BACK;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_5POINT1")]
	public const int CH_LAYOUT_5POINT1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_5POINT1_BACK")]
	public const int CH_LAYOUT_5POINT1_BACK;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_6POINT0")]
	public const int CH_LAYOUT_6POINT0;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_6POINT0_FRONT")]
	public const int CH_LAYOUT_6POINT0_FRONT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_6POINT1")]
	public const int CH_LAYOUT_6POINT1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_6POINT1_BACK")]
	public const int CH_LAYOUT_6POINT1_BACK;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_6POINT1_FRONT")]
	public const int CH_LAYOUT_6POINT1_FRONT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_7POINT0")]
	public const int CH_LAYOUT_7POINT0;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_7POINT0_FRONT")]
	public const int CH_LAYOUT_7POINT0_FRONT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_7POINT1")]
	public const int CH_LAYOUT_7POINT1;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_7POINT1_WIDE")]
	public const int CH_LAYOUT_7POINT1_WIDE;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_7POINT1_WIDE_BACK")]
	public const int CH_LAYOUT_7POINT1_WIDE_BACK;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_HEXADECAGONAL")]
	public const int CH_LAYOUT_HEXADECAGONAL;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_HEXAGONAL")]
	public const int CH_LAYOUT_HEXAGONAL;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_NATIVE")]
	public const int CH_LAYOUT_NATIVE;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_OCTAGONAL")]
	public const int CH_LAYOUT_OCTAGONAL;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_QUAD")]
	public const int CH_LAYOUT_QUAD;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_STEREO")]
	public const int CH_LAYOUT_STEREO;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_STEREO_DOWNMIX")]
	public const int CH_LAYOUT_STEREO_DOWNMIX;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LAYOUT_SURROUND")]
	public const int CH_LAYOUT_SURROUND;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LOW_FREQUENCY")]
	public const int CH_LOW_FREQUENCY;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_LOW_FREQUENCY_2")]
	public const int CH_LOW_FREQUENCY_2;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_SIDE_LEFT")]
	public const int CH_SIDE_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_SIDE_RIGHT")]
	public const int CH_SIDE_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_STEREO_LEFT")]
	public const int CH_STEREO_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_STEREO_RIGHT")]
	public const int CH_STEREO_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_SURROUND_DIRECT_LEFT")]
	public const int CH_SURROUND_DIRECT_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_SURROUND_DIRECT_RIGHT")]
	public const int CH_SURROUND_DIRECT_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_BACK_CENTER")]
	public const int CH_TOP_BACK_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_BACK_LEFT")]
	public const int CH_TOP_BACK_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_BACK_RIGHT")]
	public const int CH_TOP_BACK_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_CENTER")]
	public const int CH_TOP_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_FRONT_CENTER")]
	public const int CH_TOP_FRONT_CENTER;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_FRONT_LEFT")]
	public const int CH_TOP_FRONT_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_TOP_FRONT_RIGHT")]
	public const int CH_TOP_FRONT_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_WIDE_LEFT")]
	public const int CH_WIDE_LEFT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_CH_WIDE_RIGHT")]
	public const int CH_WIDE_RIGHT;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_FLOAT_EPSILON")]
	public const double FLOAT_EPSILON;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_LOOKUP_MAX_ENTRIES")]
	public const int LOOKUP_MAX_ENTRIES;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_MAX_AUDIO_CHANNELS")]
	public const int MAX_AUDIO_CHANNELS;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "gegl.h", cname = "GEGL_PARAM_NO_VALIDATE")]
	public const int PARAM_NO_VALIDATE;
	[CCode (cheader_filename = "gegl.h")]
	public static void apply_op (Gegl.Buffer buffer, string operation_name, ...);
	[CCode (cheader_filename = "gegl.h")]
	public static unowned Babl.Object? babl_variant (Babl.Object format, Gegl.BablVariant variant);
	[CCode (cheader_filename = "gegl.h")]
	public static void cl_disable ();
	[CCode (cheader_filename = "gegl.h")]
	public static bool cl_init () throws GLib.Error;
	[CCode (cheader_filename = "gegl.h")]
	public static bool cl_is_accelerated ();
	[CCode (cheader_filename = "gegl.h")]
	public static unowned Gegl.Config config ();
	[CCode (cheader_filename = "gegl.h")]
	public static void create_chain (string ops, Gegl.Node op_start, Gegl.Node op_end, double time, int rel_dim, string path_root) throws GLib.Error;
	[CCode (cheader_filename = "gegl.h")]
	public static void create_chain_argv (string ops, Gegl.Node op_start, Gegl.Node op_end, double time, int rel_dim, string path_root) throws GLib.Error;
	[CCode (cheader_filename = "gegl.h")]
	public static void exit ();
	[CCode (cheader_filename = "gegl.h")]
	public static Gegl.Buffer filter_op (Gegl.Buffer source_buffer, string operation_name, ...);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.Value? format (string format_name);
	[CCode (cheader_filename = "gegl.h")]
	public static unowned string? format_get_name (GLib.Value format);
	[CCode (cheader_filename = "gegl.h")]
	public static void get_version (out int major, out int minor, out int micro);
	[CCode (cheader_filename = "gegl.h")]
	public static void graph_dump_outputs (Gegl.Node node);
	[CCode (cheader_filename = "gegl.h")]
	public static void graph_dump_request (Gegl.Node node, Gegl.Rectangle roi);
	[CCode (cheader_filename = "gegl.h")]
	public static bool has_operation (string operation_type);
	[CCode (cheader_filename = "gegl.h")]
	public static void init ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv);
	[CCode (cheader_filename = "gegl.h")]
	public static bool is_main_thread ();
	[CCode (array_length_pos = 0.1, array_length_type = "guint", cheader_filename = "gegl.h")]
	public static (unowned string)[] list_operations ();
	[CCode (cheader_filename = "gegl.h")]
	public static void load_module_directory (string path);
	[CCode (cheader_filename = "gegl.h")]
	public static void parallel_distribute (int max_n, Gegl.ParallelDistributeFunc func);
	[CCode (cheader_filename = "gegl.h")]
	public static void parallel_distribute_area (Gegl.Rectangle area, double thread_cost, Gegl.SplitStrategy split_strategy, Gegl.ParallelDistributeAreaFunc func);
	[CCode (cheader_filename = "gegl.h")]
	public static void parallel_distribute_range (size_t size, double thread_cost, Gegl.ParallelDistributeRangeFunc func);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_audio_fragment (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_color (string name, string nick, string blurb, Gegl.Color default_color, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_color_from_string (string name, string nick, string blurb, string default_color_string, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static unowned Gegl.Color param_spec_color_get_default (GLib.ParamSpec self);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_curve (string name, string nick, string blurb, Gegl.Curve default_curve, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_double (string name, string nick, string blurb, double minimum, double maximum, double default_value, double ui_minimum, double ui_maximum, double ui_gamma, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_enum (string name, string nick, string blurb, GLib.Type enum_type, int default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_file_path (string name, string nick, string blurb, bool no_validate, bool null_ok, string default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static unowned string param_spec_get_property_key (GLib.ParamSpec pspec, string key_name);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_int (string name, string nick, string blurb, int minimum, int maximum, int default_value, int ui_minimum, int ui_maximum, double ui_gamma, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_path (string name, string nick, string blurb, Gegl.Path default_path, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_seed (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static void param_spec_set_property_key (GLib.ParamSpec pspec, string key_name, string value);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_string (string name, string nick, string blurb, bool no_validate, bool null_ok, string default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	public static GLib.ParamSpec param_spec_uri (string name, string nick, string blurb, bool no_validate, bool null_ok, string default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gegl.h")]
	[Version (replacement = "Rectangle.infinite_plane")]
	public static Gegl.Rectangle rectangle_infinite_plane ();
	[CCode (cheader_filename = "gegl.h")]
	public static void render_op (Gegl.Buffer source_buffer, Gegl.Buffer target_buffer, string operation_name, ...);
	[CCode (cheader_filename = "gegl.h")]
	public static void reset_stats ();
	[CCode (cheader_filename = "gegl.h")]
	public static string serialize (Gegl.Node start, Gegl.Node end, string basepath, Gegl.SerializeFlag serialize_flags);
	[CCode (cheader_filename = "gegl.h")]
	public static unowned Gegl.Stats stats ();
}
