/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.googleearth;

import com.google.earth.kml._2.BalloonStyleType;
import com.google.earth.kml._2.DocumentType;
import com.google.earth.kml._2.FeatureType;
import com.google.earth.kml._2.KmlType;
import com.google.earth.kml._2.ObjectFactory;
import com.google.earth.kml._2.PlacemarkType;
import com.google.earth.kml._2.PointType;
import com.google.earth.kml._2.StyleSelectorType;
import com.google.earth.kml._2.StyleType;
import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.external.ExternalUpdate;
import org.fibs.geotag.external.ExternalUpdateConsumer;
import org.fibs.geotag.googleearth.GoogleEarthLauncher;
import org.fibs.geotag.webserver.ContextHandler;
import org.fibs.geotag.webserver.WebServer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class KmlRequestHandler
implements ContextHandler {
    private static final I18n i18n = I18nFactory.getI18n(KmlRequestHandler.class);
    private ExternalUpdateConsumer parent;
    private static final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml";
    private static final String BALLOON_STYLE = "balloonStyle";

    public KmlRequestHandler(ExternalUpdateConsumer parent) {
        this.parent = parent;
    }

    @Override
    public NanoHTTPD.Response serve(WebServer server, String uri, String method, Properties header, Properties parameters) {
        double latitude = 51.477222222222224;
        double longitude = 0.0;
        Enumeration<Object> keys = parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = parameters.getProperty(key);
            if (key.equals("latitude")) {
                latitude = Double.parseDouble(value);
                continue;
            }
            if (!key.equals("longitude")) continue;
            longitude = Double.parseDouble(value);
        }
        ArrayList<ExternalUpdate> externalUpdates = new ArrayList<ExternalUpdate>();
        ExternalUpdate externalUpdate = new ExternalUpdate(GoogleEarthLauncher.getLastImageLauched().getSequenceNumber(), latitude, longitude, Double.NaN);
        externalUpdates.add(externalUpdate);
        this.parent.processExternalUpdates(externalUpdates);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeKml(latitude, longitude, outputStream);
        byte[] kml = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(kml);
        WebServer webServer = server;
        webServer.getClass();
        NanoHTTPD.Response response = (NanoHTTPD)webServer.new NanoHTTPD.Response("200 OK", KML_MIME_TYPE, inputStream);
        return response;
    }

    private void writeKml(double latitude, double longitude, OutputStream outputStream) {
        ImageInfo lastImageLaunched = GoogleEarthLauncher.getLastImageLauched();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)KmlType.class.getPackage().getName());
            ObjectFactory factory = new ObjectFactory();
            KmlType kml = factory.createKmlType();
            DocumentType document = factory.createDocumentType();
            List<JAXBElement<? extends FeatureType>> documentFeatures = document.getFeature();
            StyleType style = factory.createStyleType();
            style.setId(BALLOON_STYLE);
            BalloonStyleType balloonStyle = factory.createBalloonStyleType();
            String balloonText = "<center><b>$[name]</b>";
            if (lastImageLaunched.getThumbnail() != null) {
                balloonText = String.valueOf(balloonText) + "<br/>";
                balloonText = String.valueOf(balloonText) + "<img src=\"http://127.0.0.1:4321/images/";
                balloonText = String.valueOf(balloonText) + Integer.toString(lastImageLaunched.getSequenceNumber());
                balloonText = String.valueOf(balloonText) + ".jpg\" width=\"";
                balloonText = String.valueOf(balloonText) + lastImageLaunched.getThumbnail().getIconWidth();
                balloonText = String.valueOf(balloonText) + "\" height=\"";
                balloonText = String.valueOf(balloonText) + lastImageLaunched.getThumbnail().getIconHeight();
                balloonText = String.valueOf(balloonText) + "\">";
            }
            balloonText = String.valueOf(balloonText) + "</center>";
            balloonStyle.setText(balloonText);
            style.setBalloonStyle(balloonStyle);
            List<JAXBElement<? extends StyleSelectorType>> styleSelectors = document.getStyleSelector();
            styleSelectors.add(factory.createStyle(style));
            PlacemarkType placemark = factory.createPlacemarkType();
            placemark.setName(i18n.tr("Position"));
            placemark.setStyleUrl("#balloonStyle");
            PointType point = factory.createPointType();
            List<String> coordinates = point.getCoordinates();
            coordinates.add(String.valueOf(longitude) + "," + latitude);
            placemark.setGeometry(factory.createPoint(point));
            documentFeatures.add(factory.createPlacemark(placemark));
            kml.setFeature(factory.createDocument(document));
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(factory.createKml(kml), outputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

