/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.rows.merge;

import javax.swing.Icon;
import org.gephi.datalab.plugin.manipulators.rows.merge.AverageNumber;
import org.gephi.datalab.plugin.manipulators.rows.merge.ui.JoinWithSeparatorUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.TimeFormat;
import org.joda.time.DateTimeZone;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JoinWithSeparator
implements AttributeRowsMergeStrategy {
    public static final String SEPARATOR_SAVED_PREFERENCES = "JoinWithSeparator_Separator";
    private static final String DEFAULT_SEPARATOR = ", ";
    private Element[] rows;
    private Column column;
    private String separator = NbPreferences.forModule(JoinWithSeparator.class).get("JoinWithSeparator_Separator", ", ");
    private String result;

    public void setup(Element[] rows, Element selectedRow, Column column) {
        this.rows = rows;
        this.column = column;
    }

    public Object getReducedValue() {
        return this.result;
    }

    public void execute() {
        NbPreferences.forModule(JoinWithSeparator.class).put(SEPARATOR_SAVED_PREFERENCES, this.separator);
        int rowsCount = this.rows.length;
        TimeFormat timeFormat = this.column.getTable().getGraph().getModel().getTimeFormat();
        DateTimeZone timeZone = this.column.getTable().getGraph().getModel().getTimeZone();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rows.length; ++i) {
            Object value = this.rows[i].getAttribute(this.column);
            if (value == null) continue;
            sb.append(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone));
            if (i >= rowsCount - 1) continue;
            sb.append(this.separator);
        }
        this.result = sb.toString();
    }

    public String getName() {
        return NbBundle.getMessage(AverageNumber.class, (String)"JoinWithSeparator.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(AverageNumber.class, (String)"JoinWithSeparator.description");
    }

    public boolean canExecute() {
        return Object[].class.isAssignableFrom(this.column.getTypeClass()) || this.column.getTypeClass() == String.class;
    }

    public ManipulatorUI getUI() {
        return new JoinWithSeparatorUI();
    }

    public int getType() {
        return 0;
    }

    public int getPosition() {
        return 100;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/join.png", (boolean)false);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

