/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.SourceInfo;
import tim.prune.data.TrackInfo;
import tim.prune.gui.DialogCloser;
import tim.prune.gui.ProgressDialog;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.GpxWriter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.SettingsForExport;
import tim.prune.save.xml.GpxCacherList;
import tim.prune.save.xml.XmlUtils;

public class GpxExporter
extends GenericFunction {
    private final TrackInfo _trackInfo;
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _descriptionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _timestampsCheckbox = null;
    private JCheckBox _copySourceCheckbox = null;
    private JPanel _encodingsPanel = null;
    private JRadioButton _useSystemRadio = null;
    private JRadioButton _forceUtf8Radio = null;
    private File _exportFile = null;
    private boolean _cancelled = false;
    private ProgressDialog _progress = null;
    private SourceInfo _previousSourceInfo = null;

    public GpxExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
    }

    @Override
    public String getNameKey() {
        return "function.exportgpx";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._pointTypeSelector.init(this._app.getTrackInfo());
        this._encodingsPanel.setVisible(!XmlUtils.isSystemUtf8());
        if (!XmlUtils.isSystemUtf8()) {
            String string = XmlUtils.getSystemEncoding();
            this._useSystemRadio.setText(String.valueOf(I18nManager.getText("dialog.exportgpx.encoding.system")) + " (" + (string == null ? "unknown" : string) + ")");
        }
        this.setFileTitle();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        Serializable serializable;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 2));
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportgpx.name")));
        this._nameField = new JTextField(10);
        jPanel4.add(this._nameField);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportgpx.desc")));
        this._descriptionField = new JTextField(10);
        jPanel4.add(this._descriptionField);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(5));
        this._pointTypeSelector = new PointTypeSelector();
        jPanel3.add(this._pointTypeSelector);
        JPanel jPanel5 = new JPanel();
        this._timestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.includetimestamps"));
        this._timestampsCheckbox.setSelected(true);
        jPanel5.add(this._timestampsCheckbox);
        this._copySourceCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.copysource"));
        this._copySourceCheckbox.setSelected(true);
        jPanel5.add(this._copySourceCheckbox);
        jPanel3.add(jPanel5);
        this._encodingsPanel = new JPanel();
        if (!XmlUtils.isSystemUtf8()) {
            this._encodingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this._encodingsPanel.setLayout(new BorderLayout());
            this._encodingsPanel.add((Component)new JLabel(I18nManager.getText("dialog.exportgpx.encoding")), "North");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            serializable = new ButtonGroup();
            this._useSystemRadio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.system"));
            this._forceUtf8Radio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.utf8"));
            ((ButtonGroup)serializable).add(this._useSystemRadio);
            ((ButtonGroup)serializable).add(this._forceUtf8Radio);
            jPanel.add(this._useSystemRadio);
            jPanel.add(this._forceUtf8Radio);
            this._useSystemRadio.setSelected(true);
            this._encodingsPanel.add((Component)jPanel, "Center");
            jPanel3.add(this._encodingsPanel);
        }
        jPanel2.add((Component)jPanel3, "Center");
        this._nameField.addKeyListener(new DialogCloser(this._dialog));
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        serializable = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.startExport();
        ((AbstractButton)serializable).addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel.add((Component)serializable);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel.add(jButton);
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel2;
    }

    private void setFileTitle() {
        String string;
        SourceInfo sourceInfo = this._app.getTrackInfo().getFileInfo().getFirstSource();
        if (sourceInfo != null && sourceInfo != this._previousSourceInfo && (string = sourceInfo.getFileTitle()) != null && !string.equals("")) {
            this._nameField.setText(string);
        }
        if (this._nameField.getText().equals("") && (string = this._app.getTrackInfo().getFileInfo().getFirstTitle()) != null && !string.equals("")) {
            this._nameField.setText(string);
        }
        this._previousSourceInfo = sourceInfo;
    }

    private void startExport() {
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        File file = GpxExporter.chooseGpxFile(this._parentFrame, this._nameField.getText());
        if (file != null) {
            this._exportFile = file;
            this._cancelled = false;
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey(), null, () -> {
                boolean bl = this._cancelled = true;
            });
            this._progress.show();
            new Thread(this::run).start();
            this._dialog.dispose();
        }
    }

    public static File chooseGpxFile(JFrame jFrame, String string) {
        String string2;
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string3 = Config.getConfigString("prune.trackdirectory");
        if (string3 != null) {
            jFileChooser.setCurrentDirectory(new File(string3));
        }
        if ((string2 = GpxExporter.makeFilenameFromTrackName(string)) != null) {
            jFileChooser.setSelectedFile(new File(string2));
        }
        boolean bl = false;
        do {
            bl = false;
            if (jFileChooser.showSaveDialog(jFrame) != 0) continue;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".gpx")) {
                file2 = new File(String.valueOf(file2.getAbsolutePath()) + ".gpx");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file2.exists() || JOptionPane.showOptionDialog(jFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                file = file2;
                continue;
            }
            bl = true;
        } while (bl);
        return file;
    }

    private static String makeFilenameFromTrackName(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.equals("")) {
            return null;
        }
        if ((string2 = string2.replaceAll(" ", "_")).length() > 20) {
            string2 = string2.substring(0, 20);
        }
        if (!string2.toLowerCase().endsWith(".gpx")) {
            string2 = String.valueOf(string2) + ".gpx";
        }
        return string2;
    }

    public void run() {
        GpxCacherList gpxCacherList = null;
        if (this._copySourceCheckbox.isSelected()) {
            gpxCacherList = new GpxCacherList(this._trackInfo.getFileInfo());
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = this._forceUtf8Radio != null && this._forceUtf8Radio.isSelected() ? new OutputStreamWriter((OutputStream)new FileOutputStream(this._exportFile), "UTF-8") : new OutputStreamWriter(new FileOutputStream(this._exportFile));
            SettingsForExport settingsForExport = new SettingsForExport();
            settingsForExport.setExportTrackPoints(this._pointTypeSelector.getTrackpointsSelected());
            settingsForExport.setExportWaypoints(this._pointTypeSelector.getWaypointsSelected());
            settingsForExport.setExportPhotoPoints(this._pointTypeSelector.getPhotopointsSelected());
            settingsForExport.setExportAudiopoints(this._pointTypeSelector.getAudiopointsSelected());
            settingsForExport.setExportJustSelection(this._pointTypeSelector.getJustSelection());
            settingsForExport.setExportTimestamps(this._timestampsCheckbox.isSelected());
            int n = new GpxWriter(this._progress, settingsForExport).exportData(outputStreamWriter, this._trackInfo, this._nameField.getText(), this._descriptionField.getText(), gpxCacherList);
            outputStreamWriter.close();
            this._progress.close();
            if (this._cancelled) {
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.cancelled"));
                return;
            }
            Config.setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            this._app.addRecentFile(this._exportFile, true);
            UpdateMessageBroker.informSubscribers();
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._app.informDataSaved();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }
}

