/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainRequest;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.platform.BuildPlatform;

public class AdoptOpenJdkRemoteBinary {
    private static final String DEFAULT_ADOPTOPENJDK_ROOT_URL = "https://api.adoptopenjdk.net/";
    private static final String DEFAULT_ADOPTIUM_ROOT_URL = "https://api.adoptium.net/";
    private final Provider<String> adoptOpenJdkRootUrl;
    private final Provider<String> adoptiumRootUrl;

    @Inject
    public AdoptOpenJdkRemoteBinary(ProviderFactory providerFactory) {
        this.adoptOpenJdkRootUrl = providerFactory.gradleProperty("org.gradle.jvm.toolchain.install.adoptopenjdk.baseUri");
        this.adoptiumRootUrl = providerFactory.gradleProperty("org.gradle.jvm.toolchain.install.adoptium.baseUri");
    }

    public Optional<JavaToolchainDownload> resolve(JavaToolchainRequest request) {
        JavaToolchainSpec spec = request.getJavaToolchainSpec();
        if (this.canProvide(spec)) {
            return Optional.of(JavaToolchainDownload.fromUri(this.constructUri(spec, request.getBuildPlatform())));
        }
        return Optional.empty();
    }

    private boolean canProvide(JavaToolchainSpec spec) {
        boolean matchesLanguageVersion = AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec).canCompileOrRun(8);
        boolean matchesVendor = this.matchesVendor(spec);
        return matchesLanguageVersion && matchesVendor;
    }

    private boolean matchesVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        if (vendorSpec == DefaultJvmVendorSpec.any()) {
            return true;
        }
        if (vendorSpec.test(JvmVendor.KnownJvmVendor.ADOPTOPENJDK.asJvmVendor())) {
            DeprecationLogger.deprecateBehaviour((String)"Due to changes in AdoptOpenJDK download endpoint, downloading a JDK with an explicit vendor of AdoptOpenJDK should be replaced with a spec without a vendor or using Eclipse Temurin / IBM Semeru.").willBeRemovedInGradle8().withUpgradeGuideSection(7, "adoptopenjdk_download").nagUser();
            return true;
        }
        if (vendorSpec.test(JvmVendor.KnownJvmVendor.ADOPTIUM.asJvmVendor()) && !AdoptOpenJdkRemoteBinary.isJ9ExplicitlyRequested(spec)) {
            return true;
        }
        return vendorSpec.test(JvmVendor.KnownJvmVendor.IBM.asJvmVendor());
    }

    private URI constructUri(JavaToolchainSpec spec, BuildPlatform platform) {
        return URI.create(this.determineServerBaseUri(spec) + "v3/binary/latest/" + AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec) + "/" + AdoptOpenJdkRemoteBinary.determineReleaseState() + "/" + this.determineOs(platform) + "/" + this.determineArch(platform) + "/jdk/" + AdoptOpenJdkRemoteBinary.determineImplementation(spec) + "/normal/" + AdoptOpenJdkRemoteBinary.determineOrganization(spec));
    }

    private static String determineImplementation(JavaToolchainSpec spec) {
        return AdoptOpenJdkRemoteBinary.isJ9Requested(spec) ? "openj9" : "hotspot";
    }

    private static JavaLanguageVersion determineLanguageVersion(JavaToolchainSpec spec) {
        return (JavaLanguageVersion)spec.getLanguageVersion().get();
    }

    private String determineArch(BuildPlatform platform) {
        switch (platform.getArchitecture()) {
            case X86: {
                return "x32";
            }
            case X86_64: {
                return "x64";
            }
            case AARCH64: {
                return "aarch64";
            }
        }
        return "unknown";
    }

    private String determineOs(BuildPlatform platform) {
        switch (platform.getOperatingSystem()) {
            case LINUX: {
                return "linux";
            }
            case WINDOWS: {
                return "windows";
            }
            case MAC_OS: {
                return "mac";
            }
            case SOLARIS: {
                return "solaris";
            }
        }
        return "unknown";
    }

    private static String determineReleaseState() {
        return "ga";
    }

    private String determineServerBaseUri(JavaToolchainSpec spec) {
        String baseUri;
        String string = baseUri = AdoptOpenJdkRemoteBinary.adoptiumHasIt(spec) ? (String)this.adoptiumRootUrl.getOrElse((Object)DEFAULT_ADOPTIUM_ROOT_URL) : (String)this.adoptOpenJdkRootUrl.getOrElse((Object)DEFAULT_ADOPTOPENJDK_ROOT_URL);
        if (!baseUri.endsWith("/")) {
            baseUri = baseUri + "/";
        }
        return baseUri;
    }

    private static String determineOrganization(JavaToolchainSpec spec) {
        return AdoptOpenJdkRemoteBinary.adoptiumHasIt(spec) ? "eclipse" : "adoptopenjdk";
    }

    private static boolean adoptiumHasIt(JavaToolchainSpec spec) {
        if (AdoptOpenJdkRemoteBinary.isJ9Requested(spec)) {
            return false;
        }
        int version = AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec).asInt();
        return version == 8 || version == 11 || version >= 16;
    }

    private static boolean isJ9Requested(JavaToolchainSpec spec) {
        if (AdoptOpenJdkRemoteBinary.isJ9ExplicitlyRequested(spec)) {
            return true;
        }
        return AdoptOpenJdkRemoteBinary.isJ9RequestedViaVendor(spec);
    }

    private static boolean isJ9ExplicitlyRequested(JavaToolchainSpec spec) {
        return spec.getImplementation().get() == JvmImplementation.J9;
    }

    private static boolean isJ9RequestedViaVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        return vendorSpec != DefaultJvmVendorSpec.any() && vendorSpec.test(JvmVendor.KnownJvmVendor.IBM.asJvmVendor());
    }
}

