/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.util.internal.VersionNumber;

public interface VisualStudioTargetBinary {
    @Input
    public String getProjectPath();

    @Input
    public String getComponentName();

    @Input
    public String getVisualStudioProjectName();

    @Input
    public String getVisualStudioConfigurationName();

    @Internal
    public VersionNumber getVisualStudioVersion();

    @Internal
    public VersionNumber getSdkVersion();

    @Input
    public ProjectType getProjectType();

    @Input
    public List<String> getVariantDimensions();

    @Internal
    public FileCollection getSourceFiles();

    @Internal
    public FileCollection getResourceFiles();

    @Internal
    public FileCollection getHeaderFiles();

    @Input
    public boolean isExecutable();

    @Input
    public String getBuildTaskPath();

    @Input
    public String getCleanTaskPath();

    @Input
    public boolean isDebuggable();

    @Internal
    public File getOutputFile();

    @Input
    public List<String> getCompilerDefines();

    @Input
    public LanguageStandard getLanguageStandard();

    @Internal
    public Set<File> getIncludePaths();

    public static enum LanguageStandard {
        NONE(""),
        STD_CPP_14("stdcpp14"),
        STD_CPP_17("stdcpp17"),
        STD_CPP_LATEST("stdcpplatest");

        private final String value;

        private LanguageStandard(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LanguageStandard from(List<String> arguments) {
            return arguments.stream().filter(it -> it.matches("^[-/]std:c\\+\\+.+")).findFirst().map(it -> {
                if (it.endsWith("++14")) {
                    return STD_CPP_14;
                }
                if (it.endsWith("++17")) {
                    return STD_CPP_17;
                }
                if (it.endsWith("++latest")) {
                    return STD_CPP_LATEST;
                }
                return NONE;
            }).orElse(NONE);
        }
    }

    public static enum ProjectType {
        EXE("Exe"),
        LIB("Lib"),
        DLL("Dll"),
        NONE("");

        private final String suffix;

        private ProjectType(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

