/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactSelectionDetails;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.LockMode;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.dsl.dependencies.LockEntryFilter;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.locking.DefaultDependencyLockingState;
import org.gradle.internal.locking.DependencyLockingNotationConverter;
import org.gradle.internal.locking.InvalidLockFileException;
import org.gradle.internal.locking.LockEntryFilterFactory;
import org.gradle.internal.locking.LockFileReaderWriter;
import org.gradle.internal.locking.MissingLockStateException;
import org.gradle.internal.resource.local.FileResourceListener;

public class DefaultDependencyLockingProvider
implements DependencyLockingProvider {
    private static final Logger LOGGER = Logging.getLogger(DefaultDependencyLockingProvider.class);
    private static final DocumentationRegistry DOC_REG = new DocumentationRegistry();
    private final DependencyLockingNotationConverter converter = new DependencyLockingNotationConverter();
    private final LockFileReaderWriter lockFileReaderWriter;
    private final boolean writeLocks;
    private final boolean partialUpdate;
    private final LockEntryFilter updateLockEntryFilter;
    private final DomainObjectContext context;
    private final DependencySubstitutionRules dependencySubstitutionRules;
    private final Property<LockMode> lockMode;
    private final RegularFileProperty lockFile;
    private final ListProperty<String> ignoredDependencies;
    private boolean uniqueLockStateLoaded;
    private Map<String, List<String>> allLockState;
    private LockEntryFilter compoundLockEntryFilter;
    private LockEntryFilter ignoredEntryFilter;

    public DefaultDependencyLockingProvider(FileResolver fileResolver, StartParameter startParameter, DomainObjectContext context, DependencySubstitutionRules dependencySubstitutionRules, PropertyFactory propertyFactory, FilePropertyFactory filePropertyFactory, FileResourceListener listener) {
        List lockedDependenciesToUpdate;
        this.context = context;
        this.dependencySubstitutionRules = dependencySubstitutionRules;
        this.writeLocks = startParameter.isWriteDependencyLocks();
        if (this.writeLocks) {
            LOGGER.debug("Write locks is enabled");
        }
        this.partialUpdate = !(lockedDependenciesToUpdate = startParameter.getLockedDependenciesToUpdate()).isEmpty();
        this.updateLockEntryFilter = LockEntryFilterFactory.forParameter(lockedDependenciesToUpdate, "Update lock", true);
        this.lockMode = propertyFactory.property(LockMode.class);
        this.lockMode.convention((Object)LockMode.DEFAULT);
        this.lockFile = filePropertyFactory.newFileProperty();
        this.ignoredDependencies = propertyFactory.listProperty(String.class);
        this.lockFileReaderWriter = new LockFileReaderWriter(fileResolver, context, this.lockFile, listener);
    }

    private static ComponentSelector toComponentSelector(ModuleComponentIdentifier lockIdentifier) {
        String lockedVersion = lockIdentifier.getVersion();
        DefaultMutableVersionConstraint versionConstraint = DefaultMutableVersionConstraint.withVersion(lockedVersion);
        return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(lockIdentifier.getGroup(), lockIdentifier.getModule()), versionConstraint);
    }

    @Override
    public DependencyLockingState loadLockState(String configurationName) {
        this.recordUsage();
        this.loadLockState();
        if (!this.writeLocks || this.partialUpdate) {
            List<String> lockedModules = this.findLockedModules(configurationName);
            if (lockedModules == null && this.lockMode.get() == LockMode.STRICT) {
                throw new MissingLockStateException(this.context.identityPath(configurationName).toString());
            }
            if (lockedModules != null) {
                HashSet results = Sets.newHashSetWithExpectedSize((int)lockedModules.size());
                for (String module : lockedModules) {
                    ModuleComponentIdentifier lockedIdentifier = this.parseLockNotation(configurationName, module);
                    if (this.getCompoundLockEntryFilter().isSatisfiedBy(lockedIdentifier) || this.isSubstitutedInComposite(lockedIdentifier)) continue;
                    results.add(lockedIdentifier);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Loaded lock state for configuration '{}', state is: {}", (Object)this.context.identityPath(configurationName), lockedModules);
                } else {
                    LOGGER.info("Loaded lock state for configuration '{}'", (Object)this.context.identityPath(configurationName));
                }
                boolean strictlyValidate = !this.partialUpdate && this.lockMode.get() != LockMode.LENIENT;
                return new DefaultDependencyLockingState(strictlyValidate, results, this.getIgnoredEntryFilter());
            }
        }
        return DefaultDependencyLockingState.EMPTY_LOCK_CONSTRAINT;
    }

    private LockEntryFilter getCompoundLockEntryFilter() {
        if (this.compoundLockEntryFilter == null) {
            this.compoundLockEntryFilter = LockEntryFilterFactory.combine(this.getIgnoredEntryFilter(), this.updateLockEntryFilter);
        }
        return this.compoundLockEntryFilter;
    }

    private LockEntryFilter getIgnoredEntryFilter() {
        if (this.ignoredEntryFilter == null) {
            this.ignoredEntryFilter = LockEntryFilterFactory.forParameter((List)this.ignoredDependencies.getOrElse(Collections.emptyList()), "Ignored dependencies", false);
        }
        return this.ignoredEntryFilter;
    }

    @Nullable
    private List<String> findLockedModules(String configurationName) {
        List<String> result = this.allLockState.get(configurationName);
        if (result == null) {
            result = this.lockFileReaderWriter.readLockFile(configurationName);
        }
        return result;
    }

    private synchronized void loadLockState() {
        if (!this.uniqueLockStateLoaded) {
            try {
                this.allLockState = this.lockFileReaderWriter.readUniqueLockFile();
                this.uniqueLockStateLoaded = true;
            }
            catch (IllegalStateException e) {
                throw new InvalidLockFileException("project '" + this.context.getProjectPath().getPath() + "'", e);
            }
        }
    }

    private void recordUsage() {
        this.lockMode.finalizeValue();
        this.lockFile.finalizeValue();
        this.ignoredDependencies.finalizeValue();
    }

    private boolean isSubstitutedInComposite(ModuleComponentIdentifier lockedIdentifier) {
        if (this.dependencySubstitutionRules.rulesMayAddProjectDependency()) {
            LockingDependencySubstitution lockingDependencySubstitution = new LockingDependencySubstitution(DefaultDependencyLockingProvider.toComponentSelector(lockedIdentifier));
            this.dependencySubstitutionRules.getRuleAction().execute((Object)lockingDependencySubstitution);
            return lockingDependencySubstitution.didSubstitute();
        }
        return false;
    }

    private ModuleComponentIdentifier parseLockNotation(String configurationName, String module) {
        ModuleComponentIdentifier lockedIdentifier;
        try {
            lockedIdentifier = this.converter.convertFromLockNotation(module);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLockFileException("configuration '" + this.context.identityPath(configurationName).getPath() + "'", e);
        }
        return lockedIdentifier;
    }

    @Override
    public void persistResolvedDependencies(String configurationName, Set<ModuleComponentIdentifier> resolvedModules, Set<ModuleComponentIdentifier> changingResolvedModules) {
        if (this.writeLocks) {
            List<String> modulesOrdered = this.getModulesOrdered(resolvedModules);
            if (!changingResolvedModules.isEmpty()) {
                LOGGER.warn("Dependency lock state for configuration '{}' contains changing modules: {}. This means that dependencies content may still change over time. See {} for details.", new Object[]{this.context.identityPath(configurationName), this.getModulesOrdered(changingResolvedModules), DOC_REG.getDocumentationFor("dependency_locking")});
            }
            this.allLockState.put(configurationName, modulesOrdered);
        }
    }

    @Override
    public void buildFinished() {
        if (this.uniqueLockStateLoaded && this.lockFileReaderWriter.canWrite()) {
            this.lockFileReaderWriter.writeUniqueLockfile(this.allLockState);
            if (this.context.isScript()) {
                LOGGER.lifecycle("Persisted dependency lock state for buildscript of project '{}'", new Object[]{this.context.getProjectPath()});
            } else {
                LOGGER.lifecycle("Persisted dependency lock state for project '{}'", new Object[]{this.context.getProjectPath()});
            }
        }
    }

    private List<String> getModulesOrdered(Collection<ModuleComponentIdentifier> resolvedComponents) {
        ArrayList modules = Lists.newArrayListWithCapacity((int)resolvedComponents.size());
        for (ModuleComponentIdentifier identifier : resolvedComponents) {
            if (this.getIgnoredEntryFilter().isSatisfiedBy(identifier)) continue;
            modules.add(this.converter.convertToLockNotation(identifier));
        }
        Collections.sort(modules);
        return modules;
    }

    @Override
    public Property<LockMode> getLockMode() {
        return this.lockMode;
    }

    @Override
    public RegularFileProperty getLockFile() {
        return this.lockFile;
    }

    @Override
    public ListProperty<String> getIgnoredDependencies() {
        return this.ignoredDependencies;
    }

    @Override
    public void confirmConfigurationNotLocked(String configurationName) {
        if (this.writeLocks) {
            this.loadLockState();
            this.allLockState.remove(configurationName);
        }
    }

    private static class LockingDependencySubstitution
    implements DependencySubstitutionInternal {
        private final ComponentSelector selector;
        private boolean didSubstitute = false;

        private LockingDependencySubstitution(ComponentSelector selector) {
            this.selector = selector;
        }

        public ComponentSelector getRequested() {
            return this.selector;
        }

        public void useTarget(Object notation) {
            this.didSubstitute = true;
        }

        public void useTarget(Object notation, String reason) {
            this.didSubstitute = true;
        }

        public void artifactSelection(Action<? super ArtifactSelectionDetails> action) {
            throw new UnsupportedOperationException();
        }

        boolean didSubstitute() {
            return this.didSubstitute;
        }

        @Override
        public void useTarget(Object notation, ComponentSelectionDescriptor ruleDescriptor) {
            this.didSubstitute = true;
        }

        @Override
        public ComponentSelector getTarget() {
            return this.selector;
        }

        @Override
        public List<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
            return Collections.emptyList();
        }

        @Override
        public boolean isUpdated() {
            return false;
        }

        @Override
        public ArtifactSelectionDetailsInternal getArtifactSelectionDetails() {
            return new NoOpArtifactSelectionDetails();
        }

        private static class NoOpArtifactSelectionDetails
        implements ArtifactSelectionDetailsInternal {
            private NoOpArtifactSelectionDetails() {
            }

            @Override
            public boolean isUpdated() {
                return false;
            }

            @Override
            public List<DependencyArtifactSelector> getTargetSelectors() {
                return Collections.emptyList();
            }

            public boolean hasSelectors() {
                return false;
            }

            public List<DependencyArtifactSelector> getRequestedSelectors() {
                return Collections.emptyList();
            }

            public void withoutArtifactSelectors() {
            }

            public void selectArtifact(String type, @Nullable String extension, @Nullable String classifier) {
            }

            public void selectArtifact(DependencyArtifactSelector selector) {
            }
        }
    }
}

