/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClassSetAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.cache.Cache;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.vfs.FileSystemAccess;

public class CachingClassSetAnalyzer
implements ClassSetAnalyzer {
    private final ClassSetAnalyzer delegate;
    private final FileSystemAccess fileSystemAccess;
    private final Cache<HashCode, ClassSetAnalysisData> cache;

    public CachingClassSetAnalyzer(ClassSetAnalyzer delegate, FileSystemAccess fileSystemAccess, Cache<HashCode, ClassSetAnalysisData> cache) {
        this.delegate = delegate;
        this.fileSystemAccess = fileSystemAccess;
        this.cache = cache;
    }

    @Override
    public ClassSetAnalysisData analyzeClasspathEntry(File classpathEntry) {
        return (ClassSetAnalysisData)this.fileSystemAccess.read(classpathEntry.getAbsolutePath(), snapshot -> (ClassSetAnalysisData)this.cache.get((Object)snapshot.getHash(), hash -> this.delegate.analyzeClasspathEntry(classpathEntry)));
    }

    @Override
    public ClassSetAnalysisData analyzeOutputFolder(File outputFolder) {
        return this.delegate.analyzeOutputFolder(outputFolder);
    }
}

