/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;

public class BiProvider<R, A, B>
extends AbstractMinimalProvider<R> {
    private final Class<R> type;
    private final BiFunction<? super A, ? super B, ? extends R> combiner;
    private final ProviderInternal<A> left;
    private final ProviderInternal<B> right;

    public BiProvider(@Nullable Class<R> type, Provider<A> left, Provider<B> right, BiFunction<? super A, ? super B, ? extends R> combiner) {
        this.type = type;
        this.combiner = combiner;
        this.left = Providers.internal(left);
        this.right = Providers.internal(right);
    }

    @Override
    public String toString() {
        return String.format("and(%s, %s)", this.left, this.right);
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        if (!this.left.calculatePresence(consumer) || !this.right.calculatePresence(consumer)) {
            return false;
        }
        return super.calculatePresence(consumer);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends R> calculateExecutionTimeValue() {
        return this.isChangingValue(this.left) || this.isChangingValue(this.right) ? ValueSupplier.ExecutionTimeValue.changingValue(this) : super.calculateExecutionTimeValue();
    }

    private boolean isChangingValue(ProviderInternal<?> provider) {
        return provider.calculateExecutionTimeValue().isChangingValue();
    }

    @Override
    protected ValueSupplier.Value<? extends R> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<A> leftValue = this.left.calculateValue(consumer);
        if (leftValue.isMissing()) {
            return leftValue.asType();
        }
        ValueSupplier.Value<B> rightValue = this.right.calculateValue(consumer);
        if (rightValue.isMissing()) {
            return rightValue.asType();
        }
        R combinedUnpackedValue = this.combiner.apply(leftValue.getWithoutSideEffect(), rightValue.getWithoutSideEffect());
        return ValueSupplier.Value.ofNullable(combinedUnpackedValue).withSideEffect(ValueSupplier.SideEffect.fixedFrom(leftValue)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(rightValue));
    }

    @Override
    @Nullable
    public Class<R> getType() {
        return this.type;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new ValueSupplier.PlusProducer(this.left.getProducer(), this.right.getProducer());
    }
}

