/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.scope.refresh;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.runtime.context.scope.refresh.RefreshScope;
import jakarta.inject.Singleton;
import java.util.concurrent.locks.Lock;

@Singleton
@Requires(notEnv={"function", "android"})
public class RefreshInterceptor
implements MethodInterceptor {
    private final RefreshScope refreshScope;

    public RefreshInterceptor(RefreshScope refreshScope) {
        this.refreshScope = refreshScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object intercept(MethodInvocationContext context) {
        Object target = context.getTarget();
        Lock lock = this.refreshScope.getLock(target).readLock();
        try {
            lock.lock();
            Object object = context.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

