/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.util.logging.OutputController;

public class HTMLPanel
extends JPanel {
    protected JEditorPane pane = new JEditorPane();

    public HTMLPanel(URL url) {
        super(new BorderLayout());
        try {
            this.pane = new JEditorPane(url);
        }
        catch (IOException ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, ex);
        }
        this.pane.setContentType("text/html");
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(new UrlHyperlinkListener());
        JScrollPane scroller = new JScrollPane(this.pane);
        this.add((Component)scroller, "Center");
    }

    private class UrlHyperlinkListener
    implements HyperlinkListener {
        private UrlHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (Desktop.isDesktopSupported() && event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

