/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.util.ArrayList;

public class DirectoryNode {
    private String name;
    private File path;
    private ArrayList<DirectoryNode> childNodes;
    private DirectoryNode parent = null;
    private File infoFile;

    public DirectoryNode(String name, String absPathToNode, DirectoryNode parent) {
        this(name, new File(absPathToNode), parent);
    }

    public DirectoryNode(String name, File absPathToNode, DirectoryNode parent) {
        this(name, absPathToNode, null, parent);
    }

    public DirectoryNode(String name, File absPathToNode, ArrayList<DirectoryNode> childNodes, DirectoryNode parent) {
        this.name = name;
        this.path = absPathToNode;
        this.childNodes = childNodes;
        if (this.childNodes == null) {
            this.childNodes = new ArrayList();
        }
        this.parent = parent;
        if (!this.isDir()) {
            this.infoFile = new File(this.getFile().getAbsolutePath().concat(".info"));
        }
    }

    public void addChild(DirectoryNode node) {
        try {
            this.childNodes.add(node);
        }
        catch (NullPointerException e) {
            this.childNodes = new ArrayList();
            this.childNodes.add(node);
        }
    }

    public boolean removeChild(DirectoryNode node) {
        return this.childNodes.remove(node);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public File getFile() {
        return this.path;
    }

    public DirectoryNode getParent() {
        return this.parent;
    }

    public ArrayList<DirectoryNode> getChildren() {
        return this.childNodes;
    }

    public boolean isDir() {
        return this.path.isDirectory();
    }

    public File getInfoFile() {
        return this.infoFile;
    }
}

