/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.browser.LinkingBrowser;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogresults.BasicDialogValue;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.YesCancelSkip;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.util.logging.OutputController;

public class InetSecurity511Panel
extends SecurityDialogPanel {
    private static final String INFO_LINK = "https://tools.ietf.org/html/rfc6585#section-6";
    private static boolean skip = false;
    private final LinkingBrowser tabes;

    public static boolean isSkip() {
        return skip;
    }

    public InetSecurity511Panel(final SecurityDialog sd, URL url) {
        super(sd);
        if (sd != null) {
            sd.setValue(YesCancelSkip.yes());
        }
        this.tabes = new LinkingBrowser(url, false);
        this.add(this.tabes);
        JPanel menu = new JPanel();
        JButton done = new JButton(Translator.R("ButDone"));
        done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sd != null) {
                    sd.setValue(YesCancelSkip.yes());
                    InetSecurity511Panel.this.parent.getViwableDialog().dispose();
                }
            }
        });
        JButton noExit = new JButton(Translator.R("Exit511"));
        noExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sd != null) {
                    sd.setValue(YesCancelSkip.cancel());
                    InetSecurity511Panel.this.parent.getViwableDialog().dispose();
                }
            }
        });
        menu.add(done);
        menu.add(noExit);
        final JCheckBox ignoreInSession = new JCheckBox(Translator.R("Ignore511"));
        ignoreInSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                skip = ignoreInSession.isSelected();
            }
        });
        menu.add(ignoreInSession);
        this.add((Component)menu, "South");
        JLabel title = new JLabel(InetSecurity511Panel.htmlWrap(Translator.R("Header511", INFO_LINK)));
        title.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block5: {
                    if (e.getClickCount() == 1) {
                        InetSecurity511Panel.this.tabes.getBrowser().gotoUrl(InetSecurity511Panel.INFO_LINK);
                    } else if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(InetSecurity511Panel.INFO_LINK));
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                            if (JNLPRuntime.isHeadless()) break block5;
                            JOptionPane.showMessageDialog(null, ex);
                        }
                    }
                }
            }
        });
        this.add((Component)title, "North");
        if (sd != null) {
            sd.getViwableDialog().pack();
        }
    }

    @Override
    public DialogResult getDefaultNegativeAnswer() {
        return YesCancelSkip.cancel();
    }

    @Override
    public DialogResult getDefaultPositiveAnswer() {
        return YesCancelSkip.yes();
    }

    @Override
    public DialogResult readFromStdIn(String what) {
        YesCancelSkip l = YesCancelSkip.readValue(what);
        if (l.compareValue(BasicDialogValue.Primitive.SKIP)) {
            skip = true;
            l = YesCancelSkip.yes();
        }
        return l;
    }

    @Override
    public String helpToStdIn() {
        return YesCancelSkip.yes().getAllowedValues().toString();
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(Translator.R("Headless511line0")).append("\n");
        List<String> usrls = this.tabes.getLinksPanel().getAllUrls();
        for (String usrl : usrls) {
            sb.append(usrl).append("\n");
        }
        sb.append(super.getText()).append("\n");
        sb.append(Translator.R("Headless511line1")).append("\n");
        sb.append(Translator.R("Headless511line2")).append("\n");
        sb.append(Translator.R("Headless511line3", OptionsDefinitions.OPTIONS.BROWSER.option)).append("\n");
        return sb.toString();
    }
}

