/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.management.jdp.JdpGenericPacket;

public final class JdpPacketWriter {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final DataOutputStream pkt = new DataOutputStream(this.baos);

    public JdpPacketWriter() throws IOException {
        this.pkt.writeInt(JdpGenericPacket.getMagic());
        this.pkt.writeShort(JdpGenericPacket.getVersion());
    }

    public void addEntry(String entry) throws IOException {
        this.pkt.writeUTF(entry);
    }

    public void addEntry(String key, String val) throws IOException {
        if (val != null) {
            this.addEntry(key);
            this.addEntry(val);
        }
    }

    public byte[] getPacketBytes() {
        return this.baos.toByteArray();
    }
}

