/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.ClassFileAssembler;
import sun.reflect.ClassFileConstants;

class AccessorGenerator
implements ClassFileConstants {
    static final Unsafe unsafe = Unsafe.getUnsafe();
    protected static final short S0 = 0;
    protected static final short S1 = 1;
    protected static final short S2 = 2;
    protected static final short S3 = 3;
    protected static final short S4 = 4;
    protected static final short S5 = 5;
    protected static final short S6 = 6;
    protected ClassFileAssembler asm;
    protected int modifiers;
    protected short thisClass;
    protected short superClass;
    protected short targetClass;
    protected short throwableClass;
    protected short classCastClass;
    protected short nullPointerClass;
    protected short illegalArgumentClass;
    protected short invocationTargetClass;
    protected short initIdx;
    protected short initNameAndTypeIdx;
    protected short initStringNameAndTypeIdx;
    protected short nullPointerCtorIdx;
    protected short illegalArgumentCtorIdx;
    protected short illegalArgumentStringCtorIdx;
    protected short invocationTargetCtorIdx;
    protected short superCtorIdx;
    protected short objectClass;
    protected short toStringIdx;
    protected short codeIdx;
    protected short exceptionsIdx;
    protected short booleanIdx;
    protected short booleanCtorIdx;
    protected short booleanUnboxIdx;
    protected short byteIdx;
    protected short byteCtorIdx;
    protected short byteUnboxIdx;
    protected short characterIdx;
    protected short characterCtorIdx;
    protected short characterUnboxIdx;
    protected short doubleIdx;
    protected short doubleCtorIdx;
    protected short doubleUnboxIdx;
    protected short floatIdx;
    protected short floatCtorIdx;
    protected short floatUnboxIdx;
    protected short integerIdx;
    protected short integerCtorIdx;
    protected short integerUnboxIdx;
    protected short longIdx;
    protected short longCtorIdx;
    protected short longUnboxIdx;
    protected short shortIdx;
    protected short shortCtorIdx;
    protected short shortUnboxIdx;
    protected final short NUM_COMMON_CPOOL_ENTRIES = (short)30;
    protected final short NUM_BOXING_CPOOL_ENTRIES = (short)72;
    protected static final Class<?>[] primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private ClassFileAssembler illegalArgumentCodeBuffer;

    AccessorGenerator() {
    }

    protected void emitCommonConstantPoolEntries() {
        this.asm.emitConstantPoolUTF8("java/lang/Throwable");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.throwableClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/ClassCastException");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.classCastClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/NullPointerException");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.nullPointerClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/IllegalArgumentException");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.illegalArgumentClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/reflect/InvocationTargetException");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.invocationTargetClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("<init>");
        this.initIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("()V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.initNameAndTypeIdx = this.asm.cpi();
        this.asm.emitConstantPoolMethodref(this.nullPointerClass, this.initNameAndTypeIdx);
        this.nullPointerCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolMethodref(this.illegalArgumentClass, this.initNameAndTypeIdx);
        this.illegalArgumentCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/String;)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.initStringNameAndTypeIdx = this.asm.cpi();
        this.asm.emitConstantPoolMethodref(this.illegalArgumentClass, this.initStringNameAndTypeIdx);
        this.illegalArgumentStringCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Throwable;)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(this.invocationTargetClass, this.asm.cpi());
        this.invocationTargetCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolMethodref(this.superClass, this.initNameAndTypeIdx);
        this.superCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Object");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.objectClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("toString");
        this.asm.emitConstantPoolUTF8("()Ljava/lang/String;");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(this.objectClass, this.asm.cpi());
        this.toStringIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("Code");
        this.codeIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("Exceptions");
        this.exceptionsIdx = this.asm.cpi();
    }

    protected void emitBoxingContantPoolEntries() {
        this.asm.emitConstantPoolUTF8("java/lang/Boolean");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.booleanIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Z)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.booleanCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("booleanValue");
        this.asm.emitConstantPoolUTF8("()Z");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.booleanUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Byte");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.byteIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(B)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.byteCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("byteValue");
        this.asm.emitConstantPoolUTF8("()B");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.byteUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Character");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.characterIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(C)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.characterCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("charValue");
        this.asm.emitConstantPoolUTF8("()C");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.characterUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Double");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.doubleIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(D)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.doubleCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("doubleValue");
        this.asm.emitConstantPoolUTF8("()D");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.doubleUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Float");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.floatIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(F)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.floatCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("floatValue");
        this.asm.emitConstantPoolUTF8("()F");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.floatUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Integer");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.integerIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(I)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.integerCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("intValue");
        this.asm.emitConstantPoolUTF8("()I");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.integerUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Long");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.longIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(J)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.longCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("longValue");
        this.asm.emitConstantPoolUTF8("()J");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.longUnboxIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("java/lang/Short");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.shortIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(S)V");
        this.asm.emitConstantPoolNameAndType(this.initIdx, this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)2), this.asm.cpi());
        this.shortCtorIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("shortValue");
        this.asm.emitConstantPoolUTF8("()S");
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolMethodref(AccessorGenerator.sub(this.asm.cpi(), (short)6), this.asm.cpi());
        this.shortUnboxIdx = this.asm.cpi();
    }

    protected static short add(short s1, short s2) {
        return (short)(s1 + s2);
    }

    protected static short sub(short s1, short s2) {
        return (short)(s1 - s2);
    }

    protected boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    protected static String getClassName(Class<?> c, boolean addPrefixAndSuffixForNonPrimitiveTypes) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new InternalError("Should have found primitive type");
        }
        if (c.isArray()) {
            return "[" + AccessorGenerator.getClassName(c.getComponentType(), true);
        }
        if (addPrefixAndSuffixForNonPrimitiveTypes) {
            return AccessorGenerator.internalize("L" + c.getName() + ";");
        }
        return AccessorGenerator.internalize(c.getName());
    }

    private static String internalize(String className) {
        return className.replace('.', '/');
    }

    protected void emitConstructor() {
        ClassFileAssembler cb = new ClassFileAssembler();
        cb.setMaxLocals(1);
        cb.opc_aload_0();
        cb.opc_invokespecial(this.superCtorIdx, 0, 0);
        cb.opc_return();
        this.emitMethod(this.initIdx, cb.getMaxLocals(), cb, null, null);
    }

    protected void emitMethod(short nameIdx, int numArgs, ClassFileAssembler code, ClassFileAssembler exceptionTable, short[] checkedExceptionIndices) {
        short codeLen = code.getLength();
        int excLen = 0;
        if (exceptionTable != null && (excLen = exceptionTable.getLength()) % 8 != 0) {
            throw new IllegalArgumentException("Illegal exception table");
        }
        int attrLen = 12 + codeLen + excLen;
        excLen /= 8;
        this.asm.emitShort((short)1);
        this.asm.emitShort(nameIdx);
        this.asm.emitShort(AccessorGenerator.add(nameIdx, (short)1));
        if (checkedExceptionIndices == null) {
            this.asm.emitShort((short)1);
        } else {
            this.asm.emitShort((short)2);
        }
        this.asm.emitShort(this.codeIdx);
        this.asm.emitInt(attrLen);
        this.asm.emitShort(code.getMaxStack());
        this.asm.emitShort((short)Math.max(numArgs, code.getMaxLocals()));
        this.asm.emitInt(codeLen);
        this.asm.append(code);
        this.asm.emitShort((short)excLen);
        if (exceptionTable != null) {
            this.asm.append(exceptionTable);
        }
        this.asm.emitShort((short)0);
        if (checkedExceptionIndices != null) {
            this.asm.emitShort(this.exceptionsIdx);
            this.asm.emitInt(2 + 2 * checkedExceptionIndices.length);
            this.asm.emitShort((short)checkedExceptionIndices.length);
            for (int i = 0; i < checkedExceptionIndices.length; ++i) {
                this.asm.emitShort(checkedExceptionIndices[i]);
            }
        }
    }

    protected short indexForPrimitiveType(Class<?> type) {
        if (type == Boolean.TYPE) {
            return this.booleanIdx;
        }
        if (type == Byte.TYPE) {
            return this.byteIdx;
        }
        if (type == Character.TYPE) {
            return this.characterIdx;
        }
        if (type == Double.TYPE) {
            return this.doubleIdx;
        }
        if (type == Float.TYPE) {
            return this.floatIdx;
        }
        if (type == Integer.TYPE) {
            return this.integerIdx;
        }
        if (type == Long.TYPE) {
            return this.longIdx;
        }
        if (type == Short.TYPE) {
            return this.shortIdx;
        }
        throw new InternalError("Should have found primitive type");
    }

    protected short ctorIndexForPrimitiveType(Class<?> type) {
        if (type == Boolean.TYPE) {
            return this.booleanCtorIdx;
        }
        if (type == Byte.TYPE) {
            return this.byteCtorIdx;
        }
        if (type == Character.TYPE) {
            return this.characterCtorIdx;
        }
        if (type == Double.TYPE) {
            return this.doubleCtorIdx;
        }
        if (type == Float.TYPE) {
            return this.floatCtorIdx;
        }
        if (type == Integer.TYPE) {
            return this.integerCtorIdx;
        }
        if (type == Long.TYPE) {
            return this.longCtorIdx;
        }
        if (type == Short.TYPE) {
            return this.shortCtorIdx;
        }
        throw new InternalError("Should have found primitive type");
    }

    protected static boolean canWidenTo(Class<?> type, Class<?> otherType) {
        if (!type.isPrimitive()) {
            return false;
        }
        return type == Boolean.TYPE ? otherType == Boolean.TYPE : (type == Byte.TYPE ? otherType == Byte.TYPE || otherType == Short.TYPE || otherType == Integer.TYPE || otherType == Long.TYPE || otherType == Float.TYPE || otherType == Double.TYPE : (type == Short.TYPE ? otherType == Short.TYPE || otherType == Integer.TYPE || otherType == Long.TYPE || otherType == Float.TYPE || otherType == Double.TYPE : (type == Character.TYPE ? otherType == Character.TYPE || otherType == Integer.TYPE || otherType == Long.TYPE || otherType == Float.TYPE || otherType == Double.TYPE : (type == Integer.TYPE ? otherType == Integer.TYPE || otherType == Long.TYPE || otherType == Float.TYPE || otherType == Double.TYPE : (type == Long.TYPE ? otherType == Long.TYPE || otherType == Float.TYPE || otherType == Double.TYPE : (type == Float.TYPE ? otherType == Float.TYPE || otherType == Double.TYPE : type == Double.TYPE && otherType == Double.TYPE))))));
    }

    protected static void emitWideningBytecodeForPrimitiveConversion(ClassFileAssembler cb, Class<?> fromType, Class<?> toType) {
        if (fromType == Byte.TYPE || fromType == Short.TYPE || fromType == Character.TYPE || fromType == Integer.TYPE) {
            if (toType == Long.TYPE) {
                cb.opc_i2l();
            } else if (toType == Float.TYPE) {
                cb.opc_i2f();
            } else if (toType == Double.TYPE) {
                cb.opc_i2d();
            }
        } else if (fromType == Long.TYPE) {
            if (toType == Float.TYPE) {
                cb.opc_l2f();
            } else if (toType == Double.TYPE) {
                cb.opc_l2d();
            }
        } else if (fromType == Float.TYPE && toType == Double.TYPE) {
            cb.opc_f2d();
        }
    }

    protected short unboxingMethodForPrimitiveType(Class<?> primType) {
        if (primType == Boolean.TYPE) {
            return this.booleanUnboxIdx;
        }
        if (primType == Byte.TYPE) {
            return this.byteUnboxIdx;
        }
        if (primType == Character.TYPE) {
            return this.characterUnboxIdx;
        }
        if (primType == Short.TYPE) {
            return this.shortUnboxIdx;
        }
        if (primType == Integer.TYPE) {
            return this.integerUnboxIdx;
        }
        if (primType == Long.TYPE) {
            return this.longUnboxIdx;
        }
        if (primType == Float.TYPE) {
            return this.floatUnboxIdx;
        }
        if (primType == Double.TYPE) {
            return this.doubleUnboxIdx;
        }
        throw new InternalError("Illegal primitive type " + primType.getName());
    }

    protected static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() && c != Void.TYPE;
    }

    protected int typeSizeInStackSlots(Class<?> c) {
        if (c == Void.TYPE) {
            return 0;
        }
        if (c == Long.TYPE || c == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    protected ClassFileAssembler illegalArgumentCodeBuffer() {
        if (this.illegalArgumentCodeBuffer == null) {
            this.illegalArgumentCodeBuffer = new ClassFileAssembler();
            this.illegalArgumentCodeBuffer.opc_new(this.illegalArgumentClass);
            this.illegalArgumentCodeBuffer.opc_dup();
            this.illegalArgumentCodeBuffer.opc_invokespecial(this.illegalArgumentCtorIdx, 0, 0);
            this.illegalArgumentCodeBuffer.opc_athrow();
        }
        return this.illegalArgumentCodeBuffer;
    }
}

