/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.variable.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

abstract class AbstractVariable
implements BiVariable {
    protected final IRubyObject receiver;
    protected final String name;
    protected Object javaObject = null;
    protected Class javaType = null;
    protected IRubyObject rubyObject = null;
    protected boolean fromRuby;

    protected AbstractVariable(IRubyObject receiver2, String name2, boolean fromRuby) {
        this.receiver = receiver2;
        this.name = name2;
        this.fromRuby = fromRuby;
    }

    protected AbstractVariable(IRubyObject receiver2, String name2, boolean fromRuby, IRubyObject rubyObject) {
        this.receiver = receiver2;
        this.name = name2;
        this.fromRuby = fromRuby;
        this.rubyObject = rubyObject;
    }

    final Ruby getRuntime() {
        return this.receiver.getRuntime();
    }

    final ThreadContext getCurrentContext() {
        return this.getRuntime().getCurrentContext();
    }

    final RubyObject getTopSelf() {
        return AbstractVariable.getTopSelf(this.receiver);
    }

    static RubyObject getTopSelf(IRubyObject receiver2) {
        return (RubyObject)receiver2.getRuntime().getTopSelf();
    }

    protected void updateByJavaObject(Ruby runtime2, Object ... values2) {
        assert (values2 != null);
        this.javaObject = values2[0];
        this.javaType = this.javaObject == null ? null : (values2.length > 1 ? (Class)values2[1] : this.javaObject.getClass());
        this.rubyObject = JavaEmbedUtils.javaToRuby(runtime2, this.javaObject);
        this.fromRuby = false;
    }

    protected void updateRubyObject(IRubyObject rubyObject) {
        if (rubyObject == null) {
            return;
        }
        this.rubyObject = rubyObject;
        this.javaType = null;
    }

    @Override
    public IRubyObject getReceiver() {
        return this.receiver;
    }

    @Override
    public boolean isReceiverIdentical(RubyObject receiver2) {
        return this.getReceiver().equals(receiver2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getJavaObject() {
        if (this.rubyObject == null) {
            return this.javaObject;
        }
        if (this.javaType != null) {
            this.javaObject = this.javaType.cast(this.rubyObject.toJava(this.javaType));
        } else {
            this.javaObject = this.rubyObject.toJava(Object.class);
            if (this.javaObject != null) {
                this.javaType = this.javaObject.getClass();
            }
        }
        return this.javaObject;
    }

    @Override
    public void setJavaObject(Ruby runtime2, Object javaObject) {
        this.updateByJavaObject(runtime2, javaObject);
    }

    @Override
    public IRubyObject getRubyObject() {
        return this.rubyObject;
    }

    @Override
    public void setRubyObject(IRubyObject rubyObject) {
        this.updateRubyObject(rubyObject);
    }

    protected static RubyModule getRubyClass(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        StaticScope scope = context.getCurrentStaticScope();
        RubyModule rubyClass = scope.getModule();
        return rubyClass;
    }

    protected static boolean isValidName(String pattern, Object name2) {
        if (!(name2 instanceof String)) {
            return false;
        }
        return ((String)name2).matches(pattern);
    }
}

