/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.impl.base.util.LibraryUtils;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtStaticProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtLibraryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleProviderBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtScriptModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSdkModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSourceModuleBuilder;
import org.jetbrains.kotlin.analyzer.common.CommonPlatformAnalyzerServices;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.resolve.konan.platform.NativePlatformAnalyzerServices;
import org.jetbrains.kotlin.wasm.resolve.WasmPlatformAnalyzerServices;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a1\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0007\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0080\b\u001a \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0000\u00a8\u0006\u001c"}, d2={"buildKtModuleProviderByCompilerConfiguration", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtStaticProjectStructureProvider;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectSourceFilePaths", "", "root", "Ljava/nio/file/Path;", "result", "", "", "getPsiFilesFromPaths", "T", "Lcom/intellij/psi/PsiFileSystemItem;", "paths", "", "getSourceFilePaths", "", "includeDirectoryRoot", "", "getAnalyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analysis-api-standalone"})
@SourceDebugExtension(value={"SMAP\nKtModuleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtModuleUtils.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KtModuleUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtModuleProviderBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleProviderBuilderKt\n+ 5 KtScriptModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtScriptModuleBuilderKt\n+ 6 KtSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilderKt\n+ 7 KtLibraryModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtLibraryModuleBuilderKt\n+ 8 KtSdkModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSdkModuleBuilderKt\n*L\n1#1,225:1\n138#1,11:251\n150#1:263\n1855#2,2:226\n3190#2,10:233\n1549#2:268\n1620#2,3:269\n1549#2:272\n1620#2,3:273\n1#3:228\n1#3:262\n39#4,4:229\n41#5,4:243\n51#6,4:247\n37#7,4:264\n34#8,4:276\n*S KotlinDebug\n*F\n+ 1 KtModuleUtils.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KtModuleUtilsKt\n*L\n214#1:251,11\n214#1:263\n70#1:226,2\n158#1:233,10\n168#1:268\n168#1:269,3\n176#1:272\n176#1:273,3\n214#1:262\n157#1:229,4\n194#1:243,4\n204#1:247,4\n164#1:264,4\n180#1:276,4\n*E\n"})
public final class KtModuleUtilsKt {
    @NotNull
    public static final PlatformDependentAnalyzerServices getAnalyzerServices(@NotNull TargetPlatform $this$getAnalyzerServices) {
        PlatformDependentAnalyzerServices platformDependentAnalyzerServices;
        Intrinsics.checkNotNullParameter((Object)$this$getAnalyzerServices, (String)"<this>");
        if (JvmPlatformKt.isJvm((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)JsPlatformAnalyzerServices.INSTANCE;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)WasmPlatformAnalyzerServices.INSTANCE;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)NativePlatformAnalyzerServices.INSTANCE;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)CommonPlatformAnalyzerServices.INSTANCE;
        } else {
            throw new IllegalStateException(("Unknown target platform: " + $this$getAnalyzerServices).toString());
        }
        return platformDependentAnalyzerServices;
    }

    @NotNull
    public static final Set<String> getSourceFilePaths(@NotNull CompilerConfiguration compilerConfig, boolean includeDirectoryRoot) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Set $this$getSourceFilePaths_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = JvmContentRootsKt.getJavaSourceRoots((CompilerConfiguration)compilerConfig);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String srcRoot = (String)element$iv;
            boolean bl2 = false;
            Path path = Paths.get(srcRoot, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Intrinsics.checkNotNull((Object)path);
                KtModuleUtilsKt.collectSourceFilePaths(path, $this$getSourceFilePaths_u24lambda_u241);
                if (!includeDirectoryRoot) continue;
                $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
                continue;
            }
            $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
        }
        return SetsKt.build((Set)set);
    }

    public static /* synthetic */ Set getSourceFilePaths$default(CompilerConfiguration compilerConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KtModuleUtilsKt.getSourceFilePaths(compilerConfiguration, bl);
    }

    private static final void collectSourceFilePaths(Path root, Set<String> result) {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result){
            final /* synthetic */ Set<String> $result;
            {
                this.$result = $result;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
                    return FileVisitResult.CONTINUE;
                }
                String ext = com.google.common.io.Files.getFileExtension((String)((Object)file.getFileName()).toString());
                if (Intrinsics.areEqual((Object)ext, (Object)"kt") || Intrinsics.areEqual((Object)ext, (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX) || Intrinsics.areEqual((Object)ext, (Object)"java")) {
                    this.$result.add(((Object)file).toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@NotNull Path file, @Nullable IOException exc) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final /* synthetic */ <T extends PsiFileSystemItem> List<T> getPsiFilesFromPaths(Project project, Collection<String> paths) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager psiManager3 = psiManager2;
        List $this$getPsiFilesFromPaths_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String path : paths) {
            PsiFileSystemItem it;
            PsiFileSystemItem psiFileSystemItem;
            PsiFileSystemItem psiFileSystemItem2;
            VirtualFile virtualFile2;
            if (fs.findFileByPath(path) == null) continue;
            Intrinsics.checkNotNull((Object)virtualFile2);
            VirtualFile vFile = virtualFile2;
            if (vFile.isDirectory()) {
                PsiDirectory psiDirectory = psiManager3.findDirectory(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager3.findFile(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = psiFileSystemItem = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem == null) continue;
            boolean bl2 = false;
            Boolean.valueOf($this$getPsiFilesFromPaths_u24lambda_u243.add(it));
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtStaticProjectStructureProvider buildKtModuleProviderByCompilerConfiguration(@NotNull CompilerConfiguration compilerConfig, @NotNull Project project, @NotNull List<? extends KtFile> ktFiles) {
        void paths$iv;
        List list;
        String string;
        Object it;
        Object scriptFile2;
        KtModuleProviderBuilder ktModuleProviderBuilder;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        boolean $i$f$buildProjectStructureProvider = false;
        KtModuleProviderBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415 = ktModuleProviderBuilder = new KtModuleProviderBuilder();
        boolean bl = false;
        Iterable $this$partition$iv = ktFiles;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtFile it2 = (KtFile)element$iv;
            boolean bl2 = false;
            if (it2.isScript()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List scriptFiles = (List)pair.component1();
        List ordinaryFiles = (List)pair.component2();
        TargetPlatform platform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        LanguageVersionSettings configLanguageVersionSettings = (LanguageVersionSettings)compilerConfig.get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS);
        for (Object scriptFile2 : scriptFiles) {
            KtScriptModuleBuilder bl2;
            boolean $i$f$buildKtScriptModule22 = false;
            KtScriptModuleBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2411 = bl2 = new KtScriptModuleBuilder();
            boolean bl3 = false;
            if (configLanguageVersionSettings != null) {
                boolean bl4 = false;
                $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2411.setLanguageVersionSettings((LanguageVersionSettings)it);
            }
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2411.setProject(project);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2411.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2411.setFile((KtFile)scriptFile2);
            KtModuleUtilsKt.buildKtModuleProviderByCompilerConfiguration$lambda$15$addModuleDependencies($this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2411, compilerConfig, project, platform, "Script " + scriptFile2.getName());
            KtScriptModule $i$f$buildKtScriptModule22 = bl2.build();
            KtModule p0 = (KtModule)$i$f$buildKtScriptModule22;
            boolean bl5 = false;
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.addModule(p0);
        }
        boolean $i$f$buildKtSourceModule = false;
        Object $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413 = scriptFile2 = new KtSourceModuleBuilder();
        boolean bl6 = false;
        LanguageVersionSettings languageVersionSettings = configLanguageVersionSettings;
        if (languageVersionSettings != null) {
            LanguageVersionSettings it3 = languageVersionSettings;
            boolean bl7 = false;
            ((KtSourceModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setLanguageVersionSettings(it3);
        }
        ((KtModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setProject(project);
        ((KtModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setPlatform(platform);
        Object object = it = (String)compilerConfig.get(CommonConfigurationKeys.MODULE_NAME);
        if (object == null) {
            string = "<no module name provided>";
        } else {
            Intrinsics.checkNotNull((Object)object);
            string = it;
        }
        ((KtSourceModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setModuleName(string);
        KtModuleUtilsKt.buildKtModuleProviderByCompilerConfiguration$lambda$15$addModuleDependencies((KtModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413, compilerConfig, project, platform, ((KtSourceModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).getModuleName());
        ((KtModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setContentScope(TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, (Collection)ordinaryFiles));
        it = KtModuleUtilsKt.getSourceFilePaths(compilerConfig, true);
        Object object2 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413;
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs$iv = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager psiManager$iv = psiManager2;
        List $this$getPsiFilesFromPaths_u24lambda_u243$iv = list = CollectionsKt.createListBuilder();
        boolean bl8 = false;
        for (String path$iv : paths$iv) {
            PsiFileSystemItem it$iv;
            PsiFileSystemItem psiFileSystemItem$iv;
            PsiFileSystemItem psiFileSystemItem;
            VirtualFile virtualFile2;
            if (fs$iv.findFileByPath(path$iv) == null) continue;
            Intrinsics.checkNotNull((Object)virtualFile2);
            VirtualFile vFile$iv = virtualFile2;
            if (vFile$iv.isDirectory()) {
                PsiDirectory psiDirectory = psiManager$iv.findDirectory(vFile$iv);
                if (!(psiDirectory instanceof PsiFileSystemItem)) {
                    psiDirectory = null;
                }
                psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager$iv.findFile(vFile$iv);
                if (!(psiFile instanceof PsiFileSystemItem)) {
                    psiFile = null;
                }
                psiFileSystemItem = psiFileSystemItem$iv = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem$iv == null) continue;
            boolean bl9 = false;
            $this$getPsiFilesFromPaths_u24lambda_u243$iv.add(it$iv);
        }
        ((KtSourceModuleBuilder)object2).addSourceRoots(CollectionsKt.build((List)list));
        KtSourceModule ktSourceModule = ((KtSourceModuleBuilder)scriptFile2).build();
        KtModule p0 = (KtModule)ktSourceModule;
        boolean bl10 = false;
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.addModule(p0);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.setPlatform(platform);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.setProject(project);
        return ktModuleProviderBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildKtModuleProviderByCompilerConfiguration$lambda$15$addModuleDependencies(KtModuleBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies, CompilerConfiguration $compilerConfig, Project $project, TargetPlatform platform, String moduleName) {
        block2: {
            void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u249_u24lambda_u248;
            KtSdkModuleBuilder ktSdkModuleBuilder;
            Object object;
            KtSdkModuleBuilder $this$mapTo$iv$iv;
            Object object2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246;
            KtLibraryModuleBuilder ktLibraryModuleBuilder;
            List libraryRoots = CollectionsKt.plus((Collection)JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)$compilerConfig), (Iterable)JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)$compilerConfig));
            boolean $i$f$buildKtLibraryModule = false;
            KtLibraryModuleBuilder ktLibraryModuleBuilder2 = ktLibraryModuleBuilder = new KtLibraryModuleBuilder();
            KtModuleBuilder ktModuleBuilder = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies;
            boolean bl = false;
            GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)$project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(...)");
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246.setContentScope(globalSearchScope);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246.setProject($project);
            Iterable iterable = libraryRoots;
            void var11_12 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246;
            boolean $i$f$map = false;
            void var13_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                object2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.toPath());
            }
            var11_12.setBinaryRoots((List)destination$iv$iv);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246.setLibraryName("Library for " + moduleName);
            ktModuleBuilder.addRegularDependency((KtModule)ktLibraryModuleBuilder.build());
            File file = (File)$compilerConfig.get(JVMConfigurationKeys.JDK_HOME);
            if (file == null) break block2;
            File jdkHome = file;
            boolean bl3 = false;
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
            VirtualFileManager vfm = virtualFileManager;
            Path jdkHomePath = jdkHome.toPath();
            VirtualFile jdkHomeVirtualFile = vfm.findFileByNioPath(jdkHomePath);
            Intrinsics.checkNotNull((Object)jdkHomePath);
            Iterable $this$map$iv2 = LibraryUtils.INSTANCE.findClassesFromJdkHome(jdkHomePath);
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            object2 = $this$mapTo$iv$iv.iterator();
            while (object2.hasNext()) {
                void it;
                Object item$iv$iv = object2.next();
                String bl2 = (String)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl4 = false;
                object.add(Paths.get(URLUtil.extractPath((String)it), new String[0]));
            }
            List binaryRoots = (List)destination$iv$iv2;
            boolean $i$f$buildKtSdkModule = false;
            $this$mapTo$iv$iv = ktSdkModuleBuilder = new KtSdkModuleBuilder();
            object = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies;
            boolean bl5 = false;
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.fileScope((Project)$project, (VirtualFile)jdkHomeVirtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"fileScope(...)");
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u249_u24lambda_u248.setContentScope(globalSearchScope2);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u249_u24lambda_u248.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u249_u24lambda_u248.setProject($project);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u249_u24lambda_u248.setBinaryRoots(binaryRoots);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u249_u24lambda_u248.setSdkName("JDK for " + moduleName);
            ((KtModuleBuilder)object).addRegularDependency((KtModule)ktSdkModuleBuilder.build());
        }
    }
}

