# This file is generated by build_data.py.
import re

DEFAULT_SCRIPTS = {
    'ab': 'Cyrl',
    'af': 'Latn',
    'am': 'Ethi',
    'ar': 'Arab',
    'as': 'Beng',
    'ay': 'Latn',
    'be': 'Cyrl',
    'bg': 'Cyrl',
    'bn': 'Beng',
    'bs': 'Latn',
    'ca': 'Latn',
    'ch': 'Latn',
    'cs': 'Latn',
    'cy': 'Latn',
    'da': 'Latn',
    'de': 'Latn',
    'dsb': 'Latn',
    'dv': 'Thaa',
    'dz': 'Tibt',
    'el': 'Grek',
    'en': 'Latn',
    'eo': 'Latn',
    'es': 'Latn',
    'et': 'Latn',
    'eu': 'Latn',
    'fa': 'Arab',
    'fi': 'Latn',
    'fj': 'Latn',
    'fo': 'Latn',
    'fr': 'Latn',
    'frr': 'Latn',
    'frs': 'Latn',
    'fy': 'Latn',
    'ga': 'Latn',
    'gl': 'Latn',
    'gn': 'Latn',
    'gsw': 'Latn',
    'gu': 'Gujr',
    'gv': 'Latn',
    'he': 'Hebr',
    'hi': 'Deva',
    'hr': 'Latn',
    'hsb': 'Latn',
    'ht': 'Latn',
    'hu': 'Latn',
    'hy': 'Armn',
    'id': 'Latn',
    'in': 'Latn',
    'is': 'Latn',
    'it': 'Latn',
    'iw': 'Hebr',
    'ja': 'Jpan',
    'ka': 'Geor',
    'kk': 'Cyrl',
    'kl': 'Latn',
    'km': 'Khmr',
    'kn': 'Knda',
    'ko': 'Kore',
    'kok': 'Deva',
    'la': 'Latn',
    'lb': 'Latn',
    'ln': 'Latn',
    'lo': 'Laoo',
    'lt': 'Latn',
    'lv': 'Latn',
    'mai': 'Deva',
    'men': 'Latn',
    'mg': 'Latn',
    'mh': 'Latn',
    'mk': 'Cyrl',
    'ml': 'Mlym',
    'mo': 'Latn',
    'mr': 'Deva',
    'ms': 'Latn',
    'mt': 'Latn',
    'my': 'Mymr',
    'na': 'Latn',
    'nb': 'Latn',
    'nd': 'Latn',
    'nds': 'Latn',
    'ne': 'Deva',
    'niu': 'Latn',
    'nl': 'Latn',
    'nn': 'Latn',
    'no': 'Latn',
    'nqo': 'Nkoo',
    'nr': 'Latn',
    'nso': 'Latn',
    'ny': 'Latn',
    'om': 'Latn',
    'or': 'Orya',
    'pa': 'Guru',
    'pl': 'Latn',
    'ps': 'Arab',
    'pt': 'Latn',
    'qu': 'Latn',
    'rm': 'Latn',
    'rn': 'Latn',
    'ro': 'Latn',
    'ru': 'Cyrl',
    'rw': 'Latn',
    'sg': 'Latn',
    'si': 'Sinh',
    'sk': 'Latn',
    'sl': 'Latn',
    'sm': 'Latn',
    'so': 'Latn',
    'sq': 'Latn',
    'ss': 'Latn',
    'st': 'Latn',
    'sv': 'Latn',
    'sw': 'Latn',
    'ta': 'Taml',
    'te': 'Telu',
    'tem': 'Latn',
    'th': 'Thai',
    'ti': 'Ethi',
    'tkl': 'Latn',
    'tl': 'Latn',
    'tmh': 'Latn',
    'tn': 'Latn',
    'to': 'Latn',
    'tpi': 'Latn',
    'tr': 'Latn',
    'ts': 'Latn',
    'tvl': 'Latn',
    'uk': 'Cyrl',
    'ur': 'Arab',
    've': 'Latn',
    'vi': 'Latn',
    'xh': 'Latn',
    'yi': 'Hebr',
    'zbl': 'Blis',
    'zu': 'Latn',
}
LANGUAGE_REPLACEMENTS = {
    'aa-saaho': 'ssy',
    'aam': 'aas',
    'aar': 'aa',
    'abk': 'ab',
    'adp': 'dz',
    'afr': 'af',
    'agp': 'apf',
    'ais': 'ami',
    'aka': 'ak',
    'alb': 'sq',
    'amh': 'am',
    'ara': 'ar',
    'arg': 'an',
    'arm': 'hy',
    'art-lojban': 'jbo',
    'asd': 'snz',
    'asm': 'as',
    'aue': 'ktz',
    'ava': 'av',
    'ave': 'ae',
    'aym': 'ay',
    'ayx': 'nun',
    'aze': 'az',
    'bak': 'ba',
    'bam': 'bm',
    'baq': 'eu',
    'baz': 'nvo',
    'bel': 'be',
    'ben': 'bn',
    'bgm': 'bcg',
    'bhk': 'fbl',
    'bic': 'bir',
    'bih': 'bh',
    'bis': 'bi',
    'bjd': 'drl',
    'bjq': 'bzc',
    'bkb': 'ebk',
    'blg': 'iba',
    'bod': 'bo',
    'bos': 'bs',
    'bre': 'br',
    'btb': 'beb',
    'bul': 'bg',
    'bur': 'my',
    'cat': 'ca',
    'ccq': 'rki',
    'cel-gaulish': 'xtg',
    'ces': 'cs',
    'cha': 'ch',
    'che': 'ce',
    'chi': 'zh',
    'chu': 'cu',
    'chv': 'cv',
    'cjr': 'mom',
    'cka': 'cmr',
    'cmk': 'xch',
    'cnr': 'sr-ME',
    'cor': 'kw',
    'cos': 'co',
    'coy': 'pij',
    'cqu': 'quh',
    'cre': 'cr',
    'cym': 'cy',
    'cze': 'cs',
    'daf': 'dnj',
    'dan': 'da',
    'dap': 'njz',
    'deu': 'de',
    'dit': 'dif',
    'div': 'dv',
    'djl': 'dze',
    'dkl': 'aqd',
    'drh': 'mn',
    'drr': 'kzk',
    'drw': 'fa-AF',
    'dud': 'uth',
    'duj': 'dwu',
    'dut': 'nl',
    'dwl': 'dbt',
    'dzo': 'dz',
    'ell': 'el',
    'elp': 'amq',
    'en-gb-oed': 'en-GB-oxendict',
    'eng': 'en',
    'epo': 'eo',
    'est': 'et',
    'eus': 'eu',
    'ewe': 'ee',
    'fao': 'fo',
    'fas': 'fa',
    'fij': 'fj',
    'fin': 'fi',
    'fra': 'fr',
    'fre': 'fr',
    'fry': 'fy',
    'ful': 'ff',
    'gav': 'dev',
    'gbc': 'wny',
    'geo': 'ka',
    'ger': 'de',
    'gfx': 'vaj',
    'ggn': 'gvr',
    'ggo': 'esg',
    'ggr': 'gtu',
    'gio': 'aou',
    'gla': 'gd',
    'gle': 'ga',
    'glg': 'gl',
    'gli': 'kzk',
    'glv': 'gv',
    'gre': 'el',
    'grn': 'gn',
    'gti': 'nyc',
    'guj': 'gu',
    'guv': 'duz',
    'hat': 'ht',
    'hau': 'ha',
    'hbs': 'sr-Latn',
    'heb': 'he',
    'her': 'hz',
    'hin': 'hi',
    'hmo': 'ho',
    'hrr': 'jal',
    'hrv': 'hr',
    'hun': 'hu',
    'hy-arevmda': 'hyw',
    'hye': 'hy',
    'i-ami': 'ami',
    'i-bnn': 'bnn',
    'i-default': 'en-x-i-default',
    'i-enochian': 'und-x-i-enochian',
    'i-hak': 'hak',
    'i-klingon': 'tlh',
    'i-lux': 'lb',
    'i-mingo': 'see-x-i-mingo',
    'i-navajo': 'nv',
    'i-pwn': 'pwn',
    'i-tao': 'tao',
    'i-tay': 'tay',
    'i-tsu': 'tsu',
    'ibi': 'opa',
    'ibo': 'ig',
    'ice': 'is',
    'ido': 'io',
    'iii': 'ii',
    'iku': 'iu',
    'ile': 'ie',
    'ill': 'ilm',
    'ilw': 'gal',
    'in': 'id',
    'ina': 'ia',
    'ind': 'id',
    'ipk': 'ik',
    'isl': 'is',
    'ita': 'it',
    'iw': 'he',
    'izi': 'eza',
    'jar': 'jgk',
    'jav': 'jv',
    'jeg': 'oyb',
    'ji': 'yi',
    'jpn': 'ja',
    'jw': 'jv',
    'kal': 'kl',
    'kan': 'kn',
    'kas': 'ks',
    'kat': 'ka',
    'kau': 'kr',
    'kaz': 'kk',
    'kdv': 'zkd',
    'kgc': 'tdf',
    'kgd': 'ncq',
    'kgh': 'kml',
    'khm': 'km',
    'kik': 'ki',
    'kin': 'rw',
    'kir': 'ky',
    'koj': 'kwv',
    'kom': 'kv',
    'kon': 'kg',
    'kor': 'ko',
    'kpp': 'jkm',
    'krm': 'bmf',
    'ktr': 'dtp',
    'kua': 'kj',
    'kur': 'ku',
    'kvs': 'gdj',
    'kwq': 'yam',
    'kxe': 'tvd',
    'kxl': 'kru',
    'kzh': 'dgl',
    'kzj': 'dtp',
    'kzt': 'dtp',
    'lao': 'lo',
    'lat': 'la',
    'lav': 'lv',
    'leg': 'enl',
    'lii': 'raq',
    'lim': 'li',
    'lin': 'ln',
    'lit': 'lt',
    'llo': 'ngt',
    'lmm': 'rmx',
    'ltz': 'lb',
    'lub': 'lu',
    'lug': 'lg',
    'mac': 'mk',
    'mah': 'mh',
    'mal': 'ml',
    'mao': 'mi',
    'mar': 'mr',
    'may': 'ms',
    'meg': 'cir',
    'mgx': 'jbk',
    'mkd': 'mk',
    'mlg': 'mg',
    'mlt': 'mt',
    'mnt': 'wnn',
    'mo': 'ro',
    'mof': 'xnt',
    'mol': 'mo',
    'mon': 'mn',
    'mri': 'mi',
    'msa': 'ms',
    'mst': 'mry',
    'mwd': 'dmw',
    'mwj': 'vaj',
    'mya': 'my',
    'myd': 'aog',
    'myt': 'mry',
    'nad': 'xny',
    'nau': 'na',
    'nav': 'nv',
    'nbf': 'nru',
    'nbl': 'nr',
    'nbx': 'ekc',
    'ncp': 'kdz',
    'nde': 'nd',
    'ndo': 'ng',
    'nep': 'ne',
    'nld': 'nl',
    'nln': 'azd',
    'nlr': 'nrk',
    'nno': 'nn',
    'nns': 'nbr',
    'nnx': 'ngv',
    'no-bok': 'nb',
    'no-bokmal': 'nb',
    'no-nyn': 'nn',
    'no-nynorsk': 'nn',
    'nob': 'nb',
    'noo': 'dtd',
    'nor': 'no',
    'nts': 'pij',
    'nxu': 'bpp',
    'nya': 'ny',
    'oci': 'oc',
    'oji': 'oj',
    'ori': 'or',
    'orm': 'om',
    'oss': 'os',
    'oun': 'vaj',
    'pan': 'pa',
    'pat': 'kxr',
    'pcr': 'adx',
    'per': 'fa',
    'pli': 'pi',
    'pmc': 'huw',
    'pmu': 'phr',
    'pol': 'pl',
    'por': 'pt',
    'ppa': 'bfy',
    'ppr': 'lcq',
    'prs': 'fa-AF',
    'pry': 'prt',
    'pus': 'ps',
    'puz': 'pub',
    'que': 'qu',
    'rmr': 'emx',
    'roh': 'rm',
    'ron': 'ro',
    'root': 'und',
    'rum': 'ro',
    'run': 'rn',
    'rus': 'ru',
    'sag': 'sg',
    'san': 'sa',
    'sap': 'aqt',
    'sca': 'hle',
    'scc': 'sr',
    'scr': 'hr',
    'sgl': 'isk',
    'sgn-be-fr': 'sfb',
    'sgn-be-nl': 'vgt',
    'sgn-br': 'bzs',
    'sgn-ch-de': 'sgg',
    'sgn-co': 'csn',
    'sgn-de': 'gsg',
    'sgn-dk': 'dsl',
    'sgn-es': 'ssp',
    'sgn-fr': 'fsl',
    'sgn-gb': 'bfi',
    'sgn-gr': 'gss',
    'sgn-ie': 'isg',
    'sgn-it': 'ise',
    'sgn-jp': 'jsl',
    'sgn-mx': 'mfs',
    'sgn-ni': 'ncs',
    'sgn-nl': 'dse',
    'sgn-no': 'nsi',
    'sgn-pt': 'psr',
    'sgn-se': 'swl',
    'sgn-us': 'ase',
    'sgn-za': 'sfs',
    'sh': 'sr-Latn',
    'sin': 'si',
    'skk': 'oyb',
    'slk': 'sk',
    'slo': 'sk',
    'slv': 'sl',
    'sme': 'se',
    'smo': 'sm',
    'sna': 'sn',
    'snd': 'sd',
    'som': 'so',
    'sot': 'st',
    'spa': 'es',
    'sqi': 'sq',
    'srd': 'sc',
    'srp': 'sr',
    'ssw': 'ss',
    'sul': 'sgd',
    'sum': 'ulw',
    'sun': 'su',
    'swa': 'sw',
    'swc': 'sw-CD',
    'swe': 'sv',
    'tah': 'ty',
    'tam': 'ta',
    'tat': 'tt',
    'tdu': 'dtp',
    'tel': 'te',
    'tgg': 'bjp',
    'tgk': 'tg',
    'tgl': 'fil',
    'tha': 'th',
    'thc': 'tpo',
    'thw': 'ola',
    'thx': 'oyb',
    'tib': 'bo',
    'tid': 'itd',
    'tie': 'ras',
    'tir': 'ti',
    'tkk': 'twm',
    'tl': 'fil',
    'tlw': 'weo',
    'tmp': 'tyj',
    'tne': 'kak',
    'tnf': 'fa-AF',
    'ton': 'to',
    'tsf': 'taj',
    'tsn': 'tn',
    'tso': 'ts',
    'tuk': 'tk',
    'tur': 'tr',
    'twi': 'tw',
    'uig': 'ug',
    'ukr': 'uk',
    'und-aaland': 'und-AX',
    'und-arevela': 'und',
    'und-arevmda': 'und',
    'und-bokmal': 'und',
    'und-hakka': 'und',
    'und-hepburn-heploc': 'und-alalc97',
    'und-lojban': 'und',
    'und-nynorsk': 'und',
    'und-saaho': 'und',
    'und-xiang': 'und',
    'unp': 'wro',
    'uok': 'ema',
    'urd': 'ur',
    'uzb': 'uz',
    'ven': 've',
    'vie': 'vi',
    'vol': 'vo',
    'wel': 'cy',
    'wgw': 'wgb',
    'wit': 'nol',
    'wiw': 'nwo',
    'wln': 'wa',
    'wol': 'wo',
    'xba': 'cax',
    'xho': 'xh',
    'xia': 'acn',
    'xkh': 'waw',
    'xrq': 'dmw',
    'xsj': 'suj',
    'ybd': 'rki',
    'yen': 'ynq',
    'yid': 'yi',
    'yiy': 'yrm',
    'yma': 'lrr',
    'ymt': 'mtm',
    'yor': 'yo',
    'yos': 'zom',
    'yuu': 'yug',
    'zh-cmn': 'zh',
    'zh-cmn-hans': 'zh-Hans',
    'zh-cmn-hant': 'zh-Hant',
    'zh-gan': 'gan',
    'zh-guoyu': 'zh',
    'zh-hakka': 'hak',
    'zh-min': 'nan-x-zh-min',
    'zh-min-nan': 'nan',
    'zh-wuu': 'wuu',
    'zh-xiang': 'hsn',
    'zh-yue': 'yue',
    'zha': 'za',
    'zho': 'zh',
    'zir': 'scv',
    'zul': 'zu',
}
LANGUAGE_ALPHA3 = {
    'aa': 'aar',
    'ab': 'abk',
    'ae': 'ave',
    'af': 'afr',
    'ak': 'aka',
    'am': 'amh',
    'an': 'arg',
    'ar': 'ara',
    'as': 'asm',
    'av': 'ava',
    'ay': 'aym',
    'az': 'aze',
    'ba': 'bak',
    'be': 'bel',
    'bg': 'bul',
    'bh': 'bih',
    'bi': 'bis',
    'bm': 'bam',
    'bn': 'ben',
    'bo': 'bod',
    'br': 'bre',
    'bs': 'bos',
    'ca': 'cat',
    'ce': 'che',
    'ch': 'cha',
    'co': 'cos',
    'cr': 'cre',
    'cs': 'ces',
    'cu': 'chu',
    'cv': 'chv',
    'cy': 'cym',
    'da': 'dan',
    'de': 'deu',
    'dv': 'div',
    'dz': 'dzo',
    'ee': 'ewe',
    'el': 'ell',
    'en': 'eng',
    'eo': 'epo',
    'es': 'spa',
    'et': 'est',
    'eu': 'eus',
    'fa': 'fas',
    'fa-AF': 'prs',
    'ff': 'ful',
    'fi': 'fin',
    'fil': 'tgl',
    'fj': 'fij',
    'fo': 'fao',
    'fr': 'fra',
    'fy': 'fry',
    'ga': 'gle',
    'gd': 'gla',
    'gl': 'glg',
    'gn': 'grn',
    'gu': 'guj',
    'gv': 'glv',
    'ha': 'hau',
    'he': 'heb',
    'hi': 'hin',
    'ho': 'hmo',
    'hr': 'hrv',
    'ht': 'hat',
    'hu': 'hun',
    'hy': 'hye',
    'hz': 'her',
    'ia': 'ina',
    'id': 'ind',
    'ie': 'ile',
    'ig': 'ibo',
    'ii': 'iii',
    'ik': 'ipk',
    'in': 'ind',
    'io': 'ido',
    'is': 'isl',
    'it': 'ita',
    'iu': 'iku',
    'iw': 'heb',
    'ja': 'jpn',
    'ji': 'yid',
    'jv': 'jav',
    'jw': 'jav',
    'ka': 'kat',
    'kg': 'kon',
    'ki': 'kik',
    'kj': 'kua',
    'kk': 'kaz',
    'kl': 'kal',
    'km': 'khm',
    'kn': 'kan',
    'ko': 'kor',
    'kr': 'kau',
    'ks': 'kas',
    'ku': 'kur',
    'kv': 'kom',
    'kw': 'cor',
    'ky': 'kir',
    'la': 'lat',
    'lb': 'ltz',
    'lg': 'lug',
    'li': 'lim',
    'ln': 'lin',
    'lo': 'lao',
    'lt': 'lit',
    'lu': 'lub',
    'lv': 'lav',
    'mg': 'mlg',
    'mh': 'mah',
    'mi': 'mri',
    'mk': 'mkd',
    'ml': 'mal',
    'mn': 'mon',
    'mo': 'mol',
    'mr': 'mar',
    'ms': 'msa',
    'mt': 'mlt',
    'my': 'mya',
    'na': 'nau',
    'nb': 'nob',
    'nd': 'nde',
    'ne': 'nep',
    'ng': 'ndo',
    'nl': 'nld',
    'nn': 'nno',
    'no': 'nor',
    'nr': 'nbl',
    'nv': 'nav',
    'ny': 'nya',
    'oc': 'oci',
    'oj': 'oji',
    'om': 'orm',
    'or': 'ori',
    'os': 'oss',
    'pa': 'pan',
    'pi': 'pli',
    'pl': 'pol',
    'ps': 'pus',
    'pt': 'por',
    'qu': 'que',
    'rm': 'roh',
    'rn': 'run',
    'ro': 'ron',
    'ru': 'rus',
    'rw': 'kin',
    'sa': 'san',
    'sc': 'srd',
    'sd': 'snd',
    'se': 'sme',
    'sg': 'sag',
    'sh': 'hbs',
    'si': 'sin',
    'sk': 'slk',
    'sl': 'slv',
    'sm': 'smo',
    'sn': 'sna',
    'so': 'som',
    'sq': 'sqi',
    'sr': 'srp',
    'sr-Latn': 'hbs',
    'ss': 'ssw',
    'st': 'sot',
    'su': 'sun',
    'sv': 'swe',
    'sw': 'swa',
    'sw-CD': 'swc',
    'ta': 'tam',
    'te': 'tel',
    'tg': 'tgk',
    'th': 'tha',
    'ti': 'tir',
    'tk': 'tuk',
    'tl': 'tgl',
    'tn': 'tsn',
    'to': 'ton',
    'tr': 'tur',
    'ts': 'tso',
    'tt': 'tat',
    'tw': 'twi',
    'ty': 'tah',
    'ug': 'uig',
    'uk': 'ukr',
    'ur': 'urd',
    'uz': 'uzb',
    've': 'ven',
    'vi': 'vie',
    'vo': 'vol',
    'wa': 'wln',
    'wo': 'wol',
    'xh': 'xho',
    'yi': 'yid',
    'yo': 'yor',
    'za': 'zha',
    'zh': 'zho',
    'zu': 'zul',
}
LANGUAGE_ALPHA3_BIBLIOGRAPHIC = {
    'bo': 'tib',
    'cs': 'cze',
    'cy': 'wel',
    'de': 'ger',
    'el': 'gre',
    'eu': 'baq',
    'fa': 'per',
    'fr': 'fre',
    'hy': 'arm',
    'is': 'ice',
    'ka': 'geo',
    'mi': 'mao',
    'mk': 'mac',
    'ms': 'may',
    'my': 'bur',
    'nl': 'dut',
    'ro': 'rum',
    'sk': 'slo',
    'sq': 'alb',
    'zh': 'chi',
}
SCRIPT_REPLACEMENTS = {
    'qaai': 'Zinh',
}
ALL_SCRIPTS = {
    'Adlm',
    'Afak',
    'Aghb',
    'Ahom',
    'Arab',
    'Aran',
    'Armi',
    'Armn',
    'Avst',
    'Bali',
    'Bamu',
    'Bass',
    'Batk',
    'Beng',
    'Bhks',
    'Blis',
    'Bopo',
    'Brah',
    'Brai',
    'Bugi',
    'Buhd',
    'Cakm',
    'Cans',
    'Cari',
    'Cham',
    'Cher',
    'Chrs',
    'Cirt',
    'Copt',
    'Cpmn',
    'Cprt',
    'Cyrl',
    'Cyrs',
    'Deva',
    'Diak',
    'Dogr',
    'Dsrt',
    'Dupl',
    'Egyd',
    'Egyh',
    'Egyp',
    'Elba',
    'Elym',
    'Ethi',
    'Geok',
    'Geor',
    'Glag',
    'Gong',
    'Gonm',
    'Goth',
    'Gran',
    'Grek',
    'Gujr',
    'Guru',
    'Hanb',
    'Hang',
    'Hani',
    'Hano',
    'Hans',
    'Hant',
    'Hatr',
    'Hebr',
    'Hira',
    'Hluw',
    'Hmng',
    'Hmnp',
    'Hrkt',
    'Hung',
    'Inds',
    'Ital',
    'Jamo',
    'Java',
    'Jpan',
    'Jurc',
    'Kali',
    'Kana',
    'Khar',
    'Khmr',
    'Khoj',
    'Kitl',
    'Kits',
    'Knda',
    'Kore',
    'Kpel',
    'Kthi',
    'Lana',
    'Laoo',
    'Latf',
    'Latg',
    'Latn',
    'Leke',
    'Lepc',
    'Limb',
    'Lina',
    'Linb',
    'Lisu',
    'Loma',
    'Lyci',
    'Lydi',
    'Mahj',
    'Maka',
    'Mand',
    'Mani',
    'Marc',
    'Maya',
    'Medf',
    'Mend',
    'Merc',
    'Mero',
    'Mlym',
    'Modi',
    'Mong',
    'Moon',
    'Mroo',
    'Mtei',
    'Mult',
    'Mymr',
    'Nand',
    'Narb',
    'Nbat',
    'Newa',
    'Nkdb',
    'Nkgb',
    'Nkoo',
    'Nshu',
    'Ogam',
    'Olck',
    'Orkh',
    'Orya',
    'Osge',
    'Osma',
    'Ougr',
    'Palm',
    'Pauc',
    'Pcun',
    'Pelm',
    'Perm',
    'Phag',
    'Phli',
    'Phlp',
    'Phlv',
    'Phnx',
    'Piqd',
    'Plrd',
    'Prti',
    'Psin',
    'Qaaa..Qabx',
    'Ranj',
    'Rjng',
    'Rohg',
    'Roro',
    'Runr',
    'Samr',
    'Sara',
    'Sarb',
    'Saur',
    'Sgnw',
    'Shaw',
    'Shrd',
    'Shui',
    'Sidd',
    'Sind',
    'Sinh',
    'Sogd',
    'Sogo',
    'Sora',
    'Soyo',
    'Sund',
    'Sylo',
    'Syrc',
    'Syre',
    'Syrj',
    'Syrn',
    'Tagb',
    'Takr',
    'Tale',
    'Talu',
    'Taml',
    'Tang',
    'Tavt',
    'Telu',
    'Teng',
    'Tfng',
    'Tglg',
    'Thaa',
    'Thai',
    'Tibt',
    'Tirh',
    'Tnsa',
    'Toto',
    'Ugar',
    'Vaii',
    'Visp',
    'Vith',
    'Wara',
    'Wcho',
    'Wole',
    'Xpeo',
    'Xsux',
    'Yezi',
    'Yiii',
    'Zanb',
    'Zinh',
    'Zmth',
    'Zsye',
    'Zsym',
    'Zxxx',
    'Zyyy',
    'Zzzz',
}
TERRITORY_REPLACEMENTS = {
    '004': 'AF',
    '008': 'AL',
    '010': 'AQ',
    '012': 'DZ',
    '016': 'AS',
    '020': 'AD',
    '024': 'AO',
    '028': 'AG',
    '031': 'AZ',
    '032': 'AR',
    '036': 'AU',
    '040': 'AT',
    '044': 'BS',
    '048': 'BH',
    '050': 'BD',
    '051': 'AM',
    '052': 'BB',
    '056': 'BE',
    '060': 'BM',
    '062': '034',
    '064': 'BT',
    '068': 'BO',
    '070': 'BA',
    '072': 'BW',
    '074': 'BV',
    '076': 'BR',
    '084': 'BZ',
    '086': 'IO',
    '090': 'SB',
    '092': 'VG',
    '096': 'BN',
    '100': 'BG',
    '104': 'MM',
    '108': 'BI',
    '112': 'BY',
    '116': 'KH',
    '120': 'CM',
    '124': 'CA',
    '132': 'CV',
    '136': 'KY',
    '140': 'CF',
    '144': 'LK',
    '148': 'TD',
    '152': 'CL',
    '156': 'CN',
    '158': 'TW',
    '162': 'CX',
    '166': 'CC',
    '170': 'CO',
    '172': 'RU',
    '174': 'KM',
    '175': 'YT',
    '178': 'CG',
    '180': 'CD',
    '184': 'CK',
    '188': 'CR',
    '191': 'HR',
    '192': 'CU',
    '196': 'CY',
    '200': 'CZ',
    '203': 'CZ',
    '204': 'BJ',
    '208': 'DK',
    '212': 'DM',
    '214': 'DO',
    '218': 'EC',
    '222': 'SV',
    '226': 'GQ',
    '230': 'ET',
    '231': 'ET',
    '232': 'ER',
    '233': 'EE',
    '234': 'FO',
    '238': 'FK',
    '239': 'GS',
    '242': 'FJ',
    '246': 'FI',
    '248': 'AX',
    '249': 'FR',
    '250': 'FR',
    '254': 'GF',
    '258': 'PF',
    '260': 'TF',
    '262': 'DJ',
    '266': 'GA',
    '268': 'GE',
    '270': 'GM',
    '275': 'PS',
    '276': 'DE',
    '278': 'DE',
    '280': 'DE',
    '288': 'GH',
    '292': 'GI',
    '296': 'KI',
    '300': 'GR',
    '304': 'GL',
    '308': 'GD',
    '312': 'GP',
    '316': 'GU',
    '320': 'GT',
    '324': 'GN',
    '328': 'GY',
    '332': 'HT',
    '334': 'HM',
    '336': 'VA',
    '340': 'HN',
    '344': 'HK',
    '348': 'HU',
    '352': 'IS',
    '356': 'IN',
    '360': 'ID',
    '364': 'IR',
    '368': 'IQ',
    '372': 'IE',
    '376': 'IL',
    '380': 'IT',
    '384': 'CI',
    '388': 'JM',
    '392': 'JP',
    '398': 'KZ',
    '400': 'JO',
    '404': 'KE',
    '408': 'KP',
    '410': 'KR',
    '414': 'KW',
    '417': 'KG',
    '418': 'LA',
    '422': 'LB',
    '426': 'LS',
    '428': 'LV',
    '430': 'LR',
    '434': 'LY',
    '438': 'LI',
    '440': 'LT',
    '442': 'LU',
    '446': 'MO',
    '450': 'MG',
    '454': 'MW',
    '458': 'MY',
    '462': 'MV',
    '466': 'ML',
    '470': 'MT',
    '474': 'MQ',
    '478': 'MR',
    '480': 'MU',
    '484': 'MX',
    '492': 'MC',
    '496': 'MN',
    '498': 'MD',
    '499': 'ME',
    '500': 'MS',
    '504': 'MA',
    '508': 'MZ',
    '512': 'OM',
    '516': 'NA',
    '520': 'NR',
    '524': 'NP',
    '528': 'NL',
    '530': 'CW',
    '531': 'CW',
    '532': 'CW',
    '533': 'AW',
    '534': 'SX',
    '535': 'BQ',
    '536': 'SA',
    '540': 'NC',
    '548': 'VU',
    '554': 'NZ',
    '558': 'NI',
    '562': 'NE',
    '566': 'NG',
    '570': 'NU',
    '574': 'NF',
    '578': 'NO',
    '580': 'MP',
    '581': 'UM',
    '582': 'FM',
    '583': 'FM',
    '584': 'MH',
    '585': 'PW',
    '586': 'PK',
    '591': 'PA',
    '598': 'PG',
    '600': 'PY',
    '604': 'PE',
    '608': 'PH',
    '612': 'PN',
    '616': 'PL',
    '620': 'PT',
    '624': 'GW',
    '626': 'TL',
    '630': 'PR',
    '634': 'QA',
    '638': 'RE',
    '642': 'RO',
    '643': 'RU',
    '646': 'RW',
    '652': 'BL',
    '654': 'SH',
    '659': 'KN',
    '660': 'AI',
    '662': 'LC',
    '663': 'MF',
    '666': 'PM',
    '670': 'VC',
    '674': 'SM',
    '678': 'ST',
    '682': 'SA',
    '686': 'SN',
    '688': 'RS',
    '690': 'SC',
    '694': 'SL',
    '702': 'SG',
    '703': 'SK',
    '704': 'VN',
    '705': 'SI',
    '706': 'SO',
    '710': 'ZA',
    '716': 'ZW',
    '720': 'YE',
    '724': 'ES',
    '728': 'SS',
    '729': 'SD',
    '732': 'EH',
    '736': 'SD',
    '740': 'SR',
    '744': 'SJ',
    '748': 'SZ',
    '752': 'SE',
    '756': 'CH',
    '760': 'SY',
    '762': 'TJ',
    '764': 'TH',
    '768': 'TG',
    '772': 'TK',
    '776': 'TO',
    '780': 'TT',
    '784': 'AE',
    '788': 'TN',
    '792': 'TR',
    '795': 'TM',
    '796': 'TC',
    '798': 'TV',
    '800': 'UG',
    '804': 'UA',
    '807': 'MK',
    '810': 'RU',
    '818': 'EG',
    '826': 'GB',
    '830': 'JE',
    '831': 'GG',
    '832': 'JE',
    '833': 'IM',
    '834': 'TZ',
    '840': 'US',
    '850': 'VI',
    '854': 'BF',
    '858': 'UY',
    '860': 'UZ',
    '862': 'VE',
    '876': 'WF',
    '882': 'WS',
    '886': 'YE',
    '887': 'YE',
    '890': 'RS',
    '891': 'RS',
    '894': 'ZM',
    '958': 'AA',
    '959': 'QM',
    '960': 'QN',
    '962': 'QP',
    '963': 'QQ',
    '964': 'QR',
    '965': 'QS',
    '966': 'QT',
    '967': 'EU',
    '968': 'QV',
    '969': 'QW',
    '970': 'QX',
    '971': 'QY',
    '972': 'QZ',
    '973': 'XA',
    '974': 'XB',
    '975': 'XC',
    '976': 'XD',
    '977': 'XE',
    '978': 'XF',
    '979': 'XG',
    '980': 'XH',
    '981': 'XI',
    '982': 'XJ',
    '983': 'XK',
    '984': 'XL',
    '985': 'XM',
    '986': 'XN',
    '987': 'XO',
    '988': 'XP',
    '989': 'XQ',
    '990': 'XR',
    '991': 'XS',
    '992': 'XT',
    '993': 'XU',
    '994': 'XV',
    '995': 'XW',
    '996': 'XX',
    '997': 'XY',
    '998': 'XZ',
    '999': 'ZZ',
    'aaa': 'AA',
    'abw': 'AW',
    'afg': 'AF',
    'ago': 'AO',
    'aia': 'AI',
    'ala': 'AX',
    'alb': 'AL',
    'an': 'CW',
    'and': 'AD',
    'ant': 'CW',
    'are': 'AE',
    'arg': 'AR',
    'arm': 'AM',
    'asc': 'AC',
    'asm': 'AS',
    'ata': 'AQ',
    'atf': 'TF',
    'atg': 'AG',
    'aus': 'AU',
    'aut': 'AT',
    'aze': 'AZ',
    'bdi': 'BI',
    'bel': 'BE',
    'ben': 'BJ',
    'bes': 'BQ',
    'bfa': 'BF',
    'bgd': 'BD',
    'bgr': 'BG',
    'bhr': 'BH',
    'bhs': 'BS',
    'bih': 'bh',
    'blm': 'BL',
    'blr': 'BY',
    'blz': 'BZ',
    'bmu': 'BM',
    'bol': 'BO',
    'bra': 'BR',
    'brb': 'BB',
    'brn': 'BN',
    'btn': 'BT',
    'bu': 'MM',
    'bur': 'MM',
    'bvt': 'BV',
    'bwa': 'BW',
    'caf': 'CF',
    'can': 'CA',
    'cck': 'CC',
    'che': 'CH',
    'chl': 'CL',
    'chn': 'CN',
    'civ': 'CI',
    'cmr': 'CM',
    'cod': 'CD',
    'cog': 'CG',
    'cok': 'CK',
    'col': 'CO',
    'com': 'KM',
    'cpt': 'CP',
    'cpv': 'CV',
    'cri': 'CR',
    'cs': 'RS',
    'ct': 'KI',
    'cub': 'CU',
    'cuw': 'CW',
    'cxr': 'CX',
    'cym': 'KY',
    'cyp': 'CY',
    'cze': 'CZ',
    'dd': 'DE',
    'ddr': 'DE',
    'deu': 'DE',
    'dga': 'DG',
    'dji': 'DJ',
    'dma': 'DM',
    'dnk': 'DK',
    'dom': 'DO',
    'dy': 'BJ',
    'dza': 'DZ',
    'ecu': 'EC',
    'egy': 'EG',
    'eri': 'ER',
    'esh': 'EH',
    'esp': 'ES',
    'est': 'EE',
    'eth': 'ET',
    'fin': 'FI',
    'fji': 'FJ',
    'flk': 'FK',
    'fq': 'AQ',
    'fra': 'FR',
    'fro': 'FO',
    'fsm': 'FM',
    'fx': 'FR',
    'fxx': 'FR',
    'gab': 'GA',
    'gbr': 'GB',
    'geo': 'GE',
    'ggy': 'GG',
    'gha': 'GH',
    'gib': 'GI',
    'gin': 'GN',
    'glp': 'GP',
    'gmb': 'GM',
    'gnb': 'GW',
    'gnq': 'GQ',
    'grc': 'GR',
    'grd': 'GD',
    'grl': 'GL',
    'gtm': 'GT',
    'guf': 'GF',
    'gum': 'GU',
    'guy': 'GY',
    'hkg': 'HK',
    'hmd': 'HM',
    'hnd': 'HN',
    'hrv': 'HR',
    'hti': 'HT',
    'hun': 'HU',
    'hv': 'BF',
    'idn': 'ID',
    'imn': 'IM',
    'ind': 'IN',
    'iot': 'IO',
    'irl': 'IE',
    'irn': 'IR',
    'irq': 'IQ',
    'isl': 'IS',
    'isr': 'IL',
    'ita': 'IT',
    'jam': 'JM',
    'jey': 'JE',
    'jor': 'JO',
    'jpn': 'JP',
    'jt': 'UM',
    'kaz': 'KZ',
    'ken': 'KE',
    'kgz': 'KG',
    'khm': 'KH',
    'kir': 'KI',
    'kna': 'KN',
    'kor': 'KR',
    'kwt': 'KW',
    'lao': 'LA',
    'lbn': 'LB',
    'lbr': 'LR',
    'lby': 'LY',
    'lca': 'LC',
    'lie': 'LI',
    'lka': 'LK',
    'lso': 'LS',
    'ltu': 'LT',
    'lux': 'LU',
    'lva': 'LV',
    'mac': 'MO',
    'maf': 'MF',
    'mar': 'MA',
    'mco': 'MC',
    'mda': 'MD',
    'mdg': 'MG',
    'mdv': 'MV',
    'mex': 'MX',
    'mhl': 'MH',
    'mi': 'UM',
    'mkd': 'MK',
    'mli': 'ML',
    'mlt': 'MT',
    'mmr': 'MM',
    'mne': 'ME',
    'mng': 'MN',
    'mnp': 'MP',
    'moz': 'MZ',
    'mrt': 'MR',
    'msr': 'MS',
    'mtq': 'MQ',
    'mus': 'MU',
    'mwi': 'MW',
    'mys': 'MY',
    'myt': 'YT',
    'nam': 'NA',
    'ncl': 'NC',
    'ner': 'NE',
    'nfk': 'NF',
    'nga': 'NG',
    'nh': 'VU',
    'nic': 'NI',
    'niu': 'NU',
    'nld': 'NL',
    'nor': 'no',
    'npl': 'NP',
    'nq': 'AQ',
    'nru': 'NR',
    'nt': 'SA',
    'ntz': 'SA',
    'nzl': 'NZ',
    'omn': 'OM',
    'pak': 'PK',
    'pan': 'PA',
    'pc': 'FM',
    'pcn': 'PN',
    'per': 'PE',
    'phl': 'PH',
    'plw': 'PW',
    'png': 'PG',
    'pol': 'PL',
    'pri': 'PR',
    'prk': 'KP',
    'prt': 'PT',
    'pry': 'PY',
    'pse': 'PS',
    'pu': 'UM',
    'pyf': 'PF',
    'pz': 'PA',
    'qat': 'QA',
    'qmm': 'QM',
    'qnn': 'QN',
    'qpp': 'QP',
    'qqq': 'QQ',
    'qrr': 'QR',
    'qss': 'QS',
    'qtt': 'QT',
    'qu': 'EU',
    'quu': 'EU',
    'qvv': 'QV',
    'qww': 'QW',
    'qxx': 'QX',
    'qyy': 'QY',
    'qzz': 'QZ',
    'reu': 'RE',
    'rh': 'ZW',
    'rou': 'RO',
    'rus': 'RU',
    'rwa': 'RW',
    'sau': 'SA',
    'scg': 'RS',
    'sdn': 'SD',
    'sen': 'SN',
    'sgp': 'SG',
    'sgs': 'GS',
    'shn': 'SH',
    'sjm': 'SJ',
    'slb': 'SB',
    'sle': 'SL',
    'slv': 'SV',
    'smr': 'SM',
    'som': 'SO',
    'spm': 'PM',
    'srb': 'RS',
    'ssd': 'SS',
    'stp': 'ST',
    'su': 'RU',
    'sun': 'RU',
    'sur': 'SR',
    'svk': 'SK',
    'svn': 'SI',
    'swe': 'SE',
    'swz': 'SZ',
    'sxm': 'SX',
    'syc': 'SC',
    'syr': 'SY',
    'taa': 'TA',
    'tca': 'TC',
    'tcd': 'TD',
    'tgo': 'TG',
    'tha': 'TH',
    'tjk': 'TJ',
    'tkl': 'TK',
    'tkm': 'TM',
    'tls': 'TL',
    'tmp': 'TL',
    'ton': 'TO',
    'tp': 'TL',
    'tto': 'TT',
    'tun': 'TN',
    'tur': 'TR',
    'tuv': 'TV',
    'twn': 'TW',
    'tza': 'TZ',
    'uga': 'UG',
    'uk': 'GB',
    'ukr': 'UA',
    'umi': 'UM',
    'ury': 'UY',
    'usa': 'US',
    'uzb': 'UZ',
    'vat': 'VA',
    'vct': 'VC',
    'vd': 'VN',
    'ven': 'VE',
    'vgb': 'VG',
    'vir': 'VI',
    'vnm': 'VN',
    'vut': 'VU',
    'wk': 'UM',
    'wlf': 'WF',
    'wsm': 'WS',
    'xaa': 'XA',
    'xbb': 'XB',
    'xcc': 'XC',
    'xdd': 'XD',
    'xee': 'XE',
    'xff': 'XF',
    'xgg': 'XG',
    'xhh': 'XH',
    'xii': 'XI',
    'xjj': 'XJ',
    'xkk': 'XK',
    'xll': 'XL',
    'xmm': 'XM',
    'xnn': 'XN',
    'xoo': 'XO',
    'xpp': 'XP',
    'xqq': 'XQ',
    'xrr': 'XR',
    'xss': 'XS',
    'xtt': 'XT',
    'xuu': 'XU',
    'xvv': 'XV',
    'xww': 'XW',
    'xxx': 'XX',
    'xyy': 'XY',
    'xzz': 'XZ',
    'yd': 'YE',
    'yem': 'YE',
    'ymd': 'YE',
    'yu': 'RS',
    'yug': 'RS',
    'zaf': 'ZA',
    'zar': 'CD',
    'zmb': 'ZM',
    'zr': 'CD',
    'zwe': 'ZW',
    'zzz': 'ZZ',
}
MACROLANGUAGES = {
    'aae': 'sq',
    'aao': 'ar',
    'aat': 'sq',
    'abh': 'ar',
    'abv': 'ar',
    'acm': 'ar',
    'acq': 'ar',
    'acw': 'ar',
    'acx': 'ar',
    'acy': 'ar',
    'adf': 'ar',
    'aeb': 'ar',
    'aec': 'ar',
    'afb': 'ar',
    'aii': 'syr',
    'ajp': 'ar',
    'ajt': 'jrb',
    'aju': 'jrb',
    'aln': 'sq',
    'als': 'sq',
    'apc': 'ar',
    'apd': 'ar',
    'arb': 'ar',
    'arq': 'ar',
    'ars': 'ar',
    'ary': 'ar',
    'arz': 'ar',
    'auz': 'ar',
    'avl': 'ar',
    'ayc': 'ay',
    'ayh': 'ar',
    'ayl': 'ar',
    'ayn': 'ar',
    'ayp': 'ar',
    'ayr': 'ay',
    'azb': 'az',
    'azj': 'az',
    'bbz': 'ar',
    'bcc': 'bal',
    'bcl': 'bik',
    'bdt': 'gba',
    'bgn': 'bal',
    'bgp': 'bal',
    'bgq': 'raj',
    'bhk': 'bik',
    'bhr': 'mg',
    'bjn': 'ms',
    'bjq': 'mg',
    'bln': 'bik',
    'bmm': 'mg',
    'bs': 'sh',
    'btj': 'ms',
    'bto': 'bik',
    'bve': 'ms',
    'bvu': 'ms',
    'bxk': 'luy',
    'bxm': 'bua',
    'bxr': 'bua',
    'bxu': 'bua',
    'bzc': 'mg',
    'cdo': 'zh',
    'ciw': 'oj',
    'cjy': 'zh',
    'ckb': 'ku',
    'cld': 'syr',
    'cmn': 'zh',
    'cnp': 'zh',
    'cnr': 'sh',
    'coa': 'ms',
    'cpx': 'zh',
    'cqd': 'hmn',
    'cqu': 'qu',
    'crj': 'cr',
    'crk': 'cr',
    'crl': 'cr',
    'crm': 'cr',
    'csp': 'zh',
    'csw': 'cr',
    'cts': 'bik',
    'cwd': 'cr',
    'czh': 'zh',
    'czo': 'zh',
    'dgo': 'doi',
    'dhd': 'mwr',
    'dib': 'din',
    'dik': 'din',
    'dip': 'din',
    'diq': 'zza',
    'diw': 'din',
    'dks': 'din',
    'dty': 'ne',
    'dup': 'ms',
    'ebk': 'bnc',
    'ekk': 'et',
    'emk': 'man',
    'enb': 'kln',
    'esg': 'gon',
    'esi': 'ik',
    'esk': 'ik',
    'eyo': 'kln',
    'fat': 'ak',
    'fbl': 'bik',
    'ffm': 'ff',
    'fub': 'ff',
    'fuc': 'ff',
    'fue': 'ff',
    'fuf': 'ff',
    'fuh': 'ff',
    'fui': 'ff',
    'fuq': 'ff',
    'fuv': 'ff',
    'gan': 'zh',
    'gax': 'om',
    'gaz': 'om',
    'gbo': 'grb',
    'gbp': 'gba',
    'gbq': 'gba',
    'gda': 'raj',
    'gec': 'grb',
    'gju': 'raj',
    'gkp': 'kpe',
    'gmm': 'gba',
    'gno': 'gon',
    'gnw': 'gn',
    'gom': 'kok',
    'grj': 'grb',
    'grv': 'grb',
    'gry': 'grb',
    'gso': 'gba',
    'gug': 'gn',
    'gui': 'gn',
    'gun': 'gn',
    'gya': 'gba',
    'hae': 'om',
    'hak': 'zh',
    'hax': 'hai',
    'hdn': 'hai',
    'hea': 'hmn',
    'hji': 'ms',
    'hma': 'hmn',
    'hmc': 'hmn',
    'hmd': 'hmn',
    'hme': 'hmn',
    'hmg': 'hmn',
    'hmh': 'hmn',
    'hmi': 'hmn',
    'hmj': 'hmn',
    'hml': 'hmn',
    'hmm': 'hmn',
    'hmp': 'hmn',
    'hmq': 'hmn',
    'hms': 'hmn',
    'hmw': 'hmn',
    'hmy': 'hmn',
    'hmz': 'hmn',
    'hnd': 'lah',
    'hnj': 'hmn',
    'hno': 'lah',
    'hoj': 'raj',
    'hr': 'sh',
    'hrm': 'hmn',
    'hsn': 'zh',
    'huj': 'hmn',
    'id': 'ms',
    'ida': 'luy',
    'ike': 'iu',
    'ikt': 'iu',
    'in': 'ms',
    'jak': 'ms',
    'jat': 'lah',
    'jax': 'ms',
    'jye': 'jrb',
    'kby': 'kr',
    'khk': 'mn',
    'kiu': 'zza',
    'kmr': 'ku',
    'knc': 'kr',
    'kng': 'kg',
    'knn': 'kok',
    'koi': 'kv',
    'kpv': 'kv',
    'krt': 'kr',
    'kvb': 'ms',
    'kvr': 'ms',
    'kwy': 'kg',
    'kxd': 'ms',
    'lbk': 'bnc',
    'lbl': 'bik',
    'lce': 'ms',
    'lcf': 'ms',
    'ldi': 'kg',
    'liw': 'ms',
    'lkb': 'luy',
    'lko': 'luy',
    'lks': 'luy',
    'lri': 'luy',
    'lrm': 'luy',
    'lsm': 'luy',
    'ltg': 'lv',
    'lto': 'luy',
    'lts': 'luy',
    'lvs': 'lv',
    'lwg': 'luy',
    'lzh': 'zh',
    'max': 'ms',
    'meo': 'ms',
    'mfa': 'ms',
    'mfb': 'ms',
    'mhr': 'chm',
    'min': 'ms',
    'mku': 'man',
    'mlq': 'man',
    'mmr': 'hmn',
    'mnk': 'man',
    'mnp': 'zh',
    'mqg': 'ms',
    'mrj': 'chm',
    'msc': 'man',
    'msh': 'mg',
    'msi': 'ms',
    'mtr': 'mwr',
    'mui': 'ms',
    'mup': 'raj',
    'muq': 'hmn',
    'mve': 'mwr',
    'mvf': 'mn',
    'mwk': 'man',
    'mww': 'hmn',
    'myq': 'man',
    'nan': 'zh',
    'nb': 'no',
    'nhd': 'gn',
    'niq': 'kln',
    'nle': 'luy',
    'nn': 'no',
    'npi': 'ne',
    'nyd': 'luy',
    'obk': 'bnc',
    'ojb': 'oj',
    'ojc': 'oj',
    'ojg': 'oj',
    'ojs': 'oj',
    'ojw': 'oj',
    'oki': 'kln',
    'orc': 'om',
    'orn': 'ms',
    'ors': 'ms',
    'ory': 'or',
    'otw': 'oj',
    'pbt': 'ps',
    'pbu': 'ps',
    'pel': 'ms',
    'pes': 'fa',
    'pga': 'ar',
    'phr': 'lah',
    'pko': 'kln',
    'plt': 'mg',
    'pmu': 'lah',
    'pnb': 'lah',
    'prs': 'fa',
    'pse': 'ms',
    'pst': 'ps',
    'qub': 'qu',
    'qud': 'qu',
    'quf': 'qu',
    'qug': 'qu',
    'quh': 'qu',
    'quk': 'qu',
    'qul': 'qu',
    'qup': 'qu',
    'qur': 'qu',
    'qus': 'qu',
    'quw': 'qu',
    'qux': 'qu',
    'quy': 'qu',
    'quz': 'qu',
    'qva': 'qu',
    'qvc': 'qu',
    'qve': 'qu',
    'qvh': 'qu',
    'qvi': 'qu',
    'qvj': 'qu',
    'qvl': 'qu',
    'qvm': 'qu',
    'qvn': 'qu',
    'qvo': 'qu',
    'qvp': 'qu',
    'qvs': 'qu',
    'qvw': 'qu',
    'qvz': 'qu',
    'qwa': 'qu',
    'qwc': 'qu',
    'qwh': 'qu',
    'qws': 'qu',
    'qxa': 'qu',
    'qxc': 'qu',
    'qxh': 'qu',
    'qxl': 'qu',
    'qxn': 'qu',
    'qxo': 'qu',
    'qxp': 'qu',
    'qxr': 'qu',
    'qxt': 'qu',
    'qxu': 'qu',
    'qxw': 'qu',
    'rag': 'luy',
    'rbk': 'bnc',
    'rbl': 'bik',
    'rmc': 'rom',
    'rmf': 'rom',
    'rml': 'rom',
    'rmn': 'rom',
    'rmo': 'rom',
    'rmw': 'rom',
    'rmy': 'rom',
    'rwr': 'mwr',
    'scs': 'den',
    'sdc': 'sc',
    'sdh': 'ku',
    'sdn': 'sc',
    'sfm': 'hmn',
    'sgc': 'kln',
    'shu': 'ar',
    'skg': 'mg',
    'skr': 'lah',
    'spv': 'or',
    'spy': 'kln',
    'sr': 'sh',
    'src': 'sc',
    'sro': 'sc',
    'ssh': 'ar',
    'swc': 'sw',
    'swh': 'sw',
    'swv': 'mwr',
    'taq': 'tmh',
    'tdx': 'mg',
    'tec': 'kln',
    'thv': 'tmh',
    'thz': 'tmh',
    'tkg': 'mg',
    'tmw': 'ms',
    'ttq': 'tmh',
    'tuy': 'kln',
    'tw': 'ak',
    'txy': 'mg',
    'ubl': 'bik',
    'umu': 'del',
    'unm': 'del',
    'urk': 'ms',
    'uzn': 'uz',
    'uzs': 'uz',
    'vbk': 'bnc',
    'vkk': 'ms',
    'vkt': 'ms',
    'vro': 'et',
    'wbr': 'raj',
    'wry': 'mwr',
    'wsg': 'gon',
    'wuu': 'zh',
    'xhe': 'lah',
    'xmm': 'ms',
    'xmv': 'mg',
    'xmw': 'mg',
    'xnr': 'doi',
    'xpe': 'kpe',
    'xsl': 'den',
    'ydd': 'yi',
    'yhd': 'jrb',
    'yih': 'yi',
    'yud': 'jrb',
    'yue': 'zh',
    'zaa': 'zap',
    'zab': 'zap',
    'zac': 'zap',
    'zad': 'zap',
    'zae': 'zap',
    'zaf': 'zap',
    'zai': 'zap',
    'zam': 'zap',
    'zao': 'zap',
    'zaq': 'zap',
    'zar': 'zap',
    'zas': 'zap',
    'zat': 'zap',
    'zav': 'zap',
    'zaw': 'zap',
    'zax': 'zap',
    'zca': 'zap',
    'zch': 'za',
    'zeh': 'za',
    'zgb': 'za',
    'zgm': 'za',
    'zgn': 'za',
    'zhd': 'za',
    'zhn': 'za',
    'zlj': 'za',
    'zlm': 'ms',
    'zln': 'za',
    'zlq': 'za',
    'zmi': 'ms',
    'zoo': 'zap',
    'zpa': 'zap',
    'zpb': 'zap',
    'zpc': 'zap',
    'zpd': 'zap',
    'zpe': 'zap',
    'zpf': 'zap',
    'zpg': 'zap',
    'zph': 'zap',
    'zpi': 'zap',
    'zpj': 'zap',
    'zpk': 'zap',
    'zpl': 'zap',
    'zpm': 'zap',
    'zpn': 'zap',
    'zpo': 'zap',
    'zpp': 'zap',
    'zpq': 'zap',
    'zpr': 'zap',
    'zps': 'zap',
    'zpt': 'zap',
    'zpu': 'zap',
    'zpv': 'zap',
    'zpw': 'zap',
    'zpx': 'zap',
    'zpy': 'zap',
    'zpz': 'zap',
    'zqe': 'za',
    'zsm': 'ms',
    'zsr': 'zap',
    'zte': 'zap',
    'ztg': 'zap',
    'ztl': 'zap',
    'ztm': 'zap',
    'ztn': 'zap',
    'ztp': 'zap',
    'ztq': 'zap',
    'zts': 'zap',
    'ztt': 'zap',
    'ztu': 'zap',
    'ztx': 'zap',
    'zty': 'zap',
    'zyb': 'za',
    'zyg': 'za',
    'zyj': 'za',
    'zyn': 'za',
    'zzj': 'za',
}
NORMALIZED_MACROLANGUAGES = {
    'aju': 'jrb',
    'als': 'sq',
    'arb': 'ar',
    'ayr': 'ay',
    'azj': 'az',
    'bcc': 'bal',
    'bcl': 'bik',
    'bh': 'bho',
    'bxk': 'luy',
    'bxr': 'bua',
    'cld': 'syr',
    'cmn': 'zh',
    'cwd': 'cr',
    'dgo': 'doi',
    'dhd': 'mwr',
    'dik': 'din',
    'diq': 'zza',
    'ekk': 'et',
    'emk': 'man',
    'esk': 'ik',
    'fat': 'ak',
    'fuc': 'ff',
    'gaz': 'om',
    'gbo': 'grb',
    'gno': 'gon',
    'gug': 'gn',
    'gya': 'gba',
    'hdn': 'hai',
    'hea': 'hmn',
    'him': 'srx',
    'ike': 'iu',
    'khk': 'mn',
    'kmr': 'ku',
    'knc': 'kr',
    'kng': 'kg',
    'knn': 'kok',
    'kpv': 'kv',
    'lbk': 'bnc',
    'lvs': 'lv',
    'mhr': 'chm',
    'mnk': 'man',
    'mup': 'raj',
    'npi': 'ne',
    'ojg': 'oj',
    'ory': 'or',
    'pbu': 'ps',
    'pes': 'fa',
    'plt': 'mg',
    'pnb': 'lah',
    'quz': 'qu',
    'rmy': 'rom',
    'spy': 'kln',
    'src': 'sc',
    'swh': 'sw',
    'ttq': 'tmh',
    'tw': 'ak',
    'umu': 'del',
    'uzn': 'uz',
    'xpe': 'kpe',
    'xsl': 'den',
    'ydd': 'yi',
    'zai': 'zap',
    'zsm': 'ms',
    'zyb': 'za',
}
LIKELY_SUBTAGS = {
    'aa': 'aa-Latn-ET',
    'aai': 'aai-Latn-ZZ',
    'aak': 'aak-Latn-ZZ',
    'aau': 'aau-Latn-ZZ',
    'ab': 'ab-Cyrl-GE',
    'abi': 'abi-Latn-ZZ',
    'abq': 'abq-Cyrl-ZZ',
    'abr': 'abr-Latn-GH',
    'abt': 'abt-Latn-ZZ',
    'aby': 'aby-Latn-ZZ',
    'acd': 'acd-Latn-ZZ',
    'ace': 'ace-Latn-ID',
    'ach': 'ach-Latn-UG',
    'ada': 'ada-Latn-GH',
    'ade': 'ade-Latn-ZZ',
    'adj': 'adj-Latn-ZZ',
    'adp': 'adp-Tibt-BT',
    'ady': 'ady-Cyrl-RU',
    'adz': 'adz-Latn-ZZ',
    'ae': 'ae-Avst-IR',
    'aeb': 'aeb-Arab-TN',
    'aey': 'aey-Latn-ZZ',
    'af': 'af-Latn-ZA',
    'agc': 'agc-Latn-ZZ',
    'agd': 'agd-Latn-ZZ',
    'agg': 'agg-Latn-ZZ',
    'agm': 'agm-Latn-ZZ',
    'ago': 'ago-Latn-ZZ',
    'agq': 'agq-Latn-CM',
    'aha': 'aha-Latn-ZZ',
    'ahl': 'ahl-Latn-ZZ',
    'aho': 'aho-Ahom-IN',
    'ajg': 'ajg-Latn-ZZ',
    'ak': 'ak-Latn-GH',
    'akk': 'akk-Xsux-IQ',
    'ala': 'ala-Latn-ZZ',
    'ali': 'ali-Latn-ZZ',
    'aln': 'aln-Latn-XK',
    'alt': 'alt-Cyrl-RU',
    'am': 'am-Ethi-ET',
    'amm': 'amm-Latn-ZZ',
    'amn': 'amn-Latn-ZZ',
    'amo': 'amo-Latn-NG',
    'amp': 'amp-Latn-ZZ',
    'an': 'an-Latn-ES',
    'anc': 'anc-Latn-ZZ',
    'ank': 'ank-Latn-ZZ',
    'ann': 'ann-Latn-ZZ',
    'any': 'any-Latn-ZZ',
    'aoj': 'aoj-Latn-ZZ',
    'aom': 'aom-Latn-ZZ',
    'aoz': 'aoz-Latn-ID',
    'apc': 'apc-Arab-ZZ',
    'apd': 'apd-Arab-TG',
    'ape': 'ape-Latn-ZZ',
    'apr': 'apr-Latn-ZZ',
    'aps': 'aps-Latn-ZZ',
    'apz': 'apz-Latn-ZZ',
    'ar': 'ar-Arab-EG',
    'arc': 'arc-Armi-IR',
    'arc-Nbat': 'arc-Nbat-JO',
    'arc-Palm': 'arc-Palm-SY',
    'arh': 'arh-Latn-ZZ',
    'arn': 'arn-Latn-CL',
    'aro': 'aro-Latn-BO',
    'arq': 'arq-Arab-DZ',
    'ars': 'ars-Arab-SA',
    'ary': 'ary-Arab-MA',
    'arz': 'arz-Arab-EG',
    'as': 'as-Beng-IN',
    'asa': 'asa-Latn-TZ',
    'ase': 'ase-Sgnw-US',
    'asg': 'asg-Latn-ZZ',
    'aso': 'aso-Latn-ZZ',
    'ast': 'ast-Latn-ES',
    'ata': 'ata-Latn-ZZ',
    'atg': 'atg-Latn-ZZ',
    'atj': 'atj-Latn-CA',
    'auy': 'auy-Latn-ZZ',
    'av': 'av-Cyrl-RU',
    'avl': 'avl-Arab-ZZ',
    'avn': 'avn-Latn-ZZ',
    'avt': 'avt-Latn-ZZ',
    'avu': 'avu-Latn-ZZ',
    'awa': 'awa-Deva-IN',
    'awb': 'awb-Latn-ZZ',
    'awo': 'awo-Latn-ZZ',
    'awx': 'awx-Latn-ZZ',
    'ay': 'ay-Latn-BO',
    'ayb': 'ayb-Latn-ZZ',
    'az': 'az-Latn-AZ',
    'az-Arab': 'az-Arab-IR',
    'az-IQ': 'az-Arab-IQ',
    'az-IR': 'az-Arab-IR',
    'az-RU': 'az-Cyrl-RU',
    'ba': 'ba-Cyrl-RU',
    'bal': 'bal-Arab-PK',
    'ban': 'ban-Latn-ID',
    'bap': 'bap-Deva-NP',
    'bar': 'bar-Latn-AT',
    'bas': 'bas-Latn-CM',
    'bav': 'bav-Latn-ZZ',
    'bax': 'bax-Bamu-CM',
    'bba': 'bba-Latn-ZZ',
    'bbb': 'bbb-Latn-ZZ',
    'bbc': 'bbc-Latn-ID',
    'bbd': 'bbd-Latn-ZZ',
    'bbj': 'bbj-Latn-CM',
    'bbp': 'bbp-Latn-ZZ',
    'bbr': 'bbr-Latn-ZZ',
    'bcf': 'bcf-Latn-ZZ',
    'bch': 'bch-Latn-ZZ',
    'bci': 'bci-Latn-CI',
    'bcm': 'bcm-Latn-ZZ',
    'bcn': 'bcn-Latn-ZZ',
    'bco': 'bco-Latn-ZZ',
    'bcq': 'bcq-Ethi-ZZ',
    'bcu': 'bcu-Latn-ZZ',
    'bdd': 'bdd-Latn-ZZ',
    'be': 'be-Cyrl-BY',
    'bef': 'bef-Latn-ZZ',
    'beh': 'beh-Latn-ZZ',
    'bej': 'bej-Arab-SD',
    'bem': 'bem-Latn-ZM',
    'bet': 'bet-Latn-ZZ',
    'bew': 'bew-Latn-ID',
    'bex': 'bex-Latn-ZZ',
    'bez': 'bez-Latn-TZ',
    'bfd': 'bfd-Latn-CM',
    'bfq': 'bfq-Taml-IN',
    'bft': 'bft-Arab-PK',
    'bfy': 'bfy-Deva-IN',
    'bg': 'bg-Cyrl-BG',
    'bgc': 'bgc-Deva-IN',
    'bgn': 'bgn-Arab-PK',
    'bgx': 'bgx-Grek-TR',
    'bhb': 'bhb-Deva-IN',
    'bhg': 'bhg-Latn-ZZ',
    'bhi': 'bhi-Deva-IN',
    'bhl': 'bhl-Latn-ZZ',
    'bho': 'bho-Deva-IN',
    'bhy': 'bhy-Latn-ZZ',
    'bi': 'bi-Latn-VU',
    'bib': 'bib-Latn-ZZ',
    'big': 'big-Latn-ZZ',
    'bik': 'bik-Latn-PH',
    'bim': 'bim-Latn-ZZ',
    'bin': 'bin-Latn-NG',
    'bio': 'bio-Latn-ZZ',
    'biq': 'biq-Latn-ZZ',
    'bjh': 'bjh-Latn-ZZ',
    'bji': 'bji-Ethi-ZZ',
    'bjj': 'bjj-Deva-IN',
    'bjn': 'bjn-Latn-ID',
    'bjo': 'bjo-Latn-ZZ',
    'bjr': 'bjr-Latn-ZZ',
    'bjt': 'bjt-Latn-SN',
    'bjz': 'bjz-Latn-ZZ',
    'bkc': 'bkc-Latn-ZZ',
    'bkm': 'bkm-Latn-CM',
    'bkq': 'bkq-Latn-ZZ',
    'bku': 'bku-Latn-PH',
    'bkv': 'bkv-Latn-ZZ',
    'blg': 'blg-Latn-MY',
    'blt': 'blt-Tavt-VN',
    'bm': 'bm-Latn-ML',
    'bmh': 'bmh-Latn-ZZ',
    'bmk': 'bmk-Latn-ZZ',
    'bmq': 'bmq-Latn-ML',
    'bmu': 'bmu-Latn-ZZ',
    'bn': 'bn-Beng-BD',
    'bng': 'bng-Latn-ZZ',
    'bnm': 'bnm-Latn-ZZ',
    'bnp': 'bnp-Latn-ZZ',
    'bo': 'bo-Tibt-CN',
    'boj': 'boj-Latn-ZZ',
    'bom': 'bom-Latn-ZZ',
    'bon': 'bon-Latn-ZZ',
    'bpy': 'bpy-Beng-IN',
    'bqc': 'bqc-Latn-ZZ',
    'bqi': 'bqi-Arab-IR',
    'bqp': 'bqp-Latn-ZZ',
    'bqv': 'bqv-Latn-CI',
    'br': 'br-Latn-FR',
    'bra': 'bra-Deva-IN',
    'brh': 'brh-Arab-PK',
    'brx': 'brx-Deva-IN',
    'brz': 'brz-Latn-ZZ',
    'bs': 'bs-Latn-BA',
    'bsj': 'bsj-Latn-ZZ',
    'bsq': 'bsq-Bass-LR',
    'bss': 'bss-Latn-CM',
    'bst': 'bst-Ethi-ZZ',
    'bto': 'bto-Latn-PH',
    'btt': 'btt-Latn-ZZ',
    'btv': 'btv-Deva-PK',
    'bua': 'bua-Cyrl-RU',
    'buc': 'buc-Latn-YT',
    'bud': 'bud-Latn-ZZ',
    'bug': 'bug-Latn-ID',
    'buk': 'buk-Latn-ZZ',
    'bum': 'bum-Latn-CM',
    'buo': 'buo-Latn-ZZ',
    'bus': 'bus-Latn-ZZ',
    'buu': 'buu-Latn-ZZ',
    'bvb': 'bvb-Latn-GQ',
    'bwd': 'bwd-Latn-ZZ',
    'bwr': 'bwr-Latn-ZZ',
    'bxh': 'bxh-Latn-ZZ',
    'bye': 'bye-Latn-ZZ',
    'byn': 'byn-Ethi-ER',
    'byr': 'byr-Latn-ZZ',
    'bys': 'bys-Latn-ZZ',
    'byv': 'byv-Latn-CM',
    'byx': 'byx-Latn-ZZ',
    'bza': 'bza-Latn-ZZ',
    'bze': 'bze-Latn-ML',
    'bzf': 'bzf-Latn-ZZ',
    'bzh': 'bzh-Latn-ZZ',
    'bzw': 'bzw-Latn-ZZ',
    'ca': 'ca-Latn-ES',
    'cad': 'cad-Latn-US',
    'can': 'can-Latn-ZZ',
    'cbj': 'cbj-Latn-ZZ',
    'cch': 'cch-Latn-NG',
    'ccp': 'ccp-Cakm-BD',
    'ce': 'ce-Cyrl-RU',
    'ceb': 'ceb-Latn-PH',
    'cfa': 'cfa-Latn-ZZ',
    'cgg': 'cgg-Latn-UG',
    'ch': 'ch-Latn-GU',
    'chk': 'chk-Latn-FM',
    'chm': 'chm-Cyrl-RU',
    'cho': 'cho-Latn-US',
    'chp': 'chp-Latn-CA',
    'chr': 'chr-Cher-US',
    'cic': 'cic-Latn-US',
    'cja': 'cja-Arab-KH',
    'cjm': 'cjm-Cham-VN',
    'cjv': 'cjv-Latn-ZZ',
    'ckb': 'ckb-Arab-IQ',
    'ckl': 'ckl-Latn-ZZ',
    'cko': 'cko-Latn-ZZ',
    'cky': 'cky-Latn-ZZ',
    'cla': 'cla-Latn-ZZ',
    'cme': 'cme-Latn-ZZ',
    'cmg': 'cmg-Soyo-MN',
    'co': 'co-Latn-FR',
    'cop': 'cop-Copt-EG',
    'cps': 'cps-Latn-PH',
    'cr': 'cr-Cans-CA',
    'crh': 'crh-Cyrl-UA',
    'crj': 'crj-Cans-CA',
    'crk': 'crk-Cans-CA',
    'crl': 'crl-Cans-CA',
    'crm': 'crm-Cans-CA',
    'crs': 'crs-Latn-SC',
    'cs': 'cs-Latn-CZ',
    'csb': 'csb-Latn-PL',
    'csw': 'csw-Cans-CA',
    'ctd': 'ctd-Pauc-MM',
    'cu': 'cu-Cyrl-RU',
    'cu-Glag': 'cu-Glag-BG',
    'cv': 'cv-Cyrl-RU',
    'cy': 'cy-Latn-GB',
    'da': 'da-Latn-DK',
    'dad': 'dad-Latn-ZZ',
    'daf': 'daf-Latn-CI',
    'dag': 'dag-Latn-ZZ',
    'dah': 'dah-Latn-ZZ',
    'dak': 'dak-Latn-US',
    'dar': 'dar-Cyrl-RU',
    'dav': 'dav-Latn-KE',
    'dbd': 'dbd-Latn-ZZ',
    'dbq': 'dbq-Latn-ZZ',
    'dcc': 'dcc-Arab-IN',
    'ddn': 'ddn-Latn-ZZ',
    'de': 'de-Latn-DE',
    'ded': 'ded-Latn-ZZ',
    'den': 'den-Latn-CA',
    'dga': 'dga-Latn-ZZ',
    'dgh': 'dgh-Latn-ZZ',
    'dgi': 'dgi-Latn-ZZ',
    'dgl': 'dgl-Arab-ZZ',
    'dgr': 'dgr-Latn-CA',
    'dgz': 'dgz-Latn-ZZ',
    'dia': 'dia-Latn-ZZ',
    'dje': 'dje-Latn-NE',
    'dmf': 'dmf-Medf-NG',
    'dnj': 'dnj-Latn-CI',
    'dob': 'dob-Latn-ZZ',
    'doi': 'doi-Deva-IN',
    'dop': 'dop-Latn-ZZ',
    'dow': 'dow-Latn-ZZ',
    'drh': 'drh-Mong-CN',
    'dri': 'dri-Latn-ZZ',
    'drs': 'drs-Ethi-ZZ',
    'dsb': 'dsb-Latn-DE',
    'dtm': 'dtm-Latn-ML',
    'dtp': 'dtp-Latn-MY',
    'dts': 'dts-Latn-ZZ',
    'dty': 'dty-Deva-NP',
    'dua': 'dua-Latn-CM',
    'duc': 'duc-Latn-ZZ',
    'dud': 'dud-Latn-ZZ',
    'dug': 'dug-Latn-ZZ',
    'dv': 'dv-Thaa-MV',
    'dva': 'dva-Latn-ZZ',
    'dww': 'dww-Latn-ZZ',
    'dyo': 'dyo-Latn-SN',
    'dyu': 'dyu-Latn-BF',
    'dz': 'dz-Tibt-BT',
    'dzg': 'dzg-Latn-ZZ',
    'ebu': 'ebu-Latn-KE',
    'ee': 'ee-Latn-GH',
    'efi': 'efi-Latn-NG',
    'egl': 'egl-Latn-IT',
    'egy': 'egy-Egyp-EG',
    'eka': 'eka-Latn-ZZ',
    'eky': 'eky-Kali-MM',
    'el': 'el-Grek-GR',
    'ema': 'ema-Latn-ZZ',
    'emi': 'emi-Latn-ZZ',
    'en': 'en-Latn-US',
    'en-Shaw': 'en-Shaw-GB',
    'enn': 'enn-Latn-ZZ',
    'enq': 'enq-Latn-ZZ',
    'eo': 'eo-Latn-001',
    'eri': 'eri-Latn-ZZ',
    'es': 'es-Latn-ES',
    'esg': 'esg-Gonm-IN',
    'esu': 'esu-Latn-US',
    'et': 'et-Latn-EE',
    'etr': 'etr-Latn-ZZ',
    'ett': 'ett-Ital-IT',
    'etu': 'etu-Latn-ZZ',
    'etx': 'etx-Latn-ZZ',
    'eu': 'eu-Latn-ES',
    'ewo': 'ewo-Latn-CM',
    'ext': 'ext-Latn-ES',
    'eza': 'eza-Latn-ZZ',
    'fa': 'fa-Arab-IR',
    'faa': 'faa-Latn-ZZ',
    'fab': 'fab-Latn-ZZ',
    'fag': 'fag-Latn-ZZ',
    'fai': 'fai-Latn-ZZ',
    'fan': 'fan-Latn-GQ',
    'ff': 'ff-Latn-SN',
    'ff-Adlm': 'ff-Adlm-GN',
    'ffi': 'ffi-Latn-ZZ',
    'ffm': 'ffm-Latn-ML',
    'fi': 'fi-Latn-FI',
    'fia': 'fia-Arab-SD',
    'fil': 'fil-Latn-PH',
    'fit': 'fit-Latn-SE',
    'fj': 'fj-Latn-FJ',
    'flr': 'flr-Latn-ZZ',
    'fmp': 'fmp-Latn-ZZ',
    'fo': 'fo-Latn-FO',
    'fod': 'fod-Latn-ZZ',
    'fon': 'fon-Latn-BJ',
    'for': 'for-Latn-ZZ',
    'fpe': 'fpe-Latn-ZZ',
    'fqs': 'fqs-Latn-ZZ',
    'fr': 'fr-Latn-FR',
    'frc': 'frc-Latn-US',
    'frp': 'frp-Latn-FR',
    'frr': 'frr-Latn-DE',
    'frs': 'frs-Latn-DE',
    'fub': 'fub-Arab-CM',
    'fud': 'fud-Latn-WF',
    'fue': 'fue-Latn-ZZ',
    'fuf': 'fuf-Latn-GN',
    'fuh': 'fuh-Latn-ZZ',
    'fuq': 'fuq-Latn-NE',
    'fur': 'fur-Latn-IT',
    'fuv': 'fuv-Latn-NG',
    'fuy': 'fuy-Latn-ZZ',
    'fvr': 'fvr-Latn-SD',
    'fy': 'fy-Latn-NL',
    'ga': 'ga-Latn-IE',
    'gaa': 'gaa-Latn-GH',
    'gaf': 'gaf-Latn-ZZ',
    'gag': 'gag-Latn-MD',
    'gah': 'gah-Latn-ZZ',
    'gaj': 'gaj-Latn-ZZ',
    'gam': 'gam-Latn-ZZ',
    'gan': 'gan-Hans-CN',
    'gaw': 'gaw-Latn-ZZ',
    'gay': 'gay-Latn-ID',
    'gba': 'gba-Latn-ZZ',
    'gbf': 'gbf-Latn-ZZ',
    'gbm': 'gbm-Deva-IN',
    'gby': 'gby-Latn-ZZ',
    'gbz': 'gbz-Arab-IR',
    'gcr': 'gcr-Latn-GF',
    'gd': 'gd-Latn-GB',
    'gde': 'gde-Latn-ZZ',
    'gdn': 'gdn-Latn-ZZ',
    'gdr': 'gdr-Latn-ZZ',
    'geb': 'geb-Latn-ZZ',
    'gej': 'gej-Latn-ZZ',
    'gel': 'gel-Latn-ZZ',
    'gez': 'gez-Ethi-ET',
    'gfk': 'gfk-Latn-ZZ',
    'ggn': 'ggn-Deva-NP',
    'ghs': 'ghs-Latn-ZZ',
    'gil': 'gil-Latn-KI',
    'gim': 'gim-Latn-ZZ',
    'gjk': 'gjk-Arab-PK',
    'gjn': 'gjn-Latn-ZZ',
    'gju': 'gju-Arab-PK',
    'gkn': 'gkn-Latn-ZZ',
    'gkp': 'gkp-Latn-ZZ',
    'gl': 'gl-Latn-ES',
    'glk': 'glk-Arab-IR',
    'gmm': 'gmm-Latn-ZZ',
    'gmv': 'gmv-Ethi-ZZ',
    'gn': 'gn-Latn-PY',
    'gnd': 'gnd-Latn-ZZ',
    'gng': 'gng-Latn-ZZ',
    'god': 'god-Latn-ZZ',
    'gof': 'gof-Ethi-ZZ',
    'goi': 'goi-Latn-ZZ',
    'gom': 'gom-Deva-IN',
    'gon': 'gon-Telu-IN',
    'gor': 'gor-Latn-ID',
    'gos': 'gos-Latn-NL',
    'got': 'got-Goth-UA',
    'grb': 'grb-Latn-ZZ',
    'grc': 'grc-Cprt-CY',
    'grc-Linb': 'grc-Linb-GR',
    'grt': 'grt-Beng-IN',
    'grw': 'grw-Latn-ZZ',
    'gsw': 'gsw-Latn-CH',
    'gu': 'gu-Gujr-IN',
    'gub': 'gub-Latn-BR',
    'guc': 'guc-Latn-CO',
    'gud': 'gud-Latn-ZZ',
    'gur': 'gur-Latn-GH',
    'guw': 'guw-Latn-ZZ',
    'gux': 'gux-Latn-ZZ',
    'guz': 'guz-Latn-KE',
    'gv': 'gv-Latn-IM',
    'gvf': 'gvf-Latn-ZZ',
    'gvr': 'gvr-Deva-NP',
    'gvs': 'gvs-Latn-ZZ',
    'gwc': 'gwc-Arab-ZZ',
    'gwi': 'gwi-Latn-CA',
    'gwt': 'gwt-Arab-ZZ',
    'gyi': 'gyi-Latn-ZZ',
    'ha': 'ha-Latn-NG',
    'ha-CM': 'ha-Arab-CM',
    'ha-SD': 'ha-Arab-SD',
    'hag': 'hag-Latn-ZZ',
    'hak': 'hak-Hans-CN',
    'ham': 'ham-Latn-ZZ',
    'haw': 'haw-Latn-US',
    'haz': 'haz-Arab-AF',
    'hbb': 'hbb-Latn-ZZ',
    'hdy': 'hdy-Ethi-ZZ',
    'he': 'he-Hebr-IL',
    'hhy': 'hhy-Latn-ZZ',
    'hi': 'hi-Deva-IN',
    'hia': 'hia-Latn-ZZ',
    'hif': 'hif-Latn-FJ',
    'hig': 'hig-Latn-ZZ',
    'hih': 'hih-Latn-ZZ',
    'hil': 'hil-Latn-PH',
    'hla': 'hla-Latn-ZZ',
    'hlu': 'hlu-Hluw-TR',
    'hmd': 'hmd-Plrd-CN',
    'hmt': 'hmt-Latn-ZZ',
    'hnd': 'hnd-Arab-PK',
    'hne': 'hne-Deva-IN',
    'hnj': 'hnj-Hmnp-US',
    'hnn': 'hnn-Latn-PH',
    'hno': 'hno-Arab-PK',
    'ho': 'ho-Latn-PG',
    'hoc': 'hoc-Deva-IN',
    'hoj': 'hoj-Deva-IN',
    'hot': 'hot-Latn-ZZ',
    'hr': 'hr-Latn-HR',
    'hsb': 'hsb-Latn-DE',
    'hsn': 'hsn-Hans-CN',
    'ht': 'ht-Latn-HT',
    'hu': 'hu-Latn-HU',
    'hui': 'hui-Latn-ZZ',
    'hy': 'hy-Armn-AM',
    'hz': 'hz-Latn-NA',
    'ia': 'ia-Latn-001',
    'ian': 'ian-Latn-ZZ',
    'iar': 'iar-Latn-ZZ',
    'iba': 'iba-Latn-MY',
    'ibb': 'ibb-Latn-NG',
    'iby': 'iby-Latn-ZZ',
    'ica': 'ica-Latn-ZZ',
    'ich': 'ich-Latn-ZZ',
    'id': 'id-Latn-ID',
    'idd': 'idd-Latn-ZZ',
    'idi': 'idi-Latn-ZZ',
    'idu': 'idu-Latn-ZZ',
    'ife': 'ife-Latn-TG',
    'ig': 'ig-Latn-NG',
    'igb': 'igb-Latn-ZZ',
    'ige': 'ige-Latn-ZZ',
    'ii': 'ii-Yiii-CN',
    'ijj': 'ijj-Latn-ZZ',
    'ik': 'ik-Latn-US',
    'ikk': 'ikk-Latn-ZZ',
    'ikt': 'ikt-Latn-CA',
    'ikw': 'ikw-Latn-ZZ',
    'ikx': 'ikx-Latn-ZZ',
    'ilo': 'ilo-Latn-PH',
    'imo': 'imo-Latn-ZZ',
    'in': 'in-Latn-ID',
    'inh': 'inh-Cyrl-RU',
    'io': 'io-Latn-001',
    'iou': 'iou-Latn-ZZ',
    'iri': 'iri-Latn-ZZ',
    'is': 'is-Latn-IS',
    'it': 'it-Latn-IT',
    'iu': 'iu-Cans-CA',
    'iw': 'iw-Hebr-IL',
    'iwm': 'iwm-Latn-ZZ',
    'iws': 'iws-Latn-ZZ',
    'izh': 'izh-Latn-RU',
    'izi': 'izi-Latn-ZZ',
    'ja': 'ja-Jpan-JP',
    'jab': 'jab-Latn-ZZ',
    'jam': 'jam-Latn-JM',
    'jar': 'jar-Latn-ZZ',
    'jbo': 'jbo-Latn-001',
    'jbu': 'jbu-Latn-ZZ',
    'jen': 'jen-Latn-ZZ',
    'jgk': 'jgk-Latn-ZZ',
    'jgo': 'jgo-Latn-CM',
    'ji': 'ji-Hebr-UA',
    'jib': 'jib-Latn-ZZ',
    'jmc': 'jmc-Latn-TZ',
    'jml': 'jml-Deva-NP',
    'jra': 'jra-Latn-ZZ',
    'jut': 'jut-Latn-DK',
    'jv': 'jv-Latn-ID',
    'jw': 'jw-Latn-ID',
    'ka': 'ka-Geor-GE',
    'kaa': 'kaa-Cyrl-UZ',
    'kab': 'kab-Latn-DZ',
    'kac': 'kac-Latn-MM',
    'kad': 'kad-Latn-ZZ',
    'kai': 'kai-Latn-ZZ',
    'kaj': 'kaj-Latn-NG',
    'kam': 'kam-Latn-KE',
    'kao': 'kao-Latn-ML',
    'kbd': 'kbd-Cyrl-RU',
    'kbm': 'kbm-Latn-ZZ',
    'kbp': 'kbp-Latn-ZZ',
    'kbq': 'kbq-Latn-ZZ',
    'kbx': 'kbx-Latn-ZZ',
    'kby': 'kby-Arab-NE',
    'kcg': 'kcg-Latn-NG',
    'kck': 'kck-Latn-ZW',
    'kcl': 'kcl-Latn-ZZ',
    'kct': 'kct-Latn-ZZ',
    'kde': 'kde-Latn-TZ',
    'kdh': 'kdh-Latn-TG',
    'kdl': 'kdl-Latn-ZZ',
    'kdt': 'kdt-Thai-TH',
    'kea': 'kea-Latn-CV',
    'ken': 'ken-Latn-CM',
    'kez': 'kez-Latn-ZZ',
    'kfo': 'kfo-Latn-CI',
    'kfr': 'kfr-Deva-IN',
    'kfy': 'kfy-Deva-IN',
    'kg': 'kg-Latn-CD',
    'kge': 'kge-Latn-ID',
    'kgf': 'kgf-Latn-ZZ',
    'kgp': 'kgp-Latn-BR',
    'kha': 'kha-Latn-IN',
    'khb': 'khb-Talu-CN',
    'khn': 'khn-Deva-IN',
    'khq': 'khq-Latn-ML',
    'khs': 'khs-Latn-ZZ',
    'kht': 'kht-Mymr-IN',
    'khw': 'khw-Arab-PK',
    'khz': 'khz-Latn-ZZ',
    'ki': 'ki-Latn-KE',
    'kij': 'kij-Latn-ZZ',
    'kiu': 'kiu-Latn-TR',
    'kiw': 'kiw-Latn-ZZ',
    'kj': 'kj-Latn-NA',
    'kjd': 'kjd-Latn-ZZ',
    'kjg': 'kjg-Laoo-LA',
    'kjs': 'kjs-Latn-ZZ',
    'kjy': 'kjy-Latn-ZZ',
    'kk': 'kk-Cyrl-KZ',
    'kk-AF': 'kk-Arab-AF',
    'kk-Arab': 'kk-Arab-CN',
    'kk-CN': 'kk-Arab-CN',
    'kk-IR': 'kk-Arab-IR',
    'kk-MN': 'kk-Arab-MN',
    'kkc': 'kkc-Latn-ZZ',
    'kkj': 'kkj-Latn-CM',
    'kl': 'kl-Latn-GL',
    'kln': 'kln-Latn-KE',
    'klq': 'klq-Latn-ZZ',
    'klt': 'klt-Latn-ZZ',
    'klx': 'klx-Latn-ZZ',
    'km': 'km-Khmr-KH',
    'kmb': 'kmb-Latn-AO',
    'kmh': 'kmh-Latn-ZZ',
    'kmo': 'kmo-Latn-ZZ',
    'kms': 'kms-Latn-ZZ',
    'kmu': 'kmu-Latn-ZZ',
    'kmw': 'kmw-Latn-ZZ',
    'kn': 'kn-Knda-IN',
    'knf': 'knf-Latn-GW',
    'knp': 'knp-Latn-ZZ',
    'ko': 'ko-Kore-KR',
    'koi': 'koi-Cyrl-RU',
    'kok': 'kok-Deva-IN',
    'kol': 'kol-Latn-ZZ',
    'kos': 'kos-Latn-FM',
    'koz': 'koz-Latn-ZZ',
    'kpe': 'kpe-Latn-LR',
    'kpf': 'kpf-Latn-ZZ',
    'kpo': 'kpo-Latn-ZZ',
    'kpr': 'kpr-Latn-ZZ',
    'kpx': 'kpx-Latn-ZZ',
    'kqb': 'kqb-Latn-ZZ',
    'kqf': 'kqf-Latn-ZZ',
    'kqs': 'kqs-Latn-ZZ',
    'kqy': 'kqy-Ethi-ZZ',
    'kr': 'kr-Latn-ZZ',
    'krc': 'krc-Cyrl-RU',
    'kri': 'kri-Latn-SL',
    'krj': 'krj-Latn-PH',
    'krl': 'krl-Latn-RU',
    'krs': 'krs-Latn-ZZ',
    'kru': 'kru-Deva-IN',
    'ks': 'ks-Arab-IN',
    'ksb': 'ksb-Latn-TZ',
    'ksd': 'ksd-Latn-ZZ',
    'ksf': 'ksf-Latn-CM',
    'ksh': 'ksh-Latn-DE',
    'ksj': 'ksj-Latn-ZZ',
    'ksr': 'ksr-Latn-ZZ',
    'ktb': 'ktb-Ethi-ZZ',
    'ktm': 'ktm-Latn-ZZ',
    'kto': 'kto-Latn-ZZ',
    'ktr': 'ktr-Latn-MY',
    'ku': 'ku-Latn-TR',
    'ku-Arab': 'ku-Arab-IQ',
    'ku-LB': 'ku-Arab-LB',
    'ku-Yezi': 'ku-Yezi-GE',
    'kub': 'kub-Latn-ZZ',
    'kud': 'kud-Latn-ZZ',
    'kue': 'kue-Latn-ZZ',
    'kuj': 'kuj-Latn-ZZ',
    'kum': 'kum-Cyrl-RU',
    'kun': 'kun-Latn-ZZ',
    'kup': 'kup-Latn-ZZ',
    'kus': 'kus-Latn-ZZ',
    'kv': 'kv-Cyrl-RU',
    'kvg': 'kvg-Latn-ZZ',
    'kvr': 'kvr-Latn-ID',
    'kvx': 'kvx-Arab-PK',
    'kw': 'kw-Latn-GB',
    'kwj': 'kwj-Latn-ZZ',
    'kwo': 'kwo-Latn-ZZ',
    'kwq': 'kwq-Latn-ZZ',
    'kxa': 'kxa-Latn-ZZ',
    'kxc': 'kxc-Ethi-ZZ',
    'kxe': 'kxe-Latn-ZZ',
    'kxl': 'kxl-Deva-IN',
    'kxm': 'kxm-Thai-TH',
    'kxp': 'kxp-Arab-PK',
    'kxw': 'kxw-Latn-ZZ',
    'kxz': 'kxz-Latn-ZZ',
    'ky': 'ky-Cyrl-KG',
    'ky-Arab': 'ky-Arab-CN',
    'ky-CN': 'ky-Arab-CN',
    'ky-Latn': 'ky-Latn-TR',
    'ky-TR': 'ky-Latn-TR',
    'kye': 'kye-Latn-ZZ',
    'kyx': 'kyx-Latn-ZZ',
    'kzh': 'kzh-Arab-ZZ',
    'kzj': 'kzj-Latn-MY',
    'kzr': 'kzr-Latn-ZZ',
    'kzt': 'kzt-Latn-MY',
    'la': 'la-Latn-VA',
    'lab': 'lab-Lina-GR',
    'lad': 'lad-Hebr-IL',
    'lag': 'lag-Latn-TZ',
    'lah': 'lah-Arab-PK',
    'laj': 'laj-Latn-UG',
    'las': 'las-Latn-ZZ',
    'lb': 'lb-Latn-LU',
    'lbe': 'lbe-Cyrl-RU',
    'lbu': 'lbu-Latn-ZZ',
    'lbw': 'lbw-Latn-ID',
    'lcm': 'lcm-Latn-ZZ',
    'lcp': 'lcp-Thai-CN',
    'ldb': 'ldb-Latn-ZZ',
    'led': 'led-Latn-ZZ',
    'lee': 'lee-Latn-ZZ',
    'lem': 'lem-Latn-ZZ',
    'lep': 'lep-Lepc-IN',
    'leq': 'leq-Latn-ZZ',
    'leu': 'leu-Latn-ZZ',
    'lez': 'lez-Cyrl-RU',
    'lg': 'lg-Latn-UG',
    'lgg': 'lgg-Latn-ZZ',
    'li': 'li-Latn-NL',
    'lia': 'lia-Latn-ZZ',
    'lid': 'lid-Latn-ZZ',
    'lif': 'lif-Deva-NP',
    'lif-Limb': 'lif-Limb-IN',
    'lig': 'lig-Latn-ZZ',
    'lih': 'lih-Latn-ZZ',
    'lij': 'lij-Latn-IT',
    'lis': 'lis-Lisu-CN',
    'ljp': 'ljp-Latn-ID',
    'lki': 'lki-Arab-IR',
    'lkt': 'lkt-Latn-US',
    'lle': 'lle-Latn-ZZ',
    'lln': 'lln-Latn-ZZ',
    'lmn': 'lmn-Telu-IN',
    'lmo': 'lmo-Latn-IT',
    'lmp': 'lmp-Latn-ZZ',
    'ln': 'ln-Latn-CD',
    'lns': 'lns-Latn-ZZ',
    'lnu': 'lnu-Latn-ZZ',
    'lo': 'lo-Laoo-LA',
    'loj': 'loj-Latn-ZZ',
    'lok': 'lok-Latn-ZZ',
    'lol': 'lol-Latn-CD',
    'lor': 'lor-Latn-ZZ',
    'los': 'los-Latn-ZZ',
    'loz': 'loz-Latn-ZM',
    'lrc': 'lrc-Arab-IR',
    'lt': 'lt-Latn-LT',
    'ltg': 'ltg-Latn-LV',
    'lu': 'lu-Latn-CD',
    'lua': 'lua-Latn-CD',
    'luo': 'luo-Latn-KE',
    'luy': 'luy-Latn-KE',
    'luz': 'luz-Arab-IR',
    'lv': 'lv-Latn-LV',
    'lwl': 'lwl-Thai-TH',
    'lzh': 'lzh-Hans-CN',
    'lzz': 'lzz-Latn-TR',
    'mad': 'mad-Latn-ID',
    'maf': 'maf-Latn-CM',
    'mag': 'mag-Deva-IN',
    'mai': 'mai-Deva-IN',
    'mak': 'mak-Latn-ID',
    'man': 'man-Latn-GM',
    'man-GN': 'man-Nkoo-GN',
    'man-Nkoo': 'man-Nkoo-GN',
    'mas': 'mas-Latn-KE',
    'maw': 'maw-Latn-ZZ',
    'maz': 'maz-Latn-MX',
    'mbh': 'mbh-Latn-ZZ',
    'mbo': 'mbo-Latn-ZZ',
    'mbq': 'mbq-Latn-ZZ',
    'mbu': 'mbu-Latn-ZZ',
    'mbw': 'mbw-Latn-ZZ',
    'mci': 'mci-Latn-ZZ',
    'mcp': 'mcp-Latn-ZZ',
    'mcq': 'mcq-Latn-ZZ',
    'mcr': 'mcr-Latn-ZZ',
    'mcu': 'mcu-Latn-ZZ',
    'mda': 'mda-Latn-ZZ',
    'mde': 'mde-Arab-ZZ',
    'mdf': 'mdf-Cyrl-RU',
    'mdh': 'mdh-Latn-PH',
    'mdj': 'mdj-Latn-ZZ',
    'mdr': 'mdr-Latn-ID',
    'mdx': 'mdx-Ethi-ZZ',
    'med': 'med-Latn-ZZ',
    'mee': 'mee-Latn-ZZ',
    'mek': 'mek-Latn-ZZ',
    'men': 'men-Latn-SL',
    'mer': 'mer-Latn-KE',
    'met': 'met-Latn-ZZ',
    'meu': 'meu-Latn-ZZ',
    'mfa': 'mfa-Arab-TH',
    'mfe': 'mfe-Latn-MU',
    'mfn': 'mfn-Latn-ZZ',
    'mfo': 'mfo-Latn-ZZ',
    'mfq': 'mfq-Latn-ZZ',
    'mg': 'mg-Latn-MG',
    'mgh': 'mgh-Latn-MZ',
    'mgl': 'mgl-Latn-ZZ',
    'mgo': 'mgo-Latn-CM',
    'mgp': 'mgp-Deva-NP',
    'mgy': 'mgy-Latn-TZ',
    'mh': 'mh-Latn-MH',
    'mhi': 'mhi-Latn-ZZ',
    'mhl': 'mhl-Latn-ZZ',
    'mi': 'mi-Latn-NZ',
    'mif': 'mif-Latn-ZZ',
    'min': 'min-Latn-ID',
    'miw': 'miw-Latn-ZZ',
    'mk': 'mk-Cyrl-MK',
    'mki': 'mki-Arab-ZZ',
    'mkl': 'mkl-Latn-ZZ',
    'mkp': 'mkp-Latn-ZZ',
    'mkw': 'mkw-Latn-ZZ',
    'ml': 'ml-Mlym-IN',
    'mle': 'mle-Latn-ZZ',
    'mlp': 'mlp-Latn-ZZ',
    'mls': 'mls-Latn-SD',
    'mmo': 'mmo-Latn-ZZ',
    'mmu': 'mmu-Latn-ZZ',
    'mmx': 'mmx-Latn-ZZ',
    'mn': 'mn-Cyrl-MN',
    'mn-CN': 'mn-Mong-CN',
    'mn-Mong': 'mn-Mong-CN',
    'mna': 'mna-Latn-ZZ',
    'mnf': 'mnf-Latn-ZZ',
    'mni': 'mni-Beng-IN',
    'mnw': 'mnw-Mymr-MM',
    'mo': 'mo-Latn-RO',
    'moa': 'moa-Latn-ZZ',
    'moe': 'moe-Latn-CA',
    'moh': 'moh-Latn-CA',
    'mos': 'mos-Latn-BF',
    'mox': 'mox-Latn-ZZ',
    'mpp': 'mpp-Latn-ZZ',
    'mps': 'mps-Latn-ZZ',
    'mpt': 'mpt-Latn-ZZ',
    'mpx': 'mpx-Latn-ZZ',
    'mql': 'mql-Latn-ZZ',
    'mr': 'mr-Deva-IN',
    'mrd': 'mrd-Deva-NP',
    'mrj': 'mrj-Cyrl-RU',
    'mro': 'mro-Mroo-BD',
    'ms': 'ms-Latn-MY',
    'ms-CC': 'ms-Arab-CC',
    'mt': 'mt-Latn-MT',
    'mtc': 'mtc-Latn-ZZ',
    'mtf': 'mtf-Latn-ZZ',
    'mti': 'mti-Latn-ZZ',
    'mtr': 'mtr-Deva-IN',
    'mua': 'mua-Latn-CM',
    'mur': 'mur-Latn-ZZ',
    'mus': 'mus-Latn-US',
    'mva': 'mva-Latn-ZZ',
    'mvn': 'mvn-Latn-ZZ',
    'mvy': 'mvy-Arab-PK',
    'mwk': 'mwk-Latn-ML',
    'mwr': 'mwr-Deva-IN',
    'mwv': 'mwv-Latn-ID',
    'mww': 'mww-Hmnp-US',
    'mxc': 'mxc-Latn-ZW',
    'mxm': 'mxm-Latn-ZZ',
    'my': 'my-Mymr-MM',
    'myk': 'myk-Latn-ZZ',
    'mym': 'mym-Ethi-ZZ',
    'myv': 'myv-Cyrl-RU',
    'myw': 'myw-Latn-ZZ',
    'myx': 'myx-Latn-UG',
    'myz': 'myz-Mand-IR',
    'mzk': 'mzk-Latn-ZZ',
    'mzm': 'mzm-Latn-ZZ',
    'mzn': 'mzn-Arab-IR',
    'mzp': 'mzp-Latn-ZZ',
    'mzw': 'mzw-Latn-ZZ',
    'mzz': 'mzz-Latn-ZZ',
    'na': 'na-Latn-NR',
    'nac': 'nac-Latn-ZZ',
    'naf': 'naf-Latn-ZZ',
    'nak': 'nak-Latn-ZZ',
    'nan': 'nan-Hans-CN',
    'nap': 'nap-Latn-IT',
    'naq': 'naq-Latn-NA',
    'nas': 'nas-Latn-ZZ',
    'nb': 'nb-Latn-NO',
    'nca': 'nca-Latn-ZZ',
    'nce': 'nce-Latn-ZZ',
    'ncf': 'ncf-Latn-ZZ',
    'nch': 'nch-Latn-MX',
    'nco': 'nco-Latn-ZZ',
    'ncu': 'ncu-Latn-ZZ',
    'nd': 'nd-Latn-ZW',
    'ndc': 'ndc-Latn-MZ',
    'nds': 'nds-Latn-DE',
    'ne': 'ne-Deva-NP',
    'neb': 'neb-Latn-ZZ',
    'new': 'new-Deva-NP',
    'nex': 'nex-Latn-ZZ',
    'nfr': 'nfr-Latn-ZZ',
    'ng': 'ng-Latn-NA',
    'nga': 'nga-Latn-ZZ',
    'ngb': 'ngb-Latn-ZZ',
    'ngl': 'ngl-Latn-MZ',
    'nhb': 'nhb-Latn-ZZ',
    'nhe': 'nhe-Latn-MX',
    'nhw': 'nhw-Latn-MX',
    'nif': 'nif-Latn-ZZ',
    'nii': 'nii-Latn-ZZ',
    'nij': 'nij-Latn-ID',
    'nin': 'nin-Latn-ZZ',
    'niu': 'niu-Latn-NU',
    'niy': 'niy-Latn-ZZ',
    'niz': 'niz-Latn-ZZ',
    'njo': 'njo-Latn-IN',
    'nkg': 'nkg-Latn-ZZ',
    'nko': 'nko-Latn-ZZ',
    'nl': 'nl-Latn-NL',
    'nmg': 'nmg-Latn-CM',
    'nmz': 'nmz-Latn-ZZ',
    'nn': 'nn-Latn-NO',
    'nnf': 'nnf-Latn-ZZ',
    'nnh': 'nnh-Latn-CM',
    'nnk': 'nnk-Latn-ZZ',
    'nnm': 'nnm-Latn-ZZ',
    'nnp': 'nnp-Wcho-IN',
    'no': 'no-Latn-NO',
    'nod': 'nod-Lana-TH',
    'noe': 'noe-Deva-IN',
    'non': 'non-Runr-SE',
    'nop': 'nop-Latn-ZZ',
    'nou': 'nou-Latn-ZZ',
    'nqo': 'nqo-Nkoo-GN',
    'nr': 'nr-Latn-ZA',
    'nrb': 'nrb-Latn-ZZ',
    'nsk': 'nsk-Cans-CA',
    'nsn': 'nsn-Latn-ZZ',
    'nso': 'nso-Latn-ZA',
    'nss': 'nss-Latn-ZZ',
    'nst': 'nst-Tnsa-IN',
    'ntm': 'ntm-Latn-ZZ',
    'ntr': 'ntr-Latn-ZZ',
    'nui': 'nui-Latn-ZZ',
    'nup': 'nup-Latn-ZZ',
    'nus': 'nus-Latn-SS',
    'nuv': 'nuv-Latn-ZZ',
    'nux': 'nux-Latn-ZZ',
    'nv': 'nv-Latn-US',
    'nwb': 'nwb-Latn-ZZ',
    'nxq': 'nxq-Latn-CN',
    'nxr': 'nxr-Latn-ZZ',
    'ny': 'ny-Latn-MW',
    'nym': 'nym-Latn-TZ',
    'nyn': 'nyn-Latn-UG',
    'nzi': 'nzi-Latn-GH',
    'oc': 'oc-Latn-FR',
    'ogc': 'ogc-Latn-ZZ',
    'okr': 'okr-Latn-ZZ',
    'okv': 'okv-Latn-ZZ',
    'om': 'om-Latn-ET',
    'ong': 'ong-Latn-ZZ',
    'onn': 'onn-Latn-ZZ',
    'ons': 'ons-Latn-ZZ',
    'opm': 'opm-Latn-ZZ',
    'or': 'or-Orya-IN',
    'oro': 'oro-Latn-ZZ',
    'oru': 'oru-Arab-ZZ',
    'os': 'os-Cyrl-GE',
    'osa': 'osa-Osge-US',
    'ota': 'ota-Arab-ZZ',
    'otk': 'otk-Orkh-MN',
    'oui': 'oui-Ougr-143',
    'ozm': 'ozm-Latn-ZZ',
    'pa': 'pa-Guru-IN',
    'pa-Arab': 'pa-Arab-PK',
    'pa-PK': 'pa-Arab-PK',
    'pag': 'pag-Latn-PH',
    'pal': 'pal-Phli-IR',
    'pal-Phlp': 'pal-Phlp-CN',
    'pam': 'pam-Latn-PH',
    'pap': 'pap-Latn-AW',
    'pau': 'pau-Latn-PW',
    'pbi': 'pbi-Latn-ZZ',
    'pcd': 'pcd-Latn-FR',
    'pcm': 'pcm-Latn-NG',
    'pdc': 'pdc-Latn-US',
    'pdt': 'pdt-Latn-CA',
    'ped': 'ped-Latn-ZZ',
    'peo': 'peo-Xpeo-IR',
    'pex': 'pex-Latn-ZZ',
    'pfl': 'pfl-Latn-DE',
    'phl': 'phl-Arab-ZZ',
    'phn': 'phn-Phnx-LB',
    'pil': 'pil-Latn-ZZ',
    'pip': 'pip-Latn-ZZ',
    'pka': 'pka-Brah-IN',
    'pko': 'pko-Latn-KE',
    'pl': 'pl-Latn-PL',
    'pla': 'pla-Latn-ZZ',
    'pms': 'pms-Latn-IT',
    'png': 'png-Latn-ZZ',
    'pnn': 'pnn-Latn-ZZ',
    'pnt': 'pnt-Grek-GR',
    'pon': 'pon-Latn-FM',
    'ppa': 'ppa-Deva-IN',
    'ppo': 'ppo-Latn-ZZ',
    'pra': 'pra-Khar-PK',
    'prd': 'prd-Arab-IR',
    'prg': 'prg-Latn-001',
    'ps': 'ps-Arab-AF',
    'pss': 'pss-Latn-ZZ',
    'pt': 'pt-Latn-BR',
    'ptp': 'ptp-Latn-ZZ',
    'puu': 'puu-Latn-GA',
    'pwa': 'pwa-Latn-ZZ',
    'qu': 'qu-Latn-PE',
    'quc': 'quc-Latn-GT',
    'qug': 'qug-Latn-EC',
    'rai': 'rai-Latn-ZZ',
    'raj': 'raj-Deva-IN',
    'rao': 'rao-Latn-ZZ',
    'rcf': 'rcf-Latn-RE',
    'rej': 'rej-Latn-ID',
    'rel': 'rel-Latn-ZZ',
    'res': 'res-Latn-ZZ',
    'rgn': 'rgn-Latn-IT',
    'rhg': 'rhg-Rohg-MM',
    'ria': 'ria-Latn-IN',
    'rif': 'rif-Tfng-MA',
    'rif-NL': 'rif-Latn-NL',
    'rjs': 'rjs-Deva-NP',
    'rkt': 'rkt-Beng-BD',
    'rm': 'rm-Latn-CH',
    'rmf': 'rmf-Latn-FI',
    'rmo': 'rmo-Latn-CH',
    'rmt': 'rmt-Arab-IR',
    'rmu': 'rmu-Latn-SE',
    'rn': 'rn-Latn-BI',
    'rna': 'rna-Latn-ZZ',
    'rng': 'rng-Latn-MZ',
    'ro': 'ro-Latn-RO',
    'rob': 'rob-Latn-ID',
    'rof': 'rof-Latn-TZ',
    'roo': 'roo-Latn-ZZ',
    'rro': 'rro-Latn-ZZ',
    'rtm': 'rtm-Latn-FJ',
    'ru': 'ru-Cyrl-RU',
    'rue': 'rue-Cyrl-UA',
    'rug': 'rug-Latn-SB',
    'rw': 'rw-Latn-RW',
    'rwk': 'rwk-Latn-TZ',
    'rwo': 'rwo-Latn-ZZ',
    'ryu': 'ryu-Kana-JP',
    'sa': 'sa-Deva-IN',
    'saf': 'saf-Latn-GH',
    'sah': 'sah-Cyrl-RU',
    'saq': 'saq-Latn-KE',
    'sas': 'sas-Latn-ID',
    'sat': 'sat-Olck-IN',
    'sav': 'sav-Latn-SN',
    'saz': 'saz-Saur-IN',
    'sba': 'sba-Latn-ZZ',
    'sbe': 'sbe-Latn-ZZ',
    'sbp': 'sbp-Latn-TZ',
    'sc': 'sc-Latn-IT',
    'sck': 'sck-Deva-IN',
    'scl': 'scl-Arab-ZZ',
    'scn': 'scn-Latn-IT',
    'sco': 'sco-Latn-GB',
    'scs': 'scs-Latn-CA',
    'sd': 'sd-Arab-PK',
    'sd-Deva': 'sd-Deva-IN',
    'sd-Khoj': 'sd-Khoj-IN',
    'sd-Sind': 'sd-Sind-IN',
    'sdc': 'sdc-Latn-IT',
    'sdh': 'sdh-Arab-IR',
    'se': 'se-Latn-NO',
    'sef': 'sef-Latn-CI',
    'seh': 'seh-Latn-MZ',
    'sei': 'sei-Latn-MX',
    'ses': 'ses-Latn-ML',
    'sg': 'sg-Latn-CF',
    'sga': 'sga-Ogam-IE',
    'sgs': 'sgs-Latn-LT',
    'sgw': 'sgw-Ethi-ZZ',
    'sgz': 'sgz-Latn-ZZ',
    'shi': 'shi-Tfng-MA',
    'shk': 'shk-Latn-ZZ',
    'shn': 'shn-Mymr-MM',
    'shu': 'shu-Arab-ZZ',
    'si': 'si-Sinh-LK',
    'sid': 'sid-Latn-ET',
    'sig': 'sig-Latn-ZZ',
    'sil': 'sil-Latn-ZZ',
    'sim': 'sim-Latn-ZZ',
    'sjr': 'sjr-Latn-ZZ',
    'sk': 'sk-Latn-SK',
    'skc': 'skc-Latn-ZZ',
    'skr': 'skr-Arab-PK',
    'sks': 'sks-Latn-ZZ',
    'sl': 'sl-Latn-SI',
    'sld': 'sld-Latn-ZZ',
    'sli': 'sli-Latn-PL',
    'sll': 'sll-Latn-ZZ',
    'sly': 'sly-Latn-ID',
    'sm': 'sm-Latn-WS',
    'sma': 'sma-Latn-SE',
    'smj': 'smj-Latn-SE',
    'smn': 'smn-Latn-FI',
    'smp': 'smp-Samr-IL',
    'smq': 'smq-Latn-ZZ',
    'sms': 'sms-Latn-FI',
    'sn': 'sn-Latn-ZW',
    'snc': 'snc-Latn-ZZ',
    'snk': 'snk-Latn-ML',
    'snp': 'snp-Latn-ZZ',
    'snx': 'snx-Latn-ZZ',
    'sny': 'sny-Latn-ZZ',
    'so': 'so-Latn-SO',
    'sog': 'sog-Sogd-UZ',
    'sok': 'sok-Latn-ZZ',
    'soq': 'soq-Latn-ZZ',
    'sou': 'sou-Thai-TH',
    'soy': 'soy-Latn-ZZ',
    'spd': 'spd-Latn-ZZ',
    'spl': 'spl-Latn-ZZ',
    'sps': 'sps-Latn-ZZ',
    'sq': 'sq-Latn-AL',
    'sr': 'sr-Cyrl-RS',
    'sr-ME': 'sr-Latn-ME',
    'sr-RO': 'sr-Latn-RO',
    'sr-RU': 'sr-Latn-RU',
    'sr-TR': 'sr-Latn-TR',
    'srb': 'srb-Sora-IN',
    'srn': 'srn-Latn-SR',
    'srr': 'srr-Latn-SN',
    'srx': 'srx-Deva-IN',
    'ss': 'ss-Latn-ZA',
    'ssd': 'ssd-Latn-ZZ',
    'ssg': 'ssg-Latn-ZZ',
    'ssy': 'ssy-Latn-ER',
    'st': 'st-Latn-ZA',
    'stk': 'stk-Latn-ZZ',
    'stq': 'stq-Latn-DE',
    'su': 'su-Latn-ID',
    'sua': 'sua-Latn-ZZ',
    'sue': 'sue-Latn-ZZ',
    'suk': 'suk-Latn-TZ',
    'sur': 'sur-Latn-ZZ',
    'sus': 'sus-Latn-GN',
    'sv': 'sv-Latn-SE',
    'sw': 'sw-Latn-TZ',
    'swb': 'swb-Arab-YT',
    'swc': 'swc-Latn-CD',
    'swg': 'swg-Latn-DE',
    'swp': 'swp-Latn-ZZ',
    'swv': 'swv-Deva-IN',
    'sxn': 'sxn-Latn-ID',
    'sxw': 'sxw-Latn-ZZ',
    'syl': 'syl-Beng-BD',
    'syr': 'syr-Syrc-IQ',
    'szl': 'szl-Latn-PL',
    'ta': 'ta-Taml-IN',
    'taj': 'taj-Deva-NP',
    'tal': 'tal-Latn-ZZ',
    'tan': 'tan-Latn-ZZ',
    'taq': 'taq-Latn-ZZ',
    'tbc': 'tbc-Latn-ZZ',
    'tbd': 'tbd-Latn-ZZ',
    'tbf': 'tbf-Latn-ZZ',
    'tbg': 'tbg-Latn-ZZ',
    'tbo': 'tbo-Latn-ZZ',
    'tbw': 'tbw-Latn-PH',
    'tbz': 'tbz-Latn-ZZ',
    'tci': 'tci-Latn-ZZ',
    'tcy': 'tcy-Knda-IN',
    'tdd': 'tdd-Tale-CN',
    'tdg': 'tdg-Deva-NP',
    'tdh': 'tdh-Deva-NP',
    'tdu': 'tdu-Latn-MY',
    'te': 'te-Telu-IN',
    'ted': 'ted-Latn-ZZ',
    'tem': 'tem-Latn-SL',
    'teo': 'teo-Latn-UG',
    'tet': 'tet-Latn-TL',
    'tfi': 'tfi-Latn-ZZ',
    'tg': 'tg-Cyrl-TJ',
    'tg-Arab': 'tg-Arab-PK',
    'tg-PK': 'tg-Arab-PK',
    'tgc': 'tgc-Latn-ZZ',
    'tgo': 'tgo-Latn-ZZ',
    'tgu': 'tgu-Latn-ZZ',
    'th': 'th-Thai-TH',
    'thl': 'thl-Deva-NP',
    'thq': 'thq-Deva-NP',
    'thr': 'thr-Deva-NP',
    'ti': 'ti-Ethi-ET',
    'tif': 'tif-Latn-ZZ',
    'tig': 'tig-Ethi-ER',
    'tik': 'tik-Latn-ZZ',
    'tim': 'tim-Latn-ZZ',
    'tio': 'tio-Latn-ZZ',
    'tiv': 'tiv-Latn-NG',
    'tk': 'tk-Latn-TM',
    'tkl': 'tkl-Latn-TK',
    'tkr': 'tkr-Latn-AZ',
    'tkt': 'tkt-Deva-NP',
    'tl': 'tl-Latn-PH',
    'tlf': 'tlf-Latn-ZZ',
    'tlx': 'tlx-Latn-ZZ',
    'tly': 'tly-Latn-AZ',
    'tmh': 'tmh-Latn-NE',
    'tmy': 'tmy-Latn-ZZ',
    'tn': 'tn-Latn-ZA',
    'tnh': 'tnh-Latn-ZZ',
    'to': 'to-Latn-TO',
    'tof': 'tof-Latn-ZZ',
    'tog': 'tog-Latn-MW',
    'toq': 'toq-Latn-ZZ',
    'tpi': 'tpi-Latn-PG',
    'tpm': 'tpm-Latn-ZZ',
    'tpz': 'tpz-Latn-ZZ',
    'tqo': 'tqo-Latn-ZZ',
    'tr': 'tr-Latn-TR',
    'tru': 'tru-Latn-TR',
    'trv': 'trv-Latn-TW',
    'trw': 'trw-Arab-PK',
    'ts': 'ts-Latn-ZA',
    'tsd': 'tsd-Grek-GR',
    'tsf': 'tsf-Deva-NP',
    'tsg': 'tsg-Latn-PH',
    'tsj': 'tsj-Tibt-BT',
    'tsw': 'tsw-Latn-ZZ',
    'tt': 'tt-Cyrl-RU',
    'ttd': 'ttd-Latn-ZZ',
    'tte': 'tte-Latn-ZZ',
    'ttj': 'ttj-Latn-UG',
    'ttr': 'ttr-Latn-ZZ',
    'tts': 'tts-Thai-TH',
    'ttt': 'ttt-Latn-AZ',
    'tuh': 'tuh-Latn-ZZ',
    'tul': 'tul-Latn-ZZ',
    'tum': 'tum-Latn-MW',
    'tuq': 'tuq-Latn-ZZ',
    'tvd': 'tvd-Latn-ZZ',
    'tvl': 'tvl-Latn-TV',
    'tvu': 'tvu-Latn-ZZ',
    'twh': 'twh-Latn-ZZ',
    'twq': 'twq-Latn-NE',
    'txg': 'txg-Tang-CN',
    'txo': 'txo-Toto-IN',
    'ty': 'ty-Latn-PF',
    'tya': 'tya-Latn-ZZ',
    'tyv': 'tyv-Cyrl-RU',
    'tzm': 'tzm-Latn-MA',
    'ubu': 'ubu-Latn-ZZ',
    'udi': 'udi-Aghb-RU',
    'udm': 'udm-Cyrl-RU',
    'ug': 'ug-Arab-CN',
    'ug-Cyrl': 'ug-Cyrl-KZ',
    'ug-KZ': 'ug-Cyrl-KZ',
    'ug-MN': 'ug-Cyrl-MN',
    'uga': 'uga-Ugar-SY',
    'uk': 'uk-Cyrl-UA',
    'uli': 'uli-Latn-FM',
    'umb': 'umb-Latn-AO',
    'und': 'en-Latn-US',
    'und-002': 'en-Latn-NG',
    'und-003': 'en-Latn-US',
    'und-005': 'pt-Latn-BR',
    'und-009': 'en-Latn-AU',
    'und-011': 'en-Latn-NG',
    'und-013': 'es-Latn-MX',
    'und-014': 'sw-Latn-TZ',
    'und-015': 'ar-Arab-EG',
    'und-017': 'sw-Latn-CD',
    'und-018': 'en-Latn-ZA',
    'und-019': 'en-Latn-US',
    'und-021': 'en-Latn-US',
    'und-029': 'es-Latn-CU',
    'und-030': 'zh-Hans-CN',
    'und-034': 'hi-Deva-IN',
    'und-035': 'id-Latn-ID',
    'und-039': 'it-Latn-IT',
    'und-053': 'en-Latn-AU',
    'und-054': 'en-Latn-PG',
    'und-057': 'en-Latn-GU',
    'und-061': 'sm-Latn-WS',
    'und-142': 'zh-Hans-CN',
    'und-143': 'uz-Latn-UZ',
    'und-145': 'ar-Arab-SA',
    'und-150': 'ru-Cyrl-RU',
    'und-151': 'ru-Cyrl-RU',
    'und-154': 'en-Latn-GB',
    'und-155': 'de-Latn-DE',
    'und-202': 'en-Latn-NG',
    'und-419': 'es-Latn-419',
    'und-AD': 'ca-Latn-AD',
    'und-AE': 'ar-Arab-AE',
    'und-AF': 'fa-Arab-AF',
    'und-AL': 'sq-Latn-AL',
    'und-AM': 'hy-Armn-AM',
    'und-AO': 'pt-Latn-AO',
    'und-AQ': 'und-Latn-AQ',
    'und-AR': 'es-Latn-AR',
    'und-AS': 'sm-Latn-AS',
    'und-AT': 'de-Latn-AT',
    'und-AW': 'nl-Latn-AW',
    'und-AX': 'sv-Latn-AX',
    'und-AZ': 'az-Latn-AZ',
    'und-Adlm': 'ff-Adlm-GN',
    'und-Aghb': 'udi-Aghb-RU',
    'und-Ahom': 'aho-Ahom-IN',
    'und-Arab': 'ar-Arab-EG',
    'und-Arab-CC': 'ms-Arab-CC',
    'und-Arab-CN': 'ug-Arab-CN',
    'und-Arab-GB': 'ks-Arab-GB',
    'und-Arab-ID': 'ms-Arab-ID',
    'und-Arab-IN': 'ur-Arab-IN',
    'und-Arab-KH': 'cja-Arab-KH',
    'und-Arab-MM': 'rhg-Arab-MM',
    'und-Arab-MN': 'kk-Arab-MN',
    'und-Arab-MU': 'ur-Arab-MU',
    'und-Arab-NG': 'ha-Arab-NG',
    'und-Arab-PK': 'ur-Arab-PK',
    'und-Arab-TG': 'apd-Arab-TG',
    'und-Arab-TH': 'mfa-Arab-TH',
    'und-Arab-TJ': 'fa-Arab-TJ',
    'und-Arab-TR': 'az-Arab-TR',
    'und-Arab-YT': 'swb-Arab-YT',
    'und-Armi': 'arc-Armi-IR',
    'und-Armn': 'hy-Armn-AM',
    'und-Avst': 'ae-Avst-IR',
    'und-BA': 'bs-Latn-BA',
    'und-BD': 'bn-Beng-BD',
    'und-BE': 'nl-Latn-BE',
    'und-BF': 'fr-Latn-BF',
    'und-BG': 'bg-Cyrl-BG',
    'und-BH': 'ar-Arab-BH',
    'und-BI': 'rn-Latn-BI',
    'und-BJ': 'fr-Latn-BJ',
    'und-BL': 'fr-Latn-BL',
    'und-BN': 'ms-Latn-BN',
    'und-BO': 'es-Latn-BO',
    'und-BQ': 'pap-Latn-BQ',
    'und-BR': 'pt-Latn-BR',
    'und-BT': 'dz-Tibt-BT',
    'und-BV': 'und-Latn-BV',
    'und-BY': 'be-Cyrl-BY',
    'und-Bali': 'ban-Bali-ID',
    'und-Bamu': 'bax-Bamu-CM',
    'und-Bass': 'bsq-Bass-LR',
    'und-Batk': 'bbc-Batk-ID',
    'und-Beng': 'bn-Beng-BD',
    'und-Bhks': 'sa-Bhks-IN',
    'und-Bopo': 'zh-Bopo-TW',
    'und-Brah': 'pka-Brah-IN',
    'und-Brai': 'fr-Brai-FR',
    'und-Bugi': 'bug-Bugi-ID',
    'und-Buhd': 'bku-Buhd-PH',
    'und-CD': 'sw-Latn-CD',
    'und-CF': 'fr-Latn-CF',
    'und-CG': 'fr-Latn-CG',
    'und-CH': 'de-Latn-CH',
    'und-CI': 'fr-Latn-CI',
    'und-CL': 'es-Latn-CL',
    'und-CM': 'fr-Latn-CM',
    'und-CN': 'zh-Hans-CN',
    'und-CO': 'es-Latn-CO',
    'und-CP': 'und-Latn-CP',
    'und-CR': 'es-Latn-CR',
    'und-CU': 'es-Latn-CU',
    'und-CV': 'pt-Latn-CV',
    'und-CW': 'pap-Latn-CW',
    'und-CY': 'el-Grek-CY',
    'und-CZ': 'cs-Latn-CZ',
    'und-Cakm': 'ccp-Cakm-BD',
    'und-Cans': 'cr-Cans-CA',
    'und-Cari': 'xcr-Cari-TR',
    'und-Cham': 'cjm-Cham-VN',
    'und-Cher': 'chr-Cher-US',
    'und-Chrs': 'xco-Chrs-UZ',
    'und-Copt': 'cop-Copt-EG',
    'und-Cpmn': 'und-Cpmn-CY',
    'und-Cpmn-CY': 'und-Cpmn-CY',
    'und-Cprt': 'grc-Cprt-CY',
    'und-Cyrl': 'ru-Cyrl-RU',
    'und-Cyrl-AL': 'mk-Cyrl-AL',
    'und-Cyrl-BA': 'sr-Cyrl-BA',
    'und-Cyrl-GE': 'os-Cyrl-GE',
    'und-Cyrl-GR': 'mk-Cyrl-GR',
    'und-Cyrl-MD': 'uk-Cyrl-MD',
    'und-Cyrl-RO': 'bg-Cyrl-RO',
    'und-Cyrl-SK': 'uk-Cyrl-SK',
    'und-Cyrl-TR': 'kbd-Cyrl-TR',
    'und-Cyrl-XK': 'sr-Cyrl-XK',
    'und-DE': 'de-Latn-DE',
    'und-DJ': 'aa-Latn-DJ',
    'und-DK': 'da-Latn-DK',
    'und-DO': 'es-Latn-DO',
    'und-DZ': 'ar-Arab-DZ',
    'und-Deva': 'hi-Deva-IN',
    'und-Deva-BT': 'ne-Deva-BT',
    'und-Deva-FJ': 'hif-Deva-FJ',
    'und-Deva-MU': 'bho-Deva-MU',
    'und-Deva-PK': 'btv-Deva-PK',
    'und-Diak': 'dv-Diak-MV',
    'und-Dogr': 'doi-Dogr-IN',
    'und-Dupl': 'fr-Dupl-FR',
    'und-EA': 'es-Latn-EA',
    'und-EC': 'es-Latn-EC',
    'und-EE': 'et-Latn-EE',
    'und-EG': 'ar-Arab-EG',
    'und-EH': 'ar-Arab-EH',
    'und-ER': 'ti-Ethi-ER',
    'und-ES': 'es-Latn-ES',
    'und-ET': 'am-Ethi-ET',
    'und-EU': 'en-Latn-IE',
    'und-EZ': 'de-Latn-EZ',
    'und-Egyp': 'egy-Egyp-EG',
    'und-Elba': 'sq-Elba-AL',
    'und-Elym': 'arc-Elym-IR',
    'und-Ethi': 'am-Ethi-ET',
    'und-FI': 'fi-Latn-FI',
    'und-FO': 'fo-Latn-FO',
    'und-FR': 'fr-Latn-FR',
    'und-GA': 'fr-Latn-GA',
    'und-GE': 'ka-Geor-GE',
    'und-GF': 'fr-Latn-GF',
    'und-GH': 'ak-Latn-GH',
    'und-GL': 'kl-Latn-GL',
    'und-GN': 'fr-Latn-GN',
    'und-GP': 'fr-Latn-GP',
    'und-GQ': 'es-Latn-GQ',
    'und-GR': 'el-Grek-GR',
    'und-GS': 'und-Latn-GS',
    'und-GT': 'es-Latn-GT',
    'und-GW': 'pt-Latn-GW',
    'und-Geor': 'ka-Geor-GE',
    'und-Glag': 'cu-Glag-BG',
    'und-Gong': 'wsg-Gong-IN',
    'und-Gonm': 'esg-Gonm-IN',
    'und-Goth': 'got-Goth-UA',
    'und-Gran': 'sa-Gran-IN',
    'und-Grek': 'el-Grek-GR',
    'und-Grek-TR': 'bgx-Grek-TR',
    'und-Gujr': 'gu-Gujr-IN',
    'und-Guru': 'pa-Guru-IN',
    'und-HK': 'zh-Hant-HK',
    'und-HM': 'und-Latn-HM',
    'und-HN': 'es-Latn-HN',
    'und-HR': 'hr-Latn-HR',
    'und-HT': 'ht-Latn-HT',
    'und-HU': 'hu-Latn-HU',
    'und-Hanb': 'zh-Hanb-TW',
    'und-Hang': 'ko-Hang-KR',
    'und-Hani': 'zh-Hani-CN',
    'und-Hano': 'hnn-Hano-PH',
    'und-Hans': 'zh-Hans-CN',
    'und-Hant': 'zh-Hant-TW',
    'und-Hebr': 'he-Hebr-IL',
    'und-Hebr-CA': 'yi-Hebr-CA',
    'und-Hebr-GB': 'yi-Hebr-GB',
    'und-Hebr-SE': 'yi-Hebr-SE',
    'und-Hebr-UA': 'yi-Hebr-UA',
    'und-Hebr-US': 'yi-Hebr-US',
    'und-Hira': 'ja-Hira-JP',
    'und-Hluw': 'hlu-Hluw-TR',
    'und-Hmng': 'hnj-Hmng-LA',
    'und-Hmnp': 'hnj-Hmnp-US',
    'und-Hung': 'hu-Hung-HU',
    'und-IC': 'es-Latn-IC',
    'und-ID': 'id-Latn-ID',
    'und-IL': 'he-Hebr-IL',
    'und-IN': 'hi-Deva-IN',
    'und-IQ': 'ar-Arab-IQ',
    'und-IR': 'fa-Arab-IR',
    'und-IS': 'is-Latn-IS',
    'und-IT': 'it-Latn-IT',
    'und-Ital': 'ett-Ital-IT',
    'und-JO': 'ar-Arab-JO',
    'und-JP': 'ja-Jpan-JP',
    'und-Jamo': 'ko-Jamo-KR',
    'und-Java': 'jv-Java-ID',
    'und-Jpan': 'ja-Jpan-JP',
    'und-KE': 'sw-Latn-KE',
    'und-KG': 'ky-Cyrl-KG',
    'und-KH': 'km-Khmr-KH',
    'und-KM': 'ar-Arab-KM',
    'und-KP': 'ko-Kore-KP',
    'und-KR': 'ko-Kore-KR',
    'und-KW': 'ar-Arab-KW',
    'und-KZ': 'ru-Cyrl-KZ',
    'und-Kali': 'eky-Kali-MM',
    'und-Kana': 'ja-Kana-JP',
    'und-Khar': 'pra-Khar-PK',
    'und-Khmr': 'km-Khmr-KH',
    'und-Khoj': 'sd-Khoj-IN',
    'und-Kits': 'zkt-Kits-CN',
    'und-Knda': 'kn-Knda-IN',
    'und-Kore': 'ko-Kore-KR',
    'und-Kthi': 'bho-Kthi-IN',
    'und-LA': 'lo-Laoo-LA',
    'und-LB': 'ar-Arab-LB',
    'und-LI': 'de-Latn-LI',
    'und-LK': 'si-Sinh-LK',
    'und-LS': 'st-Latn-LS',
    'und-LT': 'lt-Latn-LT',
    'und-LU': 'fr-Latn-LU',
    'und-LV': 'lv-Latn-LV',
    'und-LY': 'ar-Arab-LY',
    'und-Lana': 'nod-Lana-TH',
    'und-Laoo': 'lo-Laoo-LA',
    'und-Latn-AF': 'tk-Latn-AF',
    'und-Latn-AM': 'ku-Latn-AM',
    'und-Latn-CN': 'za-Latn-CN',
    'und-Latn-CY': 'tr-Latn-CY',
    'und-Latn-DZ': 'fr-Latn-DZ',
    'und-Latn-ET': 'en-Latn-ET',
    'und-Latn-GE': 'ku-Latn-GE',
    'und-Latn-IR': 'tk-Latn-IR',
    'und-Latn-KM': 'fr-Latn-KM',
    'und-Latn-MA': 'fr-Latn-MA',
    'und-Latn-MK': 'sq-Latn-MK',
    'und-Latn-MM': 'kac-Latn-MM',
    'und-Latn-MO': 'pt-Latn-MO',
    'und-Latn-MR': 'fr-Latn-MR',
    'und-Latn-RU': 'krl-Latn-RU',
    'und-Latn-SY': 'fr-Latn-SY',
    'und-Latn-TN': 'fr-Latn-TN',
    'und-Latn-TW': 'trv-Latn-TW',
    'und-Latn-UA': 'pl-Latn-UA',
    'und-Lepc': 'lep-Lepc-IN',
    'und-Limb': 'lif-Limb-IN',
    'und-Lina': 'lab-Lina-GR',
    'und-Linb': 'grc-Linb-GR',
    'und-Lisu': 'lis-Lisu-CN',
    'und-Lyci': 'xlc-Lyci-TR',
    'und-Lydi': 'xld-Lydi-TR',
    'und-MA': 'ar-Arab-MA',
    'und-MC': 'fr-Latn-MC',
    'und-MD': 'ro-Latn-MD',
    'und-ME': 'sr-Latn-ME',
    'und-MF': 'fr-Latn-MF',
    'und-MG': 'mg-Latn-MG',
    'und-MK': 'mk-Cyrl-MK',
    'und-ML': 'bm-Latn-ML',
    'und-MM': 'my-Mymr-MM',
    'und-MN': 'mn-Cyrl-MN',
    'und-MO': 'zh-Hant-MO',
    'und-MQ': 'fr-Latn-MQ',
    'und-MR': 'ar-Arab-MR',
    'und-MT': 'mt-Latn-MT',
    'und-MU': 'mfe-Latn-MU',
    'und-MV': 'dv-Thaa-MV',
    'und-MX': 'es-Latn-MX',
    'und-MY': 'ms-Latn-MY',
    'und-MZ': 'pt-Latn-MZ',
    'und-Mahj': 'hi-Mahj-IN',
    'und-Maka': 'mak-Maka-ID',
    'und-Mand': 'myz-Mand-IR',
    'und-Mani': 'xmn-Mani-CN',
    'und-Marc': 'bo-Marc-CN',
    'und-Medf': 'dmf-Medf-NG',
    'und-Mend': 'men-Mend-SL',
    'und-Merc': 'xmr-Merc-SD',
    'und-Mero': 'xmr-Mero-SD',
    'und-Mlym': 'ml-Mlym-IN',
    'und-Modi': 'mr-Modi-IN',
    'und-Mong': 'mn-Mong-CN',
    'und-Mroo': 'mro-Mroo-BD',
    'und-Mtei': 'mni-Mtei-IN',
    'und-Mult': 'skr-Mult-PK',
    'und-Mymr': 'my-Mymr-MM',
    'und-Mymr-IN': 'kht-Mymr-IN',
    'und-Mymr-TH': 'mnw-Mymr-TH',
    'und-NA': 'af-Latn-NA',
    'und-NC': 'fr-Latn-NC',
    'und-NE': 'ha-Latn-NE',
    'und-NI': 'es-Latn-NI',
    'und-NL': 'nl-Latn-NL',
    'und-NO': 'nb-Latn-NO',
    'und-NP': 'ne-Deva-NP',
    'und-Nand': 'sa-Nand-IN',
    'und-Narb': 'xna-Narb-SA',
    'und-Nbat': 'arc-Nbat-JO',
    'und-Newa': 'new-Newa-NP',
    'und-Nkoo': 'man-Nkoo-GN',
    'und-Nshu': 'zhx-Nshu-CN',
    'und-OM': 'ar-Arab-OM',
    'und-Ogam': 'sga-Ogam-IE',
    'und-Olck': 'sat-Olck-IN',
    'und-Orkh': 'otk-Orkh-MN',
    'und-Orya': 'or-Orya-IN',
    'und-Osge': 'osa-Osge-US',
    'und-Osma': 'so-Osma-SO',
    'und-Ougr': 'oui-Ougr-143',
    'und-PA': 'es-Latn-PA',
    'und-PE': 'es-Latn-PE',
    'und-PF': 'fr-Latn-PF',
    'und-PG': 'tpi-Latn-PG',
    'und-PH': 'fil-Latn-PH',
    'und-PK': 'ur-Arab-PK',
    'und-PL': 'pl-Latn-PL',
    'und-PM': 'fr-Latn-PM',
    'und-PR': 'es-Latn-PR',
    'und-PS': 'ar-Arab-PS',
    'und-PT': 'pt-Latn-PT',
    'und-PW': 'pau-Latn-PW',
    'und-PY': 'gn-Latn-PY',
    'und-Palm': 'arc-Palm-SY',
    'und-Pauc': 'ctd-Pauc-MM',
    'und-Perm': 'kv-Perm-RU',
    'und-Phag': 'lzh-Phag-CN',
    'und-Phli': 'pal-Phli-IR',
    'und-Phlp': 'pal-Phlp-CN',
    'und-Phnx': 'phn-Phnx-LB',
    'und-Plrd': 'hmd-Plrd-CN',
    'und-Prti': 'xpr-Prti-IR',
    'und-QA': 'ar-Arab-QA',
    'und-QO': 'en-Latn-DG',
    'und-RE': 'fr-Latn-RE',
    'und-RO': 'ro-Latn-RO',
    'und-RS': 'sr-Cyrl-RS',
    'und-RU': 'ru-Cyrl-RU',
    'und-RW': 'rw-Latn-RW',
    'und-Rjng': 'rej-Rjng-ID',
    'und-Rohg': 'rhg-Rohg-MM',
    'und-Runr': 'non-Runr-SE',
    'und-SA': 'ar-Arab-SA',
    'und-SC': 'fr-Latn-SC',
    'und-SD': 'ar-Arab-SD',
    'und-SE': 'sv-Latn-SE',
    'und-SI': 'sl-Latn-SI',
    'und-SJ': 'nb-Latn-SJ',
    'und-SK': 'sk-Latn-SK',
    'und-SM': 'it-Latn-SM',
    'und-SN': 'fr-Latn-SN',
    'und-SO': 'so-Latn-SO',
    'und-SR': 'nl-Latn-SR',
    'und-ST': 'pt-Latn-ST',
    'und-SV': 'es-Latn-SV',
    'und-SY': 'ar-Arab-SY',
    'und-Samr': 'smp-Samr-IL',
    'und-Sarb': 'xsa-Sarb-YE',
    'und-Saur': 'saz-Saur-IN',
    'und-Sgnw': 'ase-Sgnw-US',
    'und-Shaw': 'en-Shaw-GB',
    'und-Shrd': 'sa-Shrd-IN',
    'und-Sidd': 'sa-Sidd-IN',
    'und-Sind': 'sd-Sind-IN',
    'und-Sinh': 'si-Sinh-LK',
    'und-Sogd': 'sog-Sogd-UZ',
    'und-Sogo': 'sog-Sogo-UZ',
    'und-Sora': 'srb-Sora-IN',
    'und-Soyo': 'cmg-Soyo-MN',
    'und-Sund': 'su-Sund-ID',
    'und-Sylo': 'syl-Sylo-BD',
    'und-Syrc': 'syr-Syrc-IQ',
    'und-TD': 'fr-Latn-TD',
    'und-TF': 'fr-Latn-TF',
    'und-TG': 'fr-Latn-TG',
    'und-TH': 'th-Thai-TH',
    'und-TJ': 'tg-Cyrl-TJ',
    'und-TK': 'tkl-Latn-TK',
    'und-TL': 'pt-Latn-TL',
    'und-TM': 'tk-Latn-TM',
    'und-TN': 'ar-Arab-TN',
    'und-TO': 'to-Latn-TO',
    'und-TR': 'tr-Latn-TR',
    'und-TV': 'tvl-Latn-TV',
    'und-TW': 'zh-Hant-TW',
    'und-TZ': 'sw-Latn-TZ',
    'und-Tagb': 'tbw-Tagb-PH',
    'und-Takr': 'doi-Takr-IN',
    'und-Tale': 'tdd-Tale-CN',
    'und-Talu': 'khb-Talu-CN',
    'und-Taml': 'ta-Taml-IN',
    'und-Tang': 'txg-Tang-CN',
    'und-Tavt': 'blt-Tavt-VN',
    'und-Telu': 'te-Telu-IN',
    'und-Tfng': 'zgh-Tfng-MA',
    'und-Tglg': 'fil-Tglg-PH',
    'und-Thaa': 'dv-Thaa-MV',
    'und-Thai': 'th-Thai-TH',
    'und-Thai-CN': 'lcp-Thai-CN',
    'und-Thai-KH': 'kdt-Thai-KH',
    'und-Thai-LA': 'kdt-Thai-LA',
    'und-Tibt': 'bo-Tibt-CN',
    'und-Tirh': 'mai-Tirh-IN',
    'und-Tnsa': 'nst-Tnsa-IN',
    'und-Toto': 'txo-Toto-IN',
    'und-UA': 'uk-Cyrl-UA',
    'und-UG': 'sw-Latn-UG',
    'und-UY': 'es-Latn-UY',
    'und-UZ': 'uz-Latn-UZ',
    'und-Ugar': 'uga-Ugar-SY',
    'und-VA': 'it-Latn-VA',
    'und-VE': 'es-Latn-VE',
    'und-VN': 'vi-Latn-VN',
    'und-VU': 'bi-Latn-VU',
    'und-Vaii': 'vai-Vaii-LR',
    'und-Vith': 'sq-Vith-AL',
    'und-WF': 'fr-Latn-WF',
    'und-WS': 'sm-Latn-WS',
    'und-Wara': 'hoc-Wara-IN',
    'und-Wcho': 'nnp-Wcho-IN',
    'und-XK': 'sq-Latn-XK',
    'und-Xpeo': 'peo-Xpeo-IR',
    'und-Xsux': 'akk-Xsux-IQ',
    'und-YE': 'ar-Arab-YE',
    'und-YT': 'fr-Latn-YT',
    'und-Yezi': 'ku-Yezi-GE',
    'und-Yiii': 'ii-Yiii-CN',
    'und-ZW': 'sn-Latn-ZW',
    'und-Zanb': 'cmg-Zanb-MN',
    'unr': 'unr-Beng-IN',
    'unr-Deva': 'unr-Deva-NP',
    'unr-NP': 'unr-Deva-NP',
    'unx': 'unx-Beng-IN',
    'uok': 'uok-Latn-ZZ',
    'ur': 'ur-Arab-PK',
    'uri': 'uri-Latn-ZZ',
    'urt': 'urt-Latn-ZZ',
    'urw': 'urw-Latn-ZZ',
    'usa': 'usa-Latn-ZZ',
    'uth': 'uth-Latn-ZZ',
    'utr': 'utr-Latn-ZZ',
    'uvh': 'uvh-Latn-ZZ',
    'uvl': 'uvl-Latn-ZZ',
    'uz': 'uz-Latn-UZ',
    'uz-AF': 'uz-Arab-AF',
    'uz-Arab': 'uz-Arab-AF',
    'uz-CN': 'uz-Cyrl-CN',
    'vag': 'vag-Latn-ZZ',
    'vai': 'vai-Vaii-LR',
    'van': 'van-Latn-ZZ',
    've': 've-Latn-ZA',
    'vec': 'vec-Latn-IT',
    'vep': 'vep-Latn-RU',
    'vi': 'vi-Latn-VN',
    'vic': 'vic-Latn-SX',
    'viv': 'viv-Latn-ZZ',
    'vls': 'vls-Latn-BE',
    'vmf': 'vmf-Latn-DE',
    'vmw': 'vmw-Latn-MZ',
    'vo': 'vo-Latn-001',
    'vot': 'vot-Latn-RU',
    'vro': 'vro-Latn-EE',
    'vun': 'vun-Latn-TZ',
    'vut': 'vut-Latn-ZZ',
    'wa': 'wa-Latn-BE',
    'wae': 'wae-Latn-CH',
    'waj': 'waj-Latn-ZZ',
    'wal': 'wal-Ethi-ET',
    'wan': 'wan-Latn-ZZ',
    'war': 'war-Latn-PH',
    'wbp': 'wbp-Latn-AU',
    'wbq': 'wbq-Telu-IN',
    'wbr': 'wbr-Deva-IN',
    'wci': 'wci-Latn-ZZ',
    'wer': 'wer-Latn-ZZ',
    'wgi': 'wgi-Latn-ZZ',
    'whg': 'whg-Latn-ZZ',
    'wib': 'wib-Latn-ZZ',
    'wiu': 'wiu-Latn-ZZ',
    'wiv': 'wiv-Latn-ZZ',
    'wja': 'wja-Latn-ZZ',
    'wji': 'wji-Latn-ZZ',
    'wls': 'wls-Latn-WF',
    'wmo': 'wmo-Latn-ZZ',
    'wnc': 'wnc-Latn-ZZ',
    'wni': 'wni-Arab-KM',
    'wnu': 'wnu-Latn-ZZ',
    'wo': 'wo-Latn-SN',
    'wob': 'wob-Latn-ZZ',
    'wos': 'wos-Latn-ZZ',
    'wrs': 'wrs-Latn-ZZ',
    'wsg': 'wsg-Gong-IN',
    'wsk': 'wsk-Latn-ZZ',
    'wtm': 'wtm-Deva-IN',
    'wuu': 'wuu-Hans-CN',
    'wuv': 'wuv-Latn-ZZ',
    'wwa': 'wwa-Latn-ZZ',
    'xav': 'xav-Latn-BR',
    'xbi': 'xbi-Latn-ZZ',
    'xco': 'xco-Chrs-UZ',
    'xcr': 'xcr-Cari-TR',
    'xes': 'xes-Latn-ZZ',
    'xh': 'xh-Latn-ZA',
    'xla': 'xla-Latn-ZZ',
    'xlc': 'xlc-Lyci-TR',
    'xld': 'xld-Lydi-TR',
    'xmf': 'xmf-Geor-GE',
    'xmn': 'xmn-Mani-CN',
    'xmr': 'xmr-Merc-SD',
    'xna': 'xna-Narb-SA',
    'xnr': 'xnr-Deva-IN',
    'xog': 'xog-Latn-UG',
    'xon': 'xon-Latn-ZZ',
    'xpr': 'xpr-Prti-IR',
    'xrb': 'xrb-Latn-ZZ',
    'xsa': 'xsa-Sarb-YE',
    'xsi': 'xsi-Latn-ZZ',
    'xsm': 'xsm-Latn-ZZ',
    'xsr': 'xsr-Deva-NP',
    'xwe': 'xwe-Latn-ZZ',
    'yam': 'yam-Latn-ZZ',
    'yao': 'yao-Latn-MZ',
    'yap': 'yap-Latn-FM',
    'yas': 'yas-Latn-ZZ',
    'yat': 'yat-Latn-ZZ',
    'yav': 'yav-Latn-CM',
    'yay': 'yay-Latn-ZZ',
    'yaz': 'yaz-Latn-ZZ',
    'yba': 'yba-Latn-ZZ',
    'ybb': 'ybb-Latn-CM',
    'yby': 'yby-Latn-ZZ',
    'yer': 'yer-Latn-ZZ',
    'ygr': 'ygr-Latn-ZZ',
    'ygw': 'ygw-Latn-ZZ',
    'yi': 'yi-Hebr-001',
    'yko': 'yko-Latn-ZZ',
    'yle': 'yle-Latn-ZZ',
    'ylg': 'ylg-Latn-ZZ',
    'yll': 'yll-Latn-ZZ',
    'yml': 'yml-Latn-ZZ',
    'yo': 'yo-Latn-NG',
    'yon': 'yon-Latn-ZZ',
    'yrb': 'yrb-Latn-ZZ',
    'yre': 'yre-Latn-ZZ',
    'yrl': 'yrl-Latn-BR',
    'yss': 'yss-Latn-ZZ',
    'yua': 'yua-Latn-MX',
    'yue': 'yue-Hant-HK',
    'yue-CN': 'yue-Hans-CN',
    'yue-Hans': 'yue-Hans-CN',
    'yuj': 'yuj-Latn-ZZ',
    'yut': 'yut-Latn-ZZ',
    'yuw': 'yuw-Latn-ZZ',
    'za': 'za-Latn-CN',
    'zag': 'zag-Latn-SD',
    'zdj': 'zdj-Arab-KM',
    'zea': 'zea-Latn-NL',
    'zgh': 'zgh-Tfng-MA',
    'zh': 'zh-Hans-CN',
    'zh-AU': 'zh-Hant-AU',
    'zh-BN': 'zh-Hant-BN',
    'zh-Bopo': 'zh-Bopo-TW',
    'zh-GB': 'zh-Hant-GB',
    'zh-GF': 'zh-Hant-GF',
    'zh-HK': 'zh-Hant-HK',
    'zh-Hanb': 'zh-Hanb-TW',
    'zh-Hant': 'zh-Hant-TW',
    'zh-ID': 'zh-Hant-ID',
    'zh-MO': 'zh-Hant-MO',
    'zh-PA': 'zh-Hant-PA',
    'zh-PF': 'zh-Hant-PF',
    'zh-PH': 'zh-Hant-PH',
    'zh-SR': 'zh-Hant-SR',
    'zh-TH': 'zh-Hant-TH',
    'zh-TW': 'zh-Hant-TW',
    'zh-US': 'zh-Hant-US',
    'zh-VN': 'zh-Hant-VN',
    'zhx': 'zhx-Nshu-CN',
    'zia': 'zia-Latn-ZZ',
    'zkt': 'zkt-Kits-CN',
    'zlm': 'zlm-Latn-TG',
    'zmi': 'zmi-Latn-MY',
    'zne': 'zne-Latn-ZZ',
    'zu': 'zu-Latn-ZA',
    'zza': 'zza-Latn-TR',
}
LANGUAGE_DISTANCES = {
    '*': {'*': 80},
    '*_*': {'*_*': 50},
    'aa': {'ssy': 4},
    'aae': {'sq': 10},
    'aao': {'ar': 10},
    'aat': {'sq': 10},
    'ab': {'ru': 30},
    'abh': {'ar': 10},
    'abv': {'ar': 10},
    'ach': {'en': 30},
    'acm': {'ar': 10},
    'acq': {'ar': 10},
    'acw': {'ar': 10},
    'acx': {'ar': 10},
    'acy': {'ar': 10},
    'adf': {'ar': 10},
    'aeb': {'ar': 10},
    'aec': {'ar': 10},
    'af': {'nl': 20},
    'afb': {'ar': 10},
    'aii': {'syr': 10},
    'ajp': {'ar': 10},
    'ak': {'en': 30},
    'aln': {'sq': 10},
    'am': {'en': 30},
    'am_Ethi': {'en_Latn': 10},
    'apc': {'ar': 10},
    'apd': {'ar': 10},
    'ar_Latn': {'ar_Arab': 20},
    'arq': {'ar': 10},
    'ars': {'ar': 10},
    'ary': {'ar': 10},
    'arz': {'ar': 10},
    'auz': {'ar': 10},
    'avl': {'ar': 10},
    'ay': {'es': 20},
    'ayh': {'ar': 10},
    'ayl': {'ar': 10},
    'ayn': {'ar': 10},
    'ayp': {'ar': 10},
    'az': {'ru': 30},
    'az_Latn': {'ru_Cyrl': 10},
    'azb': {'az': 10},
    'bal': {'ur': 20},
    'bbz': {'ar': 10},
    'be': {'ru': 20},
    'bem': {'en': 30},
    'bh': {'hi': 30},
    'bhr': {'mg': 10},
    'bjn': {'ms': 10},
    'bjq': {'mg': 10},
    'bmm': {'mg': 10},
    'bn': {'en': 30},
    'bn_Beng': {'en_Latn': 10},
    'bn_Latn': {'bn_Beng': 20},
    'bo': {'zh': 20},
    'bo_Tibt': {'zh_Hans': 10},
    'br': {'fr': 20},
    'bs': {'hr': 4, 'sh': 4, 'sr': 5},
    'btj': {'ms': 10},
    'bve': {'ms': 10},
    'bvu': {'ms': 10},
    'bzc': {'mg': 10},
    'ca': {'es': 20},
    'cdo': {'zh': 10},
    'ceb': {'fil': 30},
    'chr': {'en': 20},
    'cjy': {'zh': 10},
    'ckb': {'ar': 30},
    'co': {'fr': 20},
    'coa': {'ms': 10},
    'cpx': {'zh': 10},
    'crs': {'fr': 20},
    'cs': {'sk': 20},
    'cy': {'en': 20},
    'czh': {'zh': 10},
    'czo': {'zh': 10},
    'da': {'no': 8, 'nb': 8},
    'dty': {'ne': 10},
    'dup': {'ms': 10},
    'ee': {'en': 30},
    'enb': {'kln': 10},
    'eo': {'en': 30},
    'eu': {'es': 20},
    'eyo': {'kln': 10},
    'ffm': {'ff': 10},
    'fo': {'da': 20},
    'fub': {'ff': 10},
    'fue': {'ff': 10},
    'fuf': {'ff': 10},
    'fuh': {'ff': 10},
    'fui': {'ff': 10},
    'fuq': {'ff': 10},
    'fuv': {'ff': 10},
    'fy': {'nl': 20},
    'ga': {'en': 20},
    'gaa': {'en': 30},
    'gan': {'zh': 10},
    'gax': {'om': 10},
    'gd': {'en': 20},
    'gkp': {'kpe': 10},
    'gl': {'es': 20},
    'gn': {'es': 20},
    'gnw': {'gn': 10},
    'gom': {'kok': 10},
    'gsw': {'de': 4},
    'gu': {'hi': 30},
    'gu_Latn': {'gu_Gujr': 20},
    'gui': {'gn': 10},
    'gun': {'gn': 10},
    'ha': {'en': 30},
    'hae': {'om': 10},
    'hak': {'zh': 10},
    'haw': {'en': 20},
    'hi_Latn': {'hi_Deva': 20},
    'hji': {'ms': 10},
    'hr': {'bs': 4, 'sh': 4, 'sr': 5},
    'hsn': {'zh': 10},
    'ht': {'fr': 20},
    'hy': {'ru': 30},
    'hy_Armn': {'ru_Cyrl': 10},
    'ia': {'en': 30},
    'id': {'ms': 10},
    'ida': {'luy': 10},
    'ig': {'en': 30},
    'ikt': {'iu': 10},
    'is': {'en': 20},
    'ja_Hani': {'ja_Jpan': 5},
    'ja_Hira': {'ja_Jpan': 5, 'ja_Hrkt': 5},
    'ja_Hrkt': {'ja_Jpan': 5},
    'ja_Kana': {'ja_Jpan': 5, 'ja_Hrkt': 5},
    'ja_Latn': {'ja_Jpan': 5},
    'jak': {'ms': 10},
    'jax': {'ms': 10},
    'jv': {'id': 20},
    'ka': {'en': 30},
    'ka_Geor': {'en_Latn': 10},
    'kg': {'fr': 30},
    'kk': {'ru': 30},
    'km': {'en': 30},
    'km_Khmr': {'en_Latn': 10},
    'kn': {'en': 30},
    'kn_Knda': {'en_Latn': 10},
    'kn_Latn': {'kn_Knda': 20},
    'ko_Hang': {'ko_Kore': 5},
    'ko_Hani': {'ko_Kore': 5},
    'ko_Jamo': {'ko_Kore': 5, 'ko_Hang': 5},
    'kri': {'en': 30},
    'ku': {'tr': 30},
    'kvb': {'ms': 10},
    'kvr': {'ms': 10},
    'kxd': {'ms': 10},
    'ky': {'ru': 30},
    'la': {'it': 20},
    'lb': {'de': 4},
    'lce': {'ms': 10},
    'lcf': {'ms': 10},
    'lg': {'en': 30},
    'liw': {'ms': 10},
    'lkb': {'luy': 10},
    'lko': {'luy': 10},
    'lks': {'luy': 10},
    'ln': {'fr': 30},
    'lo': {'en': 30},
    'lo_Laoo': {'en_Latn': 10},
    'loz': {'en': 30},
    'lri': {'luy': 10},
    'lrm': {'luy': 10},
    'lsm': {'luy': 10},
    'ltg': {'lv': 10},
    'lto': {'luy': 10},
    'lts': {'luy': 10},
    'lua': {'fr': 30},
    'lwg': {'luy': 10},
    'lzh': {'zh': 10},
    'mai': {'hi': 20},
    'max': {'ms': 10},
    'meo': {'ms': 10},
    'mfa': {'ms': 10},
    'mfb': {'ms': 10},
    'mfe': {'en': 30},
    'mg': {'fr': 30},
    'mi': {'en': 20},
    'min': {'ms': 10},
    'ml': {'en': 30},
    'ml_Latn': {'ml_Mlym': 20},
    'ml_Mlym': {'en_Latn': 10},
    'mn': {'ru': 30},
    'mnp': {'zh': 10},
    'mqg': {'ms': 10},
    'mr': {'hi': 30},
    'mr_Latn': {'mr_Deva': 20},
    'ms': {'id': 30},
    'msh': {'mg': 10},
    'msi': {'ms': 10},
    'mt': {'en': 30},
    'mui': {'ms': 10},
    'mvf': {'mn': 10},
    'my': {'en': 30},
    'my_Mymr': {'en_Latn': 10},
    'nan': {'zh': 10},
    'nb': {'no': 1, 'da': 8, 'nn': 20},
    'ne': {'en': 30},
    'ne_Deva': {'en_Latn': 10},
    'nhd': {'gn': 10},
    'niq': {'kln': 10},
    'nle': {'luy': 10},
    'nn': {'nb': 20, 'no': 20},
    'no': {'nb': 1, 'da': 8, 'nn': 20},
    'nso': {'en': 30},
    'ny': {'en': 30},
    'nyd': {'luy': 10},
    'nyn': {'en': 30},
    'oc': {'fr': 20},
    'oki': {'kln': 10},
    'om': {'en': 30},
    'or': {'en': 30},
    'or_Orya': {'en_Latn': 10},
    'orc': {'om': 10},
    'orn': {'ms': 10},
    'ors': {'ms': 10},
    'pa': {'en': 30},
    'pa_Guru': {'en_Latn': 10},
    'pbt': {'ps': 10},
    'pcm': {'en': 20},
    'pel': {'ms': 10},
    'pga': {'ar': 10},
    'pko': {'kln': 10},
    'ps': {'en': 30},
    'ps_Arab': {'en_Latn': 10},
    'pse': {'ms': 10},
    'pst': {'ps': 10},
    'qu': {'es': 30},
    'qub': {'qu': 10},
    'qud': {'qu': 10},
    'quf': {'qu': 10},
    'qug': {'qu': 10},
    'quh': {'qu': 10},
    'quk': {'qu': 10},
    'qul': {'qu': 10},
    'qup': {'qu': 10},
    'qur': {'qu': 10},
    'qus': {'qu': 10},
    'quw': {'qu': 10},
    'qux': {'qu': 10},
    'quy': {'qu': 10},
    'qva': {'qu': 10},
    'qvc': {'qu': 10},
    'qve': {'qu': 10},
    'qvh': {'qu': 10},
    'qvi': {'qu': 10},
    'qvj': {'qu': 10},
    'qvl': {'qu': 10},
    'qvm': {'qu': 10},
    'qvn': {'qu': 10},
    'qvo': {'qu': 10},
    'qvp': {'qu': 10},
    'qvs': {'qu': 10},
    'qvw': {'qu': 10},
    'qvz': {'qu': 10},
    'qwa': {'qu': 10},
    'qwc': {'qu': 10},
    'qwh': {'qu': 10},
    'qws': {'qu': 10},
    'qxa': {'qu': 10},
    'qxc': {'qu': 10},
    'qxh': {'qu': 10},
    'qxl': {'qu': 10},
    'qxn': {'qu': 10},
    'qxo': {'qu': 10},
    'qxp': {'qu': 10},
    'qxr': {'qu': 10},
    'qxt': {'qu': 10},
    'qxu': {'qu': 10},
    'qxw': {'qu': 10},
    'rag': {'luy': 10},
    'rm': {'de': 20},
    'rn': {'en': 30},
    'rw': {'fr': 30},
    'sa': {'hi': 30},
    'sd': {'en': 30},
    'sd_Arab': {'en_Latn': 10},
    'sdc': {'sc': 10},
    'sdn': {'sc': 10},
    'sgc': {'kln': 10},
    'sh': {'bs': 4, 'hr': 4, 'sr': 4},
    'shu': {'ar': 10},
    'si': {'en': 30},
    'si_Sinh': {'en_Latn': 10},
    'sk': {'cs': 20},
    'skg': {'mg': 10},
    'sn': {'en': 30},
    'so': {'en': 30},
    'spv': {'or': 10},
    'sq': {'en': 30},
    'sr': {'bs': 5, 'hr': 5, 'sh': 4},
    'sr_Cyrl': {'sr_Latn': 5},
    'sr_Latn': {'sr_Cyrl': 5},
    'sro': {'sc': 10},
    'ssh': {'ar': 10},
    'ssy': {'aa': 4},
    'st': {'en': 30},
    'su': {'id': 20},
    'sw': {'en': 30},
    'ta': {'en': 30},
    'ta_Latn': {'ta_Taml': 20},
    'ta_Taml': {'en_Latn': 10},
    'tdx': {'mg': 10},
    'te': {'en': 30},
    'te_Latn': {'te_Telu': 20},
    'te_Telu': {'en_Latn': 10},
    'tec': {'kln': 10},
    'tg': {'ru': 30},
    'ti': {'en': 30},
    'ti_Ethi': {'en_Latn': 10},
    'tk': {'ru': 30},
    'tk_Latn': {'ru_Cyrl': 10},
    'tkg': {'mg': 10},
    'tlh': {'en': 30},
    'tmw': {'ms': 10},
    'tn': {'en': 30},
    'to': {'en': 30},
    'tt': {'ru': 30},
    'tum': {'en': 30},
    'tuy': {'kln': 10},
    'txy': {'mg': 10},
    'ug': {'zh': 20},
    'uk': {'ru': 20},
    'ur': {'en': 30},
    'ur_Arab': {'en_Latn': 10},
    'urk': {'ms': 10},
    'uz': {'ru': 30},
    'uz_Latn': {'ru_Cyrl': 10},
    'uzs': {'uz': 10},
    'vkk': {'ms': 10},
    'vkt': {'ms': 10},
    'vro': {'et': 10},
    'wo': {'fr': 30},
    'wuu': {'zh': 10},
    'xh': {'en': 30},
    'xmm': {'ms': 10},
    'xmv': {'mg': 10},
    'xmw': {'mg': 10},
    'yi': {'en': 30},
    'yi_Hebr': {'en_Latn': 10},
    'yih': {'yi': 10},
    'yo': {'en': 30},
    'yue': {'zh': 10},
    'za': {'zh': 20},
    'za_Latn': {'zh_Hans': 10},
    'zh_Hani': {'zh_Hans': 20, 'zh_Hant': 20},
    'zh_Latn': {'zh_Hans': 20},
    'zlm': {'ms': 10},
    'zmi': {'ms': 10},
    'zu': {'en': 30},
}
VALIDITY = re.compile('^(aa|aa[a-i]|aa[k-l]|aa[n-q]|aa[s-x]|aaz|ab|ab[a-j]|ab[l-z]|ac[a-b]|ac[d-f]|ac[h-i]|ac[k-n]|ac[p-z]|ad[a-b]|ad[d-j]|adl|ad[n-o]|ad[q-u]|ad[w-z]|ae|ae[a-e]|ae[k-n]|ae[q-s]|aeu|aew|ae[y-z]|af|af[a-b]|af[d-e]|af[g-i]|afk|af[n-p]|af[s-u]|afz|ag[a-o]|ag[q-z]|ah[a-b]|ah[g-i]|ah[k-p]|ah[r-t]|ai[a-r]|ait|ai[w-y]|aja|ajg|aji|ajn|ajp|ajt|ajw|ajz|ak|ak[b-m]|ak[o-z]|ala|al[c-r]|al[t-z]|am|am[a-c]|am[e-g]|am[i-z]|an|an[a-z]|ao[a-g]|ao[i-n]|ao[r-u]|aox|aoz|ap[a-z]|aqa|aq[c-d]|aqg|aq[k-n]|aqp|aqr|aqt|aqz|ar|ar[c-e]|ar[h-l]|ar[n-z]|as|as[a-c]|as[e-l]|as[n-z]|at[a-e]|at[g-z]|au[a-d]|au[f-u]|au[w-z]|av|avb|avd|avi|av[k-o]|av[s-v]|aw[a-e]|aw[g-i]|awk|aw[m-o]|aw[r-y]|axb|axe|axg|ax[k-m]|axx|ay|ay[a-e]|ay[g-i]|ay[k-l]|ay[n-q]|ay[s-u]|ayz|az|az[a-d]|azg|az[m-o]|azt|azz|ba|ba[a-j]|bal|ba[n-p]|ba[r-y]|bb[a-y]|bc[a-b]|bc[d-k]|bc[m-w]|bc[y-z]|bd[a-z]|be|be[a-k]|bem|be[o-z]|bf[a-u]|bf[w-z]|bg|bg[a-g]|bg[i-l]|bg[n-z]|bh[a-j]|bh[l-z]|bi|bi[a-b]|bi[d-g]|bi[k-r]|bi[t-z]|bj[a-c]|bj[e-p]|bj[r-z]|bka|bk[c-d]|bk[f-z]|bl[a-f]|bl[h-t]|bl[v-z]|bm|bm[a-x]|bmz|bn|bn[a-g]|bn[i-z]|bo|bo[a-b]|bo[e-r]|bo[t-z]|bpa|bp[d-e]|bp[g-z]|bq[a-d]|bq[f-z]|br|br[a-d]|br[f-z]|bs|bs[a-c]|bs[e-y]|bta|bt[c-k]|bt[m-z]|bu[a-k]|bu[m-q]|bu[s-z]|bv[a-r]|bv[t-z]|bw[a-u]|bw[w-z]|bx[a-j]|bx[l-q]|bxs|bx[u-w]|bxz|by[a-t]|by[v-x]|byz|bz[a-z]|ca|ca[a-s]|ca[u-z]|cb[a-d]|cbg|cb[i-l]|cb[n-o]|cb[q-w]|cby|cc[c-e]|cc[g-h]|ccj|cc[l-p]|cc[r-s]|cda|cd[c-f]|cd[h-j]|cd[m-o]|cd[r-s]|cd[y-z]|ce|ce[a-b]|ceg|ce[k-l]|cen|cet|cey|cfa|cfd|cfg|cfm|cga|cgc|cgg|cgk|ch|ch[b-d]|ch[f-h]|ch[j-r]|cht|ch[w-z]|ci[a-e]|cih|cik|ci[m-n]|cip|cir|ciw|ciy|cja|cje|cj[h-i]|cjk|cj[m-p]|cjs|cjv|cjy|ckb|ckh|ck[l-o]|ck[q-v]|ck[x-z]|cla|clc|cle|cl[h-m]|clo|cl[t-u]|clw|cly|cma|cmc|cme|cmg|cmi|cm[l-m]|cmo|cm[r-t]|cn[a-c]|cn[g-i]|cn[k-l]|cn[o-p]|cn[s-u]|cn[w-x]|co|co[a-h]|co[j-q]|co[t-x]|coz|cp[a-c]|cp[e-g]|cpi|cp[n-p]|cps|cpu|cp[x-y]|cqd|cr|cr[a-d]|cr[f-t]|cr[v-z]|cs|cs[a-z]|cta|ct[c-e]|ct[g-h]|ct[l-p]|ct[s-u]|ct[y-z]|cu|cu[a-c]|cu[g-l]|cu[o-y]|cv|cvg|cvn|cw[a-b]|cwe|cwg|cwt|cy|cy[a-b]|cyo|czh|czk|cz[n-o]|czt|da|daa|da[c-e]|da[g-m]|dao|da[q-s]|da[u-z]|db[a-b]|db[d-g]|db[i-j]|db[l-r]|db[t-w]|dby|dcc|dcr|dda|dd[d-e]|ddg|dd[i-j]|dd[n-o]|dd[r-s]|ddw|de|de[c-i]|de[k-n]|de[p-s]|dev|dez|dg[a-e]|dg[g-i]|dg[k-l]|dgn|dg[r-t]|dg[w-x]|dgz|dhg|dhi|dh[l-o]|dh[r-s]|dh[u-x]|di[a-d]|di[f-j]|di[l-p]|di[r-s]|diu|di[w-z]|dj[a-f]|dj[i-k]|dj[m-o]|djr|dju|djw|dka|dkg|dkk|dk[r-s]|dkx|dlg|dlk|dl[m-n]|dm[a-g]|dm[k-o]|dm[r-s]|dm[u-y]|dna|dn[d-e]|dng|dn[i-k]|dn[n-o]|dnr|dn[t-w]|dny|do[a-c]|do[e-f]|do[h-i]|do[k-l]|do[n-t]|do[v-z]|dpp|dr[a-e]|drg|dri|drl|dr[n-o]|drq|dr[s-u]|dry|dsb|dse|ds[h-i]|dsl|ds[n-o]|dsq|dt[a-b]|dtd|dt[h-i]|dtk|dt[m-p]|dt[r-u]|dty|du[a-c]|du[e-i]|du[k-s]|du[u-z]|dv|dva|dwa|dwk|dw[r-s]|dwu|dww|dw[y-z]|dy[a-b]|dyd|dyg|dyi|dy[m-o]|dyu|dyy|dz|dza|dze|dzg|dzl|dzn|eaa|ebc|ebg|ebk|ebo|ebr|ebu|ec[r-s]|ecy|ee|eee|efa|efe|efi|ega|egl|ego|eg[x-y]|ehs|ehu|eip|eit|eiv|eja|eka|eke|ekg|eki|ek[l-m]|ek[o-p]|ekr|eky|el|ele|el[h-i]|elk|elm|elo|elu|elx|em[a-b]|eme|emg|emi|em[m-n]|em[p-q]|ems|emu|em[w-z]|en|en[a-d]|enf|enh|en[l-o]|en[q-r]|en[u-x]|eo|eot|epi|era|er[g-i]|erk|ero|er[r-t]|erw|es|ese|es[g-i]|es[l-o]|esq|ess|esu|es[x-y]|et|et[b-c]|eth|et[n-o]|et[r-u]|etx|etz|eu|euq|eve|evh|evn|ewo|ext|eya|eyo|eza|eze|fa|fa[a-b]|fad|fa[f-n]|fap|far|fau|fa[x-z]|fbl|fcs|fer|ff|ffi|ffm|fgr|fi|fia|fi[e-f]|fil|fip|fir|fi[t-u]|fiw|fj|fkk|fkv|fla|fl[h-i]|fll|fln|flr|fly|fmp|fmu|fnb|fng|fni|fo|fod|foi|fo[m-n]|fo[r-s]|fox|fpe|fqs|fr|fr[c-d]|frk|frm|fr[o-t]|fse|fsl|fss|fub|fu[d-f]|fu[h-j]|fu[m-n]|fu[q-r]|fu[t-v]|fuy|fvr|fwa|fwe|fy|ga|ga[a-u]|ga[w-y]|gb[a-b]|gb[d-n]|gb[p-s]|gb[u-z]|gc[c-f]|gcl|gcn|gcr|gct|gd|gd[a-o]|gd[q-u]|gdx|ge[a-d]|ge[f-m]|geq|ges|ge[v-z]|gfk|gft|gg[a-b]|gg[d-e]|ggg|gg[k-l]|gg[t-u]|ggw|gha|ghc|ghe|ghh|gh[k-l]|gh[n-o]|gh[r-t]|gi[a-e]|gi[g-i]|gi[l-n]|gi[p-u]|gi[w-z]|gjk|gj[m-n]|gjr|gju|gka|gk[d-e]|gk[n-p]|gku|gl|gl[b-d]|glh|gl[j-l]|glo|glr|glu|glw|gly|gm[a-b]|gm[d-e]|gm[g-h]|gm[l-n]|gm[q-r]|gm[u-z]|gn|gn[a-e]|gn[g-n]|gn[q-r]|gn[t-u]|gnw|gnz|go[a-u]|go[w-z]|gpa|gpe|gpn|gqa|gqi|gqn|gqr|gqu|gr[a-d]|gr[g-k]|grm|gro|gr[q-z]|gse|gsg|gs[l-p]|gss|gsw|gta|gtu|gu|gu[a-f]|gu[h-i]|gu[k-u]|gu[w-x]|guz|gv|gva|gvc|gv[e-f]|gvj|gv[l-p]|gv[r-s]|gvy|gw[a-g]|gw[i-j]|gw[m-n]|gwr|gw[t-u]|gw[w-x]|gxx|gyb|gy[d-g]|gyi|gy[l-o]|gyr|gy[y-z]|gza|gzi|gzn|ha|ha[a-s]|ha[v-z]|hb[a-b]|hb[n-o]|hbu|hca|hch|hds|hdy|he|hed|he[g-i]|hem|hgm|hgw|hhi|hhr|hhy|hi|hi[a-b]|hid|hi[f-l]|hio|hir|hit|hi[w-x]|hji|hka|hke|hkh|hkk|hkn|hks|hl[a-b]|hl[d-e]|hl[t-u]|hm[a-n]|hm[p-z]|hna|hn[d-e]|hn[g-j]|hn[n-o]|hns|hnu|ho|ho[a-e]|ho[h-m]|ho[o-p]|ho[r-t]|ho[v-w]|ho[y-z]|hpo|hps|hr|hra|hrc|hre|hrk|hrm|hr[o-p]|hr[t-u]|hr[w-x]|hrz|hsb|hsh|hsl|hsn|hss|ht|hti|hto|hts|htu|htx|hu|hu[b-m]|hu[o-z]|hvc|hve|hvk|hvn|hvv|hwa|hwc|hwo|hy|hya|hy[w-x]|hz|ia|iai|ian|iar|ib[a-b]|ib[d-e]|ib[g-h]|ib[l-n]|ibr|ibu|iby|ica|ich|icl|icr|id|id[a-e]|idi|id[r-u]|ie|if[a-b]|if[e-f]|ifk|ifm|ifu|ify|ig|igb|ige|igg|ig[l-o]|igs|igw|ihb|ihi|ihp|ihw|ii|iin|iir|ijc|ije|ijj|ij[n-o]|ijs|ik|iki|ik[k-l]|ik[o-p]|ik[r-t]|ik[v-x]|ikz|il[a-b]|ilg|ili|ilk|ilm|il[o-p]|ils|il[u-v]|ima|imi|iml|im[n-o]|im[r-s]|imy|in[b-c]|ine|in[g-h]|inj|in[l-p]|in[s-t]|inz|io|ior|iou|iow|ipi|ipo|iqu|iqw|ira|ire|ir[h-i]|irk|ir[n-o]|irr|iru|ir[x-y]|is|isa|is[c-e]|is[g-i]|isk|is[m-o]|isr|is[t-u]|it|it[b-e]|iti|it[k-m]|ito|it[r-t]|it[v-z]|iu|ium|ivb|ivv|iwk|iwm|iwo|iws|ixc|ixl|iya|iyo|iyx|izh|izr|izz|ja|ja[a-f]|jah|ja[j-o]|jaq|ja[s-u]|ja[x-z]|jbe|jb[i-k]|jb[m-o]|jbr|jb[t-u]|jbw|jc[s-t]|jda|jdg|jdt|jeb|jee|je[h-i]|je[k-l]|jen|jer|je[t-u]|jgb|jge|jgk|jgo|jhi|jhs|ji[a-e]|ji[g-i]|ji[l-m]|jio|jiq|ji[t-v]|jiy|jje|jjr|jka|jkm|jk[o-p]|jk[r-s]|jku|jle|jls|jm[a-d]|jmi|jml|jmn|jm[r-s]|jm[w-x]|jna|jnd|jng|jn[i-j]|jnl|jns|job|jod|jog|jo[r-s]|jow|jpa|jpr|jpx|jqr|jr[a-b]|jrr|jr[t-u]|jsl|ju[a-d]|ju[h-i]|ju[k-p]|ju[r-u]|juw|juy|jv|jvd|jvn|jwi|jya|jye|jyy|ka|ka[a-k]|kam|ka[o-r]|ka[v-y]|kb[a-e]|kb[g-z]|kc[a-z]|kda|kd[c-r]|kd[t-u]|kd[w-z]|ke[a-z]|kf[a-z]|kg|kg[a-b]|kg[e-g]|kg[i-y]|kh[a-j]|khl|kh[n-z]|ki|ki[a-j]|ki[l-m]|ki[o-q]|ki[s-z]|kj|kj[a-e]|kj[g-v]|kj[x-z]|kk|kk[a-z]|kl|kl[a-z]|km|km[a-q]|km[s-z]|kn|kn[a-b]|kn[d-f]|kn[i-m]|kn[o-z]|ko|koa|ko[c-i]|ko[k-l]|ko[o-q]|ko[s-w]|ko[y-z]|kp[a-o]|kp[q-u]|kp[w-z]|kq[a-z]|kr|kr[a-f]|kr[h-l]|kr[n-p]|kr[r-z]|ks|ks[a-z]|kt[a-q]|kt[s-z]|ku|ku[b-q]|ku[s-z]|kv|kv[a-r]|kv[t-z]|kw|kw[a-p]|kw[r-z]|kx[a-d]|kxf|kx[h-k]|kx[m-t]|kx[v-z]|ky|ky[a-z]|kz[a-g]|kzi|kz[k-s]|kz[u-z]|la|la[a-n]|la[p-s]|lau|la[w-z]|lb|lb[b-c]|lb[e-g]|lb[i-j]|lb[l-o]|lb[q-z]|lc[c-f]|lch|lc[l-m]|lc[p-q]|lcs|ld[a-b]|ldd|ld[g-q]|le[a-f]|le[h-z]|lfa|lfn|lg|lg[a-b]|lg[g-i]|lg[k-n]|lg[q-r]|lg[t-u]|lgz|lha|lh[h-i]|lh[l-n]|lhp|lh[s-u]|li|li[a-h]|li[j-l]|li[o-s]|li[u-z]|lja|lje|lji|ljl|ljp|lj[w-x]|lk[a-e]|lk[h-j]|lk[l-o]|lk[r-u]|lky|ll[a-n]|ll[p-q]|lls|llu|llx|lm[a-l]|lm[n-r]|lm[u-y]|ln|ln[a-b]|lnd|ln[g-j]|ln[l-o]|lns|lnu|lnw|lnz|lo|lo[a-c]|lo[e-z]|lpa|lpe|lp[n-o]|lpx|lra|lrc|lre|lrg|lri|lr[k-o]|lrr|lrt|lrv|lrz|ls[a-b]|ls[d-e]|ls[h-i]|ls[l-p]|ls[r-t]|lsv|lsy|lt|ltc|lt[g-i]|lt[n-o]|lts|ltu|lu|lua|lu[c-f]|lu[i-w]|lu[y-z]|lv|lva|lvi|lvk|lvu|lwa|lwe|lw[g-h]|lw[l-m]|lwo|lw[s-u]|lww|lxm|lya|lyg|lyn|lzh|lzl|lzn|lzz|ma[a-b]|ma[d-g]|ma[i-k]|ma[m-n]|ma[p-q]|ma[s-x]|maz|mb[a-f]|mb[h-z]|mc[a-z]|md[a-n]|md[p-z]|me[a-f]|me[h-w]|me[y-z]|mf[a-z]|mg|mg[a-w]|mg[y-z]|mh|mh[a-g]|mh[i-q]|mh[s-u]|mh[w-z]|mi|mi[a-r]|mi[t-u]|mi[w-z]|mj[b-e]|mj[g-z]|mk|mk[a-c]|mk[e-z]|ml|ml[a-c]|ml[e-f]|ml[h-s]|ml[u-x]|mlz|mm[a-r]|mm[t-z]|mn|mn[a-j]|mn[l-s]|mn[u-z]|moa|mo[c-e]|mo[g-k]|mom|mo[o-z]|mp[a-e]|mp[g-z]|mq[a-c]|mq[e-z]|mr|mr[a-h]|mr[j-z]|ms|ms[b-s]|ms[u-z]|mt|mt[a-y]|mu[a-e]|mu[g-k]|mu[m-o]|mu[q-v]|mu[x-z]|mv[a-b]|mv[d-i]|mv[k-l]|mv[n-z]|mw[a-c]|mw[e-i]|mw[k-w]|mwz|mx[a-z]|my|my[b-c]|my[e-h]|my[j-p]|my[r-s]|my[u-z]|mz[a-e]|mz[g-z]|na|na[a-c]|na[e-t]|na[w-z]|nb|nb[a-e]|nb[g-k]|nb[m-w]|nby|nc[a-o]|nc[q-u]|ncx|ncz|nd|nd[a-d]|nd[f-n]|nd[p-z]|ne|ne[a-k]|ne[m-o]|ne[q-z]|nfa|nfd|nfl|nfr|nfu|ng|ng[a-n]|ng[p-z]|nh[a-i]|nhk|nh[m-r]|nh[t-z]|ni[a-o]|ni[q-z]|nj[a-b]|njd|nj[h-j]|nj[l-o]|nj[r-u]|nj[x-z]|nk[a-k]|nk[m-x]|nkz|nl|nla|nlc|nle|nlg|nl[i-m]|nlo|nlq|nl[u-z]|nm[a-z]|nn|nn[a-n]|nn[p-r]|nn[t-w]|nn[y-z]|no|noa|no[c-n]|no[p-q]|no[s-w]|no[y-z]|np[a-b]|np[g-h]|npl|np[n-o]|nps|npu|np[x-y]|nqg|nq[k-o]|nqq|nqt|nqy|nr|nr[a-c]|nr[e-g]|nri|nr[k-n]|nrp|nrr|nr[t-u]|nrx|nrz|ns[a-i]|ns[k-z]|nt[d-e]|ntg|nt[i-k]|ntm|nt[o-p]|ntr|ntu|nt[w-z]|nu[a-z]|nv|nvh|nvm|nvo|nw[a-c]|nwe|nwg|nwi|nwm|nwo|nwr|nw[x-y]|nxa|nx[d-e]|nxg|nxi|nx[k-o]|nx[q-r]|nxx|ny|ny[b-y]|nz[a-b]|nzd|nzi|nzk|nzm|nzs|nzu|nz[y-z]|oaa|oac|oar|oav|obi|ob[k-m]|obo|obr|ob[t-u]|oc|oca|och|ocm|oco|ocu|oda|odk|od[t-u]|ofo|ofs|ofu|og[b-c]|oge|ogg|ogo|ogu|oh[t-u]|oia|oin|oj|oj[b-c]|ojp|ojs|oj[v-w]|ok[a-e]|ok[g-o]|ok[r-s]|ok[u-v]|okx|okz|ola|ol[d-e]|olk|olm|olo|olr|ol[t-u]|om|om[a-c]|omg|omi|om[k-l]|om[n-r]|om[t-y]|on[a-b]|one|ong|on[i-k]|on[n-p]|on[r-u]|on[w-x]|ood|oog|oon|oo[r-s]|opa|opk|opm|opo|opt|opy|or|ora|orc|ore|or[g-h]|or[n-o]|or[r-x]|orz|os|osa|osc|osi|os[n-p]|os[t-u]|osx|ot[a-b]|ot[d-e]|oti|ot[k-o]|ot[q-u]|ot[w-z]|ou[a-b]|oue|oui|oum|ovd|owi|owl|oyb|oyd|oym|oyy|ozm|pa|pa[a-i]|pa[k-m]|pa[o-s]|pa[u-z]|pb[b-c]|pb[e-i]|pb[l-p]|pb[r-t]|pbv|pby|pc[a-n]|pcp|pcw|pda|pdc|pdi|pd[n-o]|pd[t-u]|pe[a-b]|pe[d-m]|pe[o-q]|pev|pe[x-z]|pfa|pfe|pfl|pga|pgd|pgg|pgi|pg[k-l]|pgn|pgs|pgu|pgz|pha|phd|ph[g-i]|ph[k-o]|ph[q-r]|ph[t-w]|pi|pi[a-j]|pi[l-p]|pi[r-z]|pjt|pk[a-c]|pk[g-h]|pk[n-p]|pk[r-u]|pl|pl[a-h]|pl[j-l]|pl[n-o]|pl[q-s]|pl[u-w]|pl[y-z]|pm[a-b]|pm[d-f]|pm[h-o]|pm[q-t]|pm[w-z]|pna|pn[c-e]|pn[g-z]|poc|po[e-i]|pok|po[m-q]|po[s-t]|po[v-z]|ppe|ppi|pp[k-q]|pp[s-u]|pqa|pqe|pqm|pqw|pra|pr[c-i]|pr[k-r]|pr[t-u]|pr[w-x]|prz|ps|psa|ps[c-e]|ps[g-i]|ps[l-u]|psw|psy|pt|pta|pt[h-i]|pt[n-r]|pt[t-w]|pty|pu[a-g]|pu[i-j]|pum|pu[o-r]|pu[t-u]|pu[w-y]|pw[a-b]|pwg|pwi|pw[m-o]|pwr|pww|pxm|pye|py[m-n]|pys|pyu|py[x-y]|pzn|qu|qu[a-d]|qu[f-i]|qu[k-n]|qu[p-s]|qu[v-y]|qva|qvc|qve|qv[h-j]|qv[l-p]|qvs|qvw|qv[y-z]|qwa|qwc|qwe|qwh|qwm|qw[s-t]|qxa|qxc|qxh|qxl|qx[n-u]|qxw|qya|qyp|ra[a-d]|ra[f-z]|rbb|rb[k-l]|rbp|rcf|rdb|re[a-b]|ree|reg|re[i-j]|re[l-n]|re[r-t]|rey|rga|rge|rgk|rgn|rg[r-s]|rgu|rhg|rhp|ria|rif|ri[l-n]|rir|ri[t-u]|rjg|rji|rjs|rk[a-b]|rk[h-i]|rkm|rkt|rkw|rm|rm[a-i]|rm[k-q]|rm[s-x]|rmz|rn|rnd|rng|rnl|rnn|rnp|rnr|rnw|ro|ro[a-g]|ro[l-m]|ro[o-p]|ror|rou|row|rpn|rpt|rri|rro|rrt|rsb|rs[l-m]|rtc|rth|rtm|rts|rtw|ru|ru[b-c]|ru[e-i]|ruk|ru[o-q]|ru[t-u]|ru[y-z]|rw|rwa|rw[k-m]|rwo|rwr|rxd|rxw|ryn|rys|ryu|rzh|sa|sa[a-f]|sa[h-m]|sao|sa[q-z]|sb[a-z]|sc|scb|sc[e-i]|sc[k-l]|sc[n-q]|sc[s-x]|sd|sd[a-c]|sd[e-h]|sd[j-l]|sd[n-v]|sdx|sdz|se|se[a-w]|se[y-z]|sfb|sfe|sfm|sfs|sfw|sg|sg[a-e]|sg[g-k]|sg[m-n]|sgp|sg[r-u]|sg[w-z]|sh[a-e]|sh[g-z]|si|si[a-b]|si[d-m]|si[o-z]|sj[a-b]|sj[d-e]|sjg|sj[k-p]|sj[r-u]|sjw|sk|sk[a-j]|sk[m-z]|sl|sla|sl[c-j]|sl[l-n]|sl[p-u]|sl[w-z]|sm|sm[a-d]|sm[f-n]|sm[p-z]|sn|sn[b-c]|sn[e-g]|sn[i-s]|sn[u-z]|so|so[a-e]|so[g-l]|so[n-s]|so[u-z]|sp[b-e]|spg|spi|sp[k-v]|spx|sq|sqa|sqh|sq[j-k]|sq[m-o]|sq[q-u]|sqx|sr|sr[a-b]|sr[e-i]|sr[k-o]|sr[q-z]|ss|ss[a-v]|ss[x-z]|st|st[a-b]|st[d-w]|sty|su|su[a-c]|sue|sug|su[i-k]|suo|su[q-t]|su[v-z]|sv|sv[a-c]|sve|svk|svm|svs|svx|sw|swb|sw[f-g]|sw[i-y]|sx[b-c]|sxe|sxg|sx[k-o]|sx[r-s]|sxu|sxw|sy[a-d]|syi|sy[k-o]|sy[r-s]|sy[w-y]|sz[a-e]|szg|szl|szn|szp|szs|sz[v-w]|szy|ta|ta[a-g]|ta[i-l]|ta[n-s]|ta[u-z]|tba|tb[c-z]|tc[a-i]|tc[k-q]|tc[s-u]|tc[w-z]|td[a-o]|td[q-t]|tdv|td[x-y]|te|te[a-i]|tek|te[m-z]|tfi|tf[n-o]|tfr|tft|tg|tg[a-f]|tg[h-j]|tg[n-z]|th|th[d-f]|th[h-i]|th[k-n]|th[p-v]|th[y-z]|ti|tia|tic|ti[f-q]|ti[s-z]|tja|tjg|tj[i-j]|tj[l-p]|tjs|tju|tjw|tk|tk[a-b]|tk[d-g]|tk[l-n]|tk[p-x]|tkz|tl[a-d]|tl[f-v]|tl[x-y]|tm[a-o]|tm[q-w]|tm[y-z]|tn|tn[a-d]|tn[g-i]|tn[k-z]|to|to[b-d]|to[f-j]|to[l-m]|to[o-s]|to[u-z]|tpa|tpc|tp[e-g]|tp[i-r]|tp[t-z]|tqb|tq[l-r]|tq[t-u]|tqw|tr|tr[a-z]|ts|ts[a-e]|ts[g-m]|ts[p-z]|tt|tt[a-p]|tt[r-w]|tt[y-z]|tu[a-j]|tu[l-q]|tu[s-z]|tva|tv[d-e]|tv[k-o]|tv[s-u]|tv[w-y]|tw[a-h]|tw[l-r]|tw[t-u]|tw[w-y]|tx[a-c]|txe|tx[g-j]|tx[m-o]|tx[q-u]|tx[x-y]|ty|tya|tye|ty[h-j]|tyl|tyn|typ|ty[r-v]|ty[x-z]|tza|tzh|tzj|tz[l-o]|tzx|ua[m-n]|uar|uba|ubi|ubl|ubr|ubu|uby|uda|ude|udg|ud[i-j]|ud[l-m]|udu|ues|ufi|ug|ug[a-b]|uge|ug[n-o]|ugy|uha|uhn|uis|uiv|uji|uk|uka|uk[g-i]|uk[k-l]|uk[p-q]|uks|uk[u-w]|uky|ul[a-c]|ul[e-f]|uli|ul[k-n]|ulu|ulw|um[a-d]|umg|umi|um[m-p]|um[r-s]|una|une|ung|uni|unk|un[m-n]|unr|unu|unx|unz|upi|upv|ur|ur[a-c]|ur[e-p]|urr|ur[t-z]|usa|us[h-i]|usk|usp|uss|usu|uta|ute|uth|utp|utr|utu|uu[m-n]|uur|uuu|uve|uvh|uvl|uwa|uya|uz|uzs|vaa|va[e-j]|va[l-p]|va[r-s]|va[u-v]|vay|vbb|vbk|ve|ve[c-d]|ve[l-m]|ve[o-p]|ver|vgr|vgt|vi|vi[c-d]|vi[f-g]|vil|vin|vi[s-t]|viv|vka|vk[j-p]|vk[t-u]|vkz|vlp|vls|vm[a-m]|vm[p-s]|vm[u-z]|vnk|vnm|vnp|vo|vor|vot|vra|vro|vr[s-t]|vsi|vsl|vsv|vto|vu[m-n]|vut|vwa|wa|wa[a-z]|wb[a-b]|wb[e-f]|wb[h-m]|wb[p-t]|wb[v-w]|wca|wci|wdd|wdg|wd[j-k]|wdu|wdy|wea|we[c-d]|we[g-i]|we[m-p]|we[r-u]|wew|wfg|wg[a-b]|wgg|wgi|wgo|wgu|wgy|wha|whg|whk|whu|wi[b-c]|wi[e-n]|wir|wi[u-v]|wiy|wja|wji|wk[a-b]|wkd|wkl|wkr|wku|wkw|wky|wla|wlc|wle|wl[g-i]|wl[k-m]|wlo|wl[r-s]|wl[u-y]|wm[a-e]|wm[g-i]|wm[m-o]|wm[s-t]|wm[w-x]|wn[b-e]|wng|wni|wnk|wn[m-p]|wnu|wnw|wny|wo|wo[a-g]|woi|wok|wo[m-o]|wo[r-s]|wow|woy|wpc|wrb|wrd|wr[g-i]|wr[k-p]|wr[r-s]|wr[u-z]|wsa|wsg|wsi|wsk|ws[r-s]|ws[u-v]|wtf|wt[h-i]|wtk|wtm|wtw|wu[a-b]|wud|wuh|wu[l-n]|wur|wu[t-v]|wu[x-y]|ww[a-b]|wwo|wwr|www|wxa|wxw|wy[a-b]|wyi|wym|wyr|wyy|xa[a-e]|xag|xa[i-w]|xay|xb[b-e]|xbg|xb[i-j]|xb[m-p]|xbr|xbw|xby|xc[b-c]|xce|xc[g-h]|xc[l-o]|xcr|xc[t-w]|xcy|xda|xdc|xdk|xdm|xdo|xdy|xeb|xed|xeg|xe[l-m]|xep|xe[r-u]|xfa|xg[a-b]|xgd|xg[f-g]|xgi|xg[l-n]|xgr|xgu|xgw|xh|xha|xh[c-e]|xhr|xh[t-v]|xib|xii|xil|xin|xi[r-s]|xiv|xiy|xjb|xjt|xk[a-g]|xk[i-l]|xk[n-z]|xl[a-e]|xlg|xli|xl[n-p]|xls|xlu|xly|xm[a-h]|xm[j-z]|xn[a-b]|xnd|xn[g-k]|xn[m-o]|xn[q-u]|xn[y-z]|xo[c-d]|xog|xoi|xok|xo[m-p]|xor|xow|xp[a-d]|xp[f-z]|xqa|xqt|xr[a-b]|xr[d-e]|xrg|xri|xr[m-n]|xrr|xr[t-u]|xrw|xs[a-e]|xs[h-i]|xs[m-s]|xs[u-v]|xsy|xt[a-e]|xt[g-j]|xt[l-w]|xty|xu[a-b]|xud|xug|xuj|xu[l-p]|xur|xu[t-u]|xve|xvi|xv[n-o]|xvs|xwa|xw[c-e]|xwg|xw[j-l]|xwo|xwr|xwt|xww|xxb|xxk|xxm|xxr|xxt|xy[a-b]|xy[j-l]|xyt|xyy|xzh|xzm|xzp|ya[a-z]|yb[a-b]|ybe|yb[h-o]|yb[x-y]|ych|ycl|ycn|ycp|yda|yde|ydg|ydk|yea|yec|yee|ye[i-j]|yel|ye[r-v]|yey|yga|ygi|yg[l-m]|ygp|yg[r-s]|ygu|ygw|yha|yhd|yhl|yhs|yi|yia|yi[f-n]|yi[p-v]|yix|yiz|yka|ykg|yki|yk[k-o]|ykr|yk[t-u]|yky|yl[a-b]|yle|ylg|yli|yl[l-o]|ylr|ylu|yly|ym[b-e]|ym[g-i]|ym[k-s]|ymx|ymz|yna|yn[d-e]|yng|yn[k-l]|yn[n-o]|ynq|yns|ynu|yo|yob|yog|yoi|yo[k-n]|yot|yo[x-y]|yp[a-b]|yp[g-h]|ypk|yp[m-p]|ypz|yr[a-b]|yre|yr[k-o]|yrs|yrw|yry|ys[c-d]|ysg|ys[l-p]|ys[r-s]|ysy|yta|ytl|ytp|ytw|yty|yu[a-g]|yu[i-n]|yu[p-r]|yut|yu[w-z]|yva|yvt|ywa|ywg|ywl|ywn|yw[q-r]|yw[t-u]|yww|yxa|yxg|yx[l-m]|yxu|yxy|yyr|yyu|yyz|yzg|yzk|za|za[a-h]|za[j-m]|za[o-z]|zba|zbc|zbe|zbl|zb[t-u]|zbw|zca|zch|zdj|zea|ze[g-h]|zen|zg[a-b]|zgh|zg[m-n]|zgr|zh|zhb|zhd|zhi|zhn|zh[w-x]|zi[a-b]|zi[k-n]|ziw|ziz|zk[a-b]|zkd|zk[g-h]|zkk|zk[n-p]|zkr|zk[t-v]|zkz|zla|zle|zlj|zl[m-n]|zlq|zls|zlw|zm[a-z]|zna|zn[d-e]|zng|znk|zns|zoc|zoh|zom|zoo|zo[q-s]|zp[a-z]|zqe|zra|zrg|zr[n-p]|zrs|zsa|zs[k-l]|zsr|zsu|zte|ztg|zt[l-n]|zt[p-q]|zt[s-u]|zt[x-y]|zu|zua|zuh|zu[m-n]|zuy|zwa|zyg|zyj|zyn|zyp|zza|zzj|mis|mul|zxx|aam|adp|agp|ais|aju|als|aoh|arb|asd|aue|ayr|ay[x-y]|azj|baz|bbz|bcc|bcl|bgm|bh|bhk|bic|bij|bjd|bjq|bkb|blg|bmy|bpb|btb|btl|bxk|bxr|bxx|byy|cbe|cbh|cca|ccq|cdg|cjr|cka|cld|cmk|cmn|cnr|coy|cqu|cum|cwd|daf|dap|dgo|dgu|dha|dhd|dik|diq|dit|djl|dkl|drh|drr|drw|dud|duj|dwl|dzd|ekc|ekk|elp|emk|emo|esk|fat|fuc|gav|gaz|gbc|gbo|gfx|gg[n-o]|ggr|gio|gji|gli|gno|gti|gug|guv|gya|hdn|hea|him|hrr|iap|ibi|ike|ill|ilw|ime|in|iw|izi|jar|jeg|ji|jw|kbf|kdv|kg[c-d]|kgh|khk|kjf|kmr|knc|kng|knn|koj|kox|kpp|kpv|krm|ktr|kvs|kwq|kxe|kxl|kxu|kzh|kzj|kzt|lba|lbk|leg|lii|llo|lmm|lmz|lsg|lvs|meg|mgx|mhh|mhr|mja|mld|mnk|mnt|mo|mof|mst|mup|mvm|mwd|mwj|mw[x-y]|myd|myi|myq|myt|nad|nbf|nbx|ncp|ngo|nln|nlr|nns|nnx|noo|npi|nts|nxu|ojg|ome|ory|oun|pat|pbu|pbz|pcr|pes|pgy|plp|plt|pmc|pmu|pnb|pod|ppa|ppr|prb|prs|pry|puk|puz|quz|rie|rmr|rmy|rna|rsi|sap|sca|sdm|sgl|sgo|sh|skk|snh|spy|src|su[l-m]|svr|swc|swh|tbb|tdu|tgg|thc|th[w-x]|ti[d-e]|tkk|tl|tlw|tmp|tn[e-f]|toe|tsf|ttq|tw|umu|unp|uok|uzn|vki|wgw|wit|wiw|wra|xba|xbx|xia|xip|xkh|xpe|xrq|xsj|xsl|xtz|ybd|ydd|yds|yen|yiy|yma|ymt|ynh|yos|yri|yuu|zai|zir|zsm|zyb|qa[a-z]|qb[a-z]|qc[a-z]|qd[a-z]|qe[a-z]|qf[a-y]|qfz|qg[a-z]|qh[a-z]|qi[a-z]|qj[a-z]|qk[a-z]|ql[a-z]|qm[a-z]|qn[a-z]|qo[a-z]|qp[a-z]|qq[a-z]|qr[a-z]|qs[a-z]|qt[a-z]|und|A[C-G]|AI|A[L-M]|AO|A[Q-U]|A[W-X]|AZ|B[A-B]|B[D-J]|B[L-O]|B[Q-T]|B[V-W]|B[Y-Z]|CA|C[C-D]|C[F-I]|C[K-P]|CR|C[U-Z]|DE|DG|D[J-K]|DM|DO|DZ|EA|EC|EE|E[G-H]|E[R-T]|F[I-K]|FM|FO|FR|G[A-B]|G[D-I]|G[L-N]|G[P-U]|GW|GY|HK|H[M-N]|HR|H[T-U]|I[C-E]|I[L-O]|I[Q-T]|JE|JM|J[O-P]|KE|K[G-I]|K[M-N]|KP|KR|KW|K[Y-Z]|L[A-C]|LI|LK|L[R-V]|LY|MA|M[C-H]|M[K-Z]|NA|NC|N[E-G]|NI|NL|N[O-P]|NR|NU|NZ|OM|PA|P[E-H]|P[K-N]|P[R-T]|PW|PY|QA|RE|RO|RS|RU|RW|S[A-E]|S[G-O]|S[R-T]|SV|S[X-Z]|TA|T[C-D]|T[F-H]|T[J-O]|TR|TT|T[V-W]|TZ|UA|UG|UM|US|U[Y-Z]|VA|VC|VE|VG|VI|VN|VU|WF|WS|XK|YE|YT|ZA|ZM|ZW|X[A-B]|00[1-3]|005|009|011|01[3-5]|01[7-9]|021|029|030|03[4-5]|039|05[3-4]|057|061|14[2-3]|145|15[0-1]|15[4-5]|202|419|EU|EZ|QO|UN|AN|BU|CS|DD|FX|NT|QU|SU|TP|YD|YU|ZR|AA|Q[M-N]|Q[P-T]|Q[V-Z]|X[C-J]|X[L-Z]|ZZ|Adlm|Aghb|Ahom|Arab|Armi|Armn|Avst|Bali|Bamu|Bass|Batk|Beng|Bhks|Bopo|Bra[h-i]|Bugi|Buhd|Cakm|Cans|Cari|Cham|Cher|Chrs|Copt|Cpmn|Cprt|Cyrl|Deva|Diak|Dogr|Dsrt|Dupl|Egyp|Elba|Elym|Ethi|Geor|Glag|Gong|Gonm|Goth|Gran|Grek|Gujr|Guru|Hanb|Hang|Hani|Hano|Han[s-t]|Hatr|Hebr|Hira|Hluw|Hmng|Hmnp|Hrkt|Hung|Ital|Jamo|Java|Jpan|Kali|Kana|Khar|Khmr|Khoj|Kits|Knda|Kore|Kthi|Lana|Laoo|Latn|Lepc|Limb|Lin[a-b]|Lisu|Lyci|Lydi|Mahj|Maka|Mand|Mani|Marc|Medf|Mend|Merc|Mero|Mlym|Modi|Mong|Mroo|Mtei|Mult|Mymr|Nand|Narb|Nbat|Newa|Nkoo|Nshu|Ogam|Olck|Orkh|Orya|Osge|Osma|Ougr|Palm|Pauc|Perm|Phag|Phli|Phlp|Phnx|Plrd|Prti|Rjng|Rohg|Runr|Samr|Sarb|Saur|Sgnw|Shaw|Shrd|Sidd|Sind|Sinh|Sogd|Sogo|Sora|Soyo|Sund|Sylo|Syrc|Tagb|Takr|Tale|Talu|Taml|Tang|Tavt|Telu|Tfng|Tglg|Thaa|Thai|Tibt|Tirh|Tnsa|Toto|Ugar|Vaii|Vith|Wara|Wcho|Xpeo|Xsux|Yezi|Yiii|Aran|Qaag|Zanb|Zinh|Zmth|Zsye|Zsym|Zxxx|Zyyy|Qaai|Qaa[a-f]|Qaah|Qaa[j-p]|Qaa[q-z]|Qab[a-x]|Zzzz|1606nict|1694acad|1901|1959acad|1994|1996|abl1943|akuapem|alalc97|aluku|ao1990|aranes|arkaika|asante|auvern|baku1926|balanka|barla|basiceng|bauddha|biscayan|biske|bohoric|boont|bornholm|cisaup|colb1945|cornu|creiss|dajnko|ekavsk|emodeng|fonipa|fonkirsh|fonnapa|fonupa|fonxsamp|gallo|gascon|grclass|grital|grmistr|hepburn|hognorsk|hsistemo|ijekavsk|itihasa|ivanchov|jauer|jyutping|kkcor|kociewie|kscor|laukika|lemosin|lengadoc|lipaw|luna1918|metelko|monoton|ndyuka|nedis|newfound|nicard|njiva|nulik|osojs|oxendict|pahawh[2-4]|pamaka|peano|petr1708|pinyin|polyton|provenc|puter|rigik|rozaj|rumgr|scotland|scouse|simple|solba|sotav|spanglis|surmiran|sursilv|sutsilv|synnejyl|tarask|tongyong|tunumiit|uccor|ucrcor|ulster|unifon|vaidika|valencia|vallader|vecdruka|vivaraup|wadegile|xsistemo|arevela|arevmda|heploc)$')
