/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.bean.Command;
import org.jsmpp.session.ActivityNotifier;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.session.state.SMPPServerSessionState;
import org.jsmpp.util.HexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDUProcessServerTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PDUProcessServerTask.class);
    private final Command pduHeader;
    private final byte[] pdu;
    private final SMPPServerSessionState stateProcessor;
    private final ActivityNotifier activityNotifier;
    private final ServerResponseHandler responseHandler;
    private final Runnable onIOExceptionTask;

    public PDUProcessServerTask(Command pduHeader, byte[] pdu, SMPPServerSessionState stateProcessor, ActivityNotifier activityNotifier, ServerResponseHandler responseHandler, Runnable onIOExceptionTask) {
        this.pduHeader = pduHeader;
        this.pdu = pdu;
        this.stateProcessor = stateProcessor;
        this.activityNotifier = activityNotifier;
        this.responseHandler = responseHandler;
        this.onIOExceptionTask = onIOExceptionTask;
    }

    @Override
    public void run() {
        try {
            if (logger.isDebugEnabled()) {
                String hexmsg = HexUtil.convertBytesToHexString(this.pdu, 0, this.pdu.length, " ");
                logger.debug("Received SMPP message {} {}", (Object)this.pduHeader, (Object)hexmsg);
            }
            switch (this.pduHeader.getCommandId()) {
                case 1: 
                case 2: 
                case 9: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processBind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483648: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processGenericNack(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 21: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processEnquireLink(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483627: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processEnquireLinkResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 4: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processSubmitSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 33: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processSubmitMulti(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 3: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processQuerySm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483643: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processDeliverSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 259: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processDataSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483389: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processDataSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 8: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processCancelSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 7: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processReplaceSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 6: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processUnbind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483642: {
                    this.activityNotifier.notifyActivity();
                    this.stateProcessor.processUnbindResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                default: {
                    this.stateProcessor.processUnknownCid(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.onIOExceptionTask.run();
        }
    }

    protected Command getPduHeader() {
        return this.pduHeader;
    }
}

