/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_hy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "\u058f" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0531\u0580\u0561\u0562\u0561\u056f\u0561\u0576 \u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0537\u0574\u056b\u0580\u0578\u0582\u0569\u0575\u0578\u0582\u0576\u0576\u0565\u0580\u056b \u0564\u056b\u0580\u0570\u0561\u0574" },
            { "afn", "\u0531\u0586\u0572\u0561\u0576\u0561\u056f\u0561\u0576 \u0561\u0586\u0572\u0561\u0576\u056b" },
            { "all", "\u0531\u056c\u0562\u0561\u0576\u0561\u056f\u0561\u0576 \u056c\u0565\u056f" },
            { "amd", "\u0540\u0561\u0575\u056f\u0561\u056f\u0561\u0576 \u0564\u0580\u0561\u0574" },
            { "ang", "\u0546\u056b\u0564\u0565\u0580\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0531\u0576\u057f\u056b\u056c\u0576\u0565\u0580\u056b \u0563\u0578\u0582\u056c\u0564\u0565\u0576" },
            { "aoa", "\u0531\u0576\u0563\u0578\u056c\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0576\u0566\u0561" },
            { "ars", "\u0531\u0580\u0563\u0565\u0576\u057f\u056b\u0576\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "aud", "\u0531\u057e\u057d\u057f\u0580\u0561\u056c\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "awg", "\u0531\u0580\u0578\u0582\u0562\u0561\u056f\u0561\u0576 \u0586\u056c\u0578\u0580\u056b\u0576" },
            { "azn", "\u0531\u0564\u0580\u0562\u0565\u057b\u0561\u0576\u0561\u056f\u0561\u0576 \u0574\u0561\u0576\u0561\u0569" },
            { "bam", "\u0532\u0578\u057d\u0576\u056b\u0561 \u0587 \u0540\u0565\u0580\u0581\u0565\u0563\u0578\u057e\u056b\u0576\u0561\u0575\u056b \u0583\u0578\u056d\u0561\u0580\u056f\u0565\u056c\u056b \u0574\u0561\u0580\u056f\u0561" },
            { "bbd", "\u0532\u0561\u0580\u0562\u0561\u0564\u0578\u057d\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "bdt", "\u0532\u0561\u0576\u0563\u056c\u0561\u0564\u0565\u0577\u056b \u057f\u0561\u056f\u0561" },
            { "bgn", "\u0532\u0578\u0582\u056c\u0572\u0561\u0580\u0561\u056f\u0561\u0576 \u056c\u0587" },
            { "bhd", "\u0532\u0561\u0570\u0580\u0565\u0575\u0576\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "bif", "\u0532\u0578\u0582\u0580\u0578\u0582\u0576\u0564\u056b\u056b \u0586\u0580\u0561\u0576\u056f" },
            { "bmd", "\u0532\u0565\u0580\u0574\u0578\u0582\u0564\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "bnd", "\u0532\u0580\u0578\u0582\u0576\u0565\u0575\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "bob", "\u0532\u0578\u056c\u056b\u057e\u056b\u0561\u056f\u0561\u0576 \u0562\u0578\u056c\u056b\u057e\u056b\u0561\u0576\u0578" },
            { "brl", "\u0532\u0580\u0561\u0566\u056b\u056c\u0561\u056f\u0561\u0576 \u057c\u0565\u0561\u056c" },
            { "bsd", "\u0532\u0561\u0570\u0561\u0574\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "btn", "\u0532\u0578\u0582\u0569\u0561\u0576\u0561\u056f\u0561\u0576 \u0576\u0563\u0578\u0582\u056c\u057f\u0580\u0578\u0582\u0574" },
            { "bwp", "\u0532\u0578\u0569\u057d\u057e\u0561\u0576\u0561\u056f\u0561\u0576 \u057a\u0578\u0582\u056c\u0561" },
            { "byr", "\u0532\u0565\u056c\u0561\u057c\u0578\u0582\u057d\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0562\u056c\u056b" },
            { "bzd", "\u0532\u0565\u056c\u056b\u0566\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "cad", "\u053f\u0561\u0576\u0561\u0564\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "cdf", "\u053f\u0578\u0576\u0563\u0578\u0575\u056b \u0586\u0580\u0561\u0576\u056f" },
            { "chf", "\u0547\u057e\u0565\u0575\u0581\u0561\u0580\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "clp", "\u0549\u056b\u056c\u056b\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "cny", "\u0549\u056b\u0576\u0561\u056f\u0561\u0576 \u0575\u0578\u0582\u0561\u0576" },
            { "cop", "\u053f\u0578\u056c\u0578\u0582\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "crc", "\u053f\u0578\u057d\u057f\u0561 \u054c\u056b\u056f\u0561\u0575\u056b \u056f\u0578\u056c\u0578\u0576" },
            { "cuc", "\u053f\u0578\u0582\u0562\u0561\u056f\u0561\u0576 \u0583\u0578\u056d\u0561\u0580\u056f\u0565\u056c\u056b \u057a\u0565\u057d\u0578" },
            { "cup", "\u053f\u0578\u0582\u0562\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "cve", "\u053f\u0561\u0562\u0578 \u054e\u0565\u0580\u0564\u0565\u056b \u0567\u057d\u056f\u0578\u0582\u0564\u0578" },
            { "czk", "\u0549\u0565\u056d\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576\u0561" },
            { "djf", "\u054b\u056b\u0562\u0578\u0582\u0569\u056b\u056b \u0586\u0580\u0561\u0576\u056f" },
            { "dkk", "\u0534\u0561\u0576\u056b\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576\u0561" },
            { "dop", "\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "dzd", "\u0531\u056c\u056a\u056b\u0580\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "egp", "\u0535\u0563\u056b\u057a\u057f\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "ern", "\u0537\u0580\u056b\u0569\u0580\u0565\u0561\u056f\u0561\u0576 \u0576\u0561\u056f\u0586\u0561" },
            { "etb", "\u0535\u0569\u0578\u057e\u057a\u0561\u056f\u0561\u0576 \u0562\u056b\u0580" },
            { "eur", "\u0535\u057e\u0580\u0578" },
            { "fjd", "\u0556\u056b\u057b\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "fkp", "\u0556\u0578\u056c\u056f\u056c\u0565\u0576\u0564\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580 \u0586\u0578\u0582\u0576\u057f" },
            { "gbp", "\u0532\u0580\u056b\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "gel", "\u054e\u0580\u0561\u0581\u0561\u056f\u0561\u0576 \u056c\u0561\u0580\u056b" },
            { "ghs", "\u0533\u0561\u0576\u0561\u056f\u0561\u0576 \u057d\u0565\u0564\u056b" },
            { "gip", "\u054b\u056b\u0562\u0580\u0561\u056c\u0569\u0561\u0580\u056b \u0586\u0578\u0582\u0576\u057f" },
            { "gmd", "\u0533\u0561\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u0564\u0561\u056c\u0561\u057d\u056b" },
            { "gnf", "\u0533\u057e\u056b\u0576\u0565\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "gtq", "\u0533\u057e\u0561\u057f\u0565\u0574\u0561\u056c\u0561\u056f\u0561\u0576 \u056f\u0565\u057f\u057d\u0561\u056c" },
            { "gyd", "\u0533\u0561\u0575\u0561\u0576\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "hkd", "\u0540\u0578\u0576\u056f\u0578\u0576\u0563\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "hnl", "\u0540\u0578\u0576\u0564\u0578\u0582\u0580\u0561\u057d\u0561\u056f\u0561\u0576 \u056c\u0565\u0574\u057a\u0580\u056b\u0561" },
            { "hrk", "\u053d\u0578\u0580\u057e\u0561\u0569\u0561\u056f\u0561\u0576 \u056f\u0578\u0582\u0576\u0561" },
            { "htg", "\u0540\u0561\u056b\u0569\u0575\u0561\u0576 \u0563\u0578\u0582\u0580\u0564" },
            { "huf", "\u0540\u0578\u0582\u0576\u0563\u0561\u0580\u0561\u056f\u0561\u0576 \u0586\u0578\u0580\u056b\u0576\u057f" },
            { "idr", "\u053b\u0576\u0564\u0578\u0576\u0565\u0566\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "ils", "\u053b\u057d\u0580\u0561\u0575\u0565\u056c\u056b \u0576\u0578\u0580 \u0577\u0565\u056f\u0565\u056c" },
            { "inr", "\u0540\u0576\u0564\u056f\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "iqd", "\u053b\u0580\u0561\u0584\u0575\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "irr", "\u053b\u0580\u0561\u0576\u0561\u056f\u0561\u0576 \u057c\u056b\u0561\u056c" },
            { "isk", "\u053b\u057d\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576\u0561" },
            { "jmd", "\u054b\u0561\u0574\u0561\u0575\u056f\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "jod", "\u0540\u0578\u0580\u0564\u0561\u0576\u0561\u0576\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "jpy", "\u0543\u0561\u057a\u0578\u0576\u0561\u056f\u0561\u0576 \u056b\u0565\u0576" },
            { "kes", "\u0554\u0565\u0576\u056b\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "kgs", "\u0542\u0580\u0572\u0566\u0561\u056f\u0561\u0576 \u057d\u0578\u0574" },
            { "khr", "\u053f\u0561\u0574\u0562\u0578\u057b\u0561\u056f\u0561\u0576 \u057c\u056b\u0565\u056c" },
            { "kmf", "\u053f\u0578\u0574\u0578\u0580\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u0586\u0580\u0561\u0576\u056f" },
            { "kpw", "\u053f\u053a\u0534\u0540-\u056b \u057e\u0578\u0576\u0561" },
            { "krw", "\u0540\u0561\u0580\u0561\u057e\u056f\u0578\u0580\u0565\u0561\u056f\u0561\u0576 \u057e\u0578\u0576\u0561" },
            { "kwd", "\u0554\u0578\u0582\u057e\u0565\u0575\u0569\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "kyd", "\u053f\u0561\u0575\u0574\u0561\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "kzt", "\u0542\u0561\u0566\u0561\u056d\u0561\u056f\u0561\u0576 \u057f\u0565\u0576\u0563\u0565" },
            { "lak", "\u053c\u0561\u0578\u057d\u0561\u056f\u0561\u0576 \u056f\u056b\u057a" },
            { "lbp", "\u053c\u056b\u0562\u0561\u0576\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "lkr", "\u053c\u0561\u0576\u056f\u056b\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "lrd", "\u053c\u056b\u0562\u0565\u0580\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "ltl", "\u053c\u056b\u057f\u057e\u0561\u056f\u0561\u0576 \u056c\u056b\u057f" },
            { "lvl", "\u053c\u0561\u057f\u057e\u056b\u0561\u056f\u0561\u0576 \u056c\u0561\u057f" },
            { "lyd", "\u053c\u056b\u0562\u056b\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "mad", "\u0544\u0561\u0580\u0578\u056f\u0561\u056f\u0561\u0576 \u0564\u056b\u0580\u0570\u0561\u0574" },
            { "mdl", "\u0544\u0578\u056c\u0564\u0578\u057e\u0561\u056f\u0561\u0576 \u056c\u0565\u0575" },
            { "mga", "\u0544\u0561\u0564\u0561\u0563\u0561\u057d\u056f\u0561\u0580\u056b \u0561\u0580\u056b\u0561\u0580\u056b" },
            { "mkd", "\u0544\u0561\u056f\u0565\u0564\u0578\u0576\u0561\u056f\u0561\u0576 \u0564\u0565\u0576\u0561\u0580" },
            { "mmk", "\u0544\u0575\u0561\u0576\u0574\u0561\u056f\u0561\u0576 \u056f\u0575\u0561\u057f" },
            { "mnt", "\u0544\u0578\u0576\u0572\u0578\u056c\u0561\u056f\u0561\u0576 \u057f\u0578\u0582\u0563\u0580\u056b\u056f" },
            { "mop", "\u0544\u0561\u056f\u0561\u0578\u0575\u056b \u057a\u0561\u057f\u0561\u056f\u0561" },
            { "mro", "\u0544\u0561\u057e\u0580\u056b\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u0578\u0582\u0563\u056b\u0575\u0561" },
            { "mur", "\u0544\u0561\u057e\u0580\u056b\u056f\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "mvr", "\u0544\u0561\u056c\u0564\u056b\u057e\u0575\u0561\u0576 \u057c\u0578\u0582\u0586\u056b\u0561" },
            { "mwk", "\u0544\u0561\u056c\u0561\u057e\u056b\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0579\u0561" },
            { "mxn", "\u0544\u0565\u0584\u057d\u056b\u056f\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "myr", "\u0544\u0561\u056c\u0561\u0575\u0566\u056b\u0561\u056f\u0561\u0576 \u057c\u056b\u0576\u0563\u056b\u057f" },
            { "mzn", "\u0544\u0578\u0566\u0561\u0574\u0562\u056b\u056f\u0575\u0561\u0576 \u0574\u0565\u057f\u056b\u056f\u0561\u056c" },
            { "nad", "\u0546\u0561\u0574\u056b\u0562\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "ngn", "\u0546\u056b\u0563\u0565\u0580\u056b\u0561\u056f\u0561\u0576 \u0576\u0561\u0575\u0580\u0561" },
            { "nio", "\u0546\u056b\u056f\u0561\u0580\u0561\u0563\u0578\u0582\u0561\u056f\u0561\u0576 \u056f\u0578\u0580\u0564\u0578\u0562\u0561" },
            { "nok", "\u0546\u0578\u0580\u057e\u0565\u0563\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576\u0561" },
            { "npr", "\u0546\u0565\u057a\u0561\u056c\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "nzd", "\u0546\u0578\u0580\u0566\u0565\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "omr", "\u0555\u0574\u0561\u0576\u0561\u056f\u0561\u0576 \u057c\u056b\u0561\u056c" },
            { "pab", "\u054a\u0561\u0576\u0561\u0574\u0561\u056f\u0561\u0576 \u0562\u0561\u056c\u0562\u0578\u0561" },
            { "pen", "\u054a\u0565\u0580\u0578\u0582\u056b \u0576\u0578\u0580 \u057d\u0578\u056c" },
            { "pgk", "\u054a\u0561\u057a\u0578\u0582\u0561-\u0546\u0578\u0580 \u0533\u057e\u056b\u0576\u0565\u0561\u0575\u056b \u056f\u056b\u0576\u0561" },
            { "php", "\u0556\u056b\u056c\u056b\u057a\u056b\u0576\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "pkr", "\u054a\u0561\u056f\u056b\u057d\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "pln", "\u053c\u0565\u0570\u0561\u056f\u0561\u0576 \u0566\u056c\u0578\u057f\u056b" },
            { "pyg", "\u054a\u0561\u0580\u0561\u0563\u057e\u0561\u0575\u0561\u056f\u0561\u0576 \u0563\u0578\u0582\u0561\u0580\u0561\u0576\u056b" },
            { "qar", "\u0554\u0561\u0569\u0561\u0580\u0561\u056f\u0561\u0576 \u057c\u056b\u0561\u056c" },
            { "ron", "\u054c\u0578\u0582\u0574\u056b\u0576\u0561\u056f\u0561\u0576 \u056c\u0565\u0575" },
            { "rsd", "\u054d\u0565\u0580\u0562\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "rub", "\u054c\u0578\u0582\u057d\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0562\u056c\u056b" },
            { "rwf", "\u054c\u0578\u0582\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "sar", "\u054d\u0561\u0578\u0582\u0564\u0575\u0561\u0576 \u0531\u0580\u0561\u0562\u056b\u0561\u0575\u056b \u057c\u056b\u0561\u056c" },
            { "sbd", "\u054d\u0578\u0572\u0578\u0574\u0578\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "scr", "\u054d\u0565\u0575\u0577\u0565\u056c\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u057c\u0578\u0582\u0583\u056b" },
            { "sdg", "\u054d\u0578\u0582\u0564\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "sek", "\u0547\u057e\u0565\u0564\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576\u0561" },
            { "sgd", "\u054d\u056b\u0576\u0563\u0561\u057a\u0578\u0582\u0580\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "shp", "\u054d\u0578\u0582\u0580\u0562 \u0540\u0565\u0572\u056b\u0576\u0565\u056b \u056f\u0572\u0566\u0578\u0582 \u0586\u0578\u0582\u0576\u057f" },
            { "sll", "\u054d\u056b\u0565\u0580\u0561-\u053c\u0565\u0578\u0576\u0565\u056b \u056c\u0565\u0578\u0576\u0565" },
            { "sos", "\u054d\u0578\u0574\u0561\u056c\u056b\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "srd", "\u054d\u0578\u0582\u0580\u056b\u0576\u0561\u0574\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "ssp", "\u0540\u0561\u0580\u0561\u057e\u057d\u0578\u0582\u0564\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "std", "\u054d\u0561\u0576 \u054f\u0578\u0574\u0565 \u0587 \u054a\u0580\u056b\u0576\u057d\u056b\u057a\u056b\u056b \u0564\u0578\u0562\u0580\u0561" },
            { "syp", "\u054d\u056b\u0580\u056b\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "szl", "\u054d\u057e\u0561\u0566\u056b\u056c\u0565\u0576\u0564\u0561\u056f\u0561\u0576 \u056c\u056b\u056c\u0561\u0576\u0563\u0565\u0576\u056b" },
            { "thb", "\u0539\u0561\u056b\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0562\u0561\u057f" },
            { "tjs", "\u054f\u0561\u057b\u056b\u056f\u0561\u056f\u0561\u0576 \u057d\u0578\u0574\u0578\u0576\u056b" },
            { "tmt", "\u0539\u0578\u0582\u0580\u0584\u0574\u0565\u0576\u0561\u056f\u0561\u0576 \u0574\u0561\u0576\u0561\u0569" },
            { "tnd", "\u0539\u0578\u0582\u0576\u056b\u057d\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "top", "\u054f\u0578\u0576\u0563\u0561\u0575\u056b \u057a\u0561\u0561\u0576\u0563\u0561" },
            { "try", "\u0539\u0578\u0582\u0580\u0584\u0561\u056f\u0561\u0576 \u056c\u056b\u0580\u0561" },
            { "ttd", "\u054f\u0580\u056b\u0576\u056b\u0564\u0561\u0564 \u0587 \u054f\u0578\u0562\u0561\u0563\u0578\u0575\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "twd", "\u0539\u0561\u0575\u057e\u0561\u0576\u0561\u056f\u0561\u0576 \u0576\u0578\u0580 \u0564\u0578\u056c\u0561\u0580" },
            { "tzs", "\u054f\u0561\u0576\u0566\u0561\u0576\u056b\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "uah", "\u0548\u0582\u056f\u0580\u0561\u056b\u0576\u0561\u056f\u0561\u0576 \u0563\u0580\u056b\u057e\u0576\u0561" },
            { "ugx", "\u0548\u0582\u0563\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "usd", "\u0531\u0544\u0546 \u0564\u0578\u056c\u0561\u0580" },
            { "uyu", "\u0548\u0582\u0580\u0578\u0582\u0563\u057e\u0561\u0575\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "uzs", "\u0548\u0582\u0566\u0562\u0565\u056f\u0561\u056f\u0561\u0576 \u057d\u0578\u0582\u0574" },
            { "vef", "\u054e\u0565\u0576\u0565\u057d\u0578\u0582\u0565\u056c\u0561\u056f\u0561\u0576 \u0562\u0578\u056c\u056b\u057e\u0561\u0580" },
            { "vnd", "\u054e\u056b\u0565\u057f\u0576\u0561\u0574\u0561\u056f\u0561\u0576 \u0564\u0578\u0576\u0563" },
            { "vuv", "\u054e\u0561\u0576\u0578\u0582\u0561\u057f\u0578\u0582\u056b \u057e\u0561\u057f\u0578\u0582" },
            { "wst", "\u054d\u0561\u0574\u0578\u0561\u056f\u0561\u0576 \u057f\u0561\u056c\u0561" },
            { "xaf", "\u0531\u0586\u0580\u056b\u056f\u0561\u056f\u0561\u0576 \u0586\u056b\u0576\u0561\u0576\u057d\u0561\u056f\u0561\u0576 \u0570\u0561\u0574\u0561\u0575\u0576\u0584\u056b \u0586\u0580\u0561\u0576\u056f BEAC" },
            { "xcd", "\u0531\u0580\u0587\u0565\u056c\u0561\u056f\u0561\u0580\u056b\u0562\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "xof", "\u0531\u0586\u0580\u056b\u056f\u0561\u056f\u0561\u0576 \u0586\u056b\u0576\u0561\u0576\u057d\u0561\u056f\u0561\u0576 \u0570\u0561\u0574\u0561\u0575\u0576\u0584\u056b \u0586\u0580\u0561\u0576\u056f BCEAO" },
            { "xpf", "\u053f\u054a\u0556 \u0586\u0580\u0561\u0576\u056f" },
            { "xxx", "\u0531\u0576\u0570\u0561\u0575\u057f \u0561\u0580\u056a\u0578\u0582\u0575\u0569" },
            { "yer", "\u0535\u0574\u0565\u0576\u0561\u056f\u0561\u0576 \u057c\u056b\u0561\u056c" },
            { "zar", "\u0540\u0561\u0580\u0561\u057e\u0561\u0586\u0580\u056b\u056f\u0561\u056f\u0561\u0576 \u057c\u0565\u0576\u0564" },
            { "zmk", "\u0536\u0561\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0579\u0561 (1968\u20132012)" },
            { "zmw", "\u0536\u0561\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0579\u0561" },
        };
        return data;
    }
}
