/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.replication;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.opensearch.action.support.replication.ReplicationMode;
import org.opensearch.action.support.replication.ReplicationOperation;
import org.opensearch.action.support.replication.ReplicationProxy;
import org.opensearch.action.support.replication.ReplicationProxyRequest;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.core.action.ActionListener;

public class ReplicationModeAwareProxy<ReplicaRequest extends ReplicationRequest<ReplicaRequest>>
extends ReplicationProxy<ReplicaRequest> {
    private final ReplicationMode replicationModeOverride;
    private final ReplicationOperation.Replicas<ReplicaRequest> primaryTermValidationProxy;

    public ReplicationModeAwareProxy(ReplicationMode replicationModeOverride, ReplicationOperation.Replicas<ReplicaRequest> replicasProxy, ReplicationOperation.Replicas<ReplicaRequest> primaryTermValidationProxy) {
        super(replicasProxy);
        this.replicationModeOverride = Objects.requireNonNull(replicationModeOverride);
        this.primaryTermValidationProxy = Objects.requireNonNull(primaryTermValidationProxy);
    }

    @Override
    protected void performOnReplicaProxy(ReplicationProxyRequest<ReplicaRequest> proxyRequest, ReplicationMode replicationMode, BiConsumer<Consumer<ActionListener<ReplicationOperation.ReplicaResponse>>, ReplicationProxyRequest<ReplicaRequest>> performOnReplicaConsumer) {
        assert (replicationMode == ReplicationMode.FULL_REPLICATION || replicationMode == ReplicationMode.PRIMARY_TERM_VALIDATION);
        Consumer<ActionListener<ReplicationOperation.ReplicaResponse>> replicasProxyConsumer = replicationMode == ReplicationMode.FULL_REPLICATION ? this.getReplicasProxyConsumer(this.fullReplicationProxy, proxyRequest) : this.getReplicasProxyConsumer(this.primaryTermValidationProxy, proxyRequest);
        performOnReplicaConsumer.accept(replicasProxyConsumer, proxyRequest);
    }

    @Override
    ReplicationMode determineReplicationMode(ShardRouting shardRouting, ShardRouting primaryRouting) {
        if (shardRouting.isSameAllocation(primaryRouting)) {
            return ReplicationMode.NO_REPLICATION;
        }
        if (primaryRouting.relocating() && shardRouting.isSameAllocation(primaryRouting.getTargetRelocatingShard())) {
            return ReplicationMode.FULL_REPLICATION;
        }
        return this.replicationModeOverride;
    }
}

