/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ClusterMetadataManifest
implements Writeable,
ToXContentFragment {
    private static final ParseField CLUSTER_TERM_FIELD = new ParseField("cluster_term", new String[0]);
    private static final ParseField STATE_VERSION_FIELD = new ParseField("state_version", new String[0]);
    private static final ParseField CLUSTER_UUID_FIELD = new ParseField("cluster_uuid", new String[0]);
    private static final ParseField STATE_UUID_FIELD = new ParseField("state_uuid", new String[0]);
    private static final ParseField OPENSEARCH_VERSION_FIELD = new ParseField("opensearch_version", new String[0]);
    private static final ParseField NODE_ID_FIELD = new ParseField("node_id", new String[0]);
    private static final ParseField COMMITTED_FIELD = new ParseField("committed", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField PREVIOUS_CLUSTER_UUID = new ParseField("previous_cluster_uuid", new String[0]);
    private static final ParseField CLUSTER_UUID_COMMITTED = new ParseField("cluster_uuid_committed", new String[0]);
    private static final ConstructingObjectParser<ClusterMetadataManifest, Void> PARSER = new ConstructingObjectParser("cluster_metadata_manifest", fields -> new ClusterMetadataManifest(ClusterMetadataManifest.term(fields), ClusterMetadataManifest.version(fields), ClusterMetadataManifest.clusterUUID(fields), ClusterMetadataManifest.stateUUID(fields), ClusterMetadataManifest.opensearchVersion(fields), ClusterMetadataManifest.nodeId(fields), ClusterMetadataManifest.committed(fields), ClusterMetadataManifest.indices(fields), ClusterMetadataManifest.previousClusterUUID(fields), ClusterMetadataManifest.clusterUUIDCommitted(fields)));
    private final List<UploadedIndexMetadata> indices;
    private final long clusterTerm;
    private final long stateVersion;
    private final String clusterUUID;
    private final String stateUUID;
    private final Version opensearchVersion;
    private final String nodeId;
    private final boolean committed;
    private final String previousClusterUUID;
    private final boolean clusterUUIDCommitted;

    private static long term(Object[] fields) {
        return (Long)fields[0];
    }

    private static long version(Object[] fields) {
        return (Long)fields[1];
    }

    private static String clusterUUID(Object[] fields) {
        return (String)fields[2];
    }

    private static String stateUUID(Object[] fields) {
        return (String)fields[3];
    }

    private static Version opensearchVersion(Object[] fields) {
        return Version.fromId((int)((Integer)fields[4]));
    }

    private static String nodeId(Object[] fields) {
        return (String)fields[5];
    }

    private static boolean committed(Object[] fields) {
        return (Boolean)fields[6];
    }

    private static List<UploadedIndexMetadata> indices(Object[] fields) {
        return (List)fields[7];
    }

    private static String previousClusterUUID(Object[] fields) {
        return (String)fields[8];
    }

    private static boolean clusterUUIDCommitted(Object[] fields) {
        return (Boolean)fields[9];
    }

    public List<UploadedIndexMetadata> getIndices() {
        return this.indices;
    }

    public long getClusterTerm() {
        return this.clusterTerm;
    }

    public long getStateVersion() {
        return this.stateVersion;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public String getStateUUID() {
        return this.stateUUID;
    }

    public Version getOpensearchVersion() {
        return this.opensearchVersion;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public String getPreviousClusterUUID() {
        return this.previousClusterUUID;
    }

    public boolean isClusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public ClusterMetadataManifest(long clusterTerm, long version, String clusterUUID, String stateUUID, Version opensearchVersion, String nodeId, boolean committed, List<UploadedIndexMetadata> indices, String previousClusterUUID, boolean clusterUUIDCommitted) {
        this.clusterTerm = clusterTerm;
        this.stateVersion = version;
        this.clusterUUID = clusterUUID;
        this.stateUUID = stateUUID;
        this.opensearchVersion = opensearchVersion;
        this.nodeId = nodeId;
        this.committed = committed;
        this.indices = Collections.unmodifiableList(indices);
        this.previousClusterUUID = previousClusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
    }

    public ClusterMetadataManifest(StreamInput in) throws IOException {
        this.clusterTerm = in.readVLong();
        this.stateVersion = in.readVLong();
        this.clusterUUID = in.readString();
        this.stateUUID = in.readString();
        this.opensearchVersion = Version.fromId((int)in.readInt());
        this.nodeId = in.readString();
        this.committed = in.readBoolean();
        this.indices = Collections.unmodifiableList(in.readList(UploadedIndexMetadata::new));
        this.previousClusterUUID = in.readString();
        this.clusterUUIDCommitted = in.readBoolean();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterMetadataManifest manifest) {
        return new Builder(manifest);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(CLUSTER_TERM_FIELD.getPreferredName(), this.getClusterTerm()).field(STATE_VERSION_FIELD.getPreferredName(), this.getStateVersion()).field(CLUSTER_UUID_FIELD.getPreferredName(), this.getClusterUUID()).field(STATE_UUID_FIELD.getPreferredName(), this.getStateUUID()).field(OPENSEARCH_VERSION_FIELD.getPreferredName(), this.getOpensearchVersion().id).field(NODE_ID_FIELD.getPreferredName(), this.getNodeId()).field(COMMITTED_FIELD.getPreferredName(), this.isCommitted());
        builder.startArray(INDICES_FIELD.getPreferredName());
        for (UploadedIndexMetadata uploadedIndexMetadata : this.indices) {
            uploadedIndexMetadata.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(PREVIOUS_CLUSTER_UUID.getPreferredName(), this.getPreviousClusterUUID());
        builder.field(CLUSTER_UUID_COMMITTED.getPreferredName(), this.isClusterUUIDCommitted());
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.clusterTerm);
        out.writeVLong(this.stateVersion);
        out.writeString(this.clusterUUID);
        out.writeString(this.stateUUID);
        out.writeInt(this.opensearchVersion.id);
        out.writeString(this.nodeId);
        out.writeBoolean(this.committed);
        out.writeCollection(this.indices);
        out.writeString(this.previousClusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMetadataManifest that = (ClusterMetadataManifest)o;
        return Objects.equals(this.indices, that.indices) && this.clusterTerm == that.clusterTerm && this.stateVersion == that.stateVersion && Objects.equals(this.clusterUUID, that.clusterUUID) && Objects.equals(this.stateUUID, that.stateUUID) && Objects.equals(this.opensearchVersion, that.opensearchVersion) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.committed, that.committed) && Objects.equals(this.previousClusterUUID, that.previousClusterUUID) && Objects.equals(this.clusterUUIDCommitted, that.clusterUUIDCommitted);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.clusterTerm, this.stateVersion, this.clusterUUID, this.stateUUID, this.opensearchVersion, this.nodeId, this.committed, this.previousClusterUUID, this.clusterUUIDCommitted);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public static ClusterMetadataManifest fromXContent(XContentParser parser) throws IOException {
        return (ClusterMetadataManifest)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CLUSTER_TERM_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), STATE_VERSION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CLUSTER_UUID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATE_UUID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), OPENSEARCH_VERSION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), COMMITTED_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> UploadedIndexMetadata.fromXContent(p), INDICES_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PREVIOUS_CLUSTER_UUID);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), CLUSTER_UUID_COMMITTED);
    }

    public static class UploadedIndexMetadata
    implements Writeable,
    ToXContentFragment {
        private static final ParseField INDEX_NAME_FIELD = new ParseField("index_name", new String[0]);
        private static final ParseField INDEX_UUID_FIELD = new ParseField("index_uuid", new String[0]);
        private static final ParseField UPLOADED_FILENAME_FIELD = new ParseField("uploaded_filename", new String[0]);
        private static final ConstructingObjectParser<UploadedIndexMetadata, Void> PARSER = new ConstructingObjectParser("uploaded_index_metadata", fields -> new UploadedIndexMetadata(UploadedIndexMetadata.indexName(fields), UploadedIndexMetadata.indexUUID(fields), UploadedIndexMetadata.uploadedFilename(fields)));
        private final String indexName;
        private final String indexUUID;
        private final String uploadedFilename;

        private static String indexName(Object[] fields) {
            return (String)fields[0];
        }

        private static String indexUUID(Object[] fields) {
            return (String)fields[1];
        }

        private static String uploadedFilename(Object[] fields) {
            return (String)fields[2];
        }

        public UploadedIndexMetadata(String indexName, String indexUUID, String uploadedFileName) {
            this.indexName = indexName;
            this.indexUUID = indexUUID;
            this.uploadedFilename = uploadedFileName;
        }

        public UploadedIndexMetadata(StreamInput in) throws IOException {
            this.indexName = in.readString();
            this.indexUUID = in.readString();
            this.uploadedFilename = in.readString();
        }

        public String getUploadedFilePath() {
            return this.uploadedFilename;
        }

        public String getUploadedFilename() {
            String[] splitPath = this.uploadedFilename.split("/");
            return splitPath[splitPath.length - 1];
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getIndexUUID() {
            return this.indexUUID;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(INDEX_NAME_FIELD.getPreferredName(), this.getIndexName()).field(INDEX_UUID_FIELD.getPreferredName(), this.getIndexUUID()).field(UPLOADED_FILENAME_FIELD.getPreferredName(), this.getUploadedFilePath()).endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexName);
            out.writeString(this.indexUUID);
            out.writeString(this.uploadedFilename);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadedIndexMetadata that = (UploadedIndexMetadata)o;
            return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.indexUUID, that.indexUUID) && Objects.equals(this.uploadedFilename, that.uploadedFilename);
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.indexUUID, this.uploadedFilename);
        }

        public String toString() {
            return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
        }

        public static UploadedIndexMetadata fromXContent(XContentParser parser) throws IOException {
            return (UploadedIndexMetadata)PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_NAME_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_UUID_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), UPLOADED_FILENAME_FIELD);
        }
    }

    public static class Builder {
        private List<UploadedIndexMetadata> indices;
        private long clusterTerm;
        private long stateVersion;
        private String clusterUUID;
        private String stateUUID;
        private Version opensearchVersion;
        private String nodeId;
        private String previousClusterUUID;
        private boolean committed;
        private boolean clusterUUIDCommitted;

        public Builder indices(List<UploadedIndexMetadata> indices) {
            this.indices = indices;
            return this;
        }

        public Builder clusterTerm(long clusterTerm) {
            this.clusterTerm = clusterTerm;
            return this;
        }

        public Builder stateVersion(long stateVersion) {
            this.stateVersion = stateVersion;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder stateUUID(String stateUUID) {
            this.stateUUID = stateUUID;
            return this;
        }

        public Builder opensearchVersion(Version opensearchVersion) {
            this.opensearchVersion = opensearchVersion;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder committed(boolean committed) {
            this.committed = committed;
            return this;
        }

        public List<UploadedIndexMetadata> getIndices() {
            return this.indices;
        }

        public Builder previousClusterUUID(String previousClusterUUID) {
            this.previousClusterUUID = previousClusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder() {
            this.indices = new ArrayList<UploadedIndexMetadata>();
        }

        public Builder(ClusterMetadataManifest manifest) {
            this.clusterTerm = manifest.clusterTerm;
            this.stateVersion = manifest.stateVersion;
            this.clusterUUID = manifest.clusterUUID;
            this.stateUUID = manifest.stateUUID;
            this.opensearchVersion = manifest.opensearchVersion;
            this.nodeId = manifest.nodeId;
            this.committed = manifest.committed;
            this.indices = new ArrayList<UploadedIndexMetadata>(manifest.indices);
            this.previousClusterUUID = manifest.previousClusterUUID;
            this.clusterUUIDCommitted = manifest.clusterUUIDCommitted;
        }

        public ClusterMetadataManifest build() {
            return new ClusterMetadataManifest(this.clusterTerm, this.stateVersion, this.clusterUUID, this.stateUUID, this.opensearchVersion, this.nodeId, this.committed, this.indices, this.previousClusterUUID, this.clusterUUIDCommitted);
        }
    }
}

