/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.opensearch.OpenSearchException;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.util.FileSystemUtils;
import org.opensearch.env.Environment;

public class HunspellService {
    private static final Logger logger = LogManager.getLogger(HunspellService.class);
    public static final Setting<Boolean> HUNSPELL_LAZY_LOAD = Setting.boolSetting("indices.analysis.hunspell.dictionary.lazy", (boolean)Boolean.FALSE, Setting.Property.NodeScope);
    public static final Setting<Boolean> HUNSPELL_IGNORE_CASE = Setting.boolSetting("indices.analysis.hunspell.dictionary.ignore_case", (boolean)Boolean.FALSE, Setting.Property.NodeScope);
    public static final Setting<Settings> HUNSPELL_DICTIONARY_OPTIONS = Setting.groupSetting("indices.analysis.hunspell.dictionary.", Setting.Property.NodeScope);
    private final ConcurrentHashMap<String, Dictionary> dictionaries = new ConcurrentHashMap();
    private final Map<String, Dictionary> knownDictionaries;
    private final boolean defaultIgnoreCase;
    private final Path hunspellDir;
    private final Function<String, Dictionary> loadingFunction;

    public HunspellService(Settings settings, Environment env, Map<String, Dictionary> knownDictionaries) throws IOException {
        this.knownDictionaries = Collections.unmodifiableMap(knownDictionaries);
        this.hunspellDir = this.resolveHunspellDirectory(env);
        this.defaultIgnoreCase = HUNSPELL_IGNORE_CASE.get(settings);
        this.loadingFunction = locale -> {
            try {
                return this.loadDictionary((String)locale, settings, env);
            }
            catch (Exception e) {
                logger.error("Failed to load hunspell dictionary for locale: " + locale, (Throwable)e);
                throw new IllegalStateException("Failed to load hunspell dictionary for locale: " + locale);
            }
        };
        if (!HUNSPELL_LAZY_LOAD.get(settings).booleanValue()) {
            this.scanAndLoadDictionaries();
        }
    }

    public Dictionary getDictionary(String locale) {
        Dictionary dictionary = this.knownDictionaries.get(locale);
        if (dictionary == null) {
            dictionary = this.dictionaries.computeIfAbsent(locale, this.loadingFunction);
        }
        return dictionary;
    }

    private Path resolveHunspellDirectory(Environment env) {
        return env.configFile().resolve("hunspell");
    }

    private void scanAndLoadDictionaries() throws IOException {
        if (Files.isDirectory(this.hunspellDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.hunspellDir);){
                for (Path file : stream) {
                    if (!Files.isDirectory(file, new LinkOption[0])) continue;
                    DirectoryStream<Path> inner = Files.newDirectoryStream(this.hunspellDir.resolve(file), "*.dic");
                    try {
                        if (!inner.iterator().hasNext()) continue;
                        try {
                            this.getDictionary(file.getFileName().toString());
                        }
                        catch (Exception e) {
                            logger.error(() -> new ParameterizedMessage("exception while loading dictionary {}", (Object)file.getFileName()), (Throwable)e);
                        }
                    }
                    finally {
                        if (inner == null) continue;
                        inner.close();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private Dictionary loadDictionary(String locale, Settings nodeSettings, Environment env) throws Exception {
        Path dicDir;
        if (logger.isDebugEnabled()) {
            logger.debug("Loading hunspell dictionary [{}]...", (Object)locale);
        }
        if (!FileSystemUtils.isAccessibleDirectory((Path)(dicDir = this.hunspellDir.resolve(locale)), (Logger)logger)) {
            throw new OpenSearchException(String.format(Locale.ROOT, "Could not find hunspell dictionary [%s]", locale), new Object[0]);
        }
        Settings dictSettings = HUNSPELL_DICTIONARY_OPTIONS.get(nodeSettings);
        nodeSettings = HunspellService.loadDictionarySettings(dicDir, dictSettings.getByPrefix(locale + "."));
        boolean ignoreCase = nodeSettings.getAsBoolean("ignore_case", this.defaultIgnoreCase);
        Path[] affixFiles = FileSystemUtils.files((Path)dicDir, (String)"*.aff");
        if (affixFiles.length == 0) {
            throw new OpenSearchException(String.format(Locale.ROOT, "Missing affix file for hunspell dictionary [%s]", locale), new Object[0]);
        }
        if (affixFiles.length != 1) {
            throw new OpenSearchException(String.format(Locale.ROOT, "Too many affix files exist for hunspell dictionary [%s]", locale), new Object[0]);
        }
        InputStream affixStream = null;
        Path[] dicFiles = FileSystemUtils.files((Path)dicDir, (String)"*.dic");
        ArrayList<InputStream> dicStreams = new ArrayList<InputStream>(dicFiles.length);
        for (int i = 0; i < dicFiles.length; ++i) {
            dicStreams.add(Files.newInputStream(dicFiles[i], new OpenOption[0]));
        }
        affixStream = Files.newInputStream(affixFiles[0], new OpenOption[0]);
        NIOFSDirectory tmp = new NIOFSDirectory(env.tmpFile());
        Dictionary dictionary = new Dictionary((Directory)tmp, "hunspell", affixStream, dicStreams, ignoreCase);
        tmp.close();
        IOUtils.close((Closeable)affixStream);
        IOUtils.close(dicStreams);
        return dictionary;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            tmp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.error(() -> new ParameterizedMessage("Could not load hunspell dictionary [{}]", (Object)locale), (Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    IOUtils.close(affixStream);
                    IOUtils.close(dicStreams);
                    throw throwable3;
                }
            }
        }
    }

    private static Settings loadDictionarySettings(Path dir, Settings defaults) throws IOException {
        Path file = dir.resolve("settings.yml");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.builder().loadFromPath(file).put(defaults).build();
        }
        file = dir.resolve("settings.json");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.builder().loadFromPath(file).put(defaults).build();
        }
        return defaults;
    }
}

