/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.Closeable;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.action.ExecuteWorkflowRequest;
import org.opensearch.alerting.action.ExecuteWorkflowResponse;
import org.opensearch.alerting.model.WorkflowRunResult;
import org.opensearch.alerting.transport.TransportExecuteWorkflowActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/alerting/transport/TransportExecuteWorkflowAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/ExecuteWorkflowRequest;", "Lorg/opensearch/alerting/action/ExecuteWorkflowResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "runner", "Lorg/opensearch/alerting/MonitorRunnerService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/alerting/MonitorRunnerService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "execWorkflowRequest", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
public final class TransportExecuteWorkflowAction
extends HandledTransportAction<ExecuteWorkflowRequest, ExecuteWorkflowResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final MonitorRunnerService runner;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportExecuteWorkflowAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull MonitorRunnerService runner, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opensearch/alerting/workflow/execute", transportService, actionFilters, ExecuteWorkflowRequest::new);
        this.client = client;
        this.runner = runner;
        this.xContentRegistry = xContentRegistry;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull ExecuteWorkflowRequest execWorkflowRequest, @NotNull ActionListener<ExecuteWorkflowResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)execWorkflowRequest), (String)"execWorkflowRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        TransportExecuteWorkflowActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Function1 executeWorkflow2 = (Function1)new Function1<Workflow, Unit>(this, execWorkflowRequest, actionListener){
                final /* synthetic */ TransportExecuteWorkflowAction this$0;
                final /* synthetic */ ExecuteWorkflowRequest $execWorkflowRequest;
                final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                {
                    this.this$0 = $receiver;
                    this.$execWorkflowRequest = $execWorkflowRequest;
                    this.$actionListener = $actionListener;
                    super(1);
                }

                public final void invoke(@NotNull Workflow workflow) {
                    Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
                    BuildersKt.launch$default((CoroutineScope)TransportExecuteWorkflowAction.access$getRunner$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(workflow, this.$execWorkflowRequest, this.$actionListener, null){
                        int label;
                        final /* synthetic */ Workflow $workflow;
                        final /* synthetic */ ExecuteWorkflowRequest $execWorkflowRequest;
                        final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                        {
                            this.$workflow = $workflow;
                            this.$execWorkflowRequest = $execWorkflowRequest;
                            this.$actionListener = $actionListener;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var2_3 = this.$workflow.getSchedule().getPeriodEndingAt(Instant.ofEpochMilli(this.$execWorkflowRequest.getRequestEnd().getMillis()));
                                    periodStart = (Instant)var2_3.component1();
                                    periodEnd = (Instant)var2_3.component2();
                                    TransportExecuteWorkflowActionKt.access$getLog$p().info("Executing workflow from API - id: " + this.$workflow.getId() + ", periodStart: " + periodStart + ", periodEnd: " + periodEnd + ", dryrun: " + this.$execWorkflowRequest.getDryrun());
                                    this.label = 1;
                                    v0 = MonitorRunnerService.INSTANCE.runJob(this.$workflow, periodStart, periodEnd, this.$execWorkflowRequest.getDryrun(), (Continuation<? super WorkflowRunResult>)((Continuation)this));
                                    ** if (v0 != var6_2) goto lbl15
lbl14:
                                    // 1 sources

                                    return var6_2;
lbl15:
                                    // 1 sources

                                    ** GOTO lbl21
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl21:
                                    // 2 sources

                                    workflowRunResult = (WorkflowRunResult)v0;
                                    this.label = 2;
                                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, workflowRunResult, null){
                                        int label;
                                        final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                                        final /* synthetic */ WorkflowRunResult $workflowRunResult;
                                        {
                                            this.$actionListener = $actionListener;
                                            this.$workflowRunResult = $workflowRunResult;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.$actionListener.onResponse((Object)((Object)new ExecuteWorkflowResponse(this.$workflowRunResult)));
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    ** if (v1 != var6_2) goto lbl26
lbl25:
                                    // 1 sources

                                    return var6_2;
lbl26:
                                    // 1 sources

                                    ** GOTO lbl43
                                }
                                case 2: {
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** GOTO lbl43
                                    }
                                    catch (Exception e) {
                                        TransportExecuteWorkflowActionKt.access$getLog$p().error("Unexpected error running workflow", (Throwable)e);
                                        this.label = 3;
                                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, e, null){
                                            int label;
                                            final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                                            final /* synthetic */ Exception $e;
                                            {
                                                this.$actionListener = $actionListener;
                                                this.$e = $e;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(this.$e));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl43
                                    }
                                }
                                case 3: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl43:
                                    // 4 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            };
            if (execWorkflowRequest.getWorkflowId() != null) {
                GetRequest getRequest = new GetRequest(".opendistro-alerting-config").id(execWorkflowRequest.getWorkflowId());
                this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, (Function1<? super Workflow, Unit>)executeWorkflow2, execWorkflowRequest){
                    final /* synthetic */ ActionListener<ExecuteWorkflowResponse> $actionListener;
                    final /* synthetic */ TransportExecuteWorkflowAction this$0;
                    final /* synthetic */ Function1<Workflow, Unit> $executeWorkflow;
                    final /* synthetic */ ExecuteWorkflowRequest $execWorkflowRequest;
                    {
                        this.$actionListener = $actionListener;
                        this.this$0 = $receiver;
                        this.$executeWorkflow = $executeWorkflow;
                        this.$execWorkflowRequest = $execWorkflowRequest;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(@NotNull GetResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        if (!response2.isExists()) {
                            TransportExecuteWorkflowActionKt.access$getLog$p().error("Can't find workflow with id: " + response2.getId());
                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Can't find workflow with id: " + response2.getId(), RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        if (!response2.isSourceEmpty()) {
                            Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                            Function1<Workflow, Unit> function1 = this.$executeWorkflow;
                            Throwable throwable = null;
                            try {
                                XContentParser xcp = (XContentParser)closeable;
                                boolean bl = false;
                                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                                String string = response2.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                                ScheduledJob scheduledJob2 = ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                                Intrinsics.checkNotNull((Object)scheduledJob2, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
                                Workflow workflow = (Workflow)scheduledJob2;
                                function1.invoke((Object)workflow);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        TransportExecuteWorkflowActionKt.access$getLog$p().error("Error getting workflow " + this.$execWorkflowRequest.getWorkflowId(), (Throwable)t);
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
            } else {
                Workflow workflow;
                boolean bl2;
                User user2 = user;
                CharSequence charSequence = user2 != null ? user2.getName() : null;
                boolean bl3 = bl2 = charSequence == null || charSequence.length() == 0;
                if (bl2) {
                    Workflow workflow2 = execWorkflowRequest.getWorkflow();
                    workflow = workflow2;
                    Intrinsics.checkNotNull((Object)workflow2, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
                } else if (!bl2) {
                    Workflow workflow3 = execWorkflowRequest.getWorkflow();
                    Intrinsics.checkNotNull((Object)workflow3, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
                    workflow = Workflow.copy$default((Workflow)workflow3, null, (long)0L, null, (boolean)false, null, null, null, null, (User)user, (int)0, null, null, null, null, (int)16127, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Workflow workflow4 = workflow;
                executeWorkflow2.invoke((Object)workflow4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ MonitorRunnerService access$getRunner$p(TransportExecuteWorkflowAction $this) {
        return $this.runner;
    }
}

