/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.FeatureData;

public class ThresholdingResult {
    private final double grade;
    private final double confidence;
    private final double rcfScore;
    private long totalUpdates;
    private int relativeIndex;
    private double[] relevantAttribution;
    private double[] pastValues;
    private double[][] expectedValuesList;
    private double[] likelihoodOfValues;
    private double threshold;
    private int forestSize;

    public ThresholdingResult(double grade, double confidence, double rcfScore) {
        this(grade, confidence, rcfScore, 0L, 0, null, null, null, null, 0.0, 0);
    }

    public ThresholdingResult(double grade, double confidence, double rcfScore, long totalUpdates, int relativeIndex, double[] relevantAttribution, double[] pastValues, double[][] expectedValuesList, double[] likelihoodOfValues, double threshold, int forestSize) {
        this.grade = grade;
        this.confidence = confidence;
        this.rcfScore = rcfScore;
        this.totalUpdates = totalUpdates;
        this.relativeIndex = relativeIndex;
        this.relevantAttribution = relevantAttribution;
        this.pastValues = pastValues;
        this.expectedValuesList = expectedValuesList;
        this.likelihoodOfValues = likelihoodOfValues;
        this.threshold = threshold;
        this.forestSize = forestSize;
    }

    public double getGrade() {
        return this.grade;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getRcfScore() {
        return this.rcfScore;
    }

    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    public int getRelativeIndex() {
        return this.relativeIndex;
    }

    public double[] getRelevantAttribution() {
        return this.relevantAttribution;
    }

    public double[] getPastValues() {
        return this.pastValues;
    }

    public double[][] getExpectedValuesList() {
        return this.expectedValuesList;
    }

    public double[] getLikelihoodOfValues() {
        return this.likelihoodOfValues;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getForestSize() {
        return this.forestSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdingResult that = (ThresholdingResult)o;
        return this.grade == that.grade && this.confidence == that.confidence && this.rcfScore == that.rcfScore && this.totalUpdates == that.totalUpdates && this.relativeIndex == that.relativeIndex && Arrays.equals(this.relevantAttribution, that.relevantAttribution) && Arrays.equals(this.pastValues, that.pastValues) && Arrays.deepEquals((Object[])this.expectedValuesList, (Object[])that.expectedValuesList) && Arrays.equals(this.likelihoodOfValues, that.likelihoodOfValues) && this.threshold == that.threshold && this.forestSize == that.forestSize;
    }

    public int hashCode() {
        return Objects.hash(this.grade, this.confidence, this.rcfScore, this.totalUpdates, this.relativeIndex, Arrays.hashCode(this.relevantAttribution), Arrays.hashCode(this.pastValues), Arrays.deepHashCode((Object[])this.expectedValuesList), Arrays.hashCode(this.likelihoodOfValues), this.threshold, this.forestSize);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("grade", this.grade).append("confidence", this.confidence).append("rcfScore", this.rcfScore).append("totalUpdates", this.totalUpdates).append("relativeIndex", this.relativeIndex).append("relevantAttribution", (Object)Arrays.toString(this.relevantAttribution)).append("pastValues", (Object)Arrays.toString(this.pastValues)).append("expectedValuesList", (Object)Arrays.deepToString((Object[])this.expectedValuesList)).append("likelihoodOfValues", (Object)Arrays.toString(this.likelihoodOfValues)).append("threshold", this.threshold).append("forestSize", this.forestSize).toString();
    }

    public AnomalyResult toAnomalyResult(AnomalyDetector detector, Instant dataStartInstant, Instant dataEndInstant, Instant executionStartInstant, Instant executionEndInstant, List<FeatureData> featureData, Entity entity, Integer schemaVersion, String modelId, String taskId, String error) {
        return AnomalyResult.fromRawTRCFResult(detector.getDetectorId(), detector.getDetectorIntervalInMilliseconds(), taskId, this.rcfScore, this.grade, this.confidence, featureData, dataStartInstant, dataEndInstant, executionStartInstant, executionEndInstant, error, entity, detector.getUser(), schemaVersion, modelId, this.relevantAttribution, this.relativeIndex, this.pastValues, this.expectedValuesList, this.likelihoodOfValues, this.threshold);
    }
}

