/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.util.ExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/replication/util/SecurityContext;", "", "()V", "Companion", "opensearch-cross-cluster-replication"})
public final class SecurityContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LogManager.getLogger(SecurityContext.class);
    @NotNull
    public static final String OPENDISTRO_SECURITY_USER = "_opendistro_security_user";
    @NotNull
    public static final String OPENDISTRO_SECURITY_INJECTED_ROLES_VALIDATION = "opendistro_security_injected_roles_validation";
    @NotNull
    public static final String REPLICATION_PLUGIN_USER = "ccr_user";
    @NotNull
    private static final User ADMIN_USER = new User("ccr_user", null, CollectionsKt.listOf((Object)"all_access"), null);
    @NotNull
    private static final List<String> ALL_TRANSIENTS;
    @NotNull
    private static final List<String> LEADER_USER_ACTIONS;
    @NotNull
    private static final List<String> FOLLOWER_USER_ACTIONS;

    static {
        Object[] objectArray = new String[]{"opendistro_security_injected_roles", "injected_user", OPENDISTRO_SECURITY_USER};
        ALL_TRANSIENTS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"indices:data/read/plugins/replication/changes", "indices:data/read/plugins/replication/file_chunk"};
        LEADER_USER_ACTIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"indices:data/write/plugins/replication/changes", "indices:admin/plugins/replication/index/start", "indices:admin/plugins/replication/index/pause", "indices:admin/plugins/replication/index/resume", "indices:admin/plugins/replication/index/stop", "indices:admin/plugins/replication/index/update", "indices:admin/plugins/replication/index/status_check", "cluster:admin/plugins/replication/autofollow/update"};
        FOLLOWER_USER_ACTIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/opensearch/replication/util/SecurityContext$Companion;", "", "()V", "ADMIN_USER", "Lorg/opensearch/commons/authuser/User;", "getADMIN_USER", "()Lorg/opensearch/commons/authuser/User;", "ALL_TRANSIENTS", "", "", "getALL_TRANSIENTS", "()Ljava/util/List;", "FOLLOWER_USER_ACTIONS", "getFOLLOWER_USER_ACTIONS", "LEADER_USER_ACTIONS", "getLEADER_USER_ACTIONS", "OPENDISTRO_SECURITY_INJECTED_ROLES_VALIDATION", "OPENDISTRO_SECURITY_USER", "REPLICATION_PLUGIN_USER", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "asRolesInjection", "", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext;", "role", "asUserInjection", "userString", "fromSecurityThreadContext", "setBasedOnActions", "replMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "action", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final User getADMIN_USER() {
            return ADMIN_USER;
        }

        @NotNull
        public final List<String> getALL_TRANSIENTS() {
            return ALL_TRANSIENTS;
        }

        @NotNull
        public final List<String> getLEADER_USER_ACTIONS() {
            return LEADER_USER_ACTIONS;
        }

        @NotNull
        public final List<String> getFOLLOWER_USER_ACTIONS() {
            return FOLLOWER_USER_ACTIONS;
        }

        @Nullable
        public final User fromSecurityThreadContext(@NotNull ThreadContext threadContext) {
            Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
            String userInfo = (String)threadContext.getTransient("_opendistro_security_user_info");
            Object userObj = threadContext.getTransient(SecurityContext.OPENDISTRO_SECURITY_USER);
            if (userInfo == null && userObj != null) {
                userInfo = "adminDN|";
            }
            return User.parse((String)userInfo);
        }

        public final void asUserInjection(@NotNull ThreadContext threadContext, @Nullable String userString) {
            Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
            if (userString != null) {
                String userInfo = (String)threadContext.getTransient("injected_user");
                if (userInfo != null) {
                    log.warn("Injected user not empty in thread context " + userInfo);
                } else {
                    threadContext.putTransient("injected_user", (Object)userString);
                }
            }
        }

        public final void asRolesInjection(@NotNull ThreadContext threadContext, @Nullable String role) {
            Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
            if (role != null) {
                String rolesInj = (String)threadContext.getTransient("opendistro_security_injected_roles");
                if (rolesInj != null) {
                    log.warn("Injected roles not empty in thread context " + rolesInj);
                } else {
                    threadContext.putTransient("opendistro_security_injected_roles", (Object)role);
                }
            }
        }

        public final void setBasedOnActions(@Nullable ReplicationMetadata replMetadata, @NotNull String action, @NotNull ThreadContext threadContext) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
            if (replMetadata != null) {
                if (this.getLEADER_USER_ACTIONS().contains(action)) {
                    User user = replMetadata.getLeaderContext().getUser();
                    this.asRolesInjection(threadContext, user != null ? ExtensionsKt.toInjectedRoles(user) : null);
                    return;
                }
                if (this.getFOLLOWER_USER_ACTIONS().contains(action)) {
                    User user = replMetadata.getFollowerContext().getUser();
                    this.asRolesInjection(threadContext, user != null ? ExtensionsKt.toInjectedRoles(user) : null);
                    return;
                }
            }
            this.asRolesInjection(threadContext, ExtensionsKt.toInjectedRoles(this.getADMIN_USER()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

