"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiStepHorizontal", {
  enumerable: true,
  get: function get() {
    return _step_horizontal.EuiStepHorizontal;
  }
});
exports.OuiStepHorizontal = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _step_number = require("./step_number");

var _step_strings = require("./step_strings");

var _step_horizontal = require("../../eui_components/steps/step_horizontal");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiStepHorizontal = function OuiStepHorizontal(_ref) {
  var className = _ref.className,
      _ref$step = _ref.step,
      step = _ref$step === void 0 ? 1 : _ref$step,
      title = _ref.title,
      isSelected = _ref.isSelected,
      isComplete = _ref.isComplete,
      onClick = _ref.onClick,
      disabled = _ref.disabled,
      status = _ref.status,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "step", "title", "isSelected", "isComplete", "onClick", "disabled", "status"]);
  var buttonTitle = (0, _step_strings.useI18nStep)({
    number: step,
    title: title
  });
  var completeTitle = (0, _step_strings.useI18nCompleteStep)({
    number: step,
    title: title
  });
  var disabledTitle = (0, _step_strings.useI18nDisabledStep)({
    number: step,
    title: title
  });
  var incompleteTitle = (0, _step_strings.useI18nIncompleteStep)({
    number: step,
    title: title
  });
  var warningTitle = (0, _step_strings.useI18nWarningStep)({
    number: step,
    title: title
  });
  var classes = (0, _classnames.default)('ouiStepHorizontal', className, {
    'ouiStepHorizontal-isSelected': isSelected,
    'ouiStepHorizontal-isComplete': isComplete,
    'ouiStepHorizontal-isIncomplete': !isSelected && !isComplete,
    'ouiStepHorizontal-isDisabled': disabled
  });
  if (disabled) status = 'disabled';else if (isComplete) status = 'complete';else if (isSelected) status = status;else if (!status) status = 'incomplete';
  var stepTitle = buttonTitle;
  if (status === 'disabled') stepTitle = disabledTitle;
  if (status === 'complete') stepTitle = completeTitle;
  if (status === 'incomplete') stepTitle = incompleteTitle;
  if (status === 'warning') stepTitle = warningTitle;

  var onStepClick = function onStepClick(event) {
    if (!disabled) onClick(event);
  };

  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    className: classes,
    title: stepTitle,
    onClick: onStepClick,
    disabled: disabled
  }, rest), /*#__PURE__*/_react.default.createElement(_step_number.OuiStepNumber, {
    className: "ouiStepHorizontal__number",
    status: status,
    number: step
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiStepHorizontal__title"
  }, title));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiStepHorizontal = OuiStepHorizontal;
OuiStepHorizontal.propTypes = {
  /**
     * **DEPRECATED IN CASCADIA**
     * Adds to the line before the indicator for showing current progress
     */
  isSelected: _propTypes.default.bool,

  /**
     * **DEPRECATED IN CASCADIA**
     * Adds to the line after the indicator for showing current progress
     */
  isComplete: _propTypes.default.bool,
  onClick: _propTypes.default.func.isRequired,

  /**
     * Makes the whole step button disabled.
     */
  disabled: _propTypes.default.bool,

  /**
     * The number of the step in the list of steps
     */
  step: _propTypes.default.number,
  title: _propTypes.default.string,

  /**
     * Visual representation of the step number indicator.
     * May replace the number provided in props.step with alternate styling.
     * The `isSelected`, `isComplete`, and `disabled` props will override these.
     */
  status: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};