"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyboardAccessible = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("react");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _services = require("../../services");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var EuiKeyboardAccessible = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiKeyboardAccessible, _Component);

  var _super = _createSuper(EuiKeyboardAccessible);

  function EuiKeyboardAccessible() {
    var _this;

    (0, _classCallCheck2.default)(this, EuiKeyboardAccessible);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeyDown", function (event) {
      // Prevent a scroll from occurring if the user has hit space.
      if (event.key === _services.keys.SPACE) {
        event.preventDefault();
      }

      if (_this.props.children.props.onKeyDown) {
        _this.props.children.props.onKeyDown(event);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeyUp", function (event) {
      // Support keyboard accessibility by emulating mouse click on ENTER or SPACE keypress.
      if (event.key === _services.keys.ENTER || event.key === _services.keys.SPACE) {
        // Delegate to the click handler on the element.
        _this.props.children.props.onClick(event);
      }

      if (_this.props.children.props.onKeyUp) {
        _this.props.children.props.onKeyUp(event);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "applyKeyboardAccessibility", function (child) {
      // Add attributes required for accessibility unless they are already specified.
      var props = _objectSpread(_objectSpread({
        tabIndex: '0',
        role: 'button'
      }, child.props), {}, {
        onKeyDown: _this.onKeyDown,
        onKeyUp: _this.onKeyUp
      });

      return /*#__PURE__*/(0, _react.cloneElement)(child, props);
    });
    return _this;
  }

  (0, _createClass2.default)(EuiKeyboardAccessible, [{
    key: "render",
    value: function render() {
      return this.applyKeyboardAccessibility(this.props.children);
    }
  }]);
  return EuiKeyboardAccessible;
}(_react.Component); // @ts-ignore defining this as a static on EuiKeyboardAccessible breaks the
// tests


exports.EuiKeyboardAccessible = EuiKeyboardAccessible;
EuiKeyboardAccessible.propTypes = {
  /**
     * ReactNode to render as this component's children
     */
  children: _propTypes.default.element.isRequired
};
EuiKeyboardAccessible.propTypes = {
  children: keyboardInaccessibleElement
};

function keyboardInaccessibleElement(props, propName, componentName) {
  var child = props.children;

  if (!child) {
    throw new Error("".concat(componentName, " needs to wrap an element with which the user interacts."));
  } // The whole point of this component is to hack in functionality that native buttons provide
  // by default.


  if (child.type === 'button') {
    throw new Error("".concat(componentName, " doesn't need to be used on a button."));
  }

  if (child.type === 'a' && child.props.href !== undefined) {
    throw new Error("".concat(componentName, " doesn't need to be used on a link if it has a href attribute."));
  } // We're emulating a click action, so we should already have a regular click handler defined.


  if (!child.props.onClick) {
    throw new Error("".concat(componentName, " needs to wrap an element which has an onClick prop assigned."));
  }

  if (typeof child.props.onClick !== 'function') {
    throw new Error("".concat(componentName, "'s child's onClick prop needs to be a function."));
  }
}