function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import moment from 'moment-timezone';
import { UnreachableCaseError, wrapArray } from './util';
import { METRIC_TYPE } from './metrics';
var REPORT_VERSION = 1;
export var ReportManager = /*#__PURE__*/function () {
  function ReportManager(report) {
    _classCallCheck(this, ReportManager);

    _defineProperty(this, "report", void 0);

    this.report = report || ReportManager.createReport();
  }

  _createClass(ReportManager, [{
    key: "clearReport",
    value: function clearReport() {
      this.report = ReportManager.createReport();
    }
  }, {
    key: "isReportEmpty",
    value: function isReportEmpty() {
      var _this$report = this.report,
          uiStatsMetrics = _this$report.uiStatsMetrics,
          userAgent = _this$report.userAgent,
          appUsage = _this$report.application_usage;
      var noUiStats = !uiStatsMetrics || Object.keys(uiStatsMetrics).length === 0;
      var noUserAgent = !userAgent || Object.keys(userAgent).length === 0;
      var noAppUsage = !appUsage || Object.keys(appUsage).length === 0;
      return noUiStats && noUserAgent && noAppUsage;
    }
  }, {
    key: "incrementStats",
    value: function incrementStats(count, stats) {
      var _ref = stats || {},
          _ref$min = _ref.min,
          min = _ref$min === void 0 ? 0 : _ref$min,
          _ref$max = _ref.max,
          max = _ref$max === void 0 ? 0 : _ref$max,
          _ref$sum = _ref.sum,
          sum = _ref$sum === void 0 ? 0 : _ref$sum;

      var newMin = Math.min(min, count);
      var newMax = Math.max(max, count);
      var newAvg = newMin + newMax / 2;
      var newSum = sum + count;
      return {
        min: newMin,
        max: newMax,
        avg: newAvg,
        sum: newSum
      };
    }
  }, {
    key: "assignReports",
    value: function assignReports(newMetrics) {
      var _this = this;

      wrapArray(newMetrics).forEach(function (newMetric) {
        return _this.assignReport(_this.report, newMetric);
      });
      return {
        report: this.report
      };
    }
  }, {
    key: "assignReport",
    value: function assignReport(report, metric) {
      var key = ReportManager.createMetricKey(metric);

      switch (metric.type) {
        case METRIC_TYPE.USER_AGENT:
          {
            var appName = metric.appName,
                type = metric.type,
                userAgent = metric.userAgent;

            if (userAgent) {
              report.userAgent = _defineProperty({}, key, {
                key: key,
                appName: appName,
                type: type,
                userAgent: metric.userAgent
              });
            }

            return;
          }

        case METRIC_TYPE.CLICK:
        case METRIC_TYPE.LOADED:
        case METRIC_TYPE.COUNT:
          {
            var _appName = metric.appName,
                _type = metric.type,
                eventName = metric.eventName,
                count = metric.count;
            report.uiStatsMetrics = report.uiStatsMetrics || {};
            var existingStats = (report.uiStatsMetrics[key] || {}).stats;
            report.uiStatsMetrics[key] = {
              key: key,
              appName: _appName,
              eventName: eventName,
              type: _type,
              stats: this.incrementStats(count, existingStats)
            };
            return;
          }

        case METRIC_TYPE.APPLICATION_USAGE:
          var numberOfClicks = metric.numberOfClicks,
              startTime = metric.startTime;
          var minutesOnScreen = moment().diff(startTime, 'minutes', true);
          report.application_usage = report.application_usage || {};
          var appExistingData = report.application_usage[key] || {
            minutesOnScreen: 0,
            numberOfClicks: 0
          };
          report.application_usage[key] = {
            minutesOnScreen: appExistingData.minutesOnScreen + minutesOnScreen,
            numberOfClicks: appExistingData.numberOfClicks + numberOfClicks
          };
          break;

        default:
          throw new UnreachableCaseError(metric);
      }
    }
  }], [{
    key: "createReport",
    value: function createReport() {
      return {
        reportVersion: REPORT_VERSION
      };
    }
  }, {
    key: "createMetricKey",
    value: function createMetricKey(metric) {
      switch (metric.type) {
        case METRIC_TYPE.USER_AGENT:
          {
            var appName = metric.appName,
                type = metric.type;
            return "".concat(appName, "-").concat(type);
          }

        case METRIC_TYPE.CLICK:
        case METRIC_TYPE.LOADED:
        case METRIC_TYPE.COUNT:
          {
            var _appName2 = metric.appName,
                eventName = metric.eventName,
                _type2 = metric.type;
            return "".concat(_appName2, "-").concat(_type2, "-").concat(eventName);
          }

        case METRIC_TYPE.APPLICATION_USAGE:
          return metric.appId;

        default:
          throw new UnreachableCaseError(metric);
      }
    }
  }]);

  return ReportManager;
}();

_defineProperty(ReportManager, "REPORT_VERSION", REPORT_VERSION);